/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.AssemblerItem;
import com.hifiremote.jp1.AssemblerOpCode;
import com.hifiremote.jp1.AssemblerTableModel;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.MAXQProcessor;
import com.hifiremote.jp1.Processor;
import com.hifiremote.jp1.ProcessorManager;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.ProtocolManager;
import com.hifiremote.jp1.RemoteMaster;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class JP2Analyzer {
    private PrintWriter pw = null;
    private static Executor e = null;
    private static ProtocolBlock prb = null;
    private IRPstruct irpStruct = null;
    private Processor proc = null;
    private Processor procNative = null;
    private int carrier = 0;
    private int altCarrier = 0;
    private int fix = 0;
    private int var = 0;
    private int[] pf = null;
    private int[] pfNew = null;
    private int[] pfChanges = null;
    private short[] tbLengths = null;
    private int[] tbDurations = null;
    private int tbUsed = 0;
    private int maxBlocks = 1;
    private int blockCount = 0;
    private int pbIndex = 0;
    private int sbIndex = 0;
    private List<Executor> execs = new ArrayList<Executor>();
    private List<AssemblerItem> itemList = new ArrayList<AssemblerItem>();
    private List<AssemblerItem> fullItemList = null;
    private List<AssemblerItem> completeItemList = null;
    private LinkedHashMap<String, Integer> labelIndex = new LinkedHashMap();
    private LinkedHashMap<String, Integer> loopIndex = new LinkedHashMap();
    private LinkedHashMap<Integer, CodeTree> loopDone = new LinkedHashMap();
    private LinkedHashMap<String, Function> functionIndex = new LinkedHashMap();
    private List<Integer> labelAddresses = new ArrayList<Integer>();
    private LinkedHashMap<Integer, String> labels = new LinkedHashMap();
    private LinkedHashMap<Integer, Node> nodeList = new LinkedHashMap();
    private int treeRoot = 0;
    private double unit = 0.0;
    private boolean hasNativeCode = false;
    private boolean has2usOff = false;
    private boolean changesFreq = false;
    private int initialCodeSpec = -1;
    private boolean[] choices = null;
    private String[] irpParts = new String[30];
    private int brackets = 0;
    private int minRpts = 0;
    private boolean firstFrame = true;
    private OpTree[] txd = new OpTree[16];
    private int[] txdIndex = new int[16];
    private int[] txb = new int[16];
    private int txdCount = 0;
    private boolean simple = false;
    public static int currentAddr = 0;

    private String addrHex(int addr) {
        return String.format("%04X:\t", addr);
    }

    public String analyze(Processor p, Hex hex) {
        boolean hasAltExec;
        int dbStart;
        short dbHeader;
        int dbSize;
        int tbDataSize;
        int tbSize;
        if (hex == null || hex.length() == 0) {
            return "";
        }
        this.simple = true;
        String name = e != null && JP2Analyzer.e.names.size() > 0 ? JP2Analyzer.e.names.get(0) : "protocol";
        this.proc = p;
        this.procNative = ProcessorManager.getProcessor(p.getNativeProcessorName());
        if (this.procNative != null) {
            this.procNative.setAddressList(new ArrayList<Integer>());
        }
        this.labels.clear();
        this.labelAddresses.clear();
        e = new Executor();
        JP2Analyzer.e.hex = hex;
        this.irpStruct = new IRPstruct();
        this.changesFreq = false;
        this.pfChanges = new int[16];
        int protLen = hex.length();
        short pbOffset = 0;
        StringBuilder sb = new StringBuilder();
        short[] data = hex.getData();
        String endErr = "*** Error: End of data reached prematurely";
        if (protLen < 6) {
            return endErr;
        }
        int pos = this.proc.getProtocolHeaderSize();
        sb.append("Header:\n");
        sb.append(this.addrHex(0) + hex.subHex(0, pos) + "\n");
        sb.append(this.analyzeHeader(hex) + "\n");
        int tbStart = pos++;
        short tbHeader = data[tbStart];
        boolean tbHasSpec = (tbHeader & 0x80) != 0;
        int tbSpecSize = tbHasSpec ? 2 : 0;
        boolean tbHasData = true;
        int tbSizeMask = 127;
        if (this.proc instanceof MAXQProcessor) {
            tbHasData = (tbHeader & 0x40) == 0;
            tbSizeMask = 63;
        }
        if ((pos += (tbSize = tbSpecSize + (tbDataSize = tbHasData ? tbHeader & tbSizeMask : 0))) >= protLen) {
            return endErr;
        }
        if ((dbSize = (dbHeader = data[dbStart = pos++]) & 7) == 1 || dbSize > 3) {
            return "*** Directive block has invalid size: " + dbSize;
        }
        if ((pos += dbSize) >= protLen) {
            return endErr;
        }
        boolean dbHasSwitch = dbSize > 1;
        this.hasNativeCode = (dbHeader & 0x80) != 0;
        this.has2usOff = (dbHeader & 0x40) != 0;
        int dbSwitchLen = dbHasSwitch ? 2 : 0;
        int dbSwitch = dbHasSwitch ? hex.get(dbStart + 1) : 0;
        int dbSwitchMask = dbSwitch & 0xFF;
        int dbSwitchIndex = dbSwitch >> 12 & 0xF;
        int dbSwitchSize = dbSwitch >> 8 & 0xF;
        int dbSwitchMaskStart = 0;
        if (dbSwitchSize > 0) {
            int[] rev = new int[4];
            this.reverseByte(dbSwitchMask, rev);
            if (rev[1] != rev[3] - rev[2] + 1) {
                return "*** Error:  Bits in directive switch mask are not consecutive";
            }
            dbSwitchMaskStart = 7 - rev[3];
        }
        short dbOffset = dbSize > 2 ? data[dbStart + 3] : (short)0;
        boolean bl = hasAltExec = (dbHeader & 0x20) != 0 && dbOffset > 0;
        if (hasAltExec) {
            if (pos + dbOffset >= protLen) {
                return endErr;
            }
            protLen = pos + dbOffset;
        }
        int pbStart = pos;
        sb.append("Timing block (header / timing spec / timing PD words):\n");
        this.tbUsed = 255;
        this.initialCodeSpec = 0;
        pos = tbStart;
        sb.append(this.addrHex(pos) + hex.subHex(pos, 1) + " / ");
        sb.append(hex.subHex(++pos, tbSpecSize) + " / ");
        sb.append(hex.subHex(pos += tbSpecSize, tbDataSize) + "\n");
        for (String str : this.analyzeTimingBlock(hex.subHex(tbStart, 1 + tbSize), true, 0, 64, null)) {
            sb.append(str + "\n");
        }
        sb.append("\n");
        sb.append("Directive block (header / switch / offset):\n");
        pos = dbStart;
        sb.append(this.addrHex(pos) + hex.subHex(pos, 1) + " / ");
        sb.append(hex.subHex(++pos, dbSwitchLen) + " / ");
        sb.append(hex.subHex(pos += dbSwitchLen, dbSize - dbSwitchLen) + "\n");
        sb.append("OFF times are in units of " + (this.has2usOff ? "2us\n" : "carrier cycles\n"));
        if (this.hasNativeCode) {
            sb.append("Signal block includes native code\n");
        }
        if (hasAltExec) {
            sb.append("*** Protocol block is followed by an alternate executor at " + String.format("$%04X.  ", pbStart + dbOffset) + "This option has never been seen and its operation is unclear.  Parsing here covers only the initial executor.\n");
        }
        sb.append("\n");
        String pbSelector = "(" + this.getZeroLabel(this.proc.getDcBufStart() + dbSwitchIndex) + " & " + String.format("$%02X) = ", dbSwitchMask);
        pos = pbStart;
        int pbIndex = -1;
        do {
            short pbCodeSize;
            int codeSpec;
            this.choices = new boolean[30];
            Arrays.fill(this.choices, false);
            int sigBlkCount = 0;
            ++pbIndex;
            pbStart = pos;
            short pbHeader = data[pos];
            boolean pbHasCode = (pbHeader & 0x80) != 0;
            int pbOptSize = pbHeader & 0xF;
            if (pos + pbOptSize + (pbHasCode ? 1 : 0) >= protLen) {
                return endErr;
            }
            if (pbOptSize == 2 || pbOptSize == 5 || pbOptSize > 6) {
                return "*** Protocol Block option has invalid size: " + pbOptSize;
            }
            pbOffset = pbOptSize > 0 ? data[pos + 1] : (short)0;
            int pbSwitch = pbOptSize > 2 ? hex.get(pos + 2) : 0;
            int pbSwitchMask = pbSwitch & 0xFF;
            int pbSwitchIndex = pbSwitch >> 12 & 0xF;
            int pbSwitchSize = pbSwitch >> 8 & 0xF;
            int pbSwitchMaskStart = 0;
            if (pbSwitchSize > 0) {
                int[] rev = new int[4];
                this.reverseByte(pbSwitchMask, rev);
                if (rev[1] != rev[3] - rev[2] + 1) {
                    return "*** Error:  Bits in protocol switch mask are not consecutive";
                }
                pbSwitchMaskStart = 7 - rev[3];
            }
            this.initialCodeSpec = codeSpec = pbOptSize > 3 ? data[pos + 4] : 0;
            int toggle = pbOptSize > 5 ? hex.get(pos + 5) : 0;
            short s = pbCodeSize = pbHasCode ? data[pos += 1 + pbOptSize] : (short)0;
            if (pbHasCode) {
                if (pos + pbCodeSize + 1 >= protLen) {
                    return endErr;
                }
                int addr = ++pos;
                boolean[] flags = new boolean[20];
                this.disassemblePseudocode(addr, hex.subHex(addr, pbCodeSize), "", flags, 1);
                pos += pbCodeSize;
            }
            int sbStart = pos;
            boolean hasKeyDepSignalBlock = false;
            boolean mayExecNextBlock = false;
            do {
                short sbCodeSize;
                boolean sbHasCode;
                if (pos >= protLen) {
                    return endErr;
                }
                short sbHeader = data[pos];
                int formatLen = sbHeader & 7;
                if (++sigBlkCount == 1) {
                    this.pf = new int[7];
                    for (int i = 0; i < 7 && i < formatLen + 1; ++i) {
                        this.pf[i] = data[sbStart + i];
                    }
                }
                boolean bl2 = sbHasCode = (sbHeader & 0x80) != 0;
                if (pos + formatLen >= protLen) {
                    return endErr;
                }
                short pf2 = formatLen > 1 ? data[pos + 2] : (short)0;
                short pf5 = formatLen > 4 ? data[pos + 5] : (short)0;
                int sigSpecLen = pf2 & 0x1F;
                int rptType = pf2 >> 5;
                mayExecNextBlock = rptType == 1 || rptType == 2 || rptType == 4;
                if ((pos += 1 + formatLen + sigSpecLen) + (sbHasCode ? 1 : 0) > protLen) {
                    return endErr;
                }
                short s2 = sbCodeSize = sbHasCode ? data[pos] : (short)0;
                if (sbHasCode) {
                    if (pos + sbCodeSize >= protLen) {
                        return endErr;
                    }
                    int addr = ++pos;
                    boolean[] flags = new boolean[20];
                    this.disassemblePseudocode(addr, hex.subHex(addr, sbCodeSize), "", flags, 1);
                    pos += sbCodeSize;
                }
                boolean bl3 = hasKeyDepSignalBlock = (pf5 & 0xF0) != 0;
                if (pbSwitchSize > 0 && (hasKeyDepSignalBlock || sbHasCode || this.hasNativeCode || mayExecNextBlock) || hasKeyDepSignalBlock && (sbHasCode || this.hasNativeCode || mayExecNextBlock) || this.hasNativeCode && mayExecNextBlock) {
                    System.err.println("Signal block error in " + name);
                    return "*** Error in signal block";
                }
                for (int i = 0; i < pbSwitchSize; ++i) {
                    if (pos >= protLen) {
                        return endErr;
                    }
                    short altPF2 = data[pos++];
                    int altSigSpecLen = altPF2 & 0x1F;
                    pos += altSigSpecLen;
                }
                if (this.hasNativeCode || mayExecNextBlock || (pbOffset <= 0 || pbOffset <= pos - pbStart) && (pbOffset != 0 || pos >= protLen)) continue;
                System.err.println("Extra block in " + name);
                mayExecNextBlock = true;
            } while (hasKeyDepSignalBlock || mayExecNextBlock);
            if (dbSwitchSize > 0) {
                sb.append("     - - - - - - - - - - -\n");
            }
            sb.append("Protocol block (header / offset / switch / codespec / toggle / code size)");
            sb.append(dbSwitchSize > 0 ? " when " + pbSelector + String.format("$%02X", pbIndex << dbSwitchMaskStart) + ":" : ":");
            sb.append("\n");
            pos = pbStart;
            sb.append(this.addrHex(pos) + hex.subHex(pos++, 1) + " / ");
            sb.append(pbOptSize > 0 ? hex.subHex(pos, 1) + " / " : " / ");
            sb.append(pbOptSize > 1 ? hex.subHex(pos + 1, 2) + " / " : " / ");
            sb.append(pbOptSize > 3 ? hex.subHex(pos + 3, 1) + " / " : " / ");
            sb.append(pbOptSize > 4 ? hex.subHex(pos + 4, 2) + " / " : " / ");
            sb.append(pbHasCode ? hex.subHex(pos += pbOptSize, 1) : "");
            sb.append("\n");
            List<String> list = this.interpretCodeSelector(codeSpec);
            if (!list.isEmpty()) {
                sb.append("Codespec reinterprets the 0-burst and 1-burst timing data as follows:\n");
            }
            for (String str : list) {
                sb.append(str + "\n");
            }
            if (pbHasCode) {
                sb.append("\n");
                sb.append("Protocol block code (run on first frame only, after PF bytes read):\n");
                int addr = pos + 1;
                boolean[] flags = new boolean[20];
                sb.append(this.disassemblePseudocode(addr, hex.subHex(addr, pbCodeSize), "", flags, 2));
            }
            int[] togData = null;
            if (toggle > 0) {
                togData = new int[6];
                sb.append("\n");
                sb.append("The following toggle is applied before the signal data is encoded\n");
                sb.append("by the signal block, but after any protocol code is run:\n");
                sb.append(this.analyzeToggle(toggle, togData));
            }
            sb.append("\n");
            pos = sbStart;
            int sbIndex = -1;
            do {
                int[][] pfDescs;
                int i;
                short sbHeader;
                int formatLen;
                ++sbIndex;
                short pf2 = (formatLen = (sbHeader = data[sbStart = pos++]) & 7) > 1 ? data[sbStart + 2] : (short)0;
                short pf5 = formatLen > 4 ? data[sbStart + 5] : (short)0;
                short pf6 = formatLen > 5 ? data[sbStart + 6] : (short)0;
                boolean sbCodeBeforeTX = (pf6 & 0x80) > 0;
                int sigSpecLen = pf2 & 0x1F;
                int rptType = pf2 >> 5;
                mayExecNextBlock = rptType == 1 || rptType == 2 || rptType == 4;
                Hex signalSpec = hex.subHex(pos += formatLen, sigSpecLen);
                boolean sbHasCode = (sbHeader & 0x80) != 0;
                hasKeyDepSignalBlock = (pf5 & 0xF0) != 0;
                short sbCodeSize = sbHasCode ? data[pos += sigSpecLen] : (short)0;
                String keyCondition = "";
                if ((pf5 & 0xF0) > 0) {
                    int mask = 16;
                    for (i = 0; i < 4; ++i) {
                        if ((pf5 & mask) > 0) {
                            keyCondition = " for " + (new String[]{"Record", "Power", "Vol+/-, Mute", "Vol+/-, Ch+/-, FF/Rew"})[i] + " key";
                            break;
                        }
                        mask <<= 1;
                    }
                }
                if (sigBlkCount > 1) {
                    sb.append("     -   -   -   -   -   -\n");
                }
                String sbIntro = keyCondition.isEmpty() && sigBlkCount > 1 ? (new String[]{"First", "Second", "Third", "Fourth", "Next"})[sbIndex > 4 ? 4 : sbIndex] + " signal" : "Signal";
                sb.append(sbIntro + " block (PF bytes / signal spec / code size)" + keyCondition + ":\n");
                sb.append(this.addrHex(sbStart) + hex.subHex(sbStart, 1 + formatLen) + " / ");
                sb.append(hex.subHex(sbStart + 1 + formatLen, sigSpecLen) + " / ");
                sb.append(sbHasCode ? hex.subHex(pos, 1) : "");
                sb.append("\n\n");
                sb.append("PF byte interpretation:\n");
                Arrays.fill(this.pf, 0);
                for (i = 0; i < 7 && i < formatLen + 1; ++i) {
                    this.pf[i] = data[sbStart + i];
                }
                this.pfNew = (int[])this.pf.clone();
                for (int[] pfDesc : pfDescs = new int[][]{{-1, 1, 6}, {128, 4, 0}, {8, 1, 3}, {4, 1, 2}, {-1, 0, 6}, {63, 3, 0}, {-1, 1, 4}, {224, 2, 5}, {128, 3, 7}, {240, 5, 0}, {128, 6, 0}}) {
                    if (pfDesc[0] >= 0 && (this.pf[pfDesc[1]] & pfDesc[0]) <= 0) continue;
                    sb.append(this.getPFdescription(pfDesc[1], pfDesc[2], null) + "\n");
                }
                sb.append("\n");
                sb.append(this.interpretSignalSpec(signalSpec) + "\n");
                String altSelector = "(" + this.getZeroLabel(this.proc.getDcBufStart() + pbSwitchIndex) + " & " + String.format("$%02X) = ", pbSwitchMask);
                if (pbSwitchSize > 0) {
                    sb.append("Main signal spec is used when " + altSelector + "0.\n");
                    sb.append("Alternate signal specs (size / signal spec) are used as follows:\n");
                }
                for (int i2 = 0; i2 < pbSwitchSize; ++i2) {
                    int altSigSpecLen = data[pos] & 0x1F;
                    Hex altSignalSpec = hex.subHex(pos + 1, altSigSpecLen);
                    sb.append(this.addrHex(pos) + hex.subHex(pos++, 1) + " / ");
                    sb.append(hex.subHex(pos, altSigSpecLen));
                    sb.append(" when " + altSelector + String.format("$%02X\n", i2 + 1 << pbSwitchMaskStart));
                    sb.append(this.interpretSignalSpec(altSignalSpec) + "\n");
                    pos += altSigSpecLen;
                }
                if (pbSwitchSize > 0) {
                    sb.append("\n");
                }
                if (sbHasCode) {
                    sb.append("Signal block code (run " + (sbCodeBeforeTX ? "before" : "after") + " signal spec translation of signal data):\n");
                    int addr = pos + 1;
                    boolean[] flags = new boolean[20];
                    sb.append(this.disassemblePseudocode(addr, hex.subHex(addr, sbCodeSize), "", flags, 2));
                    sb.append("\n");
                }
                pos += sbHasCode ? 1 + sbCodeSize : 0;
                sb.append("IR sent is the highest TXBn bits of byte TXDn for each n in accordance with selected encoding.\n");
                sb.append("\n");
                if (this.hasNativeCode) {
                    if (this.proc instanceof MAXQProcessor && (protLen - pos & 1) != 0) {
                        sb.append("Padding to word boundary:\n");
                        sb.append(this.addrHex(pos) + hex.subHex(pos++, 1) + "\n\n");
                    }
                    sb.append("Native code block (run after IR sent):\n");
                    sb.append(this.disassembleNativeCode(pos, hex.subHex(pos, protLen - pos), ""));
                    sb.append("\n");
                    pos = protLen;
                }
                if (this.hasNativeCode || mayExecNextBlock || hasKeyDepSignalBlock || (pbOffset <= 0 || pbOffset <= pos - pbStart) && (pbOffset != 0 || pos >= protLen)) continue;
                if (pbOffset == 0 && pos == protLen - 1 && data[pos] != 0) {
                    sb.append("*** Apparently a spurious final byte:\n");
                    sb.append(this.addrHex(pos) + hex.subHex(pos++, 1) + "\n");
                    continue;
                }
                mayExecNextBlock = true;
            } while (hasKeyDepSignalBlock || mayExecNextBlock);
            if (pbOffset <= 0 || pbOffset >= pos - pbStart) continue;
            return "*** PB Offset=" + pbOffset + ", calculated=" + (pos - pbStart);
        } while (pbOffset > 0);
        if (pos > protLen) {
            sb.append("*** Analysis overshoots end of protocol\n");
        }
        return sb.toString();
    }

    private String interpretSignalSpec(Hex txBytes) {
        String txStr = "Signal spec translation";
        txStr = txBytes.length() > 0 ? txStr + " sets data bytes TXDn to send and number of bits TXBn from each byte (n=0 to " + (txBytes.length() - 1) + "):\n    " : txStr + ": ";
        ArrayList<String> temp = new ArrayList<String>();
        txStr = txStr + this.translateTXBytes(txBytes, temp);
        return txStr;
    }

    private List<String> interpretCodeSelector(int codeSpec) {
        ArrayList<String> list = new ArrayList<String>();
        int[] sizes = new int[]{2, 2, 1, 2, 1, 2, 2, 1};
        int codeSelector = codeSpec & 0xF;
        this.altCarrier = 0;
        if ((codeSpec & 0x10) > 0) {
            int n = 0;
            for (int i = 0; i < 7; ++i) {
                n += this.tbLengths[i] * sizes[i];
            }
            if (n + this.tbLengths[7] - 1 < this.tbDurations.length) {
                Hex hex = new Hex(Math.max(2 * this.tbLengths[7], this.proc.getProtocolHeaderSize()));
                for (int j = 0; j < 2 * this.tbLengths[7]; ++j) {
                    int val = this.tbDurations[n + (j >> 1)];
                    int k = 8 * (j & 1);
                    hex.set((short)(val >> k & 0xFF), j);
                }
                int[] carrierData = this.proc.getCarrierData(hex);
                if (carrierData[0] > 0) {
                    list.add("The MARK of a 0-burst is sent with the following alternate carrier:");
                    list.add(String.format("  %.2fkHz, duty cycle %.1f", (double)this.proc.getOscillatorFreq() / (1000.0 * (double)carrierData[0]), (double)carrierData[1] / 10.0) + "%");
                    this.altCarrier = carrierData[0];
                }
            }
        }
        if ((codeSpec & 0x20) != 0) {
            list.add("Only first burst-pair of a 0-burst is sent if an odd number of bits precede it");
        }
        String str = "";
        if (codeSelector == 1) {
            int size = this.tbLengths[0] + this.tbLengths[1] > 7 ? 2 : 1;
            int n = 0;
            for (int i = 0; i < 4; ++i) {
                str = "";
                for (int j = 0; j < size; ++j) {
                    int val;
                    if ((val = this.durationToMicrosecs(this.tbDurations[n++], this.carrier, true)) > 0) {
                        str = str + (str.isEmpty() ? "" : ",");
                        str = str + "+" + val;
                    }
                    if ((val = this.durationToMicrosecs(this.tbDurations[n++], this.carrier, !this.has2usOff)) <= 0) continue;
                    str = str + (str.isEmpty() ? "" : ",");
                    str = str + "-" + val;
                }
                String range = String.format("(PD%02X-PD%02X) ", 2 * i * size, 2 * (i + 1) * size - 1);
                list.add("Bursts for bit-pair " + (new String[]{"00", "01", "10", "11"})[i] + " (us): " + range + str);
            }
        } else if (codeSelector == 5) {
            list.add("Data uses base 16 encoding, 4-bit group with value n being converted\n  for transmission to a 1 followed by n 0's ");
        } else if (codeSelector > 5 && codeSelector < 12) {
            String s = "Data is sent as asynchronous coding of each TX byte, with one start bit (1), ";
            s = s + (new String[]{"no", "even", "odd"})[codeSelector % 3] + " parity bit, ";
            s = s + (codeSelector < 9 ? "1 stop bit (0)\n" : "2 stop bits (00)\n");
            list.add(s);
        }
        return list;
    }

    private void getExecs(Processor proc) {
        LinkedHashMap<Hex, Executor> execMap = new LinkedHashMap<Hex, Executor>();
        ProtocolManager pm = ProtocolManager.getProtocolManager();
        for (String name : pm.getNames()) {
            for (Protocol p : pm.findByName(name)) {
                Executor e;
                Hex hex = p.getCode().get(proc.getEquivalentName());
                if (hex == null) continue;
                String eName = p.getName() + ": PID=" + p.getID().toString().replaceAll("\\s", "");
                String var = p.getVariantName();
                if (var != null && !var.isEmpty()) {
                    eName = eName + "." + var;
                }
                if ((e = (Executor)execMap.get(hex)) != null) {
                    e.names.add(eName);
                    continue;
                }
                e = new Executor();
                e.names.add(eName);
                e.hex = hex;
                execMap.put(hex, e);
                this.execs.add(e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void analyze() {
        FileWriter fw;
        int execCount = 0;
        int execNoCodeCount = 0;
        int execNoSBCodeCount = 0;
        int execNoSBDataChPBCount = 0;
        int execNoSBDataTimeChPBCount = 0;
        this.proc = ProcessorManager.getProcessor("MAXQ610");
        this.getExecs(this.proc);
        int eIndex = 0;
        Iterator<Executor> iterator = this.execs.iterator();
        while (iterator.hasNext()) {
            Executor executor;
            e = executor = iterator.next();
            executor.index = eIndex++;
            Hex hex = executor.hex;
            this.irpStruct = new IRPstruct();
            ++execCount;
            this.labels.clear();
            this.fullItemList = new ArrayList<AssemblerItem>();
            this.completeItemList = null;
            this.labelAddresses.clear();
            this.initialCodeSpec = -1;
            this.changesFreq = false;
            this.tbUsed = 0;
            this.pf = new int[16];
            this.pfChanges = new int[16];
            Arrays.fill(this.pfChanges, 0);
            this.pbIndex = 0;
            this.sbIndex = 0;
            this.functionIndex.clear();
            prb = null;
            this.analyzeExecutor(hex);
            this.labelIndex.clear();
            this.loopIndex.clear();
            this.loopDone.clear();
            this.functionIndex.clear();
            this.nodeList.clear();
            this.completeItemList = this.expandLabels(this.fullItemList);
            this.fullItemList = null;
            this.labels.clear();
            this.pbIndex = 0;
            this.sbIndex = 0;
            this.irpStruct = new IRPstruct();
            for (ProtocolBlock protocolBlock : executor.pbList) {
                protocolBlock.irps.clear();
                protocolBlock.warnings.clear();
            }
            prb = null;
            this.analyzeExecutor(hex);
        }
        ArrayList<IRPIndexItem> irpIndex = new ArrayList<IRPIndexItem>();
        for (Executor e : this.execs) {
            for (int i = 0; i < e.pbList.size(); ++i) {
                ProtocolBlock protocolBlock = e.pbList.get(i);
                for (int j = 0; j < protocolBlock.irps.size(); ++j) {
                    IRPIndexItem iii = new IRPIndexItem();
                    iii.irp = protocolBlock.irps.get(j);
                    iii.location[0] = e.index;
                    iii.location[1] = i;
                    iii.location[2] = j;
                    if (iii.irp.generalSpec == null || iii.irp.bitSpec == null || iii.irp.irStream == null) continue;
                    irpIndex.add(iii);
                }
            }
        }
        Collections.sort(irpIndex, new Comparator<IRPIndexItem>(){

            @Override
            public int compare(IRPIndexItem o1, IRPIndexItem o2) {
                IRPstruct irp1 = o1.irp;
                IRPstruct irp2 = o2.irp;
                int result = irp1.bitSpec.compareTo(irp2.bitSpec);
                if (result == 0) {
                    result = irp1.unit - irp2.unit;
                }
                if (result == 0) {
                    result = irp1.irStream.compareTo(irp2.irStream);
                }
                return result;
            }
        });
        boolean bl = false;
        int shownCount = 0;
        try {
            void var8_11;
            fw = new FileWriter("MAXQirps.txt");
            this.pw = new PrintWriter(fw);
            for (IRPIndexItem iii : irpIndex) {
                void var15_60;
                ++var8_11;
                Executor ex = this.execs.get(iii.location[0]);
                ProtocolBlock pb = ex.pbList.get(iii.location[1]);
                Object var15_53 = null;
                if (!ex.errors.isEmpty() || !pb.errors.isEmpty()) {
                    String string = iii.irp.toString();
                    for (String string2 : ex.errors) {
                        void var15_55;
                        String string3 = (String)var15_55 + "\n  " + string2;
                    }
                    for (String string4 : pb.errors) {
                        void var15_57;
                        String string5 = (String)var15_57 + "\n  " + string4;
                    }
                } else {
                    String string = iii.irp.toString();
                    ++shownCount;
                }
                String string8 = (String)var15_60 + " : " + iii.location[1] + "/" + iii.location[2];
                string8 = string8 + "\n   ";
                string8 = string8 + ex.names.get(0);
                string8 = string8 + "\n\n";
                this.pw.print(string8.replaceAll("\\n", System.getProperty("line.separator")));
            }
            String string = "IRP values shown: " + shownCount + " of " + (int)var8_11 + "\n";
            this.pw.print(string.replaceAll("\\n", System.getProperty("line.separator")));
            this.pw.close();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            void var11_35;
            fw = new FileWriter("MAXQprotocols.txt");
            this.pw = new PrintWriter(fw);
            Iterator<Executor> iterator2 = this.execs.iterator();
            while (iterator2.hasNext()) {
                Executor e;
                JP2Analyzer.e = e = iterator2.next();
                String s3 = "";
                for (String string : e.names) {
                    s3 = s3 + string + "\n";
                }
                s3 = s3 + e.description;
                String pbDesc = "";
                Iterator<ProtocolBlock> iterator3 = e.pbList.iterator();
                while (iterator3.hasNext()) {
                    ProtocolBlock pb;
                    prb = pb = iterator3.next();
                    if (!pbDesc.isEmpty()) {
                        pbDesc = pbDesc + "\n- - - - - - - - - - - -\n";
                    }
                    pbDesc = pbDesc + pb.description;
                    for (String str : pb.warnings) {
                        pbDesc = pbDesc + str + "\n";
                    }
                    pbDesc = pbDesc + "\nPreamble:\n";
                    if (pb.preamble != null || pb.postamble != null && pb.postambleCommutable) {
                        pbDesc = pbDesc + (pb.preamble != null ? pb.preamble : "");
                        if (pb.postamble != null && pb.postambleCommutable) {
                            pbDesc = pbDesc + pb.postamble;
                        }
                        pbDesc = pbDesc + "\n";
                    } else {
                        pbDesc = pbDesc + "<none>\n";
                    }
                    for (Function f : pb.functions) {
                        pbDesc = pbDesc + "\nProcedure " + f.name + ":\n";
                        pbDesc = pbDesc + f.code;
                    }
                    if (!pb.sbVars.isEmpty()) {
                        pbDesc = pbDesc + "\nSB referenced variables:\n";
                        for (String str : pb.sbVars) {
                            pbDesc = pbDesc + str + "\n";
                        }
                    }
                    for (IRPstruct irp : pb.irps) {
                        pbDesc = pbDesc + irp + this.getCondition(irp) + "\n";
                    }
                }
                s3 = s3 + pbDesc;
                s3 = s3 + "\n--------------------\n\n";
                this.pw.print(s3.replaceAll("\\n", System.getProperty("line.separator")));
            }
            String string13 = "Count of executors: " + execCount + "\n";
            string13 = string13 + "Count of executors without code: " + execNoCodeCount + "\n";
            string13 = string13 + "Count of executors without SB code: " + execNoSBCodeCount + "\n";
            string13 = string13 + "Count of executors without SB code and only data changing PB code: " + execNoSBDataChPBCount + "\n";
            string13 = string13 + "Count of executors without SB code and only data and time changing PB code: " + execNoSBDataTimeChPBCount + "\n";
            string13 = string13 + "Unlabelled addresses:";
            Collections.sort(AssemblerItem.unlabelled);
            for (int i : AssemblerItem.unlabelled) {
                String string14 = (String)var11_35 + String.format(" $%02X", i);
            }
            this.pw.print(var11_35.replaceAll("\\n", System.getProperty("line.separator")));
            this.pw.close();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            void var8_13;
            fw = new FileWriter("MAXQtranslations.txt");
            this.pw = new PrintWriter(fw);
            boolean bl2 = false;
            shownCount = 0;
            for (Executor e : this.execs) {
                void var15_81;
                void var15_76;
                void var17_101;
                void var15_71;
                ++var8_13;
                JP2Analyzer.e = e;
                boolean hasErrors = !e.errors.isEmpty();
                for (ProtocolBlock protocolBlock : e.pbList) {
                    hasErrors = hasErrors || !protocolBlock.errors.isEmpty();
                }
                if (hasErrors) continue;
                ++shownCount;
                short nums = e.hex.getData()[2];
                String string = "";
                for (String string15 : e.names) {
                    String string16 = (String)var15_71 + string15 + "\n";
                }
                int fix = nums >> 4 & 0xF;
                String string17 = (String)var15_71 + "\n" + fix + " fixed byte" + (fix != 1 ? "s" : "");
                if (fix > 0) {
                    String string18 = string17 + ": bit-reversed";
                }
                boolean bl3 = false;
                while (var17_101 < fix) {
                    String string19 = (String)var15_76 + " " + "ABCDEFGHIJ".charAt((int)var17_101);
                    ++var17_101;
                }
                int n = nums & 0xF;
                String string20 = (String)var15_76 + "\n" + n + " variable byte" + (n != 1 ? "s" : "");
                if (n > 0) {
                    String string21 = string20 + ": bit-reversed";
                }
                for (int i = 0; i < n; ++i) {
                    String string22 = (String)var15_81 + " " + "XYZW".charAt(i);
                }
                String string23 = (String)var15_81 + "\n\n";
                String pbDesc = "";
                Iterator<ProtocolBlock> iterator4 = e.pbList.iterator();
                while (iterator4.hasNext()) {
                    String post;
                    ProtocolBlock pb;
                    prb = pb = iterator4.next();
                    if (pb.condition != null) {
                        pbDesc = pbDesc + "If " + pb.condition + "\n\n";
                    }
                    for (String str : pb.warnings) {
                        pbDesc = pbDesc + "***" + str + "\n";
                    }
                    String pre = pb.preamble != null ? pb.preamble.toString() : "";
                    String string24 = post = pb.postamble != null ? pb.postamble.toString() : "";
                    if (!pre.isEmpty() || !post.isEmpty() && pb.postambleCommutable) {
                        pbDesc = pbDesc + "Preamble:\n";
                        pbDesc = pbDesc + pre;
                        if (!post.isEmpty() && pb.postambleCommutable) {
                            if (!pre.isEmpty()) {
                                pbDesc = pbDesc + "- - -\n";
                            }
                            pbDesc = pbDesc + post;
                        }
                        pbDesc = pbDesc + "\n";
                    }
                    for (Function f : pb.functions) {
                        pbDesc = pbDesc + "Procedure " + f.name + ":\n";
                        pbDesc = pbDesc + f.code + "\n";
                    }
                    for (IRPstruct irp : pb.irps) {
                        pbDesc = pbDesc + irp + this.getCondition(irp) + "\n\n";
                    }
                }
                String string26 = string23 + pbDesc;
                string26 = string26 + "--------------------\n\n";
                this.pw.print(string26.replaceAll("\\n", System.getProperty("line.separator")));
            }
            String string = "Executors shown: " + shownCount + " of " + (int)var8_13 + "\n";
            this.pw.print(string.replaceAll("\\n", System.getProperty("line.separator")));
            this.pw.close();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyze(Processor p, String name) {
        this.getExecs(p);
        FileWriter fw = null;
        try {
            File analyses = new File(RemoteMaster.getWorkDir(), name);
            fw = new FileWriter(analyses);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PrintWriter pw = new PrintWriter(fw);
        String s = "";
        try {
            Iterator<Executor> iterator = this.execs.iterator();
            while (iterator.hasNext()) {
                Executor e;
                JP2Analyzer.e = e = iterator.next();
                for (String eName : e.names) {
                    s = s + eName + "\n";
                }
                s = s + this.analyze(p, e.hex);
                s = s + "\n----------------------------------------\n\n";
            }
        }
        finally {
            pw.print(s.replaceAll("\\n", System.getProperty("line.separator")));
            pw.close();
            try {
                fw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String getCondition(IRPstruct irp) {
        String condition = "";
        if (!irp.comments.isEmpty()) {
            boolean whenDone = false;
            condition = condition + "  //";
            LinkedHashMap<String, String> cMap = new LinkedHashMap<String, String>();
            for (String c : irp.comments) {
                int pos = c.indexOf(":1:");
                if (pos <= 0) continue;
                String var = c.substring(0, pos);
                int ndx = 7 - Integer.parseInt(c.substring(pos + 3, pos + 4));
                String n = c.substring(pos + 5, pos + 6);
                String val = (String)cMap.get(var);
                if (val == null) {
                    val = "xxxxxxxx";
                }
                val = val.substring(0, ndx) + n + val.substring(ndx + 1);
                cMap.put(var, val);
            }
            if (cMap.size() > 0) {
                if (!whenDone) {
                    condition = condition + " when";
                    whenDone = true;
                } else {
                    condition = condition + " and";
                }
                for (String c : cMap.keySet()) {
                    condition = condition + " " + c + "=" + (String)cMap.get(c);
                }
            }
            for (String c : irp.comments) {
                if (c.contains(":1:")) continue;
                if (c.contains("=") && !whenDone) {
                    condition = condition + " when";
                    whenDone = true;
                } else if (c.startsWith("when ") && whenDone) {
                    c = "and" + c.substring(4);
                }
                condition = condition + " " + c + ";";
            }
        }
        return condition;
    }

    private String disassemblePseudocode(int addr, Hex hex, String prefix, boolean[] flags, int returnMode) {
        int opLength;
        int index;
        AssemblerOpCode.AddressMode mode;
        AssemblerOpCode oc;
        Arrays.fill(flags, false);
        this.proc.setRelativeToOpStart(true);
        this.proc.setOneByteAbsoluteAddresses(true);
        String codeStr = "";
        if (hex == null) {
            codeStr = codeStr + "*** Code block invalid\n";
            return codeStr;
        }
        Hex pHex = new Hex(hex, 0, hex.length() + 4);
        pHex.set((short)111, pHex.length() - 4);
        short[] data = pHex.getData();
        this.itemList.clear();
        AssemblerTableModel.DisasmState state = new AssemblerTableModel.DisasmState();
        for (index = 0; index < pHex.length(); index += oc.getLength() + mode.length) {
            oc = this.proc.getOpCode(pHex.subHex(index));
            mode = oc.getMode();
            int i = 0;
            while (mode.relMap >> i != 0) {
                int newAddr;
                int n;
                if ((mode.relMap >> i & 1) == 1 && (n = index + oc.getLength() + i) < data.length && !this.labelAddresses.contains(newAddr = addr + index + data[n] - (data[n] > 127 ? 256 : 0))) {
                    this.labelAddresses.add(newAddr);
                }
                ++i;
            }
        }
        Collections.sort(this.labelAddresses);
        for (int i = 0; i < this.labelAddresses.size(); ++i) {
            this.labels.put(this.labelAddresses.get(i), "L" + i);
        }
        Arrays.fill(flags, false);
        for (index = 0; index < pHex.length(); index += opLength) {
            AssemblerItem item = new AssemblerItem(addr + index, pHex.subHex(index));
            opLength = item.disassemble(this.proc, this.labels, state);
            this.itemList.add(item);
        }
        if (returnMode == 1) {
            for (int i = 0; i < this.itemList.size(); ++i) {
                AssemblerItem item = this.itemList.get(i);
                String hexOut = item.getOpCode().getName().equals("END") ? "\t           " : this.addrHex(item.getAddress()) + item.getHex().toRawString();
                String str = hexOut + "\t" + item.getLabel() + "\t" + item.getOpCode().getName() + "\t" + item.getArgumentText();
                codeStr = codeStr + str + "\n";
            }
            return codeStr;
        }
        int i = 0;
        while (i < this.itemList.size()) {
            AssemblerItem item;
            int k;
            int j = i;
            while (++j < this.itemList.size() && this.itemList.get(j).getLabel().isEmpty()) {
            }
            int[] carriers = new int[]{this.carrier, this.has2usOff ? 12 : this.carrier, this.altCarrier};
            boolean[] freqFlags = new boolean[]{false, false};
            TimingStruct ts2 = new TimingStruct(carriers, this.tbDurations, this.pf);
            this.pfNew = (int[])this.pf.clone();
            for (k = i; k < j; ++k) {
                freqFlags[0] = false;
                item = this.itemList.get(k);
                this.addItemComments(item, carriers, freqFlags, ts2);
                this.changesFreq |= freqFlags[1];
            }
            freqFlags[0] = this.changesFreq;
            for (k = i; k < j; ++k) {
                item = this.itemList.get(k);
                int itemType = this.addItemComments(item, carriers, freqFlags, null);
                item.setType(itemType);
                if (itemType >= 0) {
                    flags[itemType] = true;
                }
                String hexOut = item.getOpCode().getName().equals("END") ? "\t           \t" : this.addrHex(item.getAddress()) + item.getHex().toRawString() + "\t";
                String str = returnMode == 2 ? hexOut : prefix;
                String argText = item.getArgumentText();
                for (int m = item.getArgumentText().length(); m < 18; ++m) {
                    argText = argText + " ";
                }
                str = str + item.getLabel() + "\t" + item.getOpCode().getName() + "\t" + argText;
                String comments = item.getComments();
                if (returnMode == 2) {
                    comments = comments.replaceAll("\n", "\n\t           \t");
                }
                if (comments != null && !comments.isEmpty()) {
                    str = str + "\t" + comments;
                }
                codeStr = codeStr + str + "\n";
            }
            i = j;
        }
        return codeStr;
    }

    public String disassembleNativeCode(int addr, Hex hex, String prefix) {
        int opLength;
        int index;
        int incr;
        String codeStr = "";
        if (this.procNative == null) {
            int remain = hex.length();
            int index2 = 0;
            while (remain > 0) {
                int len = remain > 16 ? 16 : remain;
                codeStr = codeStr + this.addrHex(addr) + hex.subHex(index2, len).toString() + "\n";
                index2 += len;
                remain -= len;
                addr += len;
            }
            return codeStr;
        }
        this.proc = this.procNative;
        this.proc.setRelativeToOpStart(true);
        this.proc.setOneByteAbsoluteAddresses(false);
        this.proc.getAddressList().clear();
        if (hex == null) {
            codeStr = codeStr + "*** Code block invalid\n";
            return codeStr;
        }
        Hex pHex = new Hex(hex);
        short[] data = pHex.getData();
        this.itemList.clear();
        AssemblerTableModel.DisasmState state = new AssemblerTableModel.DisasmState();
        for (index = 0; index < pHex.length(); index += incr) {
            currentAddr = addr + index;
            AssemblerOpCode oc = this.proc.getOpCode(pHex.subHex(index));
            AssemblerOpCode.AddressMode mode = oc.getMode();
            incr = oc.getLength() + mode.length;
            int i = 0;
            while (mode.relMap >> i != 0) {
                int newAddr;
                int n;
                if ((mode.relMap >> i & 1) == 1 && (n = index + i) < data.length && !this.labelAddresses.contains(newAddr = addr + index + 2 * (data[n] - (data[n] > 127 ? 256 : 0)) + incr)) {
                    this.labelAddresses.add(newAddr);
                }
                ++i;
            }
        }
        Collections.sort(this.labelAddresses);
        for (int i = 0; i < this.labelAddresses.size(); ++i) {
            this.labels.put(this.labelAddresses.get(i), "L" + i);
        }
        for (index = 0; index < pHex.length(); index += opLength) {
            currentAddr = addr + index;
            AssemblerItem item = new AssemblerItem(addr + index, pHex.subHex(index));
            opLength = item.disassemble(this.proc, this.labels, state);
            this.itemList.add(item);
        }
        for (int i = 0; i < this.itemList.size(); ++i) {
            AssemblerItem item = this.itemList.get(i);
            String hexOut = item.getHex().toRawString();
            String str = this.addrHex(item.getAddress()) + hexOut + "\t" + item.getLabel() + "\t";
            if (!this.proc.getAddressList().contains(item.getAddress())) {
                str = str + item.getOpCode().getName() + "\t" + item.getArgumentText();
            }
            codeStr = codeStr + str + "\n";
        }
        return codeStr;
    }

    private void analyzeExecutor(Hex hex) {
        int altExecStart;
        short tbHeader;
        this.simple = false;
        short[] data = hex.getData();
        data = hex.getData();
        int pos = 0;
        pos += 3;
        boolean tbHasSpec = ((tbHeader = data[pos++]) & 0x80) != 0;
        int tbSize = tbHeader & 0x3F;
        pos += (tbHasSpec ? 2 : 0) + tbSize;
        short dbHeader = data[pos++];
        int dbSize = dbHeader & 7;
        boolean hasAltExec = (dbHeader & 0x20) != 0;
        short dirOffset = dbSize > 2 ? data[pos + 2] : (short)0;
        int n = altExecStart = hasAltExec && dirOffset > 0 ? (pos += dbSize) + dirOffset : 0;
        if (altExecStart > 0) {
            this.analyzeSingleExec(hex.subHex(0, altExecStart));
            this.analyzeSingleExec(hex.subHex(altExecStart));
        } else {
            this.analyzeSingleExec(hex);
        }
    }

    private void analyzeSingleExec(Hex hex) {
        short[] data = hex.getData();
        JP2Analyzer.e.description = this.analyzeHeader(hex.subHex(0, 3)) + "\n";
        int pos = 0;
        short tbHeader = data[pos += 3];
        boolean tbHasSpec = (tbHeader & 0x80) != 0;
        int tbSize = (tbHeader & 0x3F) + (tbHasSpec ? 3 : 1);
        int tbStart = pos;
        pos += tbSize;
        short dbHeader = data[pos++];
        this.has2usOff = (dbHeader & 0x40) != 0;
        for (String str : this.analyzeTimingBlock(hex.subHex(tbStart, tbSize), true, 0, 64, null)) {
            JP2Analyzer.e.description = JP2Analyzer.e.description + str + "\n";
        }
        int carrierSaved = this.carrier;
        int[] durationsSaved = this.tbDurations;
        int dbSize = dbHeader & 7;
        this.hasNativeCode = (dbHeader & 0x80) != 0;
        boolean hasAltExec = (dbHeader & 0x20) != 0;
        int dbSwitch = !hasAltExec && dbSize > 1 ? hex.get(pos) : 0;
        pos += dbSize;
        if (this.completeItemList == null) {
            while (true) {
                prb = new ProtocolBlock();
                JP2Analyzer.prb.e = e;
                JP2Analyzer.e.pbList.add(prb);
                int pbOptionsSize = data[pos] & 0xF;
                short pbOffset = pbOptionsSize > 0 ? data[pos + 1] : (short)0;
                this.analyzeProtocolBlock(pos, pbOffset > 0 ? hex.subHex(pos, pbOffset) : hex.subHex(pos), null);
                if (pbOffset <= 0) break;
                pos += pbOffset;
            }
            return;
        }
        int altMask = dbSwitch & 0xFF;
        int altIndex = dbSwitch >> 12 & 0xF;
        int altCount = dbSwitch >> 8 & 0xF;
        int[] rev = new int[4];
        this.reverseByte(altMask, rev);
        if (rev[1] != rev[3] - rev[2] + 1) {
            JP2Analyzer.e.errors.add("Bits in directive switch mask are not consecutive");
        }
        int maxCount = 1;
        for (int i = 0; i < rev[1]; ++i) {
            maxCount *= 2;
        }
        if (altCount >= maxCount) {
            String err = "Number of protocol alternates greater than mask permits, so reset from ";
            err = err + String.format("%d to %d", altCount, maxCount - 1);
            JP2Analyzer.e.warnings.add(err);
            altCount = maxCount - 1;
        }
        String irpName = altCount > 0 ? this.irpLabel(this.proc.getDcBufStart() + altIndex) : "";
        for (int i = 0; i < maxCount; ++i) {
            short pbOffset;
            prb = JP2Analyzer.e.pbList.get(i);
            JP2Analyzer.prb.description = "";
            LinkedList<TimingStruct> altTimings = new LinkedList<TimingStruct>();
            int pbOptionsSize = data[pos] & 0xF;
            short s = pbOffset = pbOptionsSize > 0 ? data[pos + 1] : (short)0;
            if (altCount > 0) {
                JP2Analyzer.prb.condition = irpName + ":" + (rev[1] > 1 ? "-" : "") + rev[1] + (rev[2] > 0 ? ":" + rev[2] : "") + "=" + i;
                JP2Analyzer.prb.description = JP2Analyzer.prb.description + "\nProtocol block when " + JP2Analyzer.prb.condition + "\n";
            }
            int pbIndexSaved = this.pbIndex;
            JP2Analyzer.prb.description = JP2Analyzer.prb.description + this.analyzeProtocolBlock(pos, pbOffset > 0 ? hex.subHex(pos, pbOffset) : hex.subHex(pos), altTimings);
            while (!altTimings.isEmpty()) {
                TimingStruct ts = altTimings.pop();
                this.irpStruct = new IRPstruct();
                JP2Analyzer.prb.warnings.clear();
                JP2Analyzer.prb.irpParts11.clear();
                this.pbIndex = pbIndexSaved;
                boolean changed = this.runIREngine(pos, pbOffset > 0 ? hex.subHex(pos, pbOffset) : hex.subHex(pos), altTimings, ts);
                if (changed) continue;
                this.carrier = carrierSaved;
                this.tbDurations = durationsSaved;
                for (int k = 0; k < Math.max(JP2Analyzer.prb.irpParts11.size(), 1); ++k) {
                    IRPstruct struct = this.irpStruct;
                    if (JP2Analyzer.prb.irpParts11.size() > 0) {
                        String irpPart11 = JP2Analyzer.prb.irpParts11.get(k);
                        struct = this.irpStruct.clone();
                        struct.irStream = struct.irStream.replaceAll("irpPart11", irpPart11.substring(0, irpPart11.length() - 1));
                        struct.comments.clear();
                        struct.comments.add(JP2Analyzer.prb.sigSelector + "=" + k);
                    }
                    if (this.testIRPstruct(struct)) {
                        if (JP2Analyzer.prb.irps.contains(struct)) continue;
                        JP2Analyzer.prb.irps.add(struct);
                        continue;
                    }
                    if (!JP2Analyzer.prb.irps.contains(struct)) continue;
                    JP2Analyzer.prb.irps.remove(struct);
                }
            }
            if (pbOffset > 0) {
                pos += pbOffset;
                if (i <= altCount - 1) continue;
                JP2Analyzer.e.errors.add("More than specified number " + (altCount + 1) + "  of protocol blocks");
                continue;
            }
            if (i >= altCount) break;
            JP2Analyzer.e.errors.add("Fewer than specified number " + (altCount + 1) + " of protocol blocks");
            break;
        }
    }

    public String analyzeHeader(Hex hex) {
        String s = "";
        int[] carrierData = this.proc.getCarrierData(hex);
        this.carrier = carrierData[0];
        if (carrierData[1] == 0) {
            s = s + "Carrier is unmodulated\n";
            this.irpStruct.generalSpec = "{0k,";
        } else {
            double freqKhz = (double)this.proc.getOscillatorFreq() / 1000.0;
            double duty = (double)carrierData[1] / 10.0;
            s = s + String.format("%.2fkHz, duty cycle %.1f", freqKhz / (double)this.carrier, duty) + "%\n";
            this.irpStruct.generalSpec = String.format("{%.1fk,", freqKhz / (double)this.carrier);
        }
        short args = hex.getData()[this.proc.getProtocolHeaderSize() - 1];
        this.fix = args >> 4 & 0xF;
        this.var = args & 0xF;
        s = s + "" + this.fix + " fixed, " + this.var + " variable bytes";
        ArrayList<Object> allZeroLabels = new ArrayList<Object>();
        int start = this.proc.getDcBufStart();
        if (this.fix > 0) {
            allZeroLabels.add(new String[]{"Fix0", Integer.toHexString(start), "Fix", Integer.toHexString(this.fix)});
        }
        start += this.fix;
        if (this.var > 0) {
            allZeroLabels.add(new String[]{"Var0", Integer.toHexString(start), "Var", Integer.toHexString(this.var)});
        }
        if ((start += this.var) < 224) {
            allZeroLabels.add(new String[]{"Calc0", Integer.toHexString(start), "Calc", Integer.toHexString(16 - this.fix - this.var)});
        }
        allZeroLabels.addAll(Arrays.asList(this.proc.getBaseZeroLabels()));
        this.proc.setZeroLabels((String[][])allZeroLabels.toArray((T[])new String[0][0]));
        if (this.simple) {
            if (this.procNative != null) {
                this.procNative.setZeroLabels((String[][])allZeroLabels.toArray((T[])new String[0][0]));
            }
            if (this.fix > 0 || this.var > 0) {
                s = s + " (Read into ";
            }
            if (this.fix > 0) {
                s = s + "Fix0" + (this.fix > 1 ? "-Fix" + (this.fix - 1) : "") + (this.var > 0 ? ", " : "");
            }
            if (this.var > 0) {
                s = s + "Var0" + (this.var > 1 ? "-Var" + (this.var - 1) : "");
            }
            if (this.fix > 0 || this.var > 0) {
                s = s + ")";
            }
        }
        return s + "\n";
    }

    private int calculateUnit(int provUnit, int tolerance) {
        double fracpart;
        double ratio;
        double val;
        int j;
        int i;
        int n;
        int tbFlags = (this.tbUsed | 3) & 0x6B;
        int[] sizes = new int[]{2, 2, 1, 2, 1, 2, 2, 1};
        int[] usDurations = new int[this.tbDurations.length];
        int n2 = 0;
        for (int i2 = 0; i2 < 7; ++i2) {
            for (int j2 = 0; j2 < this.tbLengths[i2] * sizes[i2] && n2 < this.tbDurations.length; ++j2) {
                int val2 = this.durationToMicrosecs(this.tbDurations[n2], this.carrier, (j2 & 1) == 0 && sizes[i2] == 2 || !this.has2usOff);
                usDurations[n2++] = val2;
            }
        }
        int nmax = (int)Math.round(1.1 * (double)provUnit + 1.0);
        int nmin = (int)Math.round(0.9 * (double)provUnit - 1.0);
        double fracmax = 0.0;
        double fracminmax = 1.0;
        for (int testUnit = nmin; testUnit <= nmax; ++testUnit) {
            fracmax = 0.0;
            n = 0;
            for (i = 0; i < 7; ++i) {
                for (j = 0; j < this.tbLengths[i] * sizes[i] && n < usDurations.length; ++j) {
                    int n3 = n++;
                    val = usDurations[n3];
                    if (!(val > 0.0) || (tbFlags >> i & 1) != 1) continue;
                    ratio = val / (double)testUnit;
                    fracpart = Math.abs(ratio - Math.rint(ratio));
                    fracmax = Math.max(fracmax, fracpart / ratio);
                }
            }
            if (!(fracmax < fracminmax)) continue;
            fracminmax = fracmax;
            this.unit = testUnit;
        }
        int no = 0;
        n = 0;
        for (i = 0; i < 7; ++i) {
            for (j = 0; j < this.tbLengths[i] * sizes[i] && n < usDurations.length; ++j) {
                int n4 = n++;
                val = usDurations[n4];
                if (!(val > 0.0) || (tbFlags >> i & 1) != 1 || !((fracpart = Math.abs((ratio = val / this.unit) - Math.rint(ratio))) / ratio > (double)tolerance / 100.0)) continue;
                ++no;
            }
        }
        return no;
    }

    private List<String> analyzeTimingBlock(Hex hex, boolean heads, int start, int end, TimingStruct ts) {
        int n5;
        String str = "";
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> warn = new ArrayList<String>();
        if (heads) {
            if (ts == null) {
                short[] data = hex.getData();
                short tbHeader = data[0];
                int spec = (tbHeader & 0x80) != 0 ? hex.get(1) : 0;
                this.tbLengths = new short[]{1, 1, 1, 1, 1, 1, 1, 1};
                int i = 0;
                while (i < 8) {
                    int n2 = i++;
                    this.tbLengths[n2] = (short)(this.tbLengths[n2] + (spec & 3));
                    spec >>= 2;
                }
                int tbSize = (tbHeader & 0x3F) / 2;
                int pos = (tbHeader & 0x80) != 0 ? 3 : 1;
                this.tbDurations = new int[tbSize];
                for (int i2 = 0; i2 < tbSize; ++i2) {
                    this.tbDurations[i2] = this.proc.getInt(data, pos);
                    pos += 2;
                }
            }
            if (ts != null) {
                this.tbDurations = ts.durations;
            }
            int tbSize = this.tbDurations.length;
            str = "Raw timing data PD00-PD" + String.format("%02X: ", tbSize - 1);
            for (int i = 0; i < tbSize; ++i) {
                str = str + (i > 0 ? ", " : "") + this.tbDurations[i];
            }
            list.add(str);
            if (this.has2usOff) {
                list.add("Raw OFF times are in units of 2us");
            }
            int min = 10000;
            int[] sizes = new int[]{2, 2, 1, 2, 1, 2, 2, 1};
            int tbFlags = (this.tbUsed | 3) & 0x6B;
            n5 = 0;
            for (int i = 0; i < 7; ++i) {
                for (int j = 0; j < this.tbLengths[i] * sizes[i] && n5 < this.tbDurations.length; ++j) {
                    int val;
                    if ((val = this.durationToMicrosecs(this.tbDurations[n5++], this.carrier, (j & 1) == 0 && sizes[i] == 2 || !this.has2usOff)) <= 0 || (tbFlags >> i & 1) != 1) continue;
                    min = Math.min(min, val);
                }
            }
            if (this.tbUsed != 0) {
                int nonint = this.calculateUnit(min, 5);
                if (nonint > 0) {
                    nonint = this.calculateUnit(min / 2, 5);
                }
                if (nonint > 0) {
                    nonint = this.calculateUnit(min / 3, 5);
                }
                if (nonint > 0) {
                    nonint = this.calculateUnit(min, 5);
                }
                if (nonint > 0) {
                    this.unit = 1.0;
                }
            } else if (this.tbUsed == 0) {
                this.unit = min;
            }
            this.irpStruct.generalSpec = this.irpStruct.generalSpec + (this.unit == 1.0 ? "}" : (int)this.unit + "}");
            this.irpStruct.unit = (int)this.unit;
        }
        ArrayList<Integer> irpVals = heads || start == 0 && end == 64 ? new ArrayList<Integer>() : null;
        int[] limits = new int[]{0, 0};
        int codeSpec = this.initialCodeSpec == -1 ? 0 : this.initialCodeSpec;
        int codeSelector = codeSpec & 0xF;
        int n3 = codeSelector = codeSelector > 5 ? 0 : codeSelector;
        if ((codeSpec & 0x10) != 0) {
            this.getTimingItem(7, limits, null, warn);
            warn.clear();
        } else {
            this.altCarrier = 0;
        }
        if (codeSelector == 1) {
            int size = this.tbLengths[0] + this.tbLengths[1] > 7 ? 2 : 1;
            n5 = 0;
            if (heads) {
                this.irpStruct.bitSpec = "<";
            }
            for (int i = 0; i < 4; ++i) {
                str = "";
                for (int j = 0; j < size; ++j) {
                    int val;
                    if ((val = this.durationToMicrosecs(this.tbDurations[n5++], this.carrier, true)) > 0) {
                        str = str + (str.isEmpty() ? "" : ",");
                        str = str + "+" + val;
                        if (heads) {
                            this.irpStruct.bitSpec = this.irpStruct.bitSpec + this.getIRPduration(val, warn) + ",";
                            if (prb != null) {
                                JP2Analyzer.prb.warnings.addAll(warn);
                            }
                            warn.clear();
                        }
                    }
                    if ((val = this.durationToMicrosecs(this.tbDurations[n5++], this.carrier, !this.has2usOff)) <= 0) continue;
                    str = str + (str.isEmpty() ? "" : ",");
                    str = str + "-" + val;
                    if (!heads) continue;
                    this.irpStruct.bitSpec = this.irpStruct.bitSpec + -this.getIRPduration(val, warn) + ",";
                    if (prb != null) {
                        JP2Analyzer.prb.warnings.addAll(warn);
                    }
                    warn.clear();
                }
                if (heads) {
                    this.irpStruct.bitSpec = this.irpStruct.bitSpec.substring(0, this.irpStruct.bitSpec.length() - 1) + "|";
                }
                String range = String.format("(PD%02X-PD%02X) ", 2 * i * size, 2 * (i + 1) * size - 1);
                if (start > 2 * i * size || 2 * i * size > end) continue;
                list.add("Bursts for bit-pair " + (new String[]{"00", "01", "10", "11"})[i] + " (us): " + range + str);
            }
            if (heads) {
                this.irpStruct.bitSpec = this.irpStruct.bitSpec.substring(0, this.irpStruct.bitSpec.length() - 1) + ">";
            }
        } else {
            int n4;
            if (heads && codeSelector == 5) {
                list.add("Data uses base 16 encoding, 4-bit group with value n being converted\n  for transmission to a 1 followed by n 0's ");
                this.irpStruct.base16 = true;
            }
            str = this.getTimingItem(0, limits, irpVals, warn);
            if (prb != null) {
                JP2Analyzer.prb.warnings.addAll(warn);
            }
            warn.clear();
            String oneStr = "";
            if (!str.isEmpty() && start <= limits[0] && limits[0] <= end) {
                list.add("1-bursts (us): " + str);
                if (irpVals != null) {
                    Iterator n5 = irpVals.iterator();
                    while (n5.hasNext()) {
                        n4 = (Integer)n5.next();
                        oneStr = oneStr + n4 + ",";
                    }
                    this.irpParts[2] = irpVals.get(0) + ",";
                }
            }
            str = this.getTimingItem(1, limits, irpVals, warn);
            if (prb != null) {
                JP2Analyzer.prb.warnings.addAll(warn);
            }
            warn.clear();
            if (!str.isEmpty() && start <= limits[0] && limits[0] <= end) {
                list.add("0-bursts (us): " + str);
                if (heads && (codeSpec & 0x20) != 0) {
                    list.add("Only first burst-pair of 0-burst is sent if an odd number of bits precede it");
                }
                if (heads && irpVals != null) {
                    this.irpStruct.bitSpec = "<";
                    Iterator n5 = irpVals.iterator();
                    while (n5.hasNext()) {
                        n4 = (Integer)n5.next();
                        this.irpStruct.bitSpec = this.irpStruct.bitSpec + n4 + ",";
                    }
                    this.irpStruct.bitSpec = this.irpStruct.bitSpec.substring(0, this.irpStruct.bitSpec.length() - 1) + "|" + oneStr.substring(0, oneStr.length() - 1) + ">";
                }
            }
        }
        str = this.getTimingItem(2, limits, irpVals, warn);
        if (!str.isEmpty() && (this.tbUsed & 4) != 0 && start <= limits[0] && limits[0] <= end) {
            list.add("Lead-out (us): " + str);
            if (irpVals != null) {
                int value = (Integer)irpVals.get(0);
                if (value > 0) {
                    if (value < 50000) {
                        this.irpParts[1] = -value + "u,";
                    } else {
                        value = (value + 500) / 1000;
                        this.irpParts[1] = -value + "m,";
                    }
                } else {
                    this.irpParts[1] = irpVals.get(0) + ",";
                    if (prb != null) {
                        JP2Analyzer.prb.warnings.addAll(warn);
                    }
                }
            }
        }
        warn.clear();
        str = this.getTimingItem(3, limits, irpVals, warn);
        if (!str.isEmpty() && (this.tbUsed & 8) != 0 && start <= limits[0] && limits[0] <= end) {
            list.add("Lead-in (us): " + str);
            if (irpVals != null) {
                this.irpParts[0] = "";
                if (irpVals.size() > 0) {
                    Iterator value = irpVals.iterator();
                    while (value.hasNext()) {
                        int n6 = (Integer)value.next();
                        this.irpParts[0] = this.irpParts[0] + n6 + ",";
                    }
                    this.irpParts[9] = irpVals.get(0) + "," + (irpVals.size() > 1 ? (Integer)irpVals.get(1) / 2 + "," : "");
                }
                if (prb != null) {
                    JP2Analyzer.prb.warnings.addAll(warn);
                }
            }
        }
        warn.clear();
        str = this.getTimingItem(4, limits, irpVals, warn);
        if (!str.isEmpty() && (this.tbUsed & 0x10) != 0 && start <= limits[0] && limits[0] <= end) {
            list.add("Alternate lead-out (us): " + str);
            if (irpVals != null) {
                int value = (Integer)irpVals.get(0);
                if (value > 0) {
                    if (value < 50000) {
                        this.irpParts[6] = -value + "u,";
                    } else {
                        value = (value + 500) / 1000;
                        this.irpParts[6] = -value + "m,";
                    }
                } else {
                    this.irpParts[6] = irpVals.get(0) + ",";
                    if (prb != null) {
                        JP2Analyzer.prb.warnings.addAll(warn);
                    }
                }
            }
        }
        warn.clear();
        str = this.getTimingItem(5, limits, irpVals, warn);
        if (!str.isEmpty() && (this.tbUsed & 0x20) != 0 && start <= limits[0] && limits[0] <= end) {
            list.add("Alternate lead-in (us): " + str);
            if (irpVals != null) {
                this.irpParts[5] = "";
                Iterator iterator = irpVals.iterator();
                while (iterator.hasNext()) {
                    int n7 = (Integer)iterator.next();
                    this.irpParts[5] = this.irpParts[5] + n7 + ",";
                }
                if (prb != null) {
                    JP2Analyzer.prb.warnings.addAll(warn);
                }
            }
        }
        warn.clear();
        str = this.getTimingItem(6, limits, irpVals, warn);
        if (!str.isEmpty() && (this.tbUsed & 0x40) != 0 && start <= limits[0] && limits[0] <= end) {
            list.add("Mid-frame burst (us): " + str);
        }
        warn.clear();
        if ((codeSpec & 0x10) != 0 && !(str = this.getTimingItem(7, limits, null, warn)).isEmpty() && start <= limits[0] && limits[0] <= end) {
            list.add("0-burst carrier times (units of 1/6us): " + str);
        }
        return list;
    }

    private int getIRPduration(int usDuration, List<String> warn) {
        double ratio = (double)usDuration / this.unit;
        double delta = Math.abs(ratio - (double)Math.round(ratio));
        if (delta > 0.05 * ratio) {
            String w = String.format("*** Diff %.2f", 100.0 * delta / ratio) + "%" + String.format(" in converting %d with unit %d", usDuration, (int)this.unit);
            warn.add(w);
        }
        return (int)Math.round(ratio);
    }

    private String getTimingItem(int n, int[] limits, List<Integer> irpVals, List<String> warn) {
        int itemCarrier = this.carrier;
        if (n == 1 && this.altCarrier != 0) {
            itemCarrier = this.altCarrier;
        }
        int[] durations = this.tbDurations;
        return this.getTimingItem(n, itemCarrier, durations, limits, irpVals, warn);
    }

    private String getTimingItem(int n, int itemCarrier, int[] durations, int[] limits, List<Integer> irpVals, List<String> warn) {
        if (irpVals != null) {
            irpVals.clear();
        }
        int pos = 0;
        int[] sizes = new int[]{2, 2, 1, 2, 1, 2, 2, 1};
        String str = "";
        for (int i = 0; i < n; ++i) {
            pos += this.tbLengths[i] * sizes[i];
        }
        if (pos + this.tbLengths[n] * sizes[n] > durations.length) {
            return str;
        }
        limits[0] = pos;
        limits[1] = pos + this.tbLengths[n] * sizes[n] - 1;
        String range = String.format("(PD%02X", pos);
        if (limits[1] > limits[0]) {
            range = range + String.format("-PD%02X", limits[1]);
        }
        range = range + ") ";
        for (int i = 0; i < this.tbLengths[n]; ++i) {
            int val;
            if (sizes[n] == 2) {
                if ((val = this.durationToMicrosecs(durations[pos++], itemCarrier, true)) > 0) {
                    str = str + (str.isEmpty() ? "" : ",");
                    str = str + "+" + val;
                    if (irpVals != null) {
                        irpVals.add(this.getIRPduration(val, warn));
                    }
                }
                if ((val = this.durationToMicrosecs(durations[pos++], itemCarrier, !this.has2usOff)) <= 0) continue;
                str = str + (str.isEmpty() ? "" : ",");
                str = str + "-" + val;
                if (irpVals == null) continue;
                irpVals.add(-this.getIRPduration(val, warn));
                continue;
            }
            val = 0;
            while (i < this.tbLengths[n]) {
                val += durations[pos++] << 16 * i;
                ++i;
            }
            if (n != 7) {
                if ((val = this.durationToMicrosecs(val, itemCarrier, !this.has2usOff)) <= 0) continue;
                str = str + "-" + val;
                if (irpVals == null) continue;
                int wSize = warn.size();
                int irpDur = this.getIRPduration(val, warn);
                if (irpDur <= 50 && warn.size() == wSize) {
                    irpVals.add(-irpDur);
                    continue;
                }
                irpVals.add(val);
                continue;
            }
            if (val <= 0) continue;
            Hex hex = new Hex(2 * this.tbLengths[7]);
            for (int j = 0; j < 2 * this.tbLengths[7]; ++j) {
                hex.set((short)(val >> 8 * j & 0xFF), j);
            }
            int[] carrierData = this.proc.getCarrierData(hex);
            this.altCarrier = carrierData[0];
            int on = (carrierData[0] * carrierData[1] + 500) / 1000;
            int off = carrierData[0] - on;
            str = str + "+" + on + ",-" + off;
        }
        return !str.isEmpty() ? range + str : str;
    }

    private void reverseByte(int n, int[] togData) {
        togData[3] = -1;
        for (int i = 0; i < 8; ++i) {
            int b = n & 1;
            togData[0] = togData[0] << 1;
            togData[1] = togData[1] + b;
            togData[0] = togData[0] | b;
            if (b == 1) {
                togData[2] = 7 - i;
                if (togData[3] < 0) {
                    togData[3] = 7 - i;
                }
            }
            n >>= 1;
        }
    }

    private String analyzeToggle(int toggle, int[] togData) {
        String togStr = "";
        int type = toggle >> 12 & 0xF;
        int index = toggle >> 8 & 0xF;
        int mask = toggle & 0xFF;
        String label = this.getZeroLabel(this.proc.getDcBufStart() + index);
        if ((type & 4) != 0) {
            togStr = togStr + "When toggle counter T is odd, XOR " + label + " with mask";
            if (mask > 0) {
                togStr = togStr + String.format(" #$%02X\n", mask);
            }
        } else {
            togStr = togStr + "Replace the bits of " + label + " selected by mask ";
            if (mask > 0) {
                togStr = togStr + String.format(" #$%02X\n", mask);
            }
            togStr = togStr + "with " + ((type & 8) != 0 ? "the complement of " : "");
            togStr = togStr + "the least significant bits of toggle counter T";
        }
        if (togData != null) {
            this.reverseByte(mask, togData);
            togData[4] = index;
            togData[5] = type & 0xC;
        }
        return togStr;
    }

    private Node makeBranch(Node node, List<Integer> validTypes, int limit) {
        for (int i = node.start; i < limit; ++i) {
            AssemblerItem item = this.completeItemList.get(i);
            int type = item.get_Type();
            if (!validTypes.contains(type)) {
                JP2Analyzer.prb.errors.add("Irregular instruction  at no. " + i + "/" + limit);
            }
            if (item.getLabel() != null && this.loopIndex.get(item.getLabel()) != null) {
                String ctrlVar;
                if (i > node.start) {
                    int[] branch = new int[]{i, i, -1};
                    node.branch = branch;
                    node.branchType = 13;
                    return node;
                }
                int loopCtrl = this.loopIndex.get(item.getLabel());
                int[] branch = new int[]{i, i + 1, this.loopIndex.get(item.getLabel()) + 1};
                node.branch = branch;
                AssemblerItem ctrlItem = this.completeItemList.get(loopCtrl);
                node.branchVar = ctrlVar = this.irpLabel(ctrlItem.getHex().getData()[2]);
                node.branchType = 11;
                return node;
            }
            if (item.getOperation().equals("DBNZ")) {
                String label = this.labels.get(item.getAddress() + item.getHex().getData()[1] - 256);
                String ctrlVar = this.irpLabel(item.getHex().getData()[2]);
                int[] branch = new int[]{i, i + 1, this.labelIndex.get(label) != null ? this.labelIndex.get(label) : -1};
                node.branch = branch;
                node.branchVar = ctrlVar;
                node.branchType = 12;
                return node;
            }
            if (item.getOperation().equals("BSR")) {
                node.branch = new int[]{i, i + 1, -1};
                node.branchType = 15;
                return node;
            }
            if (item.getOperation().equals("RTS")) {
                node.branch = new int[]{i, -1, -1};
                node.branchType = 14;
                return node;
            }
            if (type == 2 || type == 7 || type == 8 || type == 13 || type == 16) {
                int[] branch = new int[3];
                branch[0] = i;
                String args = item.getArgumentText();
                String[] argArray = new String[4];
                StringTokenizer st = new StringTokenizer(args, ",");
                int index = 0;
                while (st.hasMoreTokens()) {
                    argArray[index++] = st.nextToken().trim();
                }
                String destLabel = argArray[1] == null ? argArray[0] : argArray[1];
                int destIndex = 0;
                if (argArray[1] != null) {
                    int yes = 1;
                    int no = 2;
                    if (argArray[0].equals("NZ") || argArray[0].equals("F")) {
                        yes = 2;
                        no = 1;
                    }
                    destIndex = this.labelIndex.get(destLabel);
                    branch[no] = i + 1;
                    branch[yes] = destIndex;
                    if (type == 2) {
                        String v = this.irpLabel(argArray[2]) != null ? this.irpLabel(argArray[2]) : argArray[2];
                        int a = Integer.parseInt(argArray[3].substring(2), 16);
                        int[] rev = new int[4];
                        this.reverseByte(a, rev);
                        if (rev[1] == 1) {
                            node.branchType = rev[2];
                            node.branchVar = v;
                        } else {
                            node.branchType = 256 + rev[0];
                            node.branchVar = v;
                        }
                    } else if (type == 8) {
                        String cond = argArray[2];
                        String opComment = this.proc.getLblComments().get(cond);
                        if (opComment != null && opComment.startsWith("Test if")) {
                            node.branchType = 8;
                            node.branchVar = opComment.substring(8);
                        }
                    } else {
                        node.branchType = 9;
                    }
                    node.branch = branch;
                    return node;
                }
                destLabel = argArray[0];
                branch[1] = destIndex = this.labelIndex.get(destLabel).intValue();
                branch[2] = -1;
                node.branch = branch;
                node.branchType = 10;
                return node;
            }
            if (item.getLabel() != null && this.labelIndex.get(item.getLabel()) != null && this.labelIndex.get(item.getLabel()) != this.treeRoot && this.functionIndex.get(item.getLabel()) != null) {
                node.branch = new int[]{i, -1, -1};
                node.branchType = 16;
                return node;
            }
            if (i != limit - 1) continue;
            int[] branch = new int[]{i, -1, -1};
            node.branch = branch;
            return node;
        }
        return null;
    }

    private String analyzeProtocolBlock(int addr, Hex hex, LinkedList<TimingStruct> altTimings) {
        boolean pbHasCode;
        String s = "";
        int pos = 0;
        short[] data = hex.getData();
        short pbHeader = data[pos++];
        int pbOptSize = pbHeader & 0xF;
        int pbSwitch = pbOptSize > 2 ? hex.get(pos + 1) : 0;
        int pbSwitchMask = pbSwitch & 0xFF;
        int pbSwitchIndex = pbSwitch >> 12 & 0xF;
        int pbSwitchSize = pbSwitch >> 8 & 0xF;
        int codeSpec = pbOptSize > 3 ? data[pos + 3] : 0;
        int toggle = pbOptSize > 5 ? hex.get(pos + 4) : 0;
        int codeSelector = codeSpec & 0xF;
        if (this.initialCodeSpec == -1) {
            this.initialCodeSpec = codeSpec;
        } else if (this.initialCodeSpec != codeSpec) {
            s = s + "Codespec changed " + String.format("from $%02X to $%02X", this.initialCodeSpec, codeSpec);
        }
        if (codeSelector > 5 && codeSelector < 12) {
            s = s + "Data is sent with asynchronous coding, with one start bit (1), ";
            s = s + (new String[]{"no", "even", "odd"})[codeSelector % 3] + " parity bit, ";
            s = s + (codeSelector < 9 ? "1 stop bit (0)\n" : "2 stop bits (00)\n");
            JP2Analyzer.prb.errors.add("Uses asynchronous coding, not yet supported");
        }
        pos += pbOptSize;
        boolean bl = pbHasCode = (pbHeader & 0x80) != 0;
        if (!pbHasCode) {
            if (this.completeItemList != null) {
                altTimings.add(new TimingStruct());
            }
        } else {
            ++this.pbIndex;
            boolean[] flags = new boolean[20];
            JP2Analyzer.prb.hasPBcode = true;
            s = s + "\nProtocol block code (run on first frame only, after PF bytes read):\n";
            short cbSize = data[pos++];
            s = s + this.disassemblePseudocode(addr + pos, hex.subHex(pos, cbSize), "", flags, 0);
            if (this.fullItemList != null) {
                AssemblerItem item = new AssemblerItem();
                item.setLabel("PB" + this.pbIndex);
                this.fullItemList.add(item);
                this.fullItemList.addAll(this.itemList);
            } else if (this.completeItemList != null) {
                Object label;
                for (int i = 0; i < this.completeItemList.size(); ++i) {
                    AssemblerItem ai = this.completeItemList.get(i);
                    label = ai.getLabel();
                    if (!((String)label).isEmpty()) {
                        this.labelIndex.put((String)label, i);
                    }
                    if (ai.getOperation().equals("DBNZ") || ai.getHex() != null && ai.getHex().getData()[0] == 85 && ai.getHex().getData()[1] >= 128) {
                        label = this.labels.get(ai.getAddress() + ai.getHex().getData()[1] - 256);
                        this.loopIndex.put((String)label, i);
                        continue;
                    }
                    if (!ai.getOperation().equals("BSR")) continue;
                    short offset = ai.getHex().getData()[1];
                    label = this.labels.get(ai.getAddress() + offset - (offset >= 128 ? 256 : 0));
                    if (this.functionIndex.get(label) != null) continue;
                    String name = "Proc" + this.functionIndex.size();
                    Function fn = new Function(name);
                    this.functionIndex.put((String)label, fn);
                }
                int start = this.labelIndex.get("PB" + this.pbIndex);
                List<Integer> paths = this.createCodePaths(start, 0);
                if (paths.isEmpty()) {
                    altTimings.add(new TimingStruct());
                } else {
                    label = paths.iterator();
                    while (label.hasNext()) {
                        int p = (Integer)label.next();
                        TimingStruct ts2 = new TimingStruct();
                        ts2.pbPath = p;
                        altTimings.add(ts2);
                    }
                }
                String interp = this.interpretPB(start);
                if (!interp.isEmpty()) {
                    s = s + "\n" + interp + "\n";
                }
                if (!this.nodeList.isEmpty()) {
                    s = s + "\nPB Nodes:\n";
                }
                for (int n : this.nodeList.keySet()) {
                    int[] b = this.nodeList.get((Object)Integer.valueOf((int)n)).branch;
                    s = s + n + " " + b[0] + " " + b[1] + " " + b[2] + "\n";
                }
            }
            pos += cbSize;
        }
        int[] togData = null;
        if (toggle > 0) {
            togData = new int[6];
            s = s + (pbHasCode ? "After protocol block code is run, apply toggle:\n  " : "Toggle: ");
            s = s + this.analyzeToggle(toggle, togData);
        }
        this.choices = new boolean[30];
        Arrays.fill(this.choices, false);
        this.blockCount = 0;
        this.maxBlocks = 1;
        this.brackets = 0;
        boolean more = true;
        this.sbIndex = 0;
        this.firstFrame = true;
        if (pbSwitchSize > 0) {
            int[] rev = new int[4];
            this.reverseByte(pbSwitchMask, rev);
            if (rev[1] != rev[3] - rev[2] + 1) {
                JP2Analyzer.prb.errors.add("Bits in protocol switch mask are not consecutive");
            }
            String irpName = this.irpLabel(this.proc.getDcBufStart() + pbSwitchIndex);
            JP2Analyzer.prb.sigSelector = irpName + ":" + (rev[1] > 1 ? "-" : "") + rev[1] + (rev[2] > 0 ? ":" + rev[2] : "");
        }
        while (more) {
            int[][] pfDescs;
            ++this.blockCount;
            Arrays.fill(this.choices, false);
            this.choices[15] = toggle > 0;
            int sigPtr = pos;
            if (pos >= data.length) {
                s = s + "*** Signal block missing ***\n";
                return s;
            }
            if (this.blockCount > this.maxBlocks) {
                s = s + "*** Unreachable signal block\n";
            }
            Arrays.fill(this.pf, 0);
            this.pf[0] = data[pos++];
            int formatLen = this.pf[0] & 7;
            for (int i = 1; i <= formatLen; ++i) {
                this.pf[i] = data[sigPtr + i];
            }
            boolean sbHasAlternates = (this.pf[5] & 0xF0) > 0;
            boolean sbHasCode = (this.pf[0] & 0x80) != 0;
            boolean sbCodeBeforeTX = (this.pf[6] & 0x80) != 0;
            this.minRpts = this.pf[3] & 0x3F;
            int txCount = this.pf[2] & 0x1F;
            if (sbHasAlternates) {
                s = s + "Signal block " + this.blockCount + ":\n";
            } else if (this.blockCount < 4) {
                String[] order = new String[]{"Initial", "Second", "Third"};
                s = s + "\n" + order[this.blockCount - 1] + " signal block:\n";
            }
            s = s + "  Raw format data PF0-PF" + formatLen + ": ";
            for (int i = 0; i <= formatLen; ++i) {
                s = s + String.format("$%02X", this.pf[i]);
                s = s + (i < formatLen ? ", " : "\n");
            }
            this.pfNew = (int[])this.pf.clone();
            for (int[] pfDesc : pfDescs = new int[][]{{-1, 1, 6}, {128, 4, 0}, {8, 1, 3}, {4, 1, 2}, {-1, 0, 6}, {63, 3, 0}, {-1, 1, 4}, {224, 2, 5}, {128, 3, 7}, {255, 5, 0}}) {
                if (pfDesc[0] >= 0 && (this.pf[pfDesc[1]] & pfDesc[0]) <= 0) continue;
                s = s + "  " + this.getPFdescription(pfDesc[1], pfDesc[2], this.choices) + "\n";
            }
            pos += formatLen;
            String txStr = "";
            for (int i = 0; i <= pbSwitchSize; ++i) {
                Hex txBytes = hex.subHex(pos, txCount);
                txStr = txStr + "\n  Data translation";
                if (pbSwitchSize > 0) {
                    txStr = txStr + " (when " + JP2Analyzer.prb.sigSelector + "=" + i + ")";
                }
                txStr = txBytes.length() > 0 ? txStr + ", sets data bytes TXDn to send and number of bits TXBn from each byte (n=0 to " + (txBytes.length() - 1) + "):\n    " : txStr + ": ";
                txStr = txStr + this.translateTXBytes(txBytes, JP2Analyzer.prb.sbVars);
                pos += txCount;
                if (i >= pbSwitchSize) continue;
                txCount = data[pos++];
            }
            if (pbSwitchSize > 0) {
                if (pos != data.length) {
                    txStr = txStr + "*** Excess data in protocol block ***\n";
                }
                s = s + txStr;
                return s;
            }
            more = sbHasAlternates;
            if (more) continue;
            String codeStr = "";
            if (sbHasCode) {
                ++this.sbIndex;
                JP2Analyzer.prb.hasSBcode = true;
                boolean[] flags = new boolean[30];
                codeStr = codeStr + "\n  Signal block code";
                if (txCount > 0) {
                    codeStr = codeStr + " (run " + (sbCodeBeforeTX ? "before" : "after") + " data translation)";
                }
                codeStr = codeStr + ":\n";
                short cbSize = data[pos++];
                codeStr = codeStr + this.disassemblePseudocode(addr + pos, hex.subHex(pos, cbSize), "  ", flags, 0);
                if (this.fullItemList != null) {
                    AssemblerItem item = new AssemblerItem();
                    item.setLabel("SB" + this.sbIndex);
                    this.fullItemList.add(item);
                    this.fullItemList.addAll(this.itemList);
                    ArrayList<String> destList = new ArrayList<String>();
                    ArrayList<String> srcList = new ArrayList<String>();
                    for (AssemblerItem it : this.itemList) {
                        if (this.getReferenced(it, destList, srcList, true)) continue;
                        JP2Analyzer.prb.errors.add("Indeterminate source in SB code");
                    }
                    for (String var : srcList) {
                        if (JP2Analyzer.prb.sbVars.contains(var)) continue;
                        JP2Analyzer.prb.sbVars.add(var);
                    }
                } else if (this.completeItemList != null) {
                    for (int i = 0; i < this.completeItemList.size(); ++i) {
                        AssemblerItem ai = this.completeItemList.get(i);
                        String label = ai.getLabel();
                        if (!label.isEmpty()) {
                            this.labelIndex.put(label, i);
                        }
                        if (ai.getOperation().equals("DBNZ") || ai.getHex() != null && ai.getHex().getData()[0] == 85 && ai.getHex().getData()[1] >= 128) {
                            label = this.labels.get(ai.getAddress() + ai.getHex().getData()[1] - 256);
                            this.loopIndex.put(label, i);
                            continue;
                        }
                        if (!ai.getOperation().equals("BSR")) continue;
                        short offset = ai.getHex().getData()[1];
                        label = this.labels.get(ai.getAddress() + offset - (offset >= 128 ? 256 : 0));
                        if (this.functionIndex.get(label) != null) continue;
                        String name = "Proc" + this.functionIndex.size();
                        Function fn = new Function(name);
                        this.functionIndex.put(label, fn);
                    }
                    int start = this.labelIndex.get("SB" + this.sbIndex);
                    List<Integer> paths = this.createCodePaths(start, 0);
                    if (!paths.isEmpty()) {
                        altTimings.add(null);
                        while (altTimings.peek() != null) {
                            TimingStruct ts2 = altTimings.pop();
                            for (int p : paths) {
                                TimingStruct ts3 = ts2.clone();
                                ts3.sbPaths.put(this.sbIndex, new int[]{p, p, p});
                                altTimings.add(ts3);
                            }
                        }
                        altTimings.pop();
                    }
                }
                pos += cbSize;
            }
            s = s + (sbCodeBeforeTX ? codeStr + txStr : txStr + codeStr);
            if (txCount > 0) {
                s = s + "\n  IR sent (TXBn bits of byte TXDn for each n) after ";
                s = s + (sbHasCode && !sbCodeBeforeTX ? "signal block code run\n" : "data translation\n");
            }
            boolean bl2 = more = !this.hasNativeCode && pos < data.length;
            if (more && pos == data.length - 1) {
                s = s + "*** Apparent spurious extra byte at end of protocol block ***\n";
                more = false;
            }
            if (more || this.blockCount >= this.maxBlocks) continue;
            s = s + "*** Repeat signal block missing\n";
        }
        if (this.hasNativeCode) {
            JP2Analyzer.prb.errors.add("Has native code block, not supported");
            s = s + "Native code block (run after IR sent):\n";
            Hex nCode = hex.subHex(pos += (pos & 1) == 1 ? 1 : 0);
            s = s + nCode.toString() + "\n";
            pos += nCode.length();
        }
        if ((this.completeItemList == null || this.choices[14] || this.choices[19]) && pos != data.length) {
            s = s + "**** Parsing error ****\n";
        }
        return s;
    }

    private int[] interpretToggle(int toggle) {
        int[] togData = null;
        if (toggle > 0) {
            togData = new int[6];
            this.analyzeToggle(toggle, togData);
            this.irpParts[15] = "T=T+1,";
            if ((togData[5] & 4) > 0 && togData[1] > 1) {
                String label = this.getZeroLabel(this.proc.getDcBufStart() + togData[4]);
                label = this.irpLabel(label);
                this.irpParts[15] = this.irpParts[15] + label + "=" + label + "^(" + togData[0] + "*T:1),";
            } else if (togData[5] == 0 && togData[1] != togData[3] - togData[2] + 1) {
                this.irpParts[15] = this.irpParts[15] + "unknown toggle,";
                JP2Analyzer.prb.errors.add("Uses unsupported toggle type");
            }
        }
        return togData;
    }

    private boolean updateAltTimings(LinkedList<TimingStruct> altTimings, TimingStruct ts) {
        boolean changed;
        block5: {
            int changeType;
            ArrayList<Integer> list2;
            ArrayList<Integer> list1;
            int p;
            int[] sbPath;
            int start;
            block6: {
                changed = false;
                start = this.labelIndex.get("SB" + this.sbIndex);
                sbPath = null;
                sbPath = ts.sbPaths.get(this.sbIndex);
                if (sbPath == null) break block5;
                p = sbPath[0];
                list1 = new ArrayList<Integer>();
                list2 = new ArrayList<Integer>();
                changeType = this.createPathSequence(start, p, 1, list1);
                if (changeType <= 0) break block6;
                changed = true;
                this.createPathSequence(start, p, 2, list2);
                Iterator iterator = list1.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    Iterator iterator2 = list2.iterator();
                    while (iterator2.hasNext()) {
                        int j = (Integer)iterator2.next();
                        TimingStruct ts3 = ts.clone();
                        ts3.sbPaths.put(this.sbIndex, new int[]{i, changeType == 1 ? i : j, j});
                        altTimings.add(ts3);
                    }
                }
                break block5;
            }
            if (sbPath[1] == sbPath[0]) break block5;
            p = sbPath[1];
            list1.clear();
            list2.clear();
            changeType = this.createPathSequence(start, p, 1, list1);
            if (changeType == 1) {
                changed = true;
                this.createPathSequence(start, p, 2, list2);
                Iterator iterator = list1.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    Iterator iterator3 = list2.iterator();
                    while (iterator3.hasNext()) {
                        int j = (Integer)iterator3.next();
                        TimingStruct ts3 = ts.clone();
                        ts3.sbPaths.put(this.sbIndex, new int[]{sbPath[0], i, j});
                        altTimings.add(ts3);
                    }
                }
            }
        }
        return changed;
    }

    private boolean runIREngine(int addr, Hex hex, LinkedList<TimingStruct> altTimings, TimingStruct ts) {
        boolean pbHasCode;
        boolean changed = false;
        int pos = 0;
        short[] data = hex.getData();
        short pbHeader = data[pos++];
        int pbOptSize = pbHeader & 0xF;
        int pbSwitchSize = pbOptSize > 2 ? data[pos + 1] & 0xF : 0;
        int toggle = pbOptSize > 5 ? hex.get(pos + 4) : 0;
        int[] togData = this.interpretToggle(toggle);
        pos += pbOptSize;
        boolean bl = pbHasCode = (pbHeader & 0x80) != 0;
        if (pbHasCode) {
            ++this.pbIndex;
            short cbSize = data[pos++];
            pos += cbSize;
        }
        this.choices = new boolean[30];
        Arrays.fill(this.choices, false);
        this.blockCount = 0;
        this.maxBlocks = 1;
        this.brackets = 0;
        boolean more = true;
        this.sbIndex = 0;
        this.firstFrame = true;
        this.irpParts[22] = "";
        this.choices[22] = false;
        while (more) {
            TimingStruct next;
            int[][] pfDescs;
            ++this.blockCount;
            boolean choices22 = this.choices[22];
            Arrays.fill(this.choices, false);
            this.choices[15] = toggle > 0;
            this.choices[22] = choices22;
            int sigPtr = pos;
            if (pos >= data.length) {
                return false;
            }
            Arrays.fill(this.pf, 0);
            this.pf[0] = data[pos++];
            int formatLen = this.pf[0] & 7;
            int txPos = pos += formatLen;
            for (int i = 1; i <= formatLen; ++i) {
                this.pf[i] = data[sigPtr + i];
            }
            boolean sbHasAlternates = (this.pf[5] & 0xF0) > 0;
            boolean sbHasCode = (this.pf[0] & 0x80) != 0;
            this.choices[20] = (this.pf[6] & 0x80) != 0;
            this.minRpts = this.pf[3] & 0x3F;
            int txCount = this.pf[2] & 0x1F;
            this.pfNew = (int[])this.pf.clone();
            for (int[] pfDesc : pfDescs = new int[][]{{-1, 1, 6}, {128, 4, 0}, {8, 1, 3}, {4, 1, 2}, {-1, 0, 6}, {63, 3, 0}, {-1, 1, 4}, {224, 2, 5}, {128, 3, 7}, {255, 5, 0}}) {
                if (pfDesc[0] >= 0 && (this.pf[pfDesc[1]] & pfDesc[0]) <= 0) continue;
                this.getPFdescription(pfDesc[1], pfDesc[2], this.choices);
            }
            if (!this.choices[20]) {
                Hex txBytes = hex.subHex(txPos, txCount);
                this.translateTXBytes(txBytes, null);
            }
            for (int i = 0; i <= pbSwitchSize; ++i) {
                pos += txCount;
                if (i >= pbSwitchSize) continue;
                txCount = data[pos++];
            }
            more = sbHasAlternates;
            if (more) {
                String stream = this.makeIRStream();
                this.irpStruct.irStream = this.irpStruct.irStream + stream;
                JP2Analyzer.e.errors.add("Support for alternate signal blocks not tested");
                continue;
            }
            if (sbHasCode) {
                ++this.sbIndex;
                short cbSize = data[pos++];
                pos += cbSize;
                changed = this.updateAltTimings(altTimings, ts);
            }
            if (!changed) {
                ArrayList<Integer> paths = new ArrayList<Integer>();
                if (ts.sbPaths.get(this.sbIndex) == null) {
                    paths.add(0);
                } else {
                    int[] pp = ts.sbPaths.get(this.sbIndex);
                    paths.add(pp[0]);
                    if (pp[0] != pp[1] || pp[1] != pp[2]) {
                        paths.add(pp[1]);
                    }
                    if (pp[1] != pp[2]) {
                        paths.add(pp[2]);
                    }
                }
                int[] carriers = new int[]{this.carrier, this.has2usOff ? 12 : this.carrier, this.altCarrier};
                TimingStruct ts3 = ts != null ? ts.clone() : new TimingStruct();
                ts3.carriers = carriers;
                ts3.pf = (int[])this.pf.clone();
                ts3.durations = Arrays.copyOf(this.tbDurations, 64);
                this.irpParts[17] = "";
                this.choices[17] = false;
                if (this.firstFrame) {
                    if (ts3.pbPath != null) {
                        int pbStart = this.labelIndex.get("PB" + this.pbIndex);
                        int p3 = ts3.pbPath;
                        boolean[] freqFlags = new boolean[]{false, false};
                        Node n = this.nodeList.get(pbStart + 1);
                        while (n != null) {
                            int[] b = n.branch;
                            for (int i = n.start; i <= b[0]; ++i) {
                                AssemblerItem item = this.completeItemList.get(i);
                                if (this.isAssignmentItem(item)) continue;
                                this.addItemComments(item, carriers, freqFlags, ts3);
                            }
                            int br = p3 & 3;
                            String comment = null;
                            if (!(br != 1 && br != 2 || (comment = n.getComments(br - 1, "when ")) == null || !comment.contains("=") && n.branchType != 8 || b[0] < JP2Analyzer.prb.startTiming || b[0] > JP2Analyzer.prb.lastTiming)) {
                                ts3.pbCondition = comment;
                                this.irpStruct.comments.add(comment);
                            }
                            n = p3 != 0 ? this.nodeList.get(b[br]) : null;
                            p3 >>= 2;
                        }
                    }
                    this.carrier = ts3.carriers[0];
                    this.irpStruct.generalSpec = JP2Analyzer.e.hex.get(0) == 0 ? "{0k," : String.format("{%.1fk,", 6000.0 / (double)this.carrier);
                    this.analyzeTimingBlock(null, true, 0, 64, ts3);
                    if (!JP2Analyzer.prb.postambleCommutable && JP2Analyzer.prb.postamble != null) {
                        Function f = JP2Analyzer.prb.functions.get(JP2Analyzer.prb.functions.size() - 1);
                        if (f.code == JP2Analyzer.prb.postamble) {
                            this.irpParts[22] = f.name + "(),";
                        } else {
                            for (String str : JP2Analyzer.prb.postamble.description()) {
                                this.irpParts[22] = this.irpParts[22] + str + ",";
                            }
                        }
                        this.choices[22] = true;
                    }
                }
                for (int m = 0; m < paths.size(); ++m) {
                    int p = (Integer)paths.get(m);
                    if (sbHasCode) {
                        int start = this.labelIndex.get("SB" + this.sbIndex);
                        boolean[] freqFlags = new boolean[]{false, false};
                        LinkedHashMap<String, OpTree> varMap = new LinkedHashMap<String, OpTree>();
                        ArrayList<String> refList = new ArrayList<String>();
                        this.loopDone.clear();
                        Node n = this.nodeList.get(start + 1);
                        while (n != null) {
                            int[] b = n.branch;
                            for (int i = n.start; i <= b[0]; ++i) {
                                AssemblerItem item = this.completeItemList.get(i);
                                this.addItemComments(item, carriers, freqFlags, ts3);
                            }
                            varMap.clear();
                            refList.clear();
                            LinkedHashMap<Integer, Node> nl = new LinkedHashMap<Integer, Node>();
                            nl.put(start + 1, n);
                            CodeTree code = this.makeCTree(null, nl, varMap, refList, start + 1);
                            for (String str : code.description()) {
                                this.irpParts[17] = this.irpParts[17] + str + ",";
                                this.choices[17] = true;
                            }
                            int br = p & 3;
                            String comment = null;
                            if (!(br != 1 && br != 2 || (comment = n.getComments(br - 1, "when ")) == null || !comment.contains("=") && n.branchType != 8)) {
                                this.irpStruct.comments.add(comment);
                            }
                            n = p != 0 ? this.nodeList.get(b[br]) : null;
                            p >>= 2;
                        }
                        if (m == 2 && this.choices[23] && (this.pf[2] & 0xE0) == 0) {
                            this.choices[23] = false;
                        }
                    }
                    this.pf = ts3.pf;
                    this.tbDurations = ts3.durations;
                    for (int[] pfDesc : pfDescs) {
                        if (pfDesc[0] >= 0 && (this.pf[pfDesc[1]] & pfDesc[0]) <= 0 && pfDesc[1] != 2) continue;
                        this.getPFdescription(pfDesc[1], pfDesc[2], this.choices);
                    }
                    this.analyzeTimingBlock(null, false, 0, 64, null);
                    txCount = this.pf[2] & 0x1F;
                    int txp = txPos;
                    for (int i = 0; i <= pbSwitchSize; ++i) {
                        if (this.choices[20] || i > 0) {
                            Hex txBytes = hex.subHex(txp, txCount);
                            this.translateTXBytes(txBytes, null);
                        }
                        this.analyzeTXBytes(togData);
                        txp += txCount;
                        if (pbSwitchSize > 0) {
                            JP2Analyzer.prb.irpParts11.add(this.irpParts[11]);
                        }
                        if (i >= pbSwitchSize) continue;
                        txCount = data[txp++];
                    }
                    if (pbSwitchSize > 0) {
                        this.irpParts[11] = "irpPart11,";
                    }
                    if (!this.choices[21]) {
                        String stream = this.makeIRStream();
                        this.irpStruct.irStream = this.irpStruct.irStream + stream;
                    }
                    this.irpParts[17] = "";
                    this.choices[17] = false;
                    if (this.choices[12] || !this.choices[16]) break;
                }
            }
            boolean bl2 = more = !this.hasNativeCode && pos < data.length - 1;
            if (more && !this.choices[14] && !this.choices[19] && (next = altTimings.peek()) != null && next.same(ts, this.blockCount)) {
                altTimings.pop();
            }
            more &= this.choices[14] || this.choices[19];
        }
        if (this.irpStruct.irStream.length() > 0) {
            int index;
            this.irpStruct.irStream = this.irpStruct.irStream.substring(0, this.irpStruct.irStream.length() - 1);
            for (int i = 0; i < this.brackets; ++i) {
                this.irpStruct.irStream = this.irpStruct.irStream + ")";
            }
            if ((this.choices[15] || this.choices[22]) && (index = this.irpStruct.irStream.indexOf(40)) != -1) {
                String ir1 = this.irpStruct.irStream.substring(0, index);
                String ir2 = this.irpStruct.irStream.substring(index);
                this.irpStruct.irStream = ir1 + "(";
                this.irpStruct.irStream = this.irpStruct.irStream + (this.choices[15] ? this.irpParts[15] : "");
                this.irpStruct.irStream = this.irpStruct.irStream + (this.choices[22] ? this.irpParts[22] : "");
                this.irpStruct.irStream = ir2.substring(1).startsWith("(") ? this.irpStruct.irStream + ir2.substring(1) : this.irpStruct.irStream + ir2 + ")";
            }
        }
        if (this.hasNativeCode) {
            Hex nCode = hex.subHex(pos += (pos & 1) == 1 ? 1 : 0);
            pos += nCode.length();
        }
        return changed;
    }

    private String makeIRStream() {
        String out;
        if ((this.blockCount > 1 || this.choices[17] && this.choices[20]) && this.brackets == 0) {
            this.irpStruct.irStream = "(" + this.irpStruct.irStream;
            ++this.brackets;
        }
        String irp = "";
        int lenAfterLeadIn = 0;
        if (this.choices[12]) {
            this.choices[23] = false;
        }
        irp = this.choices[17] && this.choices[20] ? irp + (this.choices[23] ? "(" : "") + this.irpParts[17] + (!this.choices[23] ? "(" : "") : irp + "(";
        ++this.brackets;
        if (this.choices[0]) {
            irp = irp + (this.choices[5] ? this.irpParts[5] : this.irpParts[0]);
            lenAfterLeadIn = irp.length();
        }
        if (this.irpParts[11] != null) {
            irp = irp + this.irpParts[11];
        }
        if (this.choices[4]) {
            irp = irp + (this.choices[7] ? this.irpParts[5] : this.irpParts[0]);
        }
        if (this.choices[2]) {
            irp = irp + this.irpParts[2];
        }
        if (this.choices[1]) {
            String string = out = this.choices[6] ? this.irpParts[6] : this.irpParts[1];
            if (out != null && this.choices[10]) {
                out = "^" + out.substring(1);
            }
            irp = irp + out;
        }
        if (this.choices[23] || this.choices[12] || this.minRpts > 0) {
            if (this.choices[9]) {
                if (!this.firstFrame) {
                    irp = "";
                    --this.brackets;
                }
                irp = irp + "(" + this.irpParts[9];
                if (this.choices[4]) {
                    irp = irp + (this.choices[7] ? this.irpParts[5] : this.irpParts[0]);
                }
                if (this.choices[2]) {
                    irp = irp + this.irpParts[2];
                }
                if (this.choices[1]) {
                    String string = out = this.choices[6] ? this.irpParts[6] : this.irpParts[1];
                    if (out != null && this.choices[10]) {
                        out = "^" + out.substring(1);
                    }
                    irp = irp + out;
                }
                irp = irp.substring(0, irp.length() - 1) + ")";
                int r = this.firstFrame ? this.minRpts : this.minRpts + 1;
                irp = irp + (r > 1 ? Integer.valueOf(r) : "");
                irp = irp + (this.choices[12] ? (this.minRpts > 0 ? "+," : "*,") : ",");
            } else {
                boolean leadinExcluded = false;
                if (this.choices[0] && this.choices[8]) {
                    irp = irp.substring(0, lenAfterLeadIn) + "(" + irp.substring(lenAfterLeadIn);
                    leadinExcluded = true;
                    ++this.brackets;
                }
                irp = irp.substring(0, irp.length() - 1) + ")";
                irp = irp + (this.minRpts > 0 ? Integer.valueOf(this.minRpts + 1) : "");
                irp = irp + (this.choices[12] || this.choices[23] ? (this.minRpts > 0 || leadinExcluded || this.brackets == 1 ? "+," : "*,") : ",");
                --this.brackets;
            }
        }
        if (!this.choices[12] && this.choices[13] || this.choices[18]) {
            if (this.brackets > 1 && !this.choices[10] && (this.pf[3] & 0x3F) == 0) {
                int index = irp.lastIndexOf(40);
                irp = irp.substring(0, index) + irp.substring(index + 1);
                --this.brackets;
            }
            irp = irp.substring(0, irp.length() - 1);
            for (int i = 0; i < this.brackets; ++i) {
                irp = irp + ")";
            }
            this.brackets = 0;
            irp = irp + (this.choices[13] ? "+," : "2,");
        }
        if (this.choices[17] && !this.choices[20]) {
            irp = irp + this.irpParts[17];
        }
        if (this.choices[24] && (irp.endsWith("+,") || irp.endsWith("*,"))) {
            this.irpStruct.comments.add("only keys in repeating group repeat");
        }
        this.firstFrame = false;
        return irp;
    }

    private List<Integer> createCodePaths(int start, int limit) {
        AssemblerItem item;
        Object label;
        int i;
        int last = start + 1;
        ArrayList<String> labelsUsed = new ArrayList<String>();
        String source = this.completeItemList.get(start).getLabel();
        List<Integer> validTypes = null;
        validTypes = source.startsWith("PB") || limit > 0 ? Arrays.asList(-1, 1, 2, 3, 4, 8, 9, 14, 15) : Arrays.asList(-1, 1, 2, 3, 4, 7, 8, 9, 10, 11, 12, 13, 16, 17);
        if (limit == 0) {
            limit = this.completeItemList.size() - 1;
        }
        for (i = start + 1; i < limit && !((String)(label = (item = this.completeItemList.get(i)).getLabel())).startsWith("PB") && !((String)label).startsWith("SB"); ++i) {
            if (!((String)label).isEmpty()) {
                labelsUsed.add((String)label);
            }
            if (item.getOperation().equals("END")) {
                last = i;
                break;
            }
            last = i + 1;
        }
        for (i = 0; i < this.completeItemList.size(); ++i) {
            if (i > start || i <= last) continue;
            String args = this.completeItemList.get(i).getArgumentText();
            for (String label2 : labelsUsed) {
                if (!args.endsWith(label2) && !args.contains(label2 + ",")) continue;
                JP2Analyzer.prb.errors.add("There is a jump into timing region from outside");
            }
        }
        LinkedList<Integer> q = new LinkedList<Integer>();
        Node node = new Node(start + 1);
        if ((node = this.makeBranch(node, validTypes, last)) != null) {
            q.push(start + 1);
            this.nodeList.put(start + 1, node);
        }
        while (!q.isEmpty()) {
            int key = (Integer)q.pop();
            node = this.nodeList.get(key);
            for (int i2 = 1; i2 < 3; ++i2) {
                int val = node.branch[i2];
                if (val < 0 || val > last || this.nodeList.keySet().contains(val)) continue;
                Node n = new Node(val);
                if ((n = this.makeBranch(n, validTypes, last)) == null) continue;
                q.push(val);
                this.nodeList.put(val, n);
            }
        }
        ArrayList<Integer> paths = new ArrayList<Integer>();
        q.push(0);
        while (!q.isEmpty()) {
            int p = (Integer)q.pop();
            int level = 0;
            int m = p;
            Node n = this.nodeList.get(start + 1);
            while ((m & 3) > 0) {
                n = this.nodeList.get(n.branch[m & 3]);
                ++level;
                m >>= 2;
            }
            if (n != null) {
                if (n.branch[1] > 0 && n.branch[1] < n.branch[0] || n.branch[2] > 0 && n.branch[2] < n.branch[0]) {
                    JP2Analyzer.prb.description = JP2Analyzer.prb.description + "\nBackward jump at " + n.branch[0] + " (" + n.branch[1] + ", " + n.branch[2] + ")\n";
                    return paths;
                }
                if (n.branch[0] == -1) {
                    return paths;
                }
                boolean added = false;
                int branchType = this.completeItemList.get(n.branch[0]).get_Type();
                if (branchType == 7 || branchType == 13 || branchType == 16) {
                    paths.add(p + (3 << 2 * level));
                    return paths;
                }
                if (n.branch[2] > 0) {
                    q.push(p + (2 << 2 * level));
                    added = true;
                }
                if (n.branch[1] > 0) {
                    q.push(p + (1 << 2 * level));
                    added = true;
                }
                if (added) continue;
                paths.add(p);
                continue;
            }
            if (p == 0) continue;
            paths.add(p);
        }
        return paths;
    }

    private int createPathSequence(int start, int p, int index, List<Integer> list) {
        List<Integer> cp;
        int m = p;
        int next = start + 1;
        int level = 0;
        Node n = this.nodeList.get(next);
        while (n != null && ((m & 3) == 1 || (m & 3) == 2)) {
            ++level;
            next = n.branch[m & 3];
            n = this.nodeList.get(next);
            m >>= 2;
        }
        if (n == null || m == 0) {
            list.add(p);
            return 0;
        }
        int type = this.completeItemList.get(n.branch[0]).get_Type();
        int ret = type == 7 ? 2 : 1;
        p &= (1 << 2 * level) - 1;
        p += index << 2 * level;
        List<Integer> list2 = cp = n.branch[index] > 0 ? this.createCodePaths(n.branch[index] - 1, 0) : null;
        if (cp == null || cp.isEmpty()) {
            list.add(p);
        } else {
            for (int r : cp) {
                list.add(p + (r << 2 * (level + 1)));
            }
        }
        return ret;
    }

    private String getPFdescription(int pfn, int start, boolean[] choices) {
        String desc = "";
        if (choices == null) {
            choices = new boolean[30];
        }
        int val = this.pfNew[pfn];
        if (pfn == 0) {
            switch (start) {
                case 5: 
                case 6: {
                    String type = (this.pfNew[1] & 2) != 0 ? "alternate" : "normal";
                    switch (val >> 5 & 3) {
                        case 0: 
                        case 1: {
                            return "No lead-out";
                        }
                        case 2: {
                            desc = "gap";
                            break;
                        }
                        case 3: {
                            desc = "total";
                            choices[10] = true;
                        }
                    }
                    choices[1] = true;
                    choices[6] = (this.pfNew[1] & 2) != 0;
                    desc = "Use " + type + " lead-out as " + desc + " time";
                    this.tbUsed |= ((this.pfNew[1] | this.pfChanges[1]) & 2) != 0 ? 16 : 0;
                    this.tbUsed |= ((~this.pfNew[1] | this.pfChanges[1]) & 2) != 0 ? 4 : 0;
                }
            }
        } else if (pfn == 1) {
            block8 : switch (start) {
                case 1: {
                    desc = "Set lead-out type to " + ((val & 2) != 0 ? "alternate" : "normal");
                    if (((this.pfNew[0] | this.pfChanges[0]) & 0x40) != 0) {
                        this.tbUsed |= (val & 2) != 0 ? 16 : 4;
                    }
                    choices[6] = (val & 2) != 0;
                    break;
                }
                case 2: {
                    desc = (val & 4) != 0 ? "One-ON precedes lead-out" : "No One-ON before lead-out";
                    choices[2] = (val & 4) != 0;
                    break;
                }
                case 3: {
                    String type = (this.pfNew[3] & 0x40) != 0 ? "alternate" : "normal";
                    String string = desc = (val & 8) != 0 ? "Use " + type + " lead-in as end-frame burst following data" : "No end-frame burst";
                    if ((val & 8) != 0) {
                        this.tbUsed |= ((this.pfNew[3] | this.pfChanges[3]) & 0x40) != 0 ? 32 : 0;
                        this.tbUsed |= ((~this.pfNew[3] | this.pfChanges[3]) & 0x40) != 0 ? 8 : 0;
                    }
                    choices[4] = true;
                    choices[7] = (this.pfNew[3] & 0x40) != 0;
                    break;
                }
                case 4: 
                case 5: {
                    switch (val >> 4 & 3) {
                        case 0: {
                            desc = "No repeat on held keypress";
                            break block8;
                        }
                        case 1: {
                            desc = "All buttons repeat on held keypress";
                            choices[12] = true;
                            break block8;
                        }
                        case 2: {
                            desc = "Only Vol+/-, Ch+/-, FF, Rew repeat on held keypress";
                            choices[12] = true;
                            choices[24] = true;
                            break block8;
                        }
                        case 3: {
                            desc = "Send One-ON in place of first repeat, nothing on later repeats";
                            JP2Analyzer.e.errors.add("Send One-ON in place of first repeat is not yet supported");
                        }
                    }
                    break;
                }
                case 0: 
                case 6: 
                case 7: {
                    choices[9] = false;
                    choices[8] = false;
                    choices[5] = false;
                    choices[0] = false;
                    switch (val >> 6 & 3) {
                        case 0: {
                            desc = "No lead-in";
                            break block8;
                        }
                        case 1: {
                            desc = "Use " + ((val & 1) != 0 ? "alternate" : "normal") + " lead-in on all frames";
                            this.tbUsed |= (val & 1) != 0 ? 32 : 8;
                            choices[0] = true;
                            choices[5] = (val & 1) != 0;
                            break block8;
                        }
                        case 2: {
                            desc = "Use normal lead-in on first frame, no lead-in on repeat frames";
                            this.tbUsed |= 8;
                            choices[0] = true;
                            choices[8] = true;
                            break block8;
                        }
                        case 3: {
                            desc = "Use normal lead-in but on repeat frames halve the OFF duration and omit data bits";
                            this.tbUsed |= 8;
                            choices[0] = true;
                            choices[9] = true;
                        }
                    }
                }
            }
        } else if (pfn == 2) {
            if (start >= 5) {
                choices[19] = false;
                choices[18] = false;
                choices[16] = false;
                choices[14] = false;
                choices[13] = false;
                switch (val >> 5) {
                    case 0: 
                    case 7: {
                        desc = "After repeats, terminate";
                        break;
                    }
                    case 1: {
                        desc = "After repeats, execute next signal block";
                        this.maxBlocks = this.blockCount + 1;
                        choices[19] = true;
                        choices[14] = true;
                        break;
                    }
                    case 2: {
                        desc = "After repeats, if key held then execute next signal block";
                        this.maxBlocks = this.blockCount + 1;
                        choices[14] = true;
                        break;
                    }
                    case 3: {
                        desc = "After repeats, if key held then re-execute current protocol block";
                        this.maxBlocks = this.blockCount;
                        choices[13] = true;
                        break;
                    }
                    case 4: {
                        desc = "After repeats, if key held then re-execute current protocol block, else execute next signal block";
                        this.maxBlocks = this.blockCount + 1;
                        choices[19] = true;
                        choices[13] = true;
                        break;
                    }
                    case 5: {
                        desc = "After repeats, re-execute current protocol block";
                        this.maxBlocks = this.blockCount;
                        choices[18] = true;
                        choices[13] = true;
                        break;
                    }
                    case 6: {
                        desc = "After repeats, re-execute current signal block";
                        choices[16] = true;
                        this.maxBlocks = this.blockCount;
                        break;
                    }
                    default: {
                        this.maxBlocks = this.blockCount;
                        break;
                    }
                }
            }
        } else if (pfn == 3) {
            switch (start) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    desc = "Send " + (val & 0x3F) + " mandatory repeats";
                    break;
                }
                case 6: {
                    desc = "End-frame burst is " + ((val & 0x40) != 0 ? "alternate" : "normal") + "lead-in";
                    if (((this.pfNew[1] | this.pfChanges[1]) & 8) != 0) {
                        this.tbUsed |= (val & 0x40) != 0 ? 32 : 8;
                    }
                    choices[7] = (val & 0x40) != 0;
                    break;
                }
                case 7: {
                    desc = (val & 0x80) != 0 ? "Disable IR when repeats from held keypress end" : "";
                }
            }
        } else if (pfn == 4) {
            if ((val & 0x80) != 0) {
                desc = "Mid-frame burst follows first " + (val & 0x7F) + " data bits";
                this.tbUsed |= 0x40;
                choices[3] = true;
            } else {
                desc = "There is no mid-frame burst";
            }
        } else if (pfn == 5) {
            int mask = 16;
            for (int i = 0; i < 4; ++i) {
                if ((val & mask) > 0) {
                    desc = "If key is " + (new String[]{"Record", "Power", "a Volume key", "in the repeating group"})[i];
                    desc = desc + " then use this Signal Block, otherwise use the next one";
                    break;
                }
                mask <<= 1;
            }
        } else if (pfn == 6) {
            desc = "Signal block code processed " + ((val & 0x80) != 0 ? "before" : "after") + " IR transmission";
            boolean bl = choices[20] = (val & 0x80) != 0;
        }
        if (this.maxBlocks > 3) {
            this.maxBlocks = 3;
        }
        return desc;
    }

    private int addItemComments(AssemblerItem item, int[] carriers, boolean[] freqFlags, TimingStruct ts) {
        if (ts == null) {
            ts = new TimingStruct();
        }
        freqFlags[1] = false;
        String opName = item.getOperation();
        if (opName.equals("END") || opName.equals("NOP")) {
            return -1;
        }
        List<String> opList = Arrays.asList("MOV", "AND", "OR", "BRA", "MOVN", "MOVW", "CARRIER", "TIMING", "CALL", "XOR", "BSR", "DBNZ", "RTS");
        int opIndex = opList.indexOf(opName);
        String args = item.getArgumentText();
        int oldVal = 0;
        int newVal = 0;
        int xorVal = 0;
        int itemType = 0;
        ArrayList<String> argList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(args, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.startsWith("#$")) {
                int[] rev = new int[4];
                int val = Integer.parseInt(token.substring(2), 16);
                this.reverseByte(val, rev);
                token = "" + rev[0];
            } else {
                token = this.irpLabel(token);
            }
            if (token == null) continue;
            argList.add(token);
        }
        for (int i = 0; i < 3; ++i) {
            String pre;
            String string = i == 0 ? "\\(?" : (pre = i == 1 ? "Z,.*, " : "NZ,.*, ");
            if (!Pattern.matches(pre + "(Fix|Var|Calc|Tmp).*", args)) continue;
            int n = itemType = i == 0 ? 1 : 2;
            if (itemType == 1 && opIndex == 0 && (args.contains("[") || args.contains("("))) {
                itemType = 14;
                break;
            }
            if (itemType != 1 || !opName.equals("DBBC")) break;
            itemType = 0;
            break;
        }
        if (opIndex < 0) {
            return itemType;
        }
        if (opIndex == 11) {
            itemType = 15;
        } else if (opIndex == 3) {
            if (Pattern.matches("L\\d*", args)) {
                itemType = 2;
            } else if (Pattern.matches("(T|F),.*", args)) {
                short fnCode = item.getHex().getData()[2];
                itemType = fnCode == 84 ? 13 : (fnCode == 85 ? 16 : (fnCode > 85 ? 0 : 8));
            }
        } else if (opIndex == 10 || opIndex == 12) {
            itemType = 9;
        }
        if (itemType == 13 || itemType == 16) {
            int rptFlags = ts.pf[1] & 0x30;
            if ((rptFlags & 0x20) != 0) {
                JP2Analyzer.e.errors.add("Repeat policy not supported");
            }
            if (this.choices[16]) {
                this.choices[23] = itemType == 13 || rptFlags == 16;
            } else {
                JP2Analyzer.e.errors.add("Repeat policy not supported");
            }
        }
        String str = "";
        String string = opIndex == 3 && args.contains("StatFlags, #$01") ? (args.contains("NZ") ? "Branch if not first frame" : "Branch if first frame") : (opIndex == 1 && args.equals("StatFlags, StatFlags, #$FE") ? "Reset to no frames sent" : (opIndex == 2 && args.equals("CtrlFlags, CtrlFlags, #$01") ? "Suppress IR transmission" : (str = opIndex == 1 && args.equals("CtrlFlags, CtrlFlags, #$FE") ? "Resume IR transmission" : "")));
        if (!str.isEmpty()) {
            item.setComments("; " + str);
            if (str.startsWith("Branch if")) {
                itemType = 7;
            } else if (str.startsWith("Suppress")) {
                itemType = 11;
                this.choices[21] = true;
            } else if (str.startsWith("Resume")) {
                itemType = 12;
                this.choices[21] = false;
            }
            return itemType;
        }
        ArrayList<String> comments = new ArrayList<String>();
        if (opIndex == 6 || opIndex == 7) {
            itemType = 3;
            Hex hex = new Hex(5);
            int start = this.proc.getProtocolHeaderSize() > 3 ? 1 : 0;
            System.arraycopy(item.getHex().getData(), 1, hex.getData(), start, 3);
            int[] carrierData = this.proc.getCarrierData(hex);
            carriers[0] = carrierData[0];
            ts.carriers[0] = carriers[0];
            if (opIndex == 7) {
                carriers[1] = this.has2usOff ? 12 : carriers[0];
                ts.carriers[1] = carriers[1];
            }
            str = String.format("Set %.2fkHz, duty cycle %.1f", (double)this.proc.getOscillatorFreq() / (1000.0 * (double)carrierData[0]), (double)carrierData[1] / 10.0) + "%";
            str = str + (opIndex == 6 ? " for MARK; copy to IRCA" : "");
            comments.add(str);
            freqFlags[1] = true;
        }
        if (opIndex == 5 && args.startsWith("$04, #$")) {
            int total;
            itemType = 3;
            int val = Integer.parseInt(args.substring(7, 11), 16);
            int on = (val >> 8) + 1;
            int off = (val & 0xFF) + 1;
            carriers[1] = total = on + off;
            ts.carriers[1] = total;
            str = String.format("Set %.2fkHz", 6000.0 / (double)total) + " for SPACE";
            item.setComments("; " + str);
            return itemType;
        }
        if (opIndex == 4 && Pattern.matches("PD[0-9A-F]{2}, PD[0-9A-F]{2}, #\\$..", args) || opIndex == 5 && Pattern.matches("PD[0-9A-F]{2}, PD[0-9A-F]{2}", args) || opIndex == 7) {
            itemType = 3;
            int dest = 0;
            int source = 0;
            int len = 0;
            if (opIndex == 7) {
                source = len = 2 * (this.tbLengths[0] + this.tbLengths[1] + this.tbLengths[3]) + this.tbLengths[2];
                comments.add(String.format("PD%02X-PD%02X copied to PD%02X-PD%02X", source, source + len - 1, dest, dest + len - 1));
            } else {
                dest = Integer.parseInt(args.substring(2, 4), 16);
                source = Integer.parseInt(args.substring(8, 10), 16);
                len = opIndex == 4 ? this.getImmValue(args) / 2 : 1;
            }
            int[] durations = Arrays.copyOf(this.tbDurations, 64);
            for (int i = 0; i < len; ++i) {
                durations[dest + i] = durations[source + i];
                ts.durations[dest + i] = ts.durations[source + i];
            }
            int[] savedDurations = this.tbDurations;
            this.tbDurations = durations;
            int savedCarrier = this.carrier;
            this.carrier = carriers[0];
            List<String> timingComments = this.analyzeTimingBlock(null, false, dest, dest + len - 1, null);
            double f = (double)this.proc.getOscillatorFreq() / (1000.0 * (double)this.carrier);
            if (timingComments.size() > 0) {
                if (!this.has2usOff && carriers[0] != carriers[1]) {
                    comments.add("Carrier frequencies for MARK and SPACE differ");
                }
                if (freqFlags[0]) {
                    comments.add(String.format("Timings for %.2fkHz", f));
                    freqFlags[0] = false;
                }
            } else if (opIndex == 5) {
                int duration = this.durationToMicrosecs(durations[dest], this.carrier, true);
                str = String.format("PD%02X at %.2fkHz: %dus", dest, f, duration);
                timingComments.add(str);
            }
            comments.addAll(timingComments);
            this.tbDurations = savedDurations;
            this.carrier = savedCarrier;
        } else if (opIndex == 0 && Pattern.matches("PF\\d, #\\$..", args) || opIndex < 3 && Pattern.matches("PF(\\d), PF\\1, #\\$..", args) || opIndex == 5 && Pattern.matches("PF\\d, #\\$....", args)) {
            int n = args.charAt(2) - 48;
            if (n < 0 || n > 6) {
                return itemType;
            }
            itemType = 4;
            int immValFull = this.getImmValue(args);
            int end = opIndex == 5 ? 2 : 1;
            for (int k = 0; k < end; ++k) {
                oldVal = this.pf[n + k];
                newVal = this.pfNew[n + k];
                int immVal = immValFull & 0xFF;
                newVal = opIndex == 0 || opIndex == 5 ? immVal : (opIndex == 1 ? newVal & immVal : newVal | immVal);
                xorVal = newVal ^ oldVal;
                this.pfNew[n + k] = newVal;
                ts.pf[n + k] = newVal;
                int n2 = n + k;
                this.pfChanges[n2] = this.pfChanges[n2] | xorVal;
                int n3 = opIndex == 0 || opIndex == 5 ? this.pfChanges[n + k] : (xorVal = opIndex == 1 ? this.pfChanges[n + k] & ~immVal : this.pfChanges[n + k] & immVal);
                if (n == 0 && k == 1 && (this.pfNew[0] & 6) != 0) {
                    xorVal &= 0xFD;
                }
                for (int i = 0; i < 8; ++i) {
                    if ((xorVal & 1) == 1 && !(str = this.getPFdescription(n + k, i, null)).isEmpty() && !comments.contains(str)) {
                        comments.add(str);
                    }
                    xorVal >>= 1;
                }
                immValFull >>= 8;
            }
        } else if (opIndex == 0 && Pattern.matches("Tog.*, #\\$..", args)) {
            itemType = 5;
            int val = this.getImmValue(args);
            if (args.startsWith("TogMask")) {
                comments.add(String.format("Toggle mask = $%02X", val));
            } else {
                comments.add("Toggle type: " + this.analyzeToggle(val << 8, null));
            }
        } else if (opIndex == 0 && args.startsWith("TXDcount, #")) {
            int val;
            itemType = 17;
            this.txdCount = val = this.getImmValue(args);
        } else if (opIndex == 8) {
            itemType = 6;
            int pos = args.indexOf(44);
            String label = pos >= 0 ? args.substring(0, pos) : args;
            Integer val = this.proc.getAbsData().get(label);
            if (val != null) {
                this.tbUsed |= 1 << val;
            }
        } else if (opIndex == 0 && args.startsWith("MinRpts")) {
            itemType = 10;
            this.minRpts = this.getImmValue(args);
        }
        st = new StringTokenizer(args, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            String comment = this.proc.getLblComments().get(token);
            if (comment == null) continue;
            comments.add(comment);
        }
        str = "";
        for (int i = 0; i < comments.size(); ++i) {
            str = str + (i > 0 ? "\n\t\t                    \t; " : "; ") + (String)comments.get(i);
        }
        item.setComments(str);
        return itemType;
    }

    private int durationToMicrosecs(int duration, int itemCarrier, boolean mark) {
        double mult = mark ? (double)itemCarrier * (1000000.0 / (double)this.proc.getOscillatorFreq()) : 2.0;
        return (int)((double)duration * mult + 0.500001);
    }

    private int getImmValue(String args) {
        int ndx = args.indexOf("#$");
        if (ndx >= 0) {
            return Integer.parseInt(args.substring(ndx + 2), 16);
        }
        return 0;
    }

    private String translateTXBytes(Hex hex, List<String> srcList) {
        Arrays.fill(this.txd, null);
        Arrays.fill(this.txb, 0);
        Arrays.fill(this.txdIndex, -1);
        int n = this.txdCount = hex == null ? 0 : hex.length();
        if (this.txdCount == 0) {
            return " <none>\n";
        }
        String txStr = "";
        for (int i = 0; i < this.txdCount; ++i) {
            short val = hex.getData()[i];
            this.txb[i] = (val >> 4 & 7) + 1;
            boolean flag = (val & 0x80) > 0;
            this.txdIndex[i] = val & 0xF;
            int addr = this.proc.getDcBufStart() + this.txdIndex[i];
            String label = this.getZeroLabel(addr);
            txStr = txStr + " " + (flag ? "~" : "") + label + ":" + this.txb[i];
            String irpLabel = this.irpLabel(addr);
            if (srcList != null && !srcList.contains(irpLabel)) {
                srcList.add(irpLabel);
            }
            this.txd[i] = new OpTree((flag ? "~" : "") + irpLabel);
        }
        return txStr + "\n";
    }

    private void analyzeTXBytes(int[] togData) {
        int togIndex = 256;
        int togPos = 256;
        int togEnd = 256;
        int togCount = 0;
        if (this.txdCount == 0) {
            this.irpParts[11] = null;
            return;
        }
        this.irpParts[11] = "";
        int bitCount = 0;
        int mid = 256;
        if ((this.pf[4] & 0x80) != 0) {
            mid = this.pf[4] & 0x7F;
        }
        for (int i = 0; i < this.txdCount; ++i) {
            boolean togComp;
            int n = this.txb[i];
            bitCount += n;
            int rem = -1;
            if (togData != null && (togData[1] == 1 || (togData[5] & 4) == 0 && togData[1] == togData[3] - togData[2] + 1)) {
                togIndex = togData[4];
                togPos = togData[2];
                togEnd = togData[3];
                togCount = togData[1];
            }
            if (togPos < n) {
                togEnd = Math.min(togEnd, n - 1);
                togCount = togEnd - togPos + 1;
            }
            if (bitCount >= mid) {
                rem = bitCount - mid;
                n -= rem;
            }
            if (this.txd == null || this.txd[i] == null) {
                this.irpParts[11] = null;
                return;
            }
            String valStr = this.txd[i].lsbEvaluate();
            boolean flag = valStr.startsWith("~");
            boolean bl = togData != null ? (togData[5] & 8) > 0 : (togComp = false);
            togComp = togCount == 1 ? false : flag && !togComp || !flag && togComp;
            int togBits = Math.max(Math.min(togEnd + 1, n) - togPos, 0);
            if (n > 0) {
                if (togIndex == this.txdIndex[i] && togPos < n) {
                    if (togPos > 0) {
                        this.irpParts[11] = this.irpParts[11] + valStr + ":" + togPos + ",";
                    }
                    this.irpParts[11] = this.irpParts[11] + (togComp ? "~" : "") + "T:" + (togBits > 1 ? "-" : "") + togBits + ",";
                    if (togPos + togBits < n) {
                        this.irpParts[11] = this.irpParts[11] + valStr + ":" + (n - togPos - togBits) + ":" + (togPos + togBits) + ",";
                    }
                } else {
                    this.irpParts[11] = this.irpParts[11] + valStr + ":" + n + ",";
                }
            }
            if (rem < 0) continue;
            if (this.choices[3]) {
                ArrayList<String> warn = new ArrayList<String>();
                ArrayList<Integer> irpVals = new ArrayList<Integer>();
                int[] limits = new int[]{0, 0};
                this.getTimingItem(6, limits, irpVals, warn);
                Iterator iterator = irpVals.iterator();
                while (iterator.hasNext()) {
                    int m = (Integer)iterator.next();
                    this.irpParts[11] = this.irpParts[11] + m + ",";
                }
                if (prb != null) {
                    JP2Analyzer.prb.warnings.addAll(warn);
                }
            }
            int togRem = togCount - togBits;
            if (togIndex == this.txdIndex[i] && togEnd + 1 > n && togPos < n + rem) {
                if (togPos > n) {
                    this.irpParts[11] = this.irpParts[11] + valStr + ":" + (togPos - n);
                    if (n > 0) {
                        this.irpParts[11] = this.irpParts[11] + ":" + n;
                    }
                    this.irpParts[11] = this.irpParts[11] + ",";
                }
                this.irpParts[11] = this.irpParts[11] + (togComp ? "~" : "") + "T:" + (togRem > 1 ? "-" : "") + togRem;
                this.irpParts[11] = this.irpParts[11] + (togBits > 0 ? ":" + togBits + "," : ",");
                if (togEnd + 1 < n + rem) {
                    this.irpParts[11] = this.irpParts[11] + valStr + ":" + (n + rem - togEnd - 1) + ":" + (togEnd + 1) + ",";
                }
            } else if (rem > 0) {
                this.irpParts[11] = this.irpParts[11] + valStr + ":" + rem;
                if (n > 0) {
                    this.irpParts[11] = this.irpParts[11] + ":" + n;
                }
                this.irpParts[11] = this.irpParts[11] + ",";
            }
            mid = 256;
        }
    }

    private String irpLabel(String label) {
        try {
            if (label.startsWith("Fix")) {
                int k = Integer.parseInt(label.substring(3), 16);
                return "" + "ABCDEFGHIJ".charAt(k);
            }
            if (label.startsWith("Var")) {
                int k = Integer.parseInt(label.substring(3), 16);
                return "" + "XYZW".charAt(k);
            }
            if (label.startsWith("Calc")) {
                int k = Integer.parseInt(label.substring(4), 16);
                return "N" + k;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    private String irpLabel(int addr) {
        AssemblerItem item = new AssemblerItem();
        if (item.setZeroLabel(this.proc, addr, new ArrayList<Integer>(), "")) {
            String zLabel = item.getLabel();
            String iLabel = this.irpLabel(zLabel);
            return iLabel != null ? iLabel : zLabel;
        }
        return String.format("$%02X", addr);
    }

    private boolean testIRPstruct(IRPstruct irps) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String str : irps.comments) {
            int ndx = str.indexOf(61);
            if (ndx < 0) continue;
            String v = str.substring(0, ndx);
            String a = str.substring(ndx + 1);
            if (map.get(v) != null && !((String)map.get(v)).equals(a)) {
                return false;
            }
            map.put(v, a);
        }
        return true;
    }

    private String interpretPB(int start) {
        int type;
        AssemblerItem item;
        String label;
        int i;
        String ret = "";
        int last = 0;
        int startTiming = 0;
        int lastTiming = 0;
        ArrayList<String> labelsUsed = new ArrayList<String>();
        for (i = start + 1; i < this.completeItemList.size() && !(label = (item = this.completeItemList.get(i)).getLabel()).startsWith("PB") && !label.startsWith("SB"); ++i) {
            if (!label.isEmpty()) {
                labelsUsed.add(label);
            }
            if ((type = item.get_Type()) == 3 || type == 4) {
                if (startTiming == 0) {
                    startTiming = i;
                }
                lastTiming = i;
            }
            if (!item.getOperation().equals("END")) continue;
            last = i;
            break;
        }
        if (startTiming > 0) {
            AssemblerItem item2;
            int[] range = this.findSelfContained(startTiming, lastTiming + 1);
            startTiming = range[0];
            lastTiming = range[1] - 1;
            int j = startTiming - 1;
            while (j > start && (type = (item2 = this.completeItemList.get(j)).get_Type()) == 2 && (range = this.findSelfContained(j, j + 1))[0] == j && range[1] <= lastTiming + 1) {
                startTiming = j--;
            }
            range = this.findSelfContained(start, startTiming);
            if (range[0] < start) {
                JP2Analyzer.e.errors.add("PB jumps into earlier block");
            }
            if (range[1] > startTiming) {
                startTiming = start + 1;
            }
            if ((range = this.findSelfContained(lastTiming + 1, last))[0] < lastTiming + 1) {
                lastTiming = last - 1;
            }
            if (range[1] > last) {
                JP2Analyzer.e.errors.add("Postfix block jumps outside PB");
            }
        }
        if (startTiming > 0) {
            for (i = startTiming; i <= lastTiming; ++i) {
                item = this.completeItemList.get(i);
                int type2 = item.get_Type();
                if (type2 == 2 || type2 == 3 || type2 == 4 || type2 == -1) continue;
                JP2Analyzer.prb.timingBlockHasGaps = true;
                JP2Analyzer.prb.errors.add("Timing instructions not consecutive");
                break;
            }
        }
        JP2Analyzer.prb.startTiming = startTiming;
        JP2Analyzer.prb.lastTiming = lastTiming;
        int limit = startTiming == 0 ? last : startTiming;
        LinkedHashMap<Integer, Node> savedNodeList = this.nodeList;
        List<Object> comboPaths = new ArrayList();
        LinkedHashMap<String, OpTree> varMap = new LinkedHashMap<String, OpTree>();
        ArrayList<String> refList = new ArrayList<String>();
        for (String label2 : this.functionIndex.keySet()) {
            Function f = this.functionIndex.get(label2);
            this.nodeList = new LinkedHashMap();
            int fnStart = this.labelIndex.get(label2);
            comboPaths.clear();
            this.treeRoot = fnStart;
            comboPaths = this.createCodePaths(fnStart - 1, last);
            this.treeRoot = 0;
            varMap.clear();
            refList.clear();
            this.loopDone.clear();
            f.code = this.makeCTree(null, this.nodeList, varMap, refList, fnStart);
            JP2Analyzer.prb.functions.add(f);
        }
        this.nodeList = new LinkedHashMap();
        comboPaths.clear();
        varMap.clear();
        refList.clear();
        this.loopDone.clear();
        comboPaths = this.createCodePaths(start, limit);
        JP2Analyzer.prb.preamble = this.makeCTree(null, this.nodeList, varMap, refList, start + 1);
        if (lastTiming > 0) {
            this.nodeList = new LinkedHashMap();
            comboPaths.clear();
            varMap.clear();
            refList.clear();
            this.loopDone.clear();
            comboPaths = this.createCodePaths(lastTiming, last);
            JP2Analyzer.prb.postamble = this.makeCTree(null, this.nodeList, varMap, refList, lastTiming + 1);
            if (!JP2Analyzer.prb.timingBlockHasGaps && JP2Analyzer.prb.postamble != null) {
                this.nodeList = new LinkedHashMap();
                comboPaths.clear();
                varMap.clear();
                refList.clear();
                this.loopDone.clear();
                comboPaths = this.createCodePaths(startTiming - 1, lastTiming + 1);
                CodeTree timingTree = this.makeCTree(null, this.nodeList, varMap, refList, startTiming);
                List<String> timingVars = timingTree.getAllSources();
                List<String> postambleVars = JP2Analyzer.prb.postamble.getAllDests();
                for (String var : timingVars) {
                    if (!postambleVars.contains(var)) continue;
                    JP2Analyzer.prb.postambleCommutable = false;
                    Function f = new Function("Proc" + this.functionIndex.size());
                    f.code = JP2Analyzer.prb.postamble;
                    JP2Analyzer.prb.functions.add(f);
                    break;
                }
            }
        }
        this.nodeList = savedNodeList;
        return ret;
    }

    private CodeTree makeCTree(CodeTree parent, LinkedHashMap<Integer, Node> list, LinkedHashMap<String, OpTree> varMap, List<String> refList, int start) {
        LinkedHashMap<String, OpTree> newVarMap;
        int i;
        AssemblerItem item;
        CodeTree cTree = new CodeTree(parent);
        Node n = list.get(start);
        if (n == null) {
            return null;
        }
        cTree.node = n;
        if (n.branchType == 11 && this.loopDone.get(n.start) == null) {
            this.loopDone.put(n.start, cTree);
        }
        int[] b = n.branch;
        Object loopDestList = null;
        ArrayList<String> destList = new ArrayList<String>();
        ArrayList<String> srcList = new ArrayList<String>();
        LinkedHashMap<String, OpTree> nextVarMap = varMap;
        LinkedHashMap<String, OpTree> incrementals = new LinkedHashMap<String, OpTree>();
        for (int i2 = n.start; i2 <= b[0]; ++i2) {
            item = this.completeItemList.get(i2);
            this.getReferenced(item, destList, srcList, false);
            if (this.isAssignmentItem(item)) {
                this.interpretAssignmentItem(item, varMap, refList);
                continue;
            }
            if (!this.isLoopItem(item)) continue;
            this.interpretLoopItem(item, varMap, refList, incrementals);
        }
        for (String key : incrementals.keySet()) {
            varMap.remove(key);
            varMap.put(key, (OpTree)incrementals.get(key));
        }
        for (i = n.start; i <= b[0]; ++i) {
            item = this.completeItemList.get(i);
            this.getReferenced(item, cTree.thisDests, cTree.thisSources, true);
        }
        if (n.getComments(0, "").equals("loop") || n.getComments(0, "").equals("while")) {
            nextVarMap = new LinkedHashMap();
            for (i = b[1]; i < b[2]; ++i) {
                item = this.completeItemList.get(i);
                String args = item.getArgumentText();
                int refPos = -1;
                int pos = args.indexOf(", (");
                if (pos >= 0) {
                    refPos = pos + 3;
                } else {
                    pos = args.indexOf("(");
                    if (pos >= 0) {
                        refPos = pos + 1;
                    }
                }
                if (refPos <= 0) continue;
                String refVar = args.substring(refPos, args.indexOf(")"));
                refList.add(refVar);
            }
        } else if (n.getComments(0, "").equals("call")) {
            nextVarMap = new LinkedHashMap();
        }
        for (String var : varMap.keySet()) {
            cTree.assignments.put(var, varMap.get(var).lsbEvaluate());
        }
        cTree.branch[0] = n.getComments(0, "");
        cTree.branch[1] = n.getComments(1, "");
        if (cTree.branch[0] != null && (cTree.branch[0].equals("loop") || cTree.branch[0].equals("next"))) {
            OpTree base;
            cTree.loop[0] = n.branchVar;
            OpTree opTree = base = varMap.get(n.branchVar) != null ? varMap.get(n.branchVar) : new OpTree(n.branchVar);
            if (refList.contains(n.branchVar)) {
                base = base.doOp("REV", null);
            }
            OpTree ot = base.doOp("SUB", new OpTree("128"));
            cTree.loop[1] = ot.msbEvaluate();
        } else if (cTree.branch[0] != null && cTree.branch[0].equals("while")) {
            cTree.loop[0] = this.nodeList.get(b[1]).getComments(1, "");
        }
        if (b[1] > 0) {
            if (this.loopDone.get(b[1]) == null) {
                newVarMap = new LinkedHashMap<String, OpTree>();
                for (String s : nextVarMap.keySet()) {
                    newVarMap.put(s, nextVarMap.get(s).clone());
                }
                cTree.next[0] = this.makeCTree(cTree, list, newVarMap, refList, b[1]);
            } else {
                cTree.next[0] = this.loopDone.get(b[1]);
            }
        }
        if (b[2] > 0) {
            if (this.loopDone.get(b[2]) == null) {
                newVarMap = new LinkedHashMap();
                for (String s : nextVarMap.keySet()) {
                    newVarMap.put(s, nextVarMap.get(s).clone());
                }
                if (n.getComments(0, "").equals("loop")) {
                    newVarMap.put(n.branchVar, new OpTree("0"));
                }
                cTree.next[1] = this.makeCTree(cTree, list, newVarMap, refList, b[2]);
            } else {
                cTree.next[1] = this.loopDone.get(b[2]);
            }
        }
        return cTree;
    }

    private void interpretLoopItem(AssemblerItem item, LinkedHashMap<String, OpTree> varMap, List<String> refList, LinkedHashMap<String, OpTree> incrementals) {
        List<String> comboOps = Arrays.asList("LSL", "LSR", "AND", "OR", "XOR", "ADD", "SUB");
        String op = item.getOperation();
        String args = item.getArgumentText();
        StringTokenizer st = new StringTokenizer(args, ",()", true);
        int argNum = 0;
        boolean ref = false;
        String source = null;
        String dest = null;
        OpTree ot = new OpTree();
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.isEmpty()) continue;
            if (token.equals(",")) {
                ++argNum;
                continue;
            }
            if (token.equals("(")) {
                ref = true;
                continue;
            }
            if (token.equals(")")) {
                ref = false;
                continue;
            }
            if (argNum == 0) {
                dest = this.irpLabel(token);
                String string = dest = dest != null ? dest : token;
                if (!ref) continue;
                dest = this.irpLabel(this.proc.getDcBufStart()) + "[" + dest + "-208]";
                continue;
            }
            if (argNum != 1) continue;
            source = this.irpLabel(token);
            String string = source = source != null ? source : token;
            if (ref) {
                ot.op = "VAR";
                ot.opArgs = new ArrayList();
                ot.opArgs.add(new OpTree("11"));
                OpTree val = varMap.get(source);
                if (val == null) {
                    val = new OpTree(source);
                }
                val = val.doOp("REV", null);
                OpTree ot3 = val.doOp("SUB", new OpTree("11"));
                if (op.equals("MOVI")) {
                    OpTree ot4 = val.doOp("ADD", new OpTree("128")).doOp("REV", null);
                    incrementals.put(source, ot4);
                }
                ot3 = ot3.doOp("REV", null);
                ot.opArgs.add(ot3);
                source = source + "[]";
                continue;
            }
            ot = varMap.get(source) != null ? varMap.get(source) : new OpTree(source);
        }
        if (comboOps.contains(op)) {
            OpTree currVal = varMap.get(dest);
            if (currVal == null) {
                currVal = new OpTree(dest);
            }
            if (refList.contains(dest)) {
                currVal = currVal.doOp("REV", null);
            }
            ot = currVal.doOp(op, ot);
        }
        if (refList.contains(source) && !refList.contains(dest) || !refList.contains(source) && refList.contains(dest)) {
            ot = ot.doOp("REV", null);
        }
        varMap.remove(dest);
        varMap.put(dest, ot);
    }

    private void interpretAssignmentItem(AssemblerItem item, LinkedHashMap<String, OpTree> varMap, List<String> refList) {
        short dest;
        String source;
        for (int i = 0; i < 10; ++i) {
            refList.add("Tmp" + i);
        }
        ArrayList<String> argList = new ArrayList<String>();
        ArrayList<String> argList2 = new ArrayList<String>();
        List<String> comboOps = Arrays.asList("LSL", "LSR", "AND", "OR", "XOR", "ADD", "SUB", "MULT");
        String args = item.getArgumentText();
        StringTokenizer st = new StringTokenizer(args, ",[]");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.startsWith("#$")) {
                int val = Integer.parseInt(token.substring(2), 16);
                int[] rev = new int[4];
                this.reverseByte(val & 0xFF, rev);
                argList.add("" + rev[0]);
                Arrays.fill(rev, 0);
                this.reverseByte(val >> 8 & 0xFF, rev);
                argList2.add("" + rev[0]);
                continue;
            }
            String label = this.irpLabel(token);
            argList.add(label != null ? label : token);
            argList2.add("");
        }
        String op = item.getOperation();
        if (op.equals("MOV") && !args.contains("[") && !args.contains("(")) {
            OpTree newVal;
            String dest2 = (String)argList.get(0);
            source = (String)argList.get(1);
            OpTree currVal = varMap.get(source);
            OpTree opTree = newVal = currVal != null ? currVal : new OpTree(source);
            if (refList.contains(source) && !refList.contains(dest2) || !refList.contains(source) && refList.contains(dest2)) {
                newVal = newVal.doOp("REV", null);
            }
            varMap.remove(dest2);
            varMap.put(dest2, newVal);
        } else if (op.equals("MOVW") && args.contains("#$")) {
            dest = item.getHex().getData()[1];
            String var1 = (String)argList.get(0);
            String var2 = this.irpLabel(this.getZeroLabel(dest + 1));
            if (var2 != null) {
                OpTree ot1 = new OpTree((String)argList.get(1));
                OpTree ot2 = new OpTree((String)argList2.get(1));
                if (refList.contains(var1)) {
                    ot1 = ot1.doOp("REV", null);
                }
                if (refList.contains(var2)) {
                    ot2 = ot2.doOp("REV", null);
                }
                varMap.remove(var1);
                varMap.remove(var2);
                varMap.put(var1, ot1);
                varMap.put(var2, ot2);
            } else {
                int high = Integer.parseInt((String)argList.get(1));
                int low = Integer.parseInt((String)argList2.get(1));
                OpTree ot1 = new OpTree(Integer.toString(high * 256 + low));
                if (refList.contains(var1)) {
                    ot1 = ot1.doOp("REV", null);
                }
                varMap.remove(var1);
                varMap.put(var1, ot1);
            }
        } else if (op.equals("MOVN")) {
            dest = item.getHex().getData()[1];
            short src = item.getHex().getData()[2];
            int n = item.getHex().getData()[3];
            for (int i = 0; i < n; ++i) {
                OpTree newVal;
                String var1 = this.irpLabel(dest + i);
                String var2 = this.irpLabel(src + i);
                OpTree currVal = varMap.get(var2);
                OpTree opTree = newVal = currVal != null ? currVal : new OpTree(var2);
                if (refList.contains(var1) && !refList.contains(var2) || !refList.contains(var1) && refList.contains(var2)) {
                    newVal = newVal.doOp("REV", null);
                }
                varMap.remove(var1);
                varMap.put(var1, newVal);
            }
        } else if (op.equals("XOR") && args.contains("#$FF")) {
            String dest3 = (String)argList.get(0);
            source = (String)argList.get(1);
            OpTree currVal = varMap.get(source);
            currVal = currVal != null ? currVal : new OpTree(source);
            OpTree newVal = currVal.doOp("CPL", null);
            if (refList.contains(source) && !refList.contains(dest3) || !refList.contains(source) && refList.contains(dest3)) {
                newVal = newVal.doOp("REV", null);
            }
            varMap.remove(dest3);
            varMap.put(dest3, newVal);
        } else if (comboOps.contains(op)) {
            OpTree currArg;
            String dest4 = (String)argList.get(0);
            source = (String)argList.get(1);
            String argStr = (String)argList.get(2);
            OpTree currVal = varMap.get(source);
            OpTree opTree = currVal = currVal != null ? currVal : new OpTree(source);
            if (refList.contains(source)) {
                currVal = currVal.doOp("REV", null);
            }
            OpTree opTree2 = currArg = (currArg = varMap.get(argStr)) != null ? currArg : new OpTree(argStr);
            if (refList.contains(argStr)) {
                currArg = currArg.doOp("REV", null);
            }
            OpTree newVal = currVal.doOp(op, currArg);
            if (refList.contains(dest4)) {
                newVal = newVal.doOp("REV", null);
            }
            varMap.remove(dest4);
            varMap.put(dest4, newVal);
        } else if (op.equals("SWAP")) {
            String dest5 = (String)argList.get(0);
            source = (String)argList.get(1);
            OpTree currVal = varMap.get(source);
            currVal = currVal != null ? currVal : new OpTree(source);
            OpTree newVal = currVal.doOp("SWAP", null);
            if (refList.contains(source) && !refList.contains(dest5) || !refList.contains(source) && refList.contains(dest5)) {
                newVal = newVal.doOp("REV", null);
            }
            varMap.remove(dest5);
            varMap.put(dest5, newVal);
        } else if (op.equals("MOV") && args.contains("[")) {
            String dest6 = (String)argList.get(0);
            String base = (String)argList.get(2);
            OpTree currVal = varMap.get(base);
            OpTree opTree = currVal = currVal != null ? currVal : new OpTree(base);
            if (refList.contains(base)) {
                currVal = currVal.doOp("REV", null);
            }
            String str = (String)argList.get(1) + "[";
            String valStr = currVal.msbEvaluate();
            str = str + (valStr != null ? valStr : "???");
            str = str + "]";
            OpTree ot = new OpTree(str);
            if (refList.contains(dest6)) {
                ot = ot.doOp("REV", null);
            }
            varMap.remove(dest6);
            varMap.put(dest6, ot);
        }
    }

    private boolean getReferenced(AssemblerItem item, List<String> destList, List<String> srcList, boolean checkDest) {
        String label;
        Function fn;
        int i;
        if (item.getHex() == null) {
            return false;
        }
        short[] hex = item.getHex().getData();
        short op = hex[0];
        String str = null;
        if (!((op < 1 || op > 9) && op != 83 || srcList.contains(str = this.irpLabel(hex[3])) || checkDest && destList.contains(str))) {
            srcList.add(str);
        }
        if (!(op != 9 && op != 25 || srcList.contains(str = this.irpLabel(hex[2] + 1)) || checkDest && destList.contains(str))) {
            srcList.add(str);
        }
        if (op == 84 || op == 85 || op == 86 || op == 88) {
            int n = i = op == 84 ? 1 : 2;
            while (i < 3) {
                str = this.irpLabel(hex[i]);
                if (!(srcList.contains(str) || checkDest && destList.contains(str))) {
                    srcList.add(str);
                }
                ++i;
            }
        }
        if (op < 76 || op == 83 || op == 80 || op == 81) {
            List<Integer> wordOps;
            if (!(op == 16 || op == 48 || srcList.contains(str = this.irpLabel(hex[2])) || checkDest && destList.contains(str))) {
                srcList.add(str);
            }
            if (!destList.contains(str = this.irpLabel(hex[1]))) {
                str = this.irpLabel(hex[1]);
                destList.add(str);
            }
            if ((wordOps = Arrays.asList(8, 9, 24, 25, 32, 48)).contains(op) && !destList.contains(str = this.irpLabel(hex[1] + 1))) {
                destList.add(str);
            }
            if (op == 80 && !destList.contains(str = this.irpLabel(hex[3]))) {
                destList.add(str);
            }
        }
        if (op == 82) {
            for (i = 0; i < hex[3]; ++i) {
                str = this.irpLabel(hex[2] + i);
                if (srcList.contains(str) || checkDest && destList.contains(str)) continue;
                srcList.add(str);
            }
            for (i = 0; i < hex[3]; ++i) {
                str = this.irpLabel(hex[1] + i);
                if (destList.contains(str)) continue;
                destList.add(str);
            }
        }
        if (op == 88 && !destList.contains(str = this.irpLabel(hex[2]))) {
            destList.add(str);
        }
        if (op == 76) {
            str = this.irpLabel(this.proc.getDcBufStart()) + "[" + this.irpLabel(hex[1]) + "]";
            if (!destList.contains(str)) {
                destList.add(str);
            }
            if (!(srcList.contains(str = this.irpLabel(hex[2])) || checkDest && destList.contains(str))) {
                srcList.add(str);
            }
        }
        if ((op == 89 || op == 79) && (fn = this.functionIndex.get(label = op == 89 ? item.getArgumentText() : item.getLabel())) != null && fn.code != null && fn.code.node != null) {
            for (String var : fn.code.getAllSources()) {
                if (srcList.contains(var)) continue;
                srcList.add(var);
            }
            for (String var : fn.code.getAllDests()) {
                if (destList.contains(var)) continue;
                destList.add(var);
            }
        }
        return true;
    }

    private int[] findSelfContained(int start, int end) {
        boolean changed = true;
        while (changed) {
            changed = false;
            for (int i = start; i < end; ++i) {
                AssemblerItem item = this.completeItemList.get(i);
                String op = item.getOperation();
                String args = item.getArgumentText();
                if (!op.equals("BRA") && !op.equals("DBNZ")) continue;
                StringTokenizer st = new StringTokenizer(args, ",");
                String label = null;
                while (st.hasMoreTokens()) {
                    String token = st.nextToken().trim();
                    if (!Pattern.matches("L\\d*", token)) continue;
                    label = token;
                    break;
                }
                if (label == null) {
                    return null;
                }
                int dest = this.labelIndex.get(label);
                if (dest < start) {
                    start = dest;
                    changed = true;
                }
                if (dest <= end) continue;
                end = dest;
                changed = true;
            }
        }
        return new int[]{start, end};
    }

    private boolean isAssignmentItem(AssemblerItem item) {
        int t = item.get_Type();
        if (t == 3 || t == 4 || t == 5) {
            return false;
        }
        String op = item.getOperation();
        String args = item.getArgumentText();
        List<String> comboOps = Arrays.asList("MOV", "LSL", "LSR", "AND", "OR", "XOR", "MOVN", "SWAP", "ADD", "SUB", "MULT", "NOP");
        return comboOps.contains(op) && !args.contains("(") || op.equals("MOVW") && args.contains("#$");
    }

    private boolean isLoopItem(AssemblerItem item) {
        if (this.isAssignmentItem(item)) {
            return true;
        }
        String args = item.getArgumentText();
        return Pattern.matches(".*\\((Fix|Var|Calc|Tmp)\\d+\\).*", args);
    }

    private List<AssemblerItem> expandLabels(List<AssemblerItem> in) {
        ArrayList<AssemblerItem> out = new ArrayList<AssemblerItem>();
        for (AssemblerItem ai : in) {
            int ad = ai.getAddress();
            String label = this.labels.get(ad);
            if (label != null) {
                AssemblerItem newItem = new AssemblerItem(ad, new Hex(new short[]{79, 0, 0, 0}));
                newItem.setLabel(label);
                newItem.setOperation("NOP");
                newItem.setType(-1);
                out.add(newItem);
            }
            if (!ai.getLabel().startsWith("PB") && !ai.getLabel().startsWith("SB")) {
                ai.setLabel("");
            }
            out.add(ai);
        }
        return out;
    }

    private String getZeroLabel(int addr) {
        AssemblerItem item = new AssemblerItem();
        item.setZeroLabel(this.proc, addr, new ArrayList<Integer>(), "");
        return item.getLabel();
    }

    private class ProtocolBlock {
        public String description = null;
        public String condition = null;
        public String sigSelector = null;
        public CodeTree preamble = null;
        public CodeTree postamble = null;
        public List<Function> functions = new ArrayList<Function>();
        public List<IRPstruct> irps = new ArrayList<IRPstruct>();
        public List<String> irpParts11 = new ArrayList<String>();
        public boolean hasPBcode = false;
        public boolean hasSBcode = false;
        public List<String> sbVars = new ArrayList<String>();
        public List<String> errors = new ArrayList<String>();
        public List<String> warnings = new ArrayList<String>();
        public boolean timingBlockHasGaps = false;
        public boolean postambleCommutable = true;
        public Executor e = null;
        public int startTiming = 0;
        public int lastTiming = 0;

        private ProtocolBlock() {
        }
    }

    private class IRPstruct {
        public String generalSpec = "";
        public String bitSpec = "";
        public boolean base16 = false;
        public String irStream = "";
        public int unit = 0;
        public List<String> comments = new ArrayList<String>();

        private IRPstruct() {
        }

        public boolean equals(Object obj) {
            if (obj == null || this.generalSpec == null || this.bitSpec == null || this.irStream == null) {
                return false;
            }
            IRPstruct is = (IRPstruct)obj;
            if (!this.generalSpec.equals(is.generalSpec)) {
                return false;
            }
            if (!this.bitSpec.equals(is.bitSpec)) {
                return false;
            }
            if (this.base16 != is.base16) {
                return false;
            }
            if (!this.irStream.equals(is.irStream)) {
                return false;
            }
            return Arrays.deepEquals(this.comments.toArray(new String[0]), is.comments.toArray(new String[0]));
        }

        public IRPstruct clone() {
            IRPstruct struct = new IRPstruct();
            struct.generalSpec = this.generalSpec;
            struct.bitSpec = this.bitSpec;
            struct.base16 = this.base16;
            struct.irStream = this.irStream;
            struct.unit = this.unit;
            struct.comments = new ArrayList<String>();
            for (String s : this.comments) {
                struct.comments.add(s);
            }
            return struct;
        }

        public String toString() {
            String s = this.generalSpec + this.bitSpec;
            if (this.base16) {
                s = s + "(<1:1|";
                for (int i = 1; i < 16; ++i) {
                    s = s + "1:1,0:" + i + (i < 15 ? "|" : ">");
                }
            }
            s = s + this.irStream + (this.base16 ? ")" : "");
            return s;
        }
    }

    private class OpTree {
        public String op = null;
        public Value value = null;
        public ArrayList<OpTree> opArgs = null;

        public OpTree() {
        }

        public OpTree(String var) {
            this.value = new Value(var);
        }

        public OpTree clone() {
            OpTree newTree = new OpTree();
            newTree.op = this.op;
            if (this.value != null) {
                newTree.value = this.value.clone();
            }
            if (this.opArgs != null) {
                newTree.opArgs = new ArrayList();
                for (OpTree ot : this.opArgs) {
                    newTree.opArgs.add(ot.clone());
                }
            }
            return newTree;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public OpTree doOp(String os, OpTree arg) {
            OpTree ot1;
            OpTree ot;
            int[] rev;
            int n = -1;
            int nRev = -1;
            int v = -1;
            int vRev = -1;
            boolean consecutive = false;
            try {
                if (arg != null && arg.value != null) {
                    n = Integer.parseInt(arg.value.lsbEvaluate());
                    rev = new int[4];
                    JP2Analyzer.this.reverseByte(n, rev);
                    consecutive = rev[1] == rev[3] - rev[2] + 1;
                    nRev = rev[0];
                }
            }
            catch (NumberFormatException nfe) {
                n = -1;
            }
            try {
                if (this.value != null) {
                    v = Integer.parseInt(this.value.lsbEvaluate());
                    rev = new int[4];
                    JP2Analyzer.this.reverseByte(v, rev);
                    vRev = rev[0];
                }
            }
            catch (NumberFormatException nfe) {
                v = -1;
            }
            if (Arrays.asList("OR", "XOR", "ADD").contains(os) && this.value != null && this.value.var.equals("0")) {
                return arg.clone();
            }
            if (Arrays.asList("AND", "REV", "MULT").contains(os) && this.value != null && this.value.var.equals("0")) {
                return new OpTree("0");
            }
            if (n >= 0 && Arrays.asList("LSR", "LSL", "AND", "OR").contains(os) && (!os.equals("AND") || consecutive)) {
                if (this.value != null) {
                    ot = new OpTree();
                    ot.value = this.value.doNumOp(os, n);
                    return ot;
                }
                if (Arrays.asList("AND", "OR").contains(this.op) || this.op.equals("XOR") && Arrays.asList("LSR", "LSL", "AND").contains(os)) {
                    ot = new OpTree();
                    ot.op = this.op;
                    ot.opArgs = new ArrayList();
                    for (OpTree o : this.opArgs) {
                        ot.opArgs.add(o.doOp(os, arg));
                    }
                    return ot;
                }
                if (!this.op.equals("REV")) return new OpTree("(" + this.lsbEvaluate() + ")").doOp(os, arg);
                ot1 = new OpTree();
                ot1.opArgs = new ArrayList();
                if (os.equals("REV")) {
                    return this.opArgs.get(0);
                }
                if (os.equals("LSR") || os.equals("LSL")) {
                    ot1 = this.opArgs.get(0).doOp(os.equals("LSR") ? "LSL" : "LSR", arg);
                    OpTree ot2 = new OpTree();
                    ot2.op = "REV";
                    ot2.opArgs = new ArrayList();
                    ot2.opArgs.add(ot1);
                    return ot2;
                }
                if (!os.equals("AND") && !os.equals("OR")) return null;
                ot1 = this.opArgs.get(0).doOp(os, new OpTree("" + nRev));
                OpTree ot3 = new OpTree();
                ot3.op = "REV";
                ot3.opArgs = new ArrayList();
                ot3.opArgs.add(ot1);
                return ot3;
            }
            if (n >= 0 && v >= 0 && Arrays.asList("ADD", "SUB", "MULT").contains(os)) {
                v = os.equals("ADD") ? vRev + nRev : (os.equals("SUB") ? vRev - nRev : vRev * nRev);
                rev = new int[4];
                JP2Analyzer.this.reverseByte(v, rev);
                return new OpTree("" + rev[0]);
            }
            if (os.equals("CPL")) {
                if (this.value != null) {
                    ot = new OpTree();
                    ot.value = this.value.doNumOp(os, 0);
                    return ot;
                }
                if (Arrays.asList("AND", "OR").contains(this.op)) {
                    ot = new OpTree();
                    ot.op = this.op.equals("AND") ? "OR" : "AND";
                    ot.opArgs = new ArrayList();
                    for (OpTree o : this.opArgs) {
                        ot.opArgs.add(o.doOp(os, arg));
                    }
                    return ot;
                }
                if (!this.op.equals("XOR") || this.opArgs.size() != 2) return null;
                ot1 = new OpTree();
                ot1.op = "AND";
                ot1.opArgs = new ArrayList();
                ot1.opArgs.add(this.opArgs.get(0).doOp("CPL", null));
                ot1.opArgs.add(this.opArgs.get(1).doOp("CPL", null));
                OpTree ot2 = new OpTree();
                ot2.op = "AND";
                ot2.opArgs = new ArrayList();
                ot2.opArgs.add(this.opArgs.get(0));
                ot2.opArgs.add(this.opArgs.get(1));
                OpTree ot4 = new OpTree();
                ot4.op = "OR";
                ot4.opArgs = new ArrayList();
                ot4.opArgs.add(ot1);
                ot4.opArgs.add(ot2);
                return ot4;
            }
            if (Arrays.asList("AND", "OR", "XOR").contains(os)) {
                if (this.value == null && this.op.equals(os)) {
                    ot = this.clone();
                    ot.opArgs.add(arg);
                    return ot;
                }
                ot = new OpTree();
                ot.op = os;
                ot.opArgs = new ArrayList();
                ot.opArgs.add(this);
                ot.opArgs.add(arg);
                return ot;
            }
            if (os.equals("SWAP")) {
                ot1 = this.doOp("LSL", new OpTree("32"));
                OpTree ot2 = this.doOp("LSR", new OpTree("32"));
                OpTree ot5 = new OpTree();
                ot5.op = "OR";
                ot5.opArgs = new ArrayList();
                ot5.opArgs.add(ot1);
                ot5.opArgs.add(ot2);
                return ot5;
            }
            if (os.equals("REV")) {
                if (this.value == null && this.op.equals("REV")) {
                    return this.opArgs.get(0).clone();
                }
                ot = new OpTree();
                ot.op = "REV";
                ot.opArgs = new ArrayList();
                ot.opArgs.add(this);
                return ot;
            }
            if (!Arrays.asList("MULT", "ADD", "SUB").contains(os)) return null;
            ot1 = this.doOp("REV", null);
            OpTree ot2 = arg.doOp("REV", null);
            if (ot1.value == null && ot1.op.equals(os)) {
                OpTree ot6 = ot1.clone();
                ot6.opArgs.add(ot2);
                return ot6.doOp("REV", null);
            }
            OpTree ot7 = new OpTree();
            ot7.op = os;
            ot7.opArgs = new ArrayList();
            ot7.opArgs.add(ot1);
            ot7.opArgs.add(ot2);
            return ot7.doOp("REV", null);
        }

        public String lsbEvaluate() {
            return this.evaluate(false);
        }

        private String evaluate(boolean msb) {
            String str = "";
            if (this.value != null) {
                str = this.value.evaluate(msb);
            } else if (this.op.equals("REV")) {
                str = this.opArgs.get(0).evaluate(!msb);
            } else if (this.op.equals("VAR")) {
                str = this.opArgs.get(0).evaluate(true);
                try {
                    int ref = Integer.parseInt(str);
                    str = JP2Analyzer.this.irpLabel(ref);
                }
                catch (NumberFormatException nfe) {
                    str = "VAR(" + str + ")";
                }
                str = str + "[" + this.opArgs.get(1).evaluate(false) + "]";
                if (msb) {
                    str = str + ":-8";
                }
            } else if (!msb || Arrays.asList("OR", "AND", "XOR").contains(this.op)) {
                for (int i = 0; i < this.opArgs.size(); ++i) {
                    OpTree ot = this.opArgs.get(i);
                    String eval = ot.evaluate(msb);
                    if (eval.equals("0") && Arrays.asList("OR", "XOR", "ADD").contains(this.op) && (!str.isEmpty() || i < this.opArgs.size() - 1)) continue;
                    String opSymbol = this.op.equals("AND") ? "&" : (this.op.equals("OR") ? "|" : (this.op.equals("XOR") ? "^" : (this.op.equals("ADD") ? "+" : (this.op.equals("SUB") ? "-" : (this.op.equals("MULT") ? "*" : "??")))));
                    str = str + (str.isEmpty() ? "" : opSymbol);
                    if (Pattern.matches("[A-Za-z0-9\\[\\]\\-\\:\\" + opSymbol + "]+", eval)) {
                        int ndx = -1;
                        while ((ndx = eval.indexOf("-", ndx + 1)) > 0 && (eval.charAt(ndx - 1) == ':' || eval.substring(0, ndx).contains("[") && eval.substring(ndx).contains("]"))) {
                        }
                        if (ndx >= 0) {
                            str = str + "(" + eval + ")";
                            continue;
                        }
                        str = str + eval;
                        continue;
                    }
                    str = str + "(" + eval + ")";
                }
            } else {
                str = "(" + this.evaluate(false) + "):-8";
            }
            if (Pattern.matches("\\([A-Za-z0-9\\[\\]\\-\\:\\&\\|\\^]+\\)", str)) {
                str = str.substring(1, str.length() - 1);
            }
            return str;
        }

        public String msbEvaluate() {
            return this.evaluate(true);
        }
    }

    private class Executor {
        public int index = 0;
        public List<String> names = new ArrayList<String>();
        public Hex hex = null;
        public String description = null;
        public List<String> errors = new ArrayList<String>();
        public List<String> warnings = new ArrayList<String>();
        public List<ProtocolBlock> pbList = new ArrayList<ProtocolBlock>();

        private Executor() {
        }
    }

    private class TimingStruct {
        public int[] carriers = null;
        public int[] durations = null;
        public int[] pf = null;
        public Integer pbPath = null;
        public String pbCondition = null;
        public LinkedHashMap<Integer, int[]> sbPaths = new LinkedHashMap();

        public TimingStruct() {
            this.carriers = new int[3];
            this.durations = new int[64];
            this.pf = new int[16];
        }

        public TimingStruct(int[] carriers, int[] durations, int[] pf) {
            this.carriers = (int[])carriers.clone();
            this.durations = Arrays.copyOf(durations, 64);
            this.pf = Arrays.copyOf(pf, 16);
        }

        public TimingStruct clone() {
            TimingStruct ts = new TimingStruct(this.carriers, this.durations, this.pf);
            LinkedHashMap<Integer, int[]> sbp = new LinkedHashMap<Integer, int[]>();
            for (int n : this.sbPaths.keySet()) {
                sbp.put(n, (int[])this.sbPaths.get(n).clone());
            }
            ts.sbPaths = sbp;
            ts.pbPath = this.pbPath;
            return ts;
        }

        public boolean same(TimingStruct ts, int sbIndex) {
            if (ts.pbPath != this.pbPath) {
                return false;
            }
            for (int i = 0; i <= sbIndex; ++i) {
                int[] p1 = ts.sbPaths.get(i);
                int[] p2 = this.sbPaths.get(i);
                if (p1 == null && p2 != null || p1 != null && p2 == null) {
                    return false;
                }
                if (p1 == null || p2 == null || p1[0] == p2[0] && p1[1] == p2[1]) continue;
                return false;
            }
            return true;
        }
    }

    private class IRPIndexItem {
        IRPstruct irp = null;
        int[] location = new int[3];

        private IRPIndexItem() {
        }
    }

    private static class CodeTree {
        public LinkedHashMap<String, String> assignments = new LinkedHashMap();
        public String[] branch = new String[2];
        public String[] loop = new String[2];
        public CodeTree[] next = new CodeTree[2];
        public CodeTree parent = null;
        public Node node = null;
        public List<String> thisDests = new ArrayList<String>();
        public List<String> thisSources = new ArrayList<String>();
        private List<String> allSources = null;
        private List<String> allDests = null;
        private List<String> allParentDests = null;
        private static Node loopNode = null;
        private static String forStart = "0";

        public CodeTree() {
        }

        public CodeTree(CodeTree parent) {
            this.parent = parent;
        }

        public List<String> getAllSources() {
            if (this.allSources != null) {
                return this.allSources;
            }
            this.allSources = new ArrayList<String>();
            for (String var : this.thisSources) {
                if (!this.inLoop() && this.parent != null && this.parent.getAllParentDests().contains(var)) continue;
                this.allSources.add(var);
            }
            CodeTree p = this.parent;
            while (p != null && p.node.isDataBranch()) {
                for (String var : p.thisSources) {
                    if (this.allSources.contains(var)) continue;
                    this.allSources.add(var);
                }
                p = p.parent;
            }
            if (this.next[0] != null) {
                for (String var : this.next[0].getAllSources()) {
                    if (this.allSources.contains(var)) continue;
                    this.allSources.add(var);
                }
            }
            if (this.next[1] != null) {
                for (String var : this.next[1].getAllSources()) {
                    if (this.allSources.contains(var)) continue;
                    this.allSources.add(var);
                }
            }
            return this.allSources;
        }

        public List<String> getAllDests() {
            if (this.allDests != null) {
                return this.allDests;
            }
            this.allDests = new ArrayList<String>();
            for (String var : this.thisDests) {
                this.allDests.add(var);
            }
            if (this.next[0] != null) {
                for (String var : this.next[0].getAllDests()) {
                    if (this.allDests.contains(var)) continue;
                    this.allDests.add(var);
                }
            }
            if (this.next[1] != null) {
                for (String var : this.next[1].getAllDests()) {
                    if (this.allDests.contains(var)) continue;
                    this.allDests.add(var);
                }
            }
            return this.allDests;
        }

        public List<String> getAllParentDests() {
            if (this.allParentDests != null) {
                return this.allParentDests;
            }
            this.allParentDests = new ArrayList<String>();
            if (this.parent != null) {
                for (String var : this.parent.thisDests) {
                    if (this.allParentDests.contains(var)) continue;
                    this.allParentDests.add(var);
                }
                for (String var : this.parent.getAllParentDests()) {
                    if (this.allParentDests.contains(var)) continue;
                    this.allParentDests.add(var);
                }
            }
            return this.allParentDests;
        }

        private boolean inLoop() {
            if (this.parent == null) {
                return false;
            }
            if (this.parent.branch[0].equals("loop")) {
                return this == this.parent.next[0];
            }
            return this.parent.inLoop();
        }

        private List<String> getStringList(LinkedHashMap<String, String> map) {
            ArrayList<String> list = new ArrayList<String>();
            for (String var : map.keySet()) {
                if (!prb.sbVars.contains(var) && !var.contains("[") && !this.getAllSources().contains(var)) continue;
                list.add(var + "=" + map.get(var));
            }
            return list;
        }

        public List<String> description() {
            ArrayList<String> list = new ArrayList<String>();
            if (this.branch[0].equals("preloop")) {
                for (String var : this.next[0].assignments.keySet()) {
                    this.assignments.put(var, this.next[0].assignments.get(var));
                }
                this.assignments.remove(this.next[0].loop[0]);
                list.addAll(this.getStringList(this.assignments));
                list.addAll(this.next[0].description());
            } else if (this.branch[0].equals("next")) {
                list.addAll(this.getStringList(this.assignments));
                if (loopNode == null && this.next[1].branch[0].equals("loop")) {
                    forStart = "1";
                    list.addAll(this.next[1].description());
                }
            } else if (this.branch[0].equals("loop")) {
                loopNode = this.node;
                list.add("for n=" + forStart + " to " + this.loop[1] + " {");
                forStart = "0";
                List<String> list2 = this.next[0].description();
                for (String s : list2) {
                    list.add("  " + s);
                }
                list.add("}");
                loopNode = null;
                if (this.next[1] != null) {
                    list.addAll(this.next[1].description());
                }
            } else if (this.branch[0].equals("while")) {
                loopNode = this.node;
                list.add("while " + this.loop[0] + " {");
                List<String> list2 = this.next[0].description();
                for (String s : list2) {
                    list.add("  " + s);
                }
                list.add("}");
                loopNode = null;
                if (this.next[1] != null) {
                    list.addAll(this.next[1].description());
                }
            } else if (this.branch[0].equals("call")) {
                list.addAll(this.getStringList(this.assignments));
                list.add(this.branch[1] + "()");
                if (this.next[0] != null) {
                    list.addAll(this.next[0].description());
                }
            } else if (loopNode != null && this.node.start == CodeTree.loopNode.branch[2]) {
                list.add("break");
            } else if (!(loopNode == null || this.node.start <= CodeTree.loopNode.branch[2] && this.node.start >= CodeTree.loopNode.branch[1] || this.node.branch[1] >= CodeTree.loopNode.branch[0] && this.node.branch[1] <= CodeTree.loopNode.branch[2] && (this.node.branch[2] <= 0 || this.node.branch[2] >= CodeTree.loopNode.branch[0] && this.node.branch[2] <= CodeTree.loopNode.branch[2]))) {
                list.add("<ERROR>");
            } else if (loopNode != null && this.node.branch[2] == CodeTree.loopNode.start) {
                list.addAll(this.getStringList(this.assignments));
            } else if (!this.branch[0].isEmpty() && this.next[1] != null && this.next[1].branch[0].equals("while")) {
                list.addAll(this.getStringList(this.assignments));
                list.addAll(this.next[1].description());
            } else if (!this.branch[0].isEmpty()) {
                List<String> list3;
                List<String> list2 = this.next[0] == null ? this.getStringList(this.assignments) : this.next[0].description();
                List<String> list4 = list3 = this.next[1] == null ? this.getStringList(this.assignments) : this.next[1].description();
                if (!list2.isEmpty()) {
                    list.add("if (" + this.branch[0] + ") {");
                    for (String s : list2) {
                        list.add("  " + s);
                    }
                    list.add("}");
                }
                if (!list3.isEmpty()) {
                    list.add((!list2.isEmpty() ? "else " : "") + "if (" + this.branch[1] + ") {");
                    for (String s : list3) {
                        list.add("  " + s);
                    }
                    list.add("}");
                }
            } else if (this.next[0] != null && this.next[1] == null) {
                if (this.next[0].branch[0].equals("next") && loopNode == null) {
                    this.next[0].assignments.remove(this.next[0].loop[0]);
                }
                list.addAll(this.next[0].description());
            } else if (loopNode != null && this.node.start != CodeTree.loopNode.branch[2]) {
                list.add("<ERROR>");
            } else {
                list.addAll(this.getStringList(this.assignments));
            }
            return list;
        }

        public String toString() {
            String str = "";
            for (String s : this.description()) {
                str = str + s + "\n";
            }
            return str;
        }
    }

    private class Function {
        public String name = null;
        public CodeTree code = new CodeTree();

        public Function(String name) {
            this.name = name;
        }
    }

    private class Node {
        public int start = 0;
        public int[] branch = null;
        public String branchVar = "";
        public int branchType = -1;

        public Node(int start) {
            this.start = start;
        }

        public boolean isDataBranch() {
            return this.branchType == 10 || this.branchType >= 0 && this.branchType < 8;
        }

        public String getComments(int val, String prefix) {
            String str = "";
            if (this.branchType >= 0 && this.branchType < 8) {
                str = this.branchVar + ":1:" + this.branchType + "=" + val;
            } else if ((this.branchType & 0xFF00) == 256) {
                int mask = this.branchType & 0xFF;
                str = mask == 255 ? this.branchVar + (val == 0 ? "=0" : "!=0") : this.branchVar + "&" + mask + (val == 0 ? "=0" : "!=0");
            } else if (this.branchType == 8) {
                str = prefix + "key is ";
                str = str + (val == 0 ? "" : "not ");
                str = str + this.branchVar;
            } else if (this.branchType == 11) {
                str = val == 0 ? (((AssemblerItem)JP2Analyzer.this.completeItemList.get(this.branch[2] - 1)).getOperation().equals("DBNZ") ? "loop" : "while") : this.branchVar;
            } else if (this.branchType == 12) {
                str = val == 0 ? "next" : this.branchVar;
            } else if (this.branchType == 13) {
                str = val == 0 ? "preloop" : this.branchVar;
            } else if (this.branchType == 15) {
                AssemblerItem ai = (AssemblerItem)JP2Analyzer.this.completeItemList.get(this.branch[0]);
                short offset = ai.getHex().getData()[1];
                String label = (String)JP2Analyzer.this.labels.get(ai.getAddress() + offset - (offset >= 128 ? 256 : 0));
                String function = ((Function)((JP2Analyzer)JP2Analyzer.this).functionIndex.get((Object)label)).name;
                str = val == 0 ? "call" : function;
            } else if (this.branchType == 16) {
                AssemblerItem ai = (AssemblerItem)JP2Analyzer.this.completeItemList.get(this.branch[0]);
                short offset = ai.getHex().getData()[1];
                String label = (String)JP2Analyzer.this.labels.get(ai.getAddress() + offset - (offset >= 128 ? 256 : 0));
                String function = ((Function)((JP2Analyzer)JP2Analyzer.this).functionIndex.get((Object)label)).name;
                str = val == 0 ? "call" : function;
            }
            return str;
        }
    }

    private class Value {
        public String var = null;
        public int shift = 0;
        public int and = 255;
        public int or = 0;

        public Value(String var) {
            this.var = var;
        }

        public Value(String var, int shift, int and, int or) {
            this.var = var;
            this.shift = shift;
            this.and = and;
            this.or = or;
        }

        public Value doNumOp(String op, int n) {
            int[] rev = new int[4];
            JP2Analyzer.this.reverseByte(n, rev);
            if (op.equals("LSR")) {
                if (this.var.equals("0") || this.shift + rev[0] > 7 || this.shift + rev[0] < -7 || (this.and << rev[0] & 0xFF) == 0) {
                    return new Value("0");
                }
                return new Value(this.var, this.shift + rev[0], this.and << rev[0] & 0xFF, this.or << rev[0] & 0xFF);
            }
            if (op.equals("LSL")) {
                if (this.var.equals("0") || this.shift - rev[0] > 7 || this.shift - rev[0] < -7 || (this.and >> rev[0] & 0xFF) == 0) {
                    return new Value("0");
                }
                return new Value(this.var, this.shift - rev[0], this.and >> rev[0], this.or >> rev[0]);
            }
            if (op.equals("AND")) {
                if (this.var.equals("0") || n == 0) {
                    return new Value("0");
                }
                return new Value(this.var, this.shift, this.and & n, this.or & n);
            }
            if (op.equals("OR")) {
                if (n == 255) {
                    return new Value("255");
                }
                return new Value(this.var, this.shift, this.and, this.or | n);
            }
            if (op.equals("CPL")) {
                String newVar = this.var.startsWith("~") ? this.var.substring(1) : "~" + this.var;
                int newAnd = ~this.or & 0xFF;
                int newOr = ~this.and & ~this.or & 0xFF;
                return new Value(newVar, this.shift, newAnd, newOr);
            }
            return null;
        }

        private String msbEvaluate() {
            int[] revAnd = new int[4];
            int[] revOr = new int[4];
            JP2Analyzer.this.reverseByte(this.and, revAnd);
            JP2Analyzer.this.reverseByte(this.or, revOr);
            int num = 0;
            String str = "";
            if (revAnd[1] == revAnd[3] - revAnd[2] + 1) {
                block6: {
                    try {
                        int[] revVar = new int[4];
                        num = Integer.parseInt(this.var);
                        JP2Analyzer.this.reverseByte(num, revVar);
                        num = revVar[0];
                        num >>= this.shift;
                        num &= revAnd[0];
                        str = str + (num |= revOr[0]);
                    }
                    catch (NumberFormatException nex) {
                        if (revAnd[2] > 0) {
                            str = str + (int)Math.pow(2.0, revAnd[2]) + "*";
                        }
                        str = str + this.var;
                        int disc = 7 - revAnd[3] - this.shift;
                        int keep = revAnd[1] - (disc < 0 ? -disc : 0);
                        str = str + (keep > 1 ? ":-" : ":") + keep;
                        if (disc > 0) {
                            str = str + ":" + disc;
                        }
                        if (keep == 0) {
                            str = "" + revOr[0];
                        }
                        if (this.or <= 0) break block6;
                        str = "(" + str + ")|" + revOr[0];
                    }
                }
                return str;
            }
            return null;
        }

        private String lsbEvaluate() {
            if (this.and == 0) {
                return "" + this.or;
            }
            int[] revAnd = new int[4];
            int[] revOr = new int[4];
            JP2Analyzer.this.reverseByte(this.and, revAnd);
            JP2Analyzer.this.reverseByte(this.or, revOr);
            int num = 0;
            String str = "";
            if (revAnd[1] == revAnd[3] - revAnd[2] + 1) {
                block8: {
                    try {
                        num = Integer.parseInt(this.var);
                        num <<= this.shift;
                        num &= this.and;
                        str = str + (num |= this.or);
                    }
                    catch (NumberFormatException nex) {
                        if (revAnd[3] < 7) {
                            str = str + (int)Math.pow(2.0, 7 - revAnd[3]) + "*";
                        }
                        str = str + this.var;
                        int disc = 7 - revAnd[3] - this.shift;
                        if (revAnd[1] < 8) {
                            str = str + ":" + (revAnd[1] - (disc < 0 ? -disc : 0));
                            if (disc > 0) {
                                str = str + ":" + disc;
                            }
                        }
                        if (this.or <= 0) break block8;
                        if (revAnd[1] < 8) {
                            str = "(" + str + ")";
                        }
                        str = str + "|" + this.or;
                    }
                }
                return str;
            }
            return null;
        }

        public String evaluate(boolean msb) {
            return msb ? this.msbEvaluate() : this.lsbEvaluate();
        }

        public Value clone() {
            return new Value(this.var, this.shift, this.and, this.or);
        }
    }
}

