/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.CellEditorModel;
import com.hifiremote.jp1.JP1Frame;
import com.hifiremote.jp1.JP1TableModel;
import com.hifiremote.jp1.TableSorter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class JTableX
extends JTable {
    protected CellEditorModel cellModel;
    private static Border pad = BorderFactory.createEmptyBorder(0, 3, 0, 3);

    public JTableX() {
        this.cellModel = null;
    }

    public JTableX(TableModel tm) {
        super(tm);
        this.cellModel = null;
    }

    public JTableX(TableModel tm, TableColumnModel cm) {
        super(tm, cm);
        this.cellModel = null;
    }

    public JTableX(TableModel tm, TableColumnModel cm, ListSelectionModel sm) {
        super(tm, cm, sm);
        this.cellModel = null;
    }

    public JTableX(int rows, int cols) {
        super(rows, cols);
        this.cellModel = null;
    }

    public JTableX(Vector rowData, Vector<String> columnNames) {
        super(rowData, columnNames);
        this.cellModel = null;
    }

    public JTableX(Object[][] rowData, Object[] colNames) {
        super(rowData, colNames);
        this.cellModel = null;
    }

    public JTableX(TableModel tm, CellEditorModel cellModel) {
        super(tm, null, null);
        this.cellModel = cellModel;
    }

    public void setCellEditorModel(CellEditorModel cellModel) {
        this.cellModel = cellModel;
    }

    public CellEditorModel getCellEditorModel() {
        return this.cellModel;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int col) {
        TableCellEditor tmpEditor = null;
        if (this.cellModel != null) {
            tmpEditor = this.cellModel.getCellEditor(row, col);
        }
        if (tmpEditor != null) {
            return tmpEditor;
        }
        return super.getCellEditor(row, col);
    }

    private boolean isTruncated(int row, int col) {
        try {
            Object o = this.getValueAt(row, col);
            if (o == null) {
                return false;
            }
            Rectangle rect = this.getCellRect(row, col, true);
            DefaultTableCellRenderer r = (DefaultTableCellRenderer)this.getCellRenderer(row, col);
            Component c = r.getTableCellRendererComponent(this, o, false, false, row, col);
            Dimension d = c.getPreferredSize();
            return d.width >= rect.width - 4;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        JP1TableModel model;
        String rc;
        Point p = e.getPoint();
        int row = this.rowAtPoint(p);
        int col = this.columnAtPoint(p);
        if (row < 0 || col < 0) {
            return null;
        }
        col = this.convertColumnIndexToModel(col);
        TableModel tm = null;
        TableSorter sorter = null;
        if (this.dataModel != null && this.dataModel instanceof TableSorter && (tm = (sorter = (TableSorter)this.dataModel).getTableModel()) != null && tm instanceof JP1TableModel ? (rc = (model = (JP1TableModel)tm).getToolTipText(sorter.modelIndex(row), col)) != null : this.dataModel != null && this.dataModel instanceof JP1TableModel && (rc = (model = (JP1TableModel)this.dataModel).getToolTipText(row, col)) != null) {
            return rc;
        }
        if (this.isTruncated(row, col)) {
            DefaultTableCellRenderer r = (DefaultTableCellRenderer)this.getCellRenderer(row, col);
            int width = this.getColumnModel().getColumn(col).getWidth() - 6;
            String rc2 = "<html><p width=\"" + width + "px\">" + r.getText() + "</p></html>";
            JLabel lbl = new JLabel(rc2);
            int jWidth = lbl.getPreferredSize().width;
            width = width * width / jWidth - 1;
            rc2 = "<html><p width=\"" + width + "px\">" + r.getText() + "</p></html>";
            return rc2;
        }
        return null;
    }

    public static String getHtmlToolTip(String str) {
        JLabel lbl = new JLabel("<html>" + str + "</html>");
        int width = lbl.getPreferredSize().width - 6;
        return "<html><p width=\"" + width + "px\">" + str + "</p></html>";
    }

    public int getToolTipHeight(MouseEvent e) {
        String text = this.getToolTipText(e);
        if (text != null) {
            Font font = null;
            try {
                font = (Font)UIManager.get("ToolTip.font");
            }
            catch (Exception exception) {
                // empty catch block
            }
            JLabel lbl = new JLabel(text);
            if (font != null) {
                lbl.setFont(font);
            }
            return lbl.getPreferredSize().height;
        }
        return 0;
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        int row = this.rowAtPoint(event.getPoint());
        int col = this.columnAtPoint(event.getPoint());
        col = this.convertColumnIndexToModel(col);
        Point rc = this.getCellRect(row, col, true).getLocation();
        rc.translate(-1, -1);
        return rc;
    }

    @Override
    public Component prepareRenderer(TableCellRenderer r, int row, int col) {
        JComponent c = (JComponent)super.prepareRenderer(r, row, col);
        Border b = c.getBorder();
        if (b != null) {
            c.setBorder(pad);
        } else {
            c.setBorder(BorderFactory.createCompoundBorder(b, pad));
        }
        return c;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        JP1Frame.clearMessage(this);
        try {
            super.setValueAt(value, row, col);
        }
        catch (Exception except) {
            JP1Frame.showMessage(except.getMessage(), this);
            except.printStackTrace(System.err);
            this.changeSelection(row, col, false, false);
        }
    }

    public void setColumnWidth(int col, String text, boolean setMax) {
        this.setColumnWidth(col, text, setMax, 0);
    }

    public void setColumnWidth(int col, String text, boolean setMax, int limit) {
        JLabel l = (JLabel)this.tableHeader.getDefaultRenderer().getTableCellRendererComponent(this, text, false, false, 0, col);
        int width = l.getPreferredSize().width + 4;
        TableColumn column = this.columnModel.getColumn(col);
        column.setMinWidth(width / 2);
        column.setPreferredWidth(width);
        if (setMax) {
            column.setMaxWidth(width * 3 / 2);
        } else if (limit != 0) {
            column.setMaxWidth(width * limit);
        }
    }

    public void setLongToolTipTimeout() {
        this.addMouseListener(new ToolTipAdapter(this));
    }

    public static class ToolTipAdapter
    extends MouseAdapter {
        final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
        int defaultInitialDelay = 0;
        final int newDismissTimeout = 300000;
        JTableX table = null;

        public ToolTipAdapter(JTableX table) {
            this.table = table;
        }

        @Override
        public void mouseEntered(MouseEvent me) {
            ToolTipManager tm = ToolTipManager.sharedInstance();
            this.defaultInitialDelay = tm.getInitialDelay();
            tm.setDismissDelay(300000);
            tm.setInitialDelay(0);
        }

        @Override
        public void mouseExited(MouseEvent me) {
            Point p = me.getPoint();
            ToolTipManager tm = ToolTipManager.sharedInstance();
            Rectangle visRect = this.table.getVisibleRect();
            if (!visRect.contains(p)) {
                MouseEvent mev;
                int delta;
                Point pdelta = p;
                for (delta = 0; delta < 50; ++delta) {
                    pdelta = new Point(p.x, p.y - delta);
                    if (this.table.rowAtPoint(pdelta) >= 0) {
                        p = pdelta;
                        break;
                    }
                    pdelta = new Point(p.x, p.y + delta);
                    if (this.table.rowAtPoint(pdelta) < 0) continue;
                    p = pdelta;
                    break;
                }
                if (delta < 50 && this.table.columnAtPoint(p) >= 0 && this.table.getToolTipText(mev = new MouseEvent(this.table, 500, System.currentTimeMillis(), 0, p.x, p.y, 1, false)) != null) {
                    tm.setDismissDelay(0);
                    tm.mouseMoved(mev);
                }
            } else {
                int row = this.table.rowAtPoint(p);
                int col = this.table.columnAtPoint(p);
                MouseEvent mev = new MouseEvent(this.table, 500, System.currentTimeMillis(), 0, p.x, p.y, 1, false);
                int tipHeight = this.table.getToolTipHeight(mev);
                Rectangle cellRect = this.table.getCellRect(row, col, true);
                Point bottom = new Point(p.x, visRect.y + visRect.height);
                if (this.table.rowAtPoint(bottom) >= 0 && tipHeight > 0 && cellRect.y + tipHeight + 5 > visRect.y + visRect.height) {
                    tm.setDismissDelay(this.defaultDismissTimeout);
                    tm.mouseMoved(mev);
                }
            }
            tm.setDismissDelay(this.defaultDismissTimeout);
            tm.setInitialDelay(this.defaultInitialDelay);
        }
    }
}

