/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.Remote;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class KeyChooser
extends JDialog
implements ActionListener {
    private static KeyChooser dialog;
    private static Integer value;
    private JComboBox buttonBox = new JComboBox();
    private JCheckBox shiftBox = new JCheckBox();
    private JCheckBox xShiftBox = new JCheckBox();
    private Button[] availableButtons = null;
    private JLabel label = null;
    private Remote remote = null;
    private int type = Button.MOVE_BIND;

    public static Integer showDialog(Component locationComp, Remote remote, Integer initialKeyCode, int type, Button extra) {
        return KeyChooser.showDialog(locationComp, remote, initialKeyCode, type, extra, null, null);
    }

    public static Integer showDialog(Component locationComp, Remote remote, Integer initialKeyCode, int type, Button extra, String title, String label) {
        if (dialog == null) {
            dialog = new KeyChooser(locationComp);
            if (title != null) {
                dialog.setTitle(title);
            }
            if (label != null) {
                dialog.setLabel(label);
            }
        }
        dialog.setRemote(remote, type, extra);
        dialog.setKeyCode(initialKeyCode);
        dialog.setLocationRelativeTo(locationComp);
        dialog.setVisible(true);
        dialog = null;
        return value;
    }

    private KeyChooser(Component c) {
        super((JFrame)SwingUtilities.getRoot(c));
        this.setTitle("Key Chooser");
        this.setModal(true);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(this);
        JButton setButton = new JButton("Set");
        setButton.setActionCommand("Set");
        setButton.addActionListener(this);
        this.getRootPane().setDefaultButton(setButton);
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().registerKeyboardAction(this, stroke, 2);
        JPanel panel = new JPanel();
        this.label = new JLabel("Key:");
        panel.add(this.label);
        panel.add(this.buttonBox);
        panel.add(this.shiftBox);
        panel.add(this.xShiftBox);
        this.buttonBox.addActionListener(this);
        this.shiftBox.addActionListener(this);
        this.xShiftBox.addActionListener(this);
        JPanel buttonPanel = new JPanel(new FlowLayout(4));
        buttonPanel.add(setButton);
        buttonPanel.add(cancelButton);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)panel, "North");
        contentPane.add((Component)buttonPanel, "Last");
        this.pack();
    }

    private void setRemote(Remote remote, int type, Button extra) {
        this.remote = remote;
        this.type = type;
        if (type == Button.MACRO_BIND) {
            this.availableButtons = remote.getMacroButtons();
        } else if (type == Button.LEARN_BIND) {
            this.availableButtons = remote.getLearnButtons();
        } else if (type >= 0) {
            this.availableButtons = remote.getBaseUpgradeButtons();
        } else {
            this.availableButtons = new Button[1 - type];
            for (int i = 0; i <= -type; ++i) {
                this.availableButtons[i] = remote.getButton("" + i);
            }
        }
        if (extra != null) {
            Button[] useButtons = new Button[this.availableButtons.length + 1];
            useButtons[0] = extra;
            for (int i = 0; i < this.availableButtons.length; ++i) {
                useButtons[i + 1] = this.availableButtons[i];
            }
            this.availableButtons = useButtons;
        }
        this.buttonBox.setModel(new DefaultComboBoxModel<Button>(this.availableButtons));
        this.shiftBox.setText(remote.getShiftLabel());
        this.shiftBox.setVisible(type >= 0 && remote.getShiftEnabled());
        this.xShiftBox.setText(remote.getXShiftLabel());
        this.xShiftBox.setVisible(type >= 0 && remote.getXShiftEnabled());
        this.pack();
    }

    private void setLabel(String text) {
        this.label.setText(text);
    }

    public Integer getKeyCode() {
        Button b = (Button)this.buttonBox.getSelectedItem();
        int code = b.getKeyCode();
        if (this.shiftBox.isSelected()) {
            code |= this.remote.getShiftMask();
        } else if (this.xShiftBox.isSelected()) {
            code |= this.remote.getXShiftMask();
        }
        return new Integer(code);
    }

    public void setKeyCode(Integer keyCode) {
        value = keyCode;
        int code = keyCode;
        Button b = this.remote.getButton(code);
        if (!Arrays.asList(this.availableButtons).contains(b)) {
            b = null;
        }
        this.shiftBox.setSelected(false);
        this.xShiftBox.setSelected(false);
        if (b == null) {
            int base = code & 0x3F;
            if (base != 0) {
                b = this.remote.getButton(base);
                if ((base | this.remote.getShiftMask()) == code) {
                    this.shiftBox.setSelected(true);
                }
                if ((base | this.remote.getXShiftMask()) == code) {
                    this.xShiftBox.setSelected(true);
                }
            } else {
                b = this.remote.getButton(code & ~this.remote.getShiftMask());
                if (b != null) {
                    this.shiftBox.setSelected(true);
                } else {
                    b = this.remote.getButton(code ^ ~this.remote.getXShiftMask());
                    if (b != null) {
                        this.xShiftBox.setSelected(true);
                    }
                }
            }
        }
        if (b != Button.noButton) {
            this.shiftBox.setEnabled(b.allowsShiftedKeyMove());
            this.xShiftBox.setEnabled(b.allowsXShiftedKeyMove());
            if (b.getIsXShifted()) {
                this.xShiftBox.setSelected(true);
            } else if (b.getIsShifted()) {
                this.shiftBox.setSelected(true);
            }
        }
        this.buttonBox.removeActionListener(this);
        this.buttonBox.setSelectedItem(b);
        this.buttonBox.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.buttonBox) {
            Button b = (Button)this.buttonBox.getSelectedItem();
            if (this.type >= 0) {
                b.setShiftBoxes(this.type, this.shiftBox, this.xShiftBox);
            }
        } else if (source == this.shiftBox) {
            if (this.shiftBox.isSelected()) {
                this.xShiftBox.setSelected(false);
            }
        } else if (source == this.xShiftBox) {
            if (this.xShiftBox.isSelected()) {
                this.shiftBox.setSelected(false);
            }
        } else {
            value = "Set".equals(e.getActionCommand()) ? this.getKeyCode() : null;
            this.setVisible(false);
        }
    }
}

