/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.KeyChooser;
import com.hifiremote.jp1.Remote;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class KeyEditor
extends DefaultCellEditor
implements TableCellEditor,
ActionListener {
    JButton button;
    protected static final String EDIT = "edit";
    private Remote remote;
    private Integer keyCode;
    private int type = Button.MOVE_BIND;

    public KeyEditor() {
        super(new JTextField());
        this.setClickCountToStart(2);
        this.button = new JButton();
        this.button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.button.setHorizontalAlignment(10);
        this.button.setActionCommand(EDIT);
        this.button.addActionListener(this);
        this.button.setBorderPainted(false);
    }

    public void setRemote(Remote remote) {
        this.remote = remote;
        this.type = Button.MOVE_BIND;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (EDIT.equals(e.getActionCommand())) {
            Integer result = KeyChooser.showDialog(this.button, this.remote, this.keyCode, this.type, null);
            if (result != null && !result.equals(this.keyCode)) {
                this.keyCode = result;
                this.fireEditingStopped();
            } else {
                this.fireEditingCanceled();
            }
        }
    }

    public void setType(int type) {
        this.type = type;
    }

    @Override
    public Object getCellEditorValue() {
        return this.keyCode;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.keyCode = (Integer)value;
        if (this.keyCode == null) {
            this.keyCode = this.remote.getButtons().get(0).getKeyCode();
        }
        this.button.setText(this.remote.getButtonName(this.keyCode));
        return this.button;
    }
}

