/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.AssemblerItem;
import com.hifiremote.jp1.BinaryUpgradeReader;
import com.hifiremote.jp1.BinaryUpgradeWriter;
import com.hifiremote.jp1.ChoiceArea;
import com.hifiremote.jp1.CodeSelectorDialog;
import com.hifiremote.jp1.CustomNameDialog;
import com.hifiremote.jp1.DeviceEditorPanel;
import com.hifiremote.jp1.DeviceType;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.DeviceUpgradeConverter;
import com.hifiremote.jp1.DeviceUpgradeExporter;
import com.hifiremote.jp1.EndingFileFilter;
import com.hifiremote.jp1.ExternalSignal;
import com.hifiremote.jp1.GeneralSignal;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.ImportRawUpgradeDialog;
import com.hifiremote.jp1.JP1Frame;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.KMPanel;
import com.hifiremote.jp1.LearnedSignal;
import com.hifiremote.jp1.ManualProtocol;
import com.hifiremote.jp1.ManualSettingsDialog;
import com.hifiremote.jp1.ManualSettingsPanel;
import com.hifiremote.jp1.PreferredRemoteDialog;
import com.hifiremote.jp1.PropertyFile;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.ProtocolManager;
import com.hifiremote.jp1.RMDirectoryChooser;
import com.hifiremote.jp1.RMFileChooser;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.RMTablePanel;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteManager;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.TablePanel;
import com.hifiremote.jp1.TextFileViewer;
import com.hifiremote.jp1.TextPopupMenu;
import com.hifiremote.jp1.UpdateChecker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class KeyMapMaster
extends JP1Frame
implements ActionListener,
PropertyChangeListener {
    private static KeyMapMaster me = null;
    private DeviceEditorPanel editorPanel = null;
    private JMenuItem newItem = null;
    private JMenuItem openItem = null;
    protected JMenuItem saveItem = null;
    protected JMenuItem saveAsItem = null;
    private JMenuItem importFromClipboardItem = null;
    private JMenuItem importFromSetupExtractItem = null;
    private JMenuItem importFromCSVItem = null;
    private JMenuItem exportItem = null;
    private JMenu recentFileMenu = null;
    private JMenuItem exitItem = null;
    private JCheckBoxMenuItem enablePreserveSelection = null;
    private JCheckBoxMenuItem showSlingboxProtocols = null;
    private JMenuItem editManualItem = null;
    private JMenuItem newManualItem = null;
    private JMenuItem rawItem = null;
    private JMenuItem binaryItem = null;
    private JMenuItem openRdfItem = null;
    private JMenuItem writeBinaryItem = null;
    private JMenuItem updateItem = null;
    private JMenuItem readmeItem = null;
    private JMenuItem rmpbReadmeItem = null;
    private JMenuItem learnedSignalItem = null;
    private JMenuItem tutorialItem = null;
    private JMenuItem homePageItem = null;
    private JMenuItem forumItem = null;
    private JMenuItem wikiItem = null;
    private JMenuItem aboutItem = null;
    private JMenuItem separateSaveFolderItem = null;
    private ActionEvent lfEvent = null;
    private float fontAdjustment = 0.0f;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JLabel messageLabel = null;
    private ProtocolManager protocolManager = ProtocolManager.getProtocolManager();
    private DeviceUpgrade deviceUpgrade = null;
    private Remote remote = null;
    private File file = null;
    private File extractDir = null;
    private String extractSignature = null;
    private static File homeDirectory = null;
    private static String upgradeExtension = ".rmdu";
    public static RMIRSetup.RMCheckBoxMenuItem suppressConfirmPrompts = null;
    private List<AssemblerItem> clipBoardItems = new ArrayList<AssemblerItem>();
    public static final int ACTION_EXIT = 1;
    public static final int ACTION_LOAD = 2;
    private JRadioButtonMenuItem[] lookAndFeelItems = null;
    private JRadioButtonMenuItem[] promptButtons = null;
    private JMenuItem useAllRemotes = null;
    private JMenuItem usePreferredRemotes = null;
    private Float fontSizeAdjustment = Float.valueOf(0.0f);
    private static final String[] promptStrings = new String[]{"Always", "On Exit", "Never"};
    private static final int[] promptMnemonics = new int[]{65, 88, 78};
    public static final int PROMPT_NEVER = 2;
    public static final int PROMPT_ALWAYS = 0;
    private static final String[] anyEndings = new String[]{".txt", ".km", ".girr", ".ict", upgradeExtension};
    private static final String[] kmEndings = new String[]{".txt"};
    private static final String[] rmEndings = new String[]{".km", upgradeExtension};
    private static final String[] binaryEndings = new String[]{".bin", "_obj"};

    public KeyMapMaster(PropertyFile prefs) {
        super("RMDU", prefs);
        RemoteMaster.frame = this;
        System.err.println("KeyMapMaster opening");
        me = this;
        this.setDefaultCloseOperation(0);
        homeDirectory = RemoteMaster.getWorkDir();
        ProtocolManager.getProtocolManager().loadAltPIDRemoteProperties(properties);
        this.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosing(WindowEvent event) {
                boolean doDispose = true;
                try {
                    System.err.println("KeyMapMaster.windowClosing() entered");
                    if (!KeyMapMaster.this.promptToSaveUpgrade(1)) {
                        doDispose = false;
                        return;
                    }
                    System.err.println("KeyMapMaster.windowClosing() continuing");
                    ProtocolManager.getProtocolManager().setAltPIDRemoteProperties(JP1Frame.properties);
                    Remote remote = KeyMapMaster.getRemote();
                    if (remote != null) {
                        JP1Frame.preferences.setLastRemoteName(remote.getName());
                        JP1Frame.preferences.setLastRemoteSignature(remote.getSignature());
                    }
                    JP1Frame.properties.removePropertyChangeListener("enablePreserveSelection", me);
                    JP1Frame.properties.removePropertyChangeListener("ShowSlingboxProtocols", me);
                    KeyMapMaster.this.savePreferences();
                    me = null;
                }
                catch (Exception e) {
                    System.err.println("KeyMapMaster.windowClosing() caught an exception!");
                    e.printStackTrace(System.err);
                }
                finally {
                    if (doDispose) {
                        KeyMapMaster.this.dispose();
                        if (RemoteManager.getRemoteManager().isFilesSet()) {
                            System.exit(128);
                        }
                    }
                }
            }
        });
        File extractFile = new File(homeDirectory, "Extracts");
        if (extractFile.exists() && extractFile.isDirectory()) {
            this.extractDir = extractFile;
        }
        this.createMenus();
        preferences.load(this.recentFileMenu, "RecentUpgrades", this);
        LearnedSignal.getTmDecoder();
        this.deviceUpgrade = new DeviceUpgrade(this.getCustomNames());
        Remote r = null;
        String name = preferences.getLastRemoteName();
        RemoteManager rm = RemoteManager.getRemoteManager();
        if (name != null) {
            r = rm.findRemoteByName(name);
        }
        if (r == null) {
            r = this.getRemotes().iterator().next();
        }
        Protocol protocol = this.protocolManager.getProtocolsForRemote(r).get(0);
        this.deviceUpgrade.setProtocol(protocol);
        this.deviceUpgrade.setRemote(r);
        this.deviceUpgrade.setBaseline();
        this.editorPanel = new DeviceEditorPanel(this, this.deviceUpgrade, this.getRemotes());
        this.add((Component)this.editorPanel, "Center");
        this.editorPanel.addPropertyChangeListener(this, "remote");
        this.messageLabel = new JLabel(" ");
        this.messageLabel.setForeground(Color.RED);
        this.add((Component)this.messageLabel, "South");
        this.fontSizeAdjustment = Float.valueOf(preferences.getFontSizeAdjustment());
        this.adjustFontSize(this.fontSizeAdjustment.floatValue());
        this.pack();
        this.editorPanel.setAltPIDReason();
        Rectangle bounds = preferences.getBounds();
        if (bounds != null) {
            this.setBounds(bounds);
        }
        this.setVisible(true);
    }

    private void createMenus() {
        JMenuItem item;
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        this.newItem = new JMenuItem("New");
        this.newItem.setMnemonic(78);
        this.newItem.addActionListener(this);
        menu.add(this.newItem);
        this.openItem = new JMenuItem("Open...");
        this.openItem.setMnemonic(79);
        this.openItem.addActionListener(this);
        menu.add(this.openItem);
        this.saveItem = new JMenuItem("Save");
        this.saveItem.setMnemonic(83);
        this.saveItem.setEnabled(false);
        this.saveItem.addActionListener(this);
        menu.add(this.saveItem);
        this.saveAsItem = new JMenuItem("Save as...");
        this.saveAsItem.setMnemonic(65);
        this.saveAsItem.setDisplayedMnemonicIndex(5);
        this.saveAsItem.addActionListener(this);
        menu.add(this.saveAsItem);
        menu.addSeparator();
        this.importFromClipboardItem = new JMenuItem("Import from Clipboard");
        this.importFromClipboardItem.setMnemonic(67);
        this.importFromClipboardItem.addActionListener(this);
        menu.add(this.importFromClipboardItem);
        this.importFromSetupExtractItem = new JMenuItem("Import from Extract...");
        this.importFromSetupExtractItem.setMnemonic(88);
        this.importFromSetupExtractItem.addActionListener(this);
        this.importFromSetupExtractItem.setVisible(this.extractDir != null);
        menu.add(this.importFromSetupExtractItem);
        this.importFromCSVItem = new JMenuItem("Import from CSV...");
        this.importFromCSVItem.setMnemonic(86);
        this.importFromCSVItem.addActionListener(this);
        this.importFromCSVItem.setVisible(this.extractDir != null);
        menu.add(this.importFromCSVItem);
        this.exportItem = new JMenuItem("Export as Girr or IRScope file...");
        this.exportItem.setMnemonic(69);
        this.exportItem.addActionListener(this);
        menu.add(this.exportItem);
        menu.addSeparator();
        this.recentFileMenu = new JMenu("Recent");
        this.recentFileMenu.setMnemonic(82);
        this.recentFileMenu.setEnabled(false);
        menu.add(this.recentFileMenu);
        menu.addSeparator();
        this.exitItem = new JMenuItem("Exit");
        this.exitItem.setMnemonic(88);
        this.exitItem.addActionListener(this);
        menu.add(this.exitItem);
        menu = new JMenu("Options");
        menu.setMnemonic(79);
        menuBar.add(menu);
        JMenu submenu = new JMenu("Look and Feel");
        submenu.setMnemonic(76);
        menu.add(submenu);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyMapMaster.this.lfEvent = e;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String title = "Look and Feel";
                            String message = "Due to a bug in Java, you may find it necessary to close and then re-open RMIR\nfor it to work properly after a change of Look and Feel.  Moreover, you may need\nto use the menu item File > Exit to close it.  To abort the change press Cancel,\notherwise press OK to continue.";
                            if (JOptionPane.showConfirmDialog(KeyMapMaster.this, message, title, 2, 1) == 2) {
                                String lf = UIManager.getLookAndFeel().getName();
                                for (JRadioButtonMenuItem item : KeyMapMaster.this.lookAndFeelItems) {
                                    if (!item.getText().equals(lf)) continue;
                                    item.setSelected(true);
                                    break;
                                }
                                return;
                            }
                            JRadioButtonMenuItem item = (JRadioButtonMenuItem)KeyMapMaster.this.lfEvent.getSource();
                            String lf = item.getActionCommand();
                            UIManager.setLookAndFeel(lf);
                            JP1Frame.preferences.setLookAndFeel(lf);
                            SwingUtilities.updateComponentTreeUI(me);
                            JP1Frame.preferences.setLookAndFeel(lf);
                        }
                        catch (Exception x) {
                            x.printStackTrace(System.err);
                        }
                    }
                });
            }
        };
        ButtonGroup group = new ButtonGroup();
        String lookAndFeel = UIManager.getLookAndFeel().getClass().getName();
        UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
        this.lookAndFeelItems = new JRadioButtonMenuItem[info.length];
        for (int i = 0; i < info.length; ++i) {
            JRadioButtonMenuItem item2;
            this.lookAndFeelItems[i] = item2 = new JRadioButtonMenuItem(info[i].getName());
            item2.setMnemonic(item2.getText().charAt(0));
            item2.setActionCommand(info[i].getClassName());
            group.add(item2);
            submenu.add(item2);
            if (item2.getActionCommand().equals(lookAndFeel)) {
                item2.setSelected(true);
            }
            item2.addActionListener(al);
        }
        submenu = new JMenu("Font size");
        submenu.setMnemonic(70);
        menu.add(submenu);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem button = (JMenuItem)e.getSource();
                float adjustment = Float.parseFloat(button.getActionCommand());
                KeyMapMaster.this.adjustFontSize(adjustment);
                KeyMapMaster.this.fontSizeAdjustment = Float.valueOf(KeyMapMaster.this.fontSizeAdjustment.floatValue() + adjustment);
            }
        };
        JMenuItem menuItem = new JMenuItem("Increase");
        menuItem.setMnemonic(73);
        submenu.add(menuItem);
        menuItem.addActionListener(al);
        menuItem.setActionCommand("1f");
        menuItem = new JMenuItem("Decrease");
        menuItem.setMnemonic(73);
        submenu.add(menuItem);
        menuItem.addActionListener(al);
        menuItem.setActionCommand("-1f");
        group = new ButtonGroup();
        submenu = new JMenu("Prompt to Save");
        submenu.setMnemonic(80);
        menu.add(submenu);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                for (int i = 0; i < KeyMapMaster.this.promptButtons.length; ++i) {
                    if (KeyMapMaster.this.promptButtons[i] != source) continue;
                    JP1Frame.preferences.setPromptToSave(promptStrings[i]);
                    break;
                }
            }
        };
        String promptText = preferences.getPromptToSave();
        this.promptButtons = new JRadioButtonMenuItem[promptStrings.length];
        for (int i = 0; i < promptStrings.length; ++i) {
            item = new JRadioButtonMenuItem(promptStrings[i]);
            item.setMnemonic(promptMnemonics[i]);
            this.promptButtons[i] = item;
            if (promptStrings[i].equals(promptText)) {
                item.setSelected(true);
            }
            item.addActionListener(al);
            group.add(item);
            submenu.add(item);
        }
        submenu = new JMenu("Remotes");
        submenu.setMnemonic(82);
        menu.add(submenu);
        group = new ButtonGroup();
        this.useAllRemotes = new JRadioButtonMenuItem("All");
        this.useAllRemotes.setMnemonic(65);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (source == KeyMapMaster.this.useAllRemotes) {
                    KeyMapMaster.this.editorPanel.setRemotes(RemoteManager.getRemoteManager().getRemotes());
                    JP1Frame.preferences.setShowRemotes("All");
                } else if (source == KeyMapMaster.this.usePreferredRemotes) {
                    KeyMapMaster.this.editorPanel.setRemotes(JP1Frame.preferences.getPreferredRemotes());
                    JP1Frame.preferences.setShowRemotes("Preferred");
                } else {
                    KeyMapMaster.this.editPreferredRemotes();
                }
            }
        };
        this.useAllRemotes.setSelected(true);
        group.add(this.useAllRemotes);
        submenu.add(this.useAllRemotes);
        this.usePreferredRemotes = new JRadioButtonMenuItem("Preferred");
        this.usePreferredRemotes.setMnemonic(80);
        group.add(this.usePreferredRemotes);
        submenu.add(this.usePreferredRemotes);
        String temp = preferences.getShowRemotes();
        if (temp.equals("All")) {
            this.useAllRemotes.setSelected(true);
        } else {
            this.usePreferredRemotes.setSelected(true);
        }
        if (preferences.getPreferredRemotes().size() == 0) {
            this.useAllRemotes.setSelected(true);
            this.usePreferredRemotes.setEnabled(false);
        }
        this.useAllRemotes.addActionListener(al);
        this.usePreferredRemotes.addActionListener(al);
        submenu.addSeparator();
        item = new JMenuItem("Edit preferred...");
        item.setMnemonic(69);
        item.addActionListener(al);
        submenu.add(item);
        KeyMapMaster.createFunctionNamesMenus(menu);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem checkItem = (JCheckBoxMenuItem)e.getSource();
                boolean state = checkItem.getState();
                JP1Frame.preferences.setShowRemoteSignature(state);
                KeyMapMaster.this.editorPanel.setShowRemoteSignature(state);
            }
        };
        JCheckBoxMenuItem checkItem = new JCheckBoxMenuItem("Show remote signature");
        checkItem.setMnemonic(83);
        checkItem.setState(preferences.getShowRemoteSignature());
        checkItem.addActionListener(al);
        menu.add(checkItem);
        submenu = new JMenu("Folders");
        menu.add(submenu);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = e.getActionCommand();
                String extension = name == "RDF" ? ".rdf" : ".map";
                File path = JP1Frame.properties.getFileProperty(name + "Path");
                RMDirectoryChooser chooser = new RMDirectoryChooser(path, extension, name);
                chooser.setAccessory(new ChoiceArea(chooser));
                chooser.setDialogTitle("Choose the directory containing the " + name + "s");
                int returnVal = chooser.showDialog(me, "OK");
                if (returnVal == 0) {
                    File newPath = chooser.getSelectedFile();
                    JP1Frame.properties.setProperty(name + "Path", newPath);
                    RemoteManager mgr = RemoteManager.getRemoteManager();
                    mgr.reset();
                    mgr.loadRemotes(JP1Frame.properties);
                    if (KeyMapMaster.this.useAllRemotes.isSelected()) {
                        KeyMapMaster.this.editorPanel.setRemotes(RemoteManager.getRemoteManager().getRemotes());
                    }
                }
            }
        };
        menuItem = new JMenuItem("RDF Folder...");
        menuItem.setMnemonic(82);
        menuItem.setActionCommand("RDF");
        menuItem.addActionListener(al);
        submenu.add(menuItem);
        menuItem = new JMenuItem("Map Folder...");
        menuItem.setMnemonic(82);
        menuItem.setActionCommand("Image");
        menuItem.addActionListener(al);
        submenu.add(menuItem);
        this.separateSaveFolderItem = new JCheckBoxMenuItem("Separate Save folder");
        this.separateSaveFolderItem.setMnemonic(86);
        this.separateSaveFolderItem.setSelected(preferences.getSeparateSaveFolder());
        this.separateSaveFolderItem.addActionListener(this);
        this.separateSaveFolderItem.setToolTipText("Use separate default folders for loading and saving .rmdu files");
        menu.add(this.separateSaveFolderItem);
        this.enablePreserveSelection = new JCheckBoxMenuItem("Allow Preserve Control");
        this.enablePreserveSelection.setMnemonic(65);
        this.enablePreserveSelection.setSelected(Boolean.parseBoolean(properties.getProperty("enablePreserveSelection", "false")));
        this.enablePreserveSelection.addActionListener(this);
        this.enablePreserveSelection.setToolTipText(JTableX.getHtmlToolTip("Allow control of which function data is preserved when changing the protocol used in a device upgrade.<br>Do not use this unless you know what you are doing and why."));
        menu.add(this.enablePreserveSelection);
        this.showSlingboxProtocols = new JCheckBoxMenuItem("Show Slingbox protocols");
        this.showSlingboxProtocols.setMnemonic(88);
        this.showSlingboxProtocols.setSelected(Boolean.parseBoolean(properties.getProperty("ShowSlingboxProtocols", "false")));
        this.showSlingboxProtocols.addActionListener(this);
        this.showSlingboxProtocols.setToolTipText(JTableX.getHtmlToolTip("Include the no-repeat protocols that are specific to Slingbox usage.<br>Note that a change to this option only takes effect when RM or RMIR<br>is next opened."));
        menu.add(this.showSlingboxProtocols);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
                    if (item.getActionCommand().equals("SuppressDeletePrompts")) {
                        TablePanel.suppressDeletePrompts = item.isSelected();
                        RMTablePanel.suppressDeletePrompts = item.isSelected();
                    }
                }
                catch (Exception x) {
                    x.printStackTrace(System.err);
                }
            }
        };
        item = new RMIRSetup.RMCheckBoxMenuItem("Chop Ict imports at 200ms", "ChopIctImports", true);
        item.setToolTipText(JTableX.getHtmlToolTip("When an IRScope .ict file is imported, it is separated into distinct signals that are named by<br/>the Note fields entered in IRScope.  When Chop Ict is selected, gaps of more than 200ms are also<br/>treated as signal separators, following the behaviour of IRScope.  The decoder acts recursively<br/>on each separated signal and may further separate the signal into multiple decodes, as in a macro.<br/>In some instances the chopping may split a signal incorrectly and result in decode failures or errors.<br/>This option is provided to enable the chopping action to be deselected in such cases."));
        menu.add(item);
        item = new RMIRSetup.RMCheckBoxMenuItem("Ignore final 1 on dev parm names", "IgnoreFinal1", false);
        item.setToolTipText(JTableX.getHtmlToolTip("When changing protocol in a device upgrade, ignore a final 1 in device parameter names, so that<br/>for example \"Device1\" or \"Device 1\" will match \"Device\"."));
        menu.add(item);
        menu.addSeparator();
        JMenu suppressSubMenu = new JMenu("Suppress Messages");
        suppressSubMenu.setMnemonic(83);
        menu.add(suppressSubMenu);
        item = new RMIRSetup.RMCheckBoxMenuItem("All table deletes", "SuppressDeletePrompts", false);
        TablePanel.suppressDeletePrompts = item.isSelected();
        RMTablePanel.suppressDeletePrompts = item.isSelected();
        item.addActionListener(listener);
        suppressSubMenu.add(item);
        item = new RMIRSetup.RMCheckBoxMenuItem("Confirmation prompts", "SuppressConfirmPrompts", false);
        item.setToolTipText(JTableX.getHtmlToolTip("This suppresses messages asking if you want to continue, and also some information<br/>messages requiring no response"));
        suppressSubMenu.add(item);
        suppressConfirmPrompts = (RMIRSetup.RMCheckBoxMenuItem)item;
        item = new RMIRSetup.RMCheckBoxMenuItem("Import options", "SuppressImportOptions", true);
        item.setToolTipText(JTableX.getHtmlToolTip("When a device upgrade is created by importing an ict or Girr file or by conversion<br/>of learned signals, there may be more than one protocol consistent with the signals.<br/>When this option is checked, the choice is made by an RMIR algorithm, when unchecked<br/>the user is given a list to choose from.  This is checked by default."));
        suppressSubMenu.add(item);
        menu = new JMenu("Advanced");
        menu.setMnemonic(65);
        menuBar.add(menu);
        this.editManualItem = new JMenuItem("Edit Protocol...");
        this.editManualItem.setMnemonic(69);
        this.editManualItem.addActionListener(this);
        menu.add(this.editManualItem);
        this.newManualItem = new JMenuItem("New Manual Protocol...");
        this.newManualItem.setMnemonic(77);
        this.newManualItem.addActionListener(this);
        menu.add(this.newManualItem);
        menu.addSeparator();
        this.rawItem = new JMenuItem("Import Raw Upgrade...");
        this.rawItem.setMnemonic(82);
        this.rawItem.addActionListener(this);
        menu.add(this.rawItem);
        this.binaryItem = new JMenuItem("Import Binary Upgrade...");
        this.binaryItem.setMnemonic(66);
        this.binaryItem.addActionListener(this);
        menu.add(this.binaryItem);
        this.writeBinaryItem = new JMenuItem("Export Binary Upgrade...");
        this.writeBinaryItem.setEnabled(false);
        this.writeBinaryItem.setMnemonic(88);
        this.writeBinaryItem.addActionListener(this);
        menu.add(this.writeBinaryItem);
        menu.addSeparator();
        this.openRdfItem = new JMenuItem("View/Edit RDF");
        this.openRdfItem.setEnabled(true);
        this.openRdfItem.setMnemonic(82);
        this.openRdfItem.addActionListener(this);
        menu.add(this.openRdfItem);
        menu = new JMenu("Help");
        menu.setMnemonic(72);
        menuBar.add(menu);
        if (KeyMapMaster.desktopUsable()) {
            this.readmeItem = new JMenuItem("Readme", 82);
            this.readmeItem.addActionListener(this);
            menu.add(this.readmeItem);
            this.tutorialItem = new JMenuItem("Tutorial", 84);
            this.tutorialItem.addActionListener(this);
            menu.add(this.tutorialItem);
            this.rmpbReadmeItem = new JMenuItem("Using RMPB", 85);
            this.rmpbReadmeItem.addActionListener(this);
            menu.add(this.rmpbReadmeItem);
            this.learnedSignalItem = new JMenuItem("Interpreting Decoded IR Signals", 73);
            this.learnedSignalItem.addActionListener(this);
            menu.add(this.learnedSignalItem);
            menu.addSeparator();
            this.homePageItem = new JMenuItem("Home Page", 72);
            this.homePageItem.addActionListener(this);
            menu.add(this.homePageItem);
            this.forumItem = new JMenuItem("Forums", 70);
            this.forumItem.addActionListener(this);
            menu.add(this.forumItem);
            this.wikiItem = new JMenuItem("Wiki", 87);
            this.wikiItem.addActionListener(this);
            menu.add(this.wikiItem);
            menu.addSeparator();
        }
        this.updateItem = new JMenuItem("Check for updates", 67);
        this.updateItem.addActionListener(this);
        menu.add(this.updateItem);
        this.aboutItem = new JMenuItem("About...");
        this.aboutItem.setMnemonic(65);
        this.aboutItem.addActionListener(this);
        menu.add(this.aboutItem);
    }

    public DeviceEditorPanel getEditorPanel() {
        return this.editorPanel;
    }

    public static void createFunctionNamesMenus(JMenu menu) {
        JMenu submenu = new JMenu("Function names");
        submenu.setMnemonic(70);
        submenu.setToolTipText("Select the list of function names used for a new Device Upgrade");
        menu.add(submenu);
        ButtonGroup group = new ButtonGroup();
        final JRadioButtonMenuItem useEmptyNames = new JRadioButtonMenuItem("Empty");
        useEmptyNames.setMnemonic(69);
        JRadioButtonMenuItem useDefaultNames = new JRadioButtonMenuItem("Default");
        useDefaultNames.setMnemonic(68);
        final JRadioButtonMenuItem useCustomNames = new JRadioButtonMenuItem("Custom");
        useCustomNames.setMnemonic(67);
        final JMenuItem[] functionNameItems = new JMenuItem[]{useEmptyNames, useDefaultNames, useCustomNames};
        final String[] functionNameLists = new String[]{"Empty", "Default", "Custom"};
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                int index = -1;
                index = Arrays.asList(functionNameItems).indexOf(source);
                if (index >= 0) {
                    JP1Frame.preferences.setUseCustomNames(functionNameLists[index]);
                } else {
                    CustomNameDialog d = new CustomNameDialog(RemoteMaster.getFrame(), JP1Frame.preferences.getCustomNames());
                    d.setVisible(true);
                    if (d.getUserAction() == 0) {
                        String[] customNames = d.getCustomNames();
                        if (customNames == null || customNames.length == 0) {
                            useCustomNames.setEnabled(false);
                            useEmptyNames.setSelected(true);
                        } else {
                            useCustomNames.setEnabled(true);
                        }
                        JP1Frame.preferences.setCustomNames(customNames);
                    }
                }
            }
        };
        useEmptyNames.addActionListener(al);
        group.add(useEmptyNames);
        submenu.add(useEmptyNames);
        useDefaultNames.addActionListener(al);
        group.add(useDefaultNames);
        submenu.add(useDefaultNames);
        useCustomNames.addActionListener(al);
        group.add(useCustomNames);
        submenu.add(useCustomNames);
        int index = -1;
        index = Arrays.asList(functionNameLists).indexOf(preferences.getUseCustomNames());
        if (index >= 0) {
            functionNameItems[index].setSelected(true);
        }
        submenu.addSeparator();
        JMenuItem item = new JMenuItem("Edit custom names...");
        item.setMnemonic(69);
        item.addActionListener(al);
        submenu.add(item);
    }

    private void savePreferences() throws Exception {
        int state = this.getExtendedState();
        if (state != 0) {
            this.setExtendedState(0);
        }
        preferences.setBounds(this.getBounds());
        preferences.save(this.recentFileMenu, "RecentUpgrades");
    }

    private void editManualSettings() {
        Protocol p = this.deviceUpgrade.getProtocol();
        Protocol edited = p.editProtocol(KeyMapMaster.getRemote(), this);
        if (edited == null) {
            return;
        }
        if (p instanceof ManualProtocol && p != edited) {
            this.deviceUpgrade.setProtocol(edited);
        }
    }

    private void newManualSettings() {
        ManualProtocol mp = new ManualProtocol(null, null);
        ManualSettingsDialog d = new ManualSettingsDialog(this, mp);
        ManualSettingsPanel dp = d.getManualSettingsPanel();
        Remote remote = KeyMapMaster.getRemote();
        if (remote != null) {
            dp.setSelectedCode(remote.getProcessor());
            d.setMessage(0);
        }
        d.setVisible(true);
        mp = d.getProtocol();
        if (mp != null) {
            ProtocolManager.getProtocolManager().add(mp);
        }
    }

    @Override
    public void showMessage(String message) {
        this.messageLabel.setText(message);
        Toolkit.getDefaultToolkit().beep();
    }

    public static void showMessage(String message, Component c) {
        KeyMapMaster km = (KeyMapMaster)SwingUtilities.getAncestorOfClass(KeyMapMaster.class, c);
        if (km != null) {
            km.showMessage(message);
            return;
        }
        JP1Frame frame = (JP1Frame)SwingUtilities.getAncestorOfClass(JP1Frame.class, c);
        if (frame != null) {
            frame.showMessage(message);
            return;
        }
        JOptionPane.showMessageDialog(c, message);
    }

    @Override
    public void clearMessage() {
        this.messageLabel.setText(" ");
    }

    public static void clearMessage(Component c) {
        KeyMapMaster km = (KeyMapMaster)SwingUtilities.getAncestorOfClass(KeyMapMaster.class, c);
        if (km != null) {
            km.clearMessage();
            return;
        }
        JP1Frame frame = (JP1Frame)SwingUtilities.getAncestorOfClass(JP1Frame.class, c);
        if (frame != null) {
            frame.clearMessage();
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.editorPanel.commit();
            Object source = e.getSource();
            if (source == this.newItem) {
                if (!this.promptToSaveUpgrade(2)) {
                    return;
                }
                ProtocolManager.getProtocolManager().reset();
                this.deviceUpgrade.reset(this.getCustomNames());
            } else if (source == this.saveItem) {
                this.deviceUpgrade.store();
            } else if (source == this.saveAsItem) {
                this.saveAs();
            } else if (source == this.openItem) {
                if (!this.promptToSaveUpgrade(2)) {
                    return;
                }
                ProtocolManager.getProtocolManager().reset();
                File file = KeyMapMaster.getUpgradeFile(preferences.getUpgradePath(), this);
                this.loadUpgrade(file);
            } else if (source == this.importFromClipboardItem) {
                if (!this.promptToSaveUpgrade(2)) {
                    return;
                }
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable clipData = clipboard.getContents(clipboard);
                if (clipData != null) {
                    try {
                        if (clipData.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                            String s = (String)clipData.getTransferData(DataFlavor.stringFlavor);
                            BufferedReader in = new BufferedReader(new StringReader(s));
                            this.loadUpgrade(in);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(System.err);
                    }
                }
            } else if (source == this.importFromCSVItem) {
                if (!this.promptToSaveUpgrade(2)) {
                    return;
                }
                String title = "Import CSV string";
                JPanel panel = new JPanel(new FlowLayout(0, 1, 1));
                JLabel label1 = new JLabel("Enter CSV string:");
                JLabel label2 = new JLabel("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
                panel.setPreferredSize(new Dimension(label2.getPreferredSize().width, (int)((double)label1.getPreferredSize().height * 1.5)));
                panel.add(new JLabel("Enter CSV string:"));
                String csvString = JOptionPane.showInputDialog(this, panel, title, -1);
                this.loadCsvString(csvString);
            } else if (source == this.importFromSetupExtractItem) {
                if (!this.promptToSaveUpgrade(2)) {
                    return;
                }
                RMFileChooser chooser = new RMFileChooser();
                chooser.setAcceptAllFileFilterUsed(false);
                EndingFileFilter extractFilter = new EndingFileFilter("Setup Extract files (*.csv)", RemoteMaster.setupExtractEndings);
                chooser.setFileFilter(extractFilter);
                chooser.setCurrentDirectory(this.extractDir);
                int returnVal = chooser.showOpenDialog(this);
                if (returnVal != 0) {
                    return;
                }
                this.file = chooser.getSelectedFile();
                String name = this.file.getName();
                if (!this.file.exists()) {
                    JOptionPane.showMessageDialog(this, name + " doesn't exist.", "File doesn't exist.", 0);
                    return;
                }
                if (this.file.isDirectory()) {
                    JOptionPane.showMessageDialog(this, name + " is a directory.", "File doesn't exist.", 0);
                    return;
                }
                String extractName = null;
                String message = null;
                this.remote = null;
                BufferedReader rdr = new BufferedReader(new FileReader(this.file));
                String line = null;
                while ((line = rdr.readLine()) != null) {
                    String[] tokens = line.split(",");
                    if (tokens.length <= 0 || !name.startsWith(tokens[0])) continue;
                    this.extractSignature = tokens[0];
                    break;
                }
                rdr.close();
                if (this.extractSignature == null) {
                    JOptionPane.showMessageDialog(this, "Unable to identify signature from this file", "File error", 0);
                    return;
                }
                List<Remote> remotes = RemoteManager.getRemoteManager().findRemoteBySignature(this.extractSignature);
                if (remotes.size() == 0) {
                    message = "There are no remotes with signature " + this.extractSignature + ".";
                } else if (remotes.size() == 1) {
                    this.remote = remotes.get(0);
                } else {
                    extractName = name.substring(this.extractSignature.length());
                    Integer[] matchCounts = new Integer[remotes.size()];
                    String remoteName = null;
                    block7: for (int i = 0; i < remotes.size(); ++i) {
                        matchCounts[i] = 0;
                        Remote r = remotes.get(i);
                        remoteName = r.getName();
                        for (int j = remoteName.length(); j > 0; --j) {
                            String testName = remoteName.substring(0, j);
                            if (!extractName.contains(testName)) continue;
                            matchCounts[i] = j;
                            continue block7;
                        }
                    }
                    int maxMatch = -1;
                    for (int i = 0; i < remotes.size(); ++i) {
                        if (matchCounts[i] <= maxMatch) continue;
                        maxMatch = matchCounts[i];
                        this.remote = remotes.get(i);
                    }
                }
                if (this.remote == null) {
                    message = "There are no remotes with signature " + this.extractSignature + " matching the extract name.";
                }
                if (message != null) {
                    String title = "Import from Extract";
                    JOptionPane.showMessageDialog(this, message, title, 0);
                    return;
                }
                this.remote.load();
                this.remote.setExtract();
                this.remote.setExtractData();
                this.deviceUpgrade.reset();
                this.deviceUpgrade.setRemote(this.remote);
                CodeSelectorDialog.okString = null;
                CodeSelectorDialog.showDialog(this, true);
                if (CodeSelectorDialog.okString != null) {
                    System.err.println("CodeSelector " + CodeSelectorDialog.okString);
                }
            } else if (source == this.exitItem) {
                this.dispatchEvent(new WindowEvent(this, 201));
            } else if (source == this.editManualItem) {
                this.editManualSettings();
            } else if (source == this.newManualItem) {
                this.newManualSettings();
            } else if (source == this.rawItem) {
                ImportRawUpgradeDialog d = new ImportRawUpgradeDialog(this, this.deviceUpgrade, false);
                d.setVisible(true);
            } else if (source == this.binaryItem) {
                File file = null;
                RMFileChooser chooser = new RMFileChooser(preferences.getBinaryUpgradePath());
                try {
                    chooser.setAcceptAllFileFilterUsed(false);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
                chooser.setFileFilter(new EndingFileFilter("Binary upgrade files", binaryEndings));
                int returnVal = chooser.showOpenDialog(this);
                if (returnVal == 0) {
                    file = chooser.getSelectedFile();
                    if (!file.exists()) {
                        JOptionPane.showMessageDialog(this, file.getName() + " doesn't exist.", "File doesn't exist.", 0);
                    } else if (file.isDirectory()) {
                        JOptionPane.showMessageDialog(this, file.getName() + " is a directory.", "File doesn't exist.", 0);
                    } else {
                        preferences.setBinaryUpgradePath(file.getParentFile());
                        BinaryUpgradeReader reader = new BinaryUpgradeReader(file);
                        Remote r = reader.getRemote();
                        DeviceType devType = r.getDeviceTypeByIndex(reader.getDeviceIndex());
                        String aliasName = null;
                        String[] aliasNames = r.getDeviceTypeAliasNames();
                        boolean nameMatch = false;
                        for (int i = 0; i < aliasNames.length && !nameMatch; ++i) {
                            String tryit = aliasNames[i];
                            if (devType != r.getDeviceTypeByAliasName(tryit)) continue;
                            nameMatch = devType.getName().equalsIgnoreCase(tryit);
                            if (aliasName != null && !nameMatch) continue;
                            aliasName = tryit;
                        }
                        this.deviceUpgrade.importRawUpgrade(reader.getCode(), r, aliasName, reader.getPid(), reader.getProtocolCode());
                        this.deviceUpgrade.setSetupCode(reader.getSetupCode());
                    }
                }
            } else if (source == this.exportItem) {
                if (this.deviceUpgrade.getFunctionList().size() == 0) {
                    String message = "There are no functions in this upgrade, so export aborting.";
                    String title = "Export as Girr file";
                    JOptionPane.showMessageDialog(this, message, title, 0);
                    return;
                }
                DeviceUpgradeExporter exporter = new DeviceUpgradeExporter(this.deviceUpgrade);
                exporter.exportToFile();
            } else if (source == this.separateSaveFolderItem) {
                if (this.separateSaveFolderItem.isSelected()) {
                    properties.setProperty("UpgradeSaveFolder", "true");
                } else {
                    properties.remove("UpgradeSaveFolder");
                }
            } else if (source == this.enablePreserveSelection) {
                properties.setProperty("enablePreserveSelection", Boolean.toString(this.enablePreserveSelection.isSelected()));
            } else if (source == this.showSlingboxProtocols) {
                if (!this.showSlingboxProtocols.isSelected()) {
                    properties.remove("ShowSlingboxProtocols");
                } else {
                    properties.setProperty("ShowSlingboxProtocols", Boolean.toString(this.showSlingboxProtocols.isSelected()));
                }
            } else if (source == this.writeBinaryItem) {
                File path = BinaryUpgradeWriter.write(this.deviceUpgrade, preferences.getBinaryUpgradePath());
                if (path != null) {
                    preferences.setBinaryUpgradePath(path);
                }
            } else if (source == this.openRdfItem) {
                Remote remote = (Remote)this.editorPanel.getRemoteList().getSelectedItem();
                TextFileViewer.showFile(this, remote, "View/Edit RDF", false);
            } else if (source == this.updateItem) {
                UpdateChecker.checkUpdateAvailable(this);
            } else if (source == this.readmeItem) {
                File readme = new File(RemoteMaster.getWorkDir(), "Readme.html");
                KeyMapMaster.browse(readme.toURI());
            } else if (source == this.tutorialItem) {
                URL url = new URL("http://www.hifi-remote.com/wiki/index.php?title=JP1_-_Just_How_Easy_Is_It%3F_-_RM-IR_Version");
                KeyMapMaster.browse(url);
            } else if (source == this.rmpbReadmeItem) {
                File rmpbReadme = new File(RemoteMaster.getWorkDir(), "RMPB_Readme.html");
                KeyMapMaster.browse(rmpbReadme.toURI());
            } else if (source == this.learnedSignalItem) {
                File decodeFile = new File(RemoteMaster.getWorkDir(), "DecodeIR.html");
                KeyMapMaster.browse(decodeFile.toURI());
            } else if (source == this.homePageItem) {
                URL url = new URL("https://controlremote.sourceforge.io/");
                KeyMapMaster.browse(url);
            } else if (source == this.forumItem) {
                URL url = new URL("http://www.hifi-remote.com/forums/");
                KeyMapMaster.browse(url);
            } else if (source == this.wikiItem) {
                URL url = new URL("http://www.hifi-remote.com/wiki/index.php?title=Main_Page");
                KeyMapMaster.browse(url);
            } else if (source == this.aboutItem) {
                String text = "<html><b>RM Device Upgrade Editor (RMDU), " + RemoteMaster.getDisplayVersion() + (RemoteMaster.admin ? " (admin mode)" : "") + "</b><p>Get the latest version at <a href=\"https://controlremote.sourceforge.io\">https://controlremote.sourceforge.io</a></p><p>Java version " + System.getProperty("java.version") + " from " + System.getProperty("java.vendor") + "</p><p>Home directory is <b>" + homeDirectory.getAbsolutePath() + "</b></p><p>RDFs loaded from <b>" + preferences.getRDFPath() + "</b></p><p>Written originally by Greg&nbsp;Bush with help from John&nbsp;S&nbsp;Fine, Nils&nbsp;Ekberg, Jon&nbsp;Armstrong, Robert&nbsp;Crowe, Mark&nbsp;Pauker, Mark&nbsp;Pierson and Mike&nbsp;England</p><p>Subsequently developed by Graham Dixon with help from Ross&nbsp;Day, Marcin&nbsp;Jaworski, Bengt&nbsp;Martensson and Dave&nbsp;Reed</p></html>";
                JEditorPane pane = new JEditorPane("text/html", text);
                pane.addHyperlinkListener(this);
                pane.setEditable(false);
                pane.setBackground(this.getContentPane().getBackground());
                new TextPopupMenu(pane);
                final JScrollPane scroll = new JScrollPane(pane);
                Dimension d = pane.getPreferredSize();
                d.height = d.height * 3 / 2;
                d.width = d.width * 1 / 2;
                scroll.setPreferredSize(d);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        scroll.getVerticalScrollBar().setValue(0);
                        scroll.getHorizontalScrollBar().setValue(0);
                    }
                });
                JOptionPane.showMessageDialog(this, scroll, "About RMDU", 1);
            } else if (source == this.okButton) {
                this.setVisible(false);
            } else if (source == this.cancelButton) {
                this.deviceUpgrade = null;
                this.setVisible(false);
            } else {
                JMenuItem item = (JMenuItem)source;
                File f = new File(item.getText());
                this.loadUpgrade(f);
            }
            this.refresh();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    public static void createUpgrade(DeviceUpgrade deviceUpgrade, Remote remote, DeviceEditorPanel editorPanel) {
        int mode = -1;
        int setupCodeValue = -1;
        Hex pid = null;
        Hex uHex = null;
        Hex pHex = null;
        try {
            for (String line : remote.getExtract()) {
                String[] tokens;
                int tokensLength;
                if (!line.contains(",") || (tokensLength = (tokens = line.split(",")).length) < 5 || !tokens[0].equals(remote.getExtractSignature())) continue;
                try {
                    int incr;
                    mode = Integer.parseInt(tokens[1]);
                    setupCodeValue = Integer.valueOf(tokens[2]);
                    List<Integer> noFix = Arrays.asList(5, 8, 9, 10);
                    List<Integer> hasFix = Arrays.asList(6, 11);
                    int n = hasFix.contains(tokensLength) ? 1 : (incr = noFix.contains(tokensLength) ? 0 : -1);
                    if (incr < 0) {
                        String message = "Number of tokens = " + tokensLength + " is not supported";
                        String title = "Error importing builtin setup";
                        JOptionPane.showMessageDialog(null, message, title, 0);
                        return;
                    }
                    uHex = new Hex(tokens[4 + incr]);
                    pHex = tokens.length > 9 + incr ? new Hex(tokens[9 + incr]) : null;
                }
                catch (Exception e) {
                    continue;
                }
                int setupCodeOffsetted = setupCodeValue + remote.getDeviceCodeOffset();
                String setupCodeOffsettedString = String.format("%04d", setupCodeOffsetted);
                if (mode != deviceUpgrade.getSelectedDeviceIndex() || !deviceUpgrade.getSelectedSetupCode().equals(setupCodeOffsettedString)) continue;
                DeviceType deviceType = remote.getDeviceTypeByIndex(mode);
                pid = new Hex(tokens[3]);
                String aliasName = remote.getDeviceTypeAlias(deviceType);
                deviceUpgrade.importRawUpgrade(uHex, remote, aliasName, pid, pHex);
                deviceUpgrade.setSetupCode(setupCodeOffsetted);
                deviceUpgrade.setDescription(aliasName + "/" + setupCodeOffsettedString + " import");
                if (editorPanel == null) break;
                editorPanel.setDeviceTypeName(aliasName);
                KMPanel currPanel = editorPanel.getCurrPanel();
                currPanel.update();
                break;
            }
            if (pid == null) {
                DeviceType deviceType = remote.getDeviceTypeByIndex(deviceUpgrade.getSelectedDeviceIndex());
                String aliasName = remote.getDeviceTypeAlias(deviceType);
                String setupCode = deviceUpgrade.getSelectedSetupCode();
                String title = "Import built-in setup code";
                String message = "No import available for " + aliasName + "/" + setupCode;
                JOptionPane.showMessageDialog(null, message, title, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.err.println(e.getMessage());
        }
    }

    public static void createUpgrade(CodeSelectorDialog selector, DeviceEditorPanel editorPanel) {
        Remote remote = selector.getRemote();
        DeviceUpgrade deviceUpgrade = selector.getDeviceUpgrade();
        KeyMapMaster.createUpgrade(deviceUpgrade, remote, editorPanel);
        if (selector != null) {
            selector.dispose();
            selector = null;
        }
    }

    public static File promptForUpgradeFile(File path) {
        return KeyMapMaster.getUpgradeFile(path, RemoteMaster.getFrame());
    }

    public static File getUpgradeFile(File path, Component component) {
        if (path == null) {
            path = preferences.getUpgradePath();
        }
        File file = null;
        RMFileChooser chooser = new RMFileChooser(path);
        try {
            chooser.setAcceptAllFileFilterUsed(false);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        EndingFileFilter filter = new EndingFileFilter("All device upgrade files", anyEndings);
        chooser.addChoosableFileFilter(filter);
        chooser.addChoosableFileFilter(new EndingFileFilter("KeyMapMaster device upgrade files (*.txt)", kmEndings));
        chooser.addChoosableFileFilter(new EndingFileFilter("RemoteMaster device upgrade files (*.km, *.rmdu)", rmEndings));
        chooser.addChoosableFileFilter(new EndingFileFilter("Girr files for import (*.girr)", RemoteMaster.girrEndings));
        chooser.addChoosableFileFilter(new EndingFileFilter("IRScope files for import (*.ict)", RemoteMaster.ictEndings));
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(component);
        if (returnVal == 0) {
            file = chooser.getSelectedFile();
            if (!file.exists()) {
                JOptionPane.showMessageDialog(RemoteMaster.getFrame(), file.getName() + " doesn't exist.", "File doesn't exist.", 0);
            } else if (file.isDirectory()) {
                JOptionPane.showMessageDialog(RemoteMaster.getFrame(), file.getName() + " is a directory.", "File doesn't exist.", 0);
            } else {
                preferences.setUpgradePath(file.getParentFile());
            }
        }
        return file;
    }

    public void saveAs() throws IOException {
        RMFileChooser chooser = new RMFileChooser(preferences.getUpgradeSavePath());
        chooser.setFileFilter(new EndingFileFilter("RM device upgrade files (*.rmdu)", rmEndings));
        File f = this.deviceUpgrade.getFile();
        if (f == null) {
            String fname = this.deviceUpgrade.getDescription() + upgradeExtension;
            fname = fname.replace('/', '-');
            f = new File(preferences.getUpgradeSavePath(), fname);
        }
        if (preferences.getSeparateSaveFolder()) {
            chooser.setSelectedFile(new File(preferences.getUpgradeSavePath(), f.getName()));
        } else {
            chooser.setSelectedFile(f);
        }
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            String name = chooser.getSelectedFile().getAbsolutePath();
            if (!name.toLowerCase().endsWith(upgradeExtension)) {
                name = name + upgradeExtension;
            }
            File file = new File(name);
            int rc = 0;
            if (file.exists()) {
                rc = JOptionPane.showConfirmDialog(this, file.getName() + " already exists.  Do you want to replace it?", "Replace existing file?", 0);
            }
            if (rc == 0) {
                this.deviceUpgrade.store(file);
                this.updateRecentFiles(file);
                this.saveItem.setEnabled(true);
                preferences.setUpgradeSavePath(file.getParentFile());
                this.setTitle("RMDU: " + file.getCanonicalPath());
            }
        }
    }

    public boolean promptToSaveUpgrade(int action) throws IOException {
        if (suppressConfirmPrompts.isSelected() || !this.deviceUpgrade.hasChanged()) {
            return true;
        }
        String promptFlag = preferences.getPromptToSave();
        if (promptFlag.equals(promptStrings[2])) {
            return true;
        }
        if (!promptFlag.equals(promptStrings[0]) && action != 1) {
            return true;
        }
        int rc = JOptionPane.showConfirmDialog(this, "Do you want to save the current upgrade before proceeding?", "Save upgrade?", 1);
        if (rc == 2 || rc == -1) {
            return false;
        }
        if (rc == 1) {
            return true;
        }
        if (this.deviceUpgrade.getFile() != null) {
            this.deviceUpgrade.store();
        } else {
            this.saveAs();
        }
        return true;
    }

    public void loadCsvString(String csvString) {
        String[] tokens = csvString.split(",");
        if (tokens.length < 5) {
            return;
        }
        this.extractSignature = tokens[0];
        List<Remote> remotes = RemoteManager.getRemoteManager().findRemoteBySignature(this.extractSignature);
        if (remotes.size() == 0) {
            JOptionPane.showMessageDialog(this, "There are no remotes with signature " + this.extractSignature + ".", "CSV error", 0);
            return;
        }
        try {
            this.remote = remotes.get(0);
            this.deviceUpgrade.reset();
            this.deviceUpgrade.setRemote(this.remote);
            int mode = Integer.parseInt(tokens[1]);
            DeviceType deviceType = this.remote.getDeviceTypeByIndex(mode);
            String aliasName = this.remote.getDeviceTypeAlias(deviceType);
            String setupCode = tokens[2];
            Hex pid = new Hex(tokens[3]);
            Hex uHex = new Hex(tokens[4]);
            Hex pHex = null;
            if (tokens.length > 9) {
                pHex = new Hex(tokens[9]);
            }
            this.deviceUpgrade.importRawUpgrade(uHex, this.remote, aliasName, pid, pHex);
            this.deviceUpgrade.setSetupCode(Integer.parseInt(setupCode));
            if (this.editorPanel != null) {
                this.editorPanel.setDeviceTypeName(aliasName);
                KMPanel currPanel = this.editorPanel.getCurrPanel();
                currPanel.update();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    public void loadUpgrade(File file) throws Exception {
        if (file == null || !file.exists()) {
            return;
        }
        System.err.println("Opening " + file.getCanonicalPath() + ", last modified " + DateFormat.getInstance().format(new Date(file.lastModified())));
        this.deviceUpgrade.reset();
        boolean isRMDU = RemoteMaster.hasEnding(file.getName(), new String[][]{rmEndings});
        boolean isTxt = RemoteMaster.hasEnding(file.getName(), new String[][]{kmEndings});
        if (isRMDU || isTxt) {
            this.deviceUpgrade.load(file);
            this.updateRecentFiles(file);
            this.setTitle("RMDU: " + file.getCanonicalPath());
            preferences.setUpgradePath(file.getParentFile());
        } else {
            this.loadExternalFile(file);
            this.setTitle("RMDU");
        }
        this.refresh();
    }

    private void updateRecentFiles(File file) throws IOException {
        boolean isRMDU = file.getName().toLowerCase().endsWith(".rmdu");
        boolean isTxt = file.getName().toLowerCase().endsWith(".txt");
        if (isRMDU || isTxt) {
            JMenuItem item;
            int i;
            for (i = this.recentFileMenu.getItemCount() - 1; i >= 0; --i) {
                item = this.recentFileMenu.getItem(i);
                File f = new File(item.getText());
                if (!f.getCanonicalPath().equals(file.getCanonicalPath())) continue;
                this.recentFileMenu.remove(i);
            }
            i = this.recentFileMenu.getItemCount();
            while (i > 9) {
                this.recentFileMenu.remove(--i);
            }
            item = new JMenuItem(file.getAbsolutePath());
            item.addActionListener(this);
            this.recentFileMenu.add((Component)item, 0);
            this.recentFileMenu.setEnabled(true);
        }
    }

    public void loadUpgrade(BufferedReader reader) throws Exception {
        this.deviceUpgrade.reset();
        this.deviceUpgrade.load(reader);
        this.refresh();
    }

    private void refresh() {
        File file = this.deviceUpgrade.getFile();
        this.saveItem.setEnabled(file != null);
        this.writeBinaryItem.setEnabled(this.deviceUpgrade.getRemote().getSupportsBinaryUpgrades());
        this.validateUpgrade();
        this.editorPanel.refresh();
    }

    public void importUpgrade(BufferedReader in) throws Exception {
        this.deviceUpgrade.reset();
        this.deviceUpgrade.importUpgrade(in);
        this.refresh();
    }

    public static File getHomeDirectory() {
        if (homeDirectory == null) {
            homeDirectory = RemoteMaster.getWorkDir();
        }
        return homeDirectory;
    }

    public void validateUpgrade() {
        this.editorPanel.validateUpgrade();
    }

    public static Remote getRemote() {
        return KeyMapMaster.me.deviceUpgrade.getRemote();
    }

    public Collection<Remote> getRemotes() {
        if (preferences.getShowRemotes().equals("Preferred")) {
            return preferences.getPreferredRemotes();
        }
        return RemoteManager.getRemoteManager().getRemotes();
    }

    public DeviceUpgrade getDeviceUpgrade() {
        return this.deviceUpgrade;
    }

    private void editPreferredRemotes() {
        PreferredRemoteDialog d = new PreferredRemoteDialog(this, preferences.getPreferredRemotes());
        d.setVisible(true);
        if (d.getUserAction() == 0) {
            Collection<Remote> preferredRemotes = d.getPreferredRemotes();
            preferences.setPreferredRemotes(preferredRemotes);
            if (preferredRemotes.size() == 0) {
                this.usePreferredRemotes.setEnabled(false);
                if (!this.useAllRemotes.isSelected()) {
                    this.useAllRemotes.setSelected(true);
                    this.editorPanel.setRemotes(RemoteManager.getRemoteManager().getRemotes());
                }
            } else {
                this.usePreferredRemotes.setEnabled(true);
            }
            if (this.usePreferredRemotes.isSelected()) {
                this.editorPanel.setRemotes(preferredRemotes);
            }
        }
    }

    public String[] getCustomNames() {
        if (preferences.getUseCustomNames().equals("Empty")) {
            return new String[0];
        }
        if (!preferences.getUseCustomNames().equals("Default")) {
            return preferences.getCustomNames();
        }
        return null;
    }

    private void adjustFontSize(float adjustment) {
        if (adjustment == 0.0f) {
            return;
        }
        ArrayList<String> keyList = new ArrayList<String>();
        UIDefaults defaults = UIManager.getDefaults();
        Enumeration en = defaults.keys();
        while (en.hasMoreElements()) {
            String key;
            Object o = en.nextElement();
            if (o.getClass() != String.class || keyList.contains(key = (String)o) || !key.endsWith(".font") || key.startsWith("class") || key.startsWith("javax")) continue;
            keyList.add(key);
            FontUIResource font = (FontUIResource)UIManager.get(key);
            FontUIResource newFont = new FontUIResource(font.deriveFont(font.getSize2D() + adjustment));
            if (key.indexOf("Table") != -1) {
                System.err.println("key=" + key);
                System.err.println("got font " + font);
                System.err.println("set font " + newFont);
            }
            UIManager.put(key, newFont);
        }
        this.fontAdjustment += adjustment;
        preferences.setFontSizeAdjustment(Float.valueOf(this.fontAdjustment));
        SwingUtilities.updateComponentTreeUI(this);
        this.pack();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.refresh();
    }

    public List<AssemblerItem> getClipBoardItems() {
        return this.clipBoardItems;
    }

    public void loadExternalFile(File file) {
        GeneralSignal[] signals = ExternalSignal.loadExternalFile(file, this);
        ProtocolManager.getProtocolManager().reset();
        this.deviceUpgrade.reset(new String[0]);
        if (signals != null) {
            DeviceUpgradeConverter converter = new DeviceUpgradeConverter(null, KeyMapMaster.getRemote());
            converter.setBaseUpgrade(this.deviceUpgrade);
            DeviceUpgrade upgrade = converter.convertToDeviceUpgrade(signals, true);
            if (upgrade == null) {
                System.err.println("Import from file " + file.getName() + " failed");
                return;
            }
            String description = ExternalSignal.remote != null ? ExternalSignal.remote.getName() : "Import from IRScope file";
            String notes = "Imported from ";
            notes = notes + (ExternalSignal.remote != null ? "Girr file " : "IRScope file ");
            notes = notes + file.getAbsolutePath();
            if (ExternalSignal.remote != null) {
                notes = notes + "\n" + ExternalSignal.remote.getMetaData().toFormattedString();
            }
            upgrade.setDescription(description);
            upgrade.setNotes(notes);
        }
        this.refresh();
    }
}

