/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.Function;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.KMPanel;
import com.hifiremote.jp1.Remote;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;

public class KeyMapPanel
extends KMPanel
implements ActionListener,
Printable {
    private static DecimalFormat df = new DecimalFormat("0000");
    private Box box = null;
    private JLabel titleLabel = null;
    private JLabel subtitleLabel = null;
    private JTableX table = null;
    private JTableHeader header = null;
    private JButton print = null;
    private List<Button> list = new ArrayList<Button>();
    private static String[] headers = new String[]{"Button", "Normal Function", "Shifted Function", "XShifted Function"};

    public KeyMapPanel(DeviceUpgrade devUpgrade) {
        super("Key Map", devUpgrade);
        this.setLayout(new BorderLayout());
        String fontName = "Tahoma";
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(new Font(fontName, 1, 14));
        this.titleLabel.setBackground(Color.WHITE);
        this.titleLabel.setAlignmentX(0.5f);
        this.subtitleLabel = new JLabel();
        this.subtitleLabel.setFont(new Font(fontName, 1, 10));
        this.subtitleLabel.setBackground(Color.WHITE);
        this.subtitleLabel.setAlignmentX(0.5f);
        this.box = Box.createVerticalBox();
        this.box.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createLineBorder(Color.BLACK)));
        this.box.add(this.titleLabel);
        this.box.add(this.subtitleLabel);
        this.add((Component)new JScrollPane(this.box), "Center");
        AbstractTableModel dataModel = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                if (KeyMapPanel.this.deviceUpgrade == null) {
                    return 3;
                }
                Remote r = KeyMapPanel.this.deviceUpgrade.getRemote();
                if (r != null && r.getXShiftEnabled()) {
                    return 4;
                }
                return 3;
            }

            @Override
            public int getRowCount() {
                return KeyMapPanel.this.list.size();
            }

            @Override
            public Object getValueAt(int row, int col) {
                Button b = (Button)KeyMapPanel.this.list.get(row);
                switch (col) {
                    case 0: {
                        return b.getName();
                    }
                    case 1: {
                        return this.getName(KeyMapPanel.this.deviceUpgrade.getFunction(b, 0));
                    }
                    case 2: {
                        return this.getName(KeyMapPanel.this.deviceUpgrade.getFunction(b, 1));
                    }
                    case 3: {
                        return this.getName(KeyMapPanel.this.deviceUpgrade.getFunction(b, 2));
                    }
                }
                return null;
            }

            private String getName(Function f) {
                if (f != null) {
                    return f.getName();
                }
                return null;
            }

            @Override
            public String getColumnName(int column) {
                return headers[column];
            }

            @Override
            public Class<?> getColumnClass(int col) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.table = new JTableX(dataModel);
        this.table.setAlignmentX(0.5f);
        this.table.setFont(new Font(fontName, 0, 10));
        this.table.setRowHeight(12);
        this.header = this.table.getTableHeader();
        this.header.setReorderingAllowed(false);
        this.header.setResizingAllowed(false);
        this.header.setFont(new Font(fontName, 1, 8));
        Box tableBox = Box.createVerticalBox();
        tableBox.add(this.header);
        tableBox.add(this.table);
        this.box.add(tableBox);
        this.print = new JButton("Print");
        this.print.addActionListener(this);
        JPanel panel = new JPanel();
        panel.add(this.print);
        this.add((Component)panel, "South");
    }

    private void getAssignedButtons() {
        this.list.clear();
        Button[] buttons = this.deviceUpgrade.getRemote().getBaseUpgradeButtons();
        for (int i = 0; i < buttons.length; ++i) {
            Button b = buttons[i];
            if (this.deviceUpgrade.getFunction(b, 0) == null && this.deviceUpgrade.getFunction(b, 1) == null && this.deviceUpgrade.getFunction(b, 2) == null) continue;
            this.list.add(b);
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paint(g2);
    }

    @Override
    public void update() {
        String text = this.deviceUpgrade.getDescription();
        if (text == null || text.length() == 0) {
            text = " ";
        }
        this.titleLabel.setText(text);
        text = this.deviceUpgrade.getRemote().getName() + " (" + this.deviceUpgrade.getDeviceTypeAliasName() + '/' + df.format(this.deviceUpgrade.getSetupCode()) + " - " + this.deviceUpgrade.getProtocol().getName() + ')';
        this.subtitleLabel.setText(text);
        this.getAssignedButtons();
        Remote r = this.deviceUpgrade.getRemote();
        KeyMapPanel.headers[2] = r.getShiftLabel() + " Function";
        KeyMapPanel.headers[3] = r.getXShiftLabel() + " Function";
        ((AbstractTableModel)this.table.getModel()).fireTableStructureChanged();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setPrintable(this);
        pj.printDialog();
        try {
            pj.print();
        }
        catch (Exception printException) {
            printException.printStackTrace(System.err);
        }
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.black);
        if (pageIndex >= 1) {
            return 1;
        }
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        Dimension d = this.box.getSize();
        d.width = (int)pageFormat.getImageableWidth();
        this.box.setSize(d);
        this.box.validate();
        this.box.paint(g2);
        return 0;
    }
}

