/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.AdvancedCode;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.EFC;
import com.hifiremote.jp1.EFC5;
import com.hifiremote.jp1.Function;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.KeyMoveEFC5;
import com.hifiremote.jp1.KeyMoveKey;
import com.hifiremote.jp1.KeyMoveLong;
import com.hifiremote.jp1.PropertyWriter;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.SetupCode;
import java.util.Properties;

public class KeyMove
extends AdvancedCode
implements Cloneable {
    private int deviceType;
    private DeviceButton targetDevice = null;
    private int setupCode;
    private Hex cmd = null;
    protected static final int DEVICE_TYPE_INDEX = 0;
    private static int setupCodeIndex = 0;
    private static int cmdIndex = 2;
    private Integer irSerial = null;

    public KeyMove(int keyCode, int deviceButtonIndex, Hex data, String notes) {
        super(keyCode, data, notes);
        this.cmd = data.subHex(cmdIndex);
        this.deviceButtonIndex = deviceButtonIndex;
        short[] hex = data.getData();
        this.deviceType = hex[0] >> (setupCodeIndex == 0 ? 4 : 0);
        int mask = SetupCode.getMax() > 4095 ? 65535 : SetupCode.getMax();
        this.setupCode = Hex.get(hex, setupCodeIndex) & mask;
    }

    public KeyMove(int keyCode, int deviceButtonIndex, int deviceType, int setupCode, Hex cmd, String notes) {
        super(keyCode, null, notes);
        Hex cmdHex = cmd;
        if (cmdIndex == 3 && cmd.length() < 3) {
            cmdHex = new Hex(3);
            cmdHex.put(cmd, 1);
        }
        this.setData(this.getRawHex(deviceType, setupCode, cmdHex));
        this.cmd = cmd;
        this.setDeviceButtonIndex(deviceButtonIndex);
        this.deviceType = deviceType;
        this.setupCode = setupCode;
    }

    public Hex getRawHex(int deviceType, int setupCode, Hex cmd) {
        Hex hex = new Hex(cmdIndex + cmd.length());
        KeyMove.update(deviceType, setupCode, hex);
        hex.put(cmd, cmdIndex);
        return hex;
    }

    public KeyMove(Properties props) {
        super(props);
        this.cmd = this.data.subHex(cmdIndex == 2 ? 2 : (this instanceof KeyMoveKey ? 3 : 4));
        if (this instanceof KeyMoveLong) {
            this.cmd = this.cmd.subHex(0, 1);
        }
        this.deviceButtonIndex = Integer.parseInt(props.getProperty("DeviceButtonIndex"));
        this.setDeviceType(Integer.parseInt(props.getProperty("DeviceType")));
        this.setSetupCode(Integer.parseInt(props.getProperty("SetupCode")));
    }

    public KeyMove(KeyMove keyMove) {
        this(keyMove.getKeyCode(), keyMove.getDeviceButtonIndex(), keyMove.getDeviceType(), keyMove.getSetupCode(), new Hex(keyMove.getCmd()), keyMove.getNotes());
        this.setUploadStatus(keyMove.getUploadStatus());
    }

    protected Object clone() throws CloneNotSupportedException {
        return new KeyMove(this.getKeyCode(), this.getDeviceButtonIndex(), this.getDeviceType(), this.getSetupCode(), (Hex)this.getCmd().clone(), this.getNotes());
    }

    public EFC getEFC() {
        return new EFC(this.cmd);
    }

    public EFC5 getEFC5() {
        if (this instanceof KeyMoveLong && this.cmd.length() == 1 && cmdIndex == 2) {
            return new EFC5(this.getRawHex(0, 0, this.cmd).subHex(cmdIndex == 2 ? 2 : 4));
        }
        return new EFC5(this.cmd);
    }

    public void setCmd(Hex cmd) {
        this.cmd = cmd;
        this.data = this.getRawHex(this.deviceType, this.setupCode, cmd);
    }

    @Override
    public String getValueString(RemoteConfiguration remoteConfig) {
        Function f;
        DeviceUpgrade deviceUpgrade = remoteConfig.findDeviceUpgrade(this.getDeviceType(), this.getSetupCode());
        if (deviceUpgrade != null && (f = deviceUpgrade.getFunction(this.getCmd())) != null) {
            return "\"" + f.getName() + '\"';
        }
        if (this.cmd.length() == 1 && !(this instanceof KeyMoveLong)) {
            return this.getEFC().toString();
        }
        return this.getEFC5().toString();
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(int newDeviceType) {
        this.deviceType = newDeviceType;
        this.update();
    }

    public DeviceButton getTargetDevice() {
        return this.targetDevice;
    }

    public void setTargetDevice(DeviceButton targetDevice) {
        this.targetDevice = targetDevice;
    }

    private void update() {
        KeyMove.update(this.deviceType, this.setupCode, this.data);
    }

    protected static void update(int deviceType, int setupCode, Hex data) {
        if (setupCodeIndex == 0) {
            int temp = deviceType << 12 | setupCode;
            data.put(temp, setupCodeIndex);
        } else {
            data.set((short)deviceType, 0);
            data.put(setupCode, setupCodeIndex);
        }
    }

    public int getSetupCode() {
        return this.setupCode;
    }

    public void setSetupCode(int newCode) {
        this.setupCode = newCode;
        this.update();
    }

    public Hex getCmd() {
        return this.cmd;
    }

    @Override
    public void store(PropertyWriter pw) {
        pw.print("DeviceButtonIndex", this.deviceButtonIndex);
        pw.print("DeviceType", this.deviceType);
        pw.print("SetupCode", this.setupCode);
        super.store(pw);
    }

    public static void setSetupCodeIndex(int setupCodeIndex) {
        KeyMove.setupCodeIndex = setupCodeIndex;
    }

    public static int getCmdIndex() {
        return cmdIndex;
    }

    public static void setCmdIndex(int cmdIndex) {
        KeyMove.cmdIndex = cmdIndex;
    }

    public Integer getIrSerial() {
        return this.irSerial;
    }

    public void setIrSerial(Integer irSerial) {
        this.irSerial = irSerial;
    }

    @Override
    public int store(short[] buffer, int offset, Remote remote) {
        int hexLength;
        if (cmdIndex == 2) {
            int lengthOffset;
            buffer[offset++] = (short)this.keyCode;
            if (remote.getAdvCodeBindFormat() == AdvancedCode.BindFormat.NORMAL) {
                int temp = this.deviceButtonIndex << 5 & 0xFF;
                buffer[offset] = (short)temp;
                lengthOffset = offset++;
            } else {
                buffer[offset++] = (short)(0x10 | this.deviceButtonIndex);
                lengthOffset = offset++;
                buffer[lengthOffset] = 0;
            }
            hexLength = this.data.length();
            if (hexLength == 5 && this instanceof KeyMoveEFC5) {
                hexLength = 4;
                Hex.put(this.data.subHex(0, 4), buffer, offset);
            } else {
                Hex.put(this.data, buffer, offset);
            }
            int n = lengthOffset;
            buffer[n] = (short)(buffer[n] | (short)hexLength);
        } else {
            buffer[offset++] = (short)this.deviceButtonIndex;
            buffer[offset++] = (short)this.keyCode;
            hexLength = this.data.length();
            Hex.put(this.data, buffer, offset);
        }
        return offset + hexLength;
    }
}

