/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.AdvancedCode;
import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.DeviceButtonTableModel;
import com.hifiremote.jp1.DeviceType;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.EFC;
import com.hifiremote.jp1.EFC5;
import com.hifiremote.jp1.FocusSelector;
import com.hifiremote.jp1.Function;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.HexFormatter;
import com.hifiremote.jp1.JP1Table;
import com.hifiremote.jp1.KeyMove;
import com.hifiremote.jp1.KeyMoveKey;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.SetupCode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.NumberFormatter;

public class KeyMoveDialog
extends JDialog
implements ActionListener,
PropertyChangeListener,
Runnable,
ItemListener {
    private JComboBox boundDevice = new JComboBox();
    private JComboBox boundKey = new JComboBox();
    private JCheckBox shift = new JCheckBox();
    private JCheckBox xShift = new JCheckBox();
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private DeviceButtonTableModel model = new DeviceButtonTableModel();
    private JP1Table table = new JP1Table(this.model);
    private JComboBox deviceType = new JComboBox();
    private JFormattedTextField setupCode = null;
    private JPopupMenu popup = new JPopupMenu();
    private JButton chooseUpgrade = new JButton("Device Upgrades");
    public boolean use3DigitEFCs = true;
    private JRadioButton useEFC = new JRadioButton("EFC");
    private JRadioButton useHex = new JRadioButton("Hex");
    private JRadioButton useKey = new JRadioButton("Key");
    private JRadioButton useFunction = new JRadioButton("Function");
    private JRadioButton buttonToSelect = null;
    private JFormattedTextField efcField = null;
    private JFormattedTextField hexField = null;
    private JComboBox function = new JComboBox();
    private JComboBox movedKey = new JComboBox();
    private JCheckBox shiftMovedKey = new JCheckBox();
    private JCheckBox xShiftMovedKey = new JCheckBox();
    private JTextArea notes = new JTextArea(2, 10);
    private String initialNotes = null;
    private RemoteConfiguration config = null;
    private KeyMove keyMove = null;
    private Hex cmd = null;
    private DeviceUpgrade upgrade = null;

    public static KeyMove showDialog(JFrame frame, KeyMove keyMove, RemoteConfiguration config) {
        KeyMoveDialog dialog = new KeyMoveDialog(frame, config);
        dialog.config = config;
        dialog.setKeyMove(keyMove);
        dialog.pack();
        dialog.setLocationRelativeTo(frame);
        dialog.setVisible(true);
        return dialog.keyMove;
    }

    private KeyMoveDialog(JFrame frame, RemoteConfiguration config) {
        super(frame, "Key Move", true);
        boolean showMovedKey;
        this.model.set(config);
        this.config = config;
        Remote remote = config.getRemote();
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        contentPane.setLayout(new BoxLayout(contentPane, 3));
        JPanel panel = new JPanel(new FlowLayout(0, 5, 0));
        panel.setAlignmentX(0.0f);
        contentPane.add(panel);
        panel.setBorder(BorderFactory.createTitledBorder("Bound Key"));
        panel.add(new JLabel("Device:"));
        this.boundDevice.setModel(new DefaultComboBoxModel<DeviceButton>(config.getAllowedDeviceButtons()));
        panel.add(this.boundDevice);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(new JLabel("Key:"));
        this.boundKey.setModel(new DefaultComboBoxModel<Button>(remote.getBaseUpgradeButtons()));
        this.boundKey.addActionListener(this);
        panel.add(this.boundKey);
        if (remote.getShiftEnabled()) {
            this.shift.setText(remote.getShiftLabel());
            this.shift.addActionListener(this);
            panel.add(this.shift);
        }
        if (remote.getXShiftEnabled()) {
            this.xShift.setText(remote.getXShiftLabel());
            this.xShift.addActionListener(this);
            panel.add(this.xShift);
        }
        Box functionBox = Box.createVerticalBox();
        functionBox.setBorder(BorderFactory.createTitledBorder("Function to Perform"));
        contentPane.add(functionBox);
        Box deviceBox = Box.createVerticalBox();
        functionBox.add(deviceBox);
        deviceBox.setBorder(BorderFactory.createTitledBorder("Device"));
        JLabel label = new JLabel("Double-click a row to select a type/code, or enter a device below.");
        label.setAlignmentX(0.0f);
        deviceBox.add(label);
        deviceBox.add(Box.createVerticalStrut(5));
        this.model.setEditable(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.initColumns(this.model);
        MouseAdapter ma = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                int row = KeyMoveDialog.this.table.rowAtPoint(e.getPoint());
                if (row != -1) {
                    KeyMoveDialog.this.deviceType.setSelectedItem(KeyMoveDialog.this.table.getValueAt(row, 2));
                    KeyMoveDialog.this.setupCode.setValue(new Integer(((SetupCode)KeyMoveDialog.this.table.getValueAt(row, 3)).getValue()));
                }
            }
        };
        this.table.addMouseListener(ma);
        Dimension d = this.table.getPreferredScrollableViewportSize();
        d.width = this.table.getPreferredSize().width;
        d.height = 8 * this.table.getRowHeight();
        this.table.setPreferredScrollableViewportSize(d);
        JScrollPane scroll = new JScrollPane(this.table);
        scroll.setAlignmentX(0.0f);
        deviceBox.add(scroll);
        deviceBox.add(Box.createVerticalStrut(10));
        panel = new JPanel(new FlowLayout(0, 5, 0));
        panel.setAlignmentX(0.0f);
        deviceBox.add(panel);
        label = new JLabel("Device Type:");
        panel.add(label);
        this.deviceType.setModel(new DefaultComboBoxModel<DeviceType>(remote.getDeviceTypes()));
        panel.add(this.deviceType);
        label.setLabelFor(this.deviceType);
        this.deviceType.addActionListener(this);
        panel.add(Box.createHorizontalStrut(5));
        label = new JLabel("Setup Code:");
        panel.add(label);
        DecimalFormat format = new DecimalFormat("0000");
        format.setParseIntegerOnly(true);
        format.setGroupingUsed(false);
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setValueClass(Integer.class);
        formatter.setMinimum(new Integer(0));
        formatter.setMaximum(new Integer(SetupCode.getMax()));
        this.setupCode = new JFormattedTextField(formatter);
        this.setupCode.setColumns(4);
        FocusSelector.selectOnFocus(this.setupCode);
        this.setupCode.addPropertyChangeListener(this);
        label.setLabelFor(this.setupCode);
        panel.add(this.setupCode);
        this.chooseUpgrade.addActionListener(this);
        panel.add(this.chooseUpgrade);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem source = (JMenuItem)e.getSource();
                int index = Integer.valueOf(source.getActionCommand());
                DeviceUpgrade upgrade = KeyMoveDialog.this.config.getDeviceUpgrades().get(index);
                KeyMoveDialog.this.deviceType.setSelectedIndex(upgrade.getDeviceType().getNumber());
                KeyMoveDialog.this.setupCode.setValue(upgrade.getSetupCode());
            }
        };
        List<DeviceUpgrade> upgrades = config.getDeviceUpgrades();
        for (int i = 0; i < upgrades.size(); ++i) {
            DeviceUpgrade upgrade = upgrades.get(i);
            String desc = upgrade.getDescription();
            if (this.getValidFunctions(upgrade).size() <= 0 || config.findBoundDeviceButtonIndex(upgrade) != -1) continue;
            if (desc == null || desc.trim().length() == 0) {
                desc = String.format("%s/%04d", upgrade.getDeviceType().toString(), upgrade.getSetupCode());
            }
            JMenuItem item = new JMenuItem(desc);
            this.popup.add(item);
            item.setActionCommand(Integer.toString(i));
            item.addActionListener(al);
        }
        if (this.popup.getComponentCount() == 0) {
            this.chooseUpgrade.setVisible(false);
        }
        panel = new JPanel(new FlowLayout(0, 5, 0));
        panel.setAlignmentX(0.0f);
        functionBox.add(panel);
        ButtonGroup group = new ButtonGroup();
        this.useEFC.addActionListener(this);
        this.useEFC.addItemListener(this);
        panel.add(this.useEFC);
        group.add(this.useEFC);
        this.useHex.addActionListener(this);
        this.useHex.addItemListener(this);
        panel.add(this.useHex);
        group.add(this.useHex);
        this.useFunction.addActionListener(this);
        this.useFunction.addItemListener(this);
        this.useFunction.setVisible(false);
        panel.add(this.useFunction);
        group.add(this.useFunction);
        boolean bl = showMovedKey = remote.getAdvCodeBindFormat() == AdvancedCode.BindFormat.LONG;
        if (showMovedKey) {
            this.useKey.addActionListener(this);
            this.useKey.addItemListener(this);
            panel.add(this.useKey);
            group.add(this.useKey);
        }
        boolean bl2 = this.use3DigitEFCs = remote.getEFCDigits() == 3;
        if (this.use3DigitEFCs) {
            this.useEFC.setText("EFC");
            format = new DecimalFormat("000");
            format.setParseIntegerOnly(true);
            format.setGroupingUsed(false);
            formatter = new NumberFormatter(format);
            formatter.setValueClass(Integer.class);
            formatter.setMinimum(new Integer(0));
            formatter.setMaximum(new Integer(255));
            this.efcField = new JFormattedTextField(formatter);
            this.efcField.setColumns(3);
        } else {
            this.useEFC.setText("EFC-5");
            format = new DecimalFormat("00000");
            format.setParseIntegerOnly(true);
            format.setGroupingUsed(false);
            formatter = new NumberFormatter(format);
            formatter.setValueClass(Integer.class);
            formatter.setMinimum(new Integer(0));
            formatter.setMaximum(new Integer(99999));
            this.efcField = new JFormattedTextField(formatter);
            this.efcField.setColumns(5);
        }
        FocusSelector.selectOnFocus(this.efcField);
        this.efcField.addPropertyChangeListener(this);
        panel.add(this.efcField);
        this.efcField.setVisible(false);
        HexFormatter hexFormatter = new HexFormatter(0);
        this.hexField = new JFormattedTextField(hexFormatter);
        this.hexField.setColumns(15);
        FocusSelector.selectOnFocus(this.hexField);
        this.hexField.addPropertyChangeListener(this);
        panel.add(this.hexField);
        FocusSelector.selectOnFocus(this.hexField);
        this.hexField.setVisible(false);
        this.function.addActionListener(this);
        panel.add(this.function);
        this.function.setVisible(false);
        if (showMovedKey) {
            this.movedKey.setVisible(false);
            this.movedKey.setModel(new DefaultComboBoxModel<Button>(remote.getBaseUpgradeButtons()));
            this.movedKey.addActionListener(this);
            panel.add(this.movedKey);
            if (remote.getShiftEnabled()) {
                this.shiftMovedKey.setText(remote.getShiftLabel());
                this.shiftMovedKey.setVisible(false);
                this.shiftMovedKey.addActionListener(this);
                panel.add(this.shiftMovedKey);
            }
            if (remote.getXShiftEnabled()) {
                this.xShiftMovedKey.setText(remote.getXShiftLabel());
                this.xShiftMovedKey.setVisible(false);
                this.xShiftMovedKey.addActionListener(this);
                panel.add(this.xShiftMovedKey);
            }
        }
        panel = new JPanel(new BorderLayout());
        panel.setAlignmentX(0.0f);
        contentPane.add((Component)panel, "Center");
        panel.setBorder(BorderFactory.createTitledBorder("Notes"));
        this.notes.setLineWrap(true);
        panel.add(new JScrollPane(this.notes, 22, 31));
        panel = new JPanel(new FlowLayout(2));
        panel.setAlignmentX(0.0f);
        contentPane.add(panel);
        this.okButton.addActionListener(this);
        panel.add(this.okButton);
        this.cancelButton.addActionListener(this);
        panel.add(this.cancelButton);
    }

    private void setKeyMove(KeyMove keyMove) {
        if (keyMove == null) {
            this.useEFC.doClick();
            return;
        }
        Remote remote = this.config.getRemote();
        this.cmd = new Hex(keyMove.getCmd());
        DeviceButton devBtn = this.config.getRemote().getDeviceButton(keyMove.getDeviceButtonIndex());
        this.boundDevice.setSelectedItem(devBtn);
        this.shift.removeActionListener(this);
        this.xShift.removeActionListener(this);
        this.setButton(keyMove.getKeyCode(), this.boundKey, this.shift, this.xShift);
        this.shift.addActionListener(this);
        this.xShift.addActionListener(this);
        this.deviceType.removeActionListener(this);
        this.deviceType.setSelectedIndex(keyMove.getDeviceType());
        this.deviceType.addActionListener(this);
        this.setupCode.removeActionListener(this);
        this.setupCode.setValue(new Integer(keyMove.getSetupCode() + remote.getDeviceCodeOffset()));
        this.setupCode.addActionListener(this);
        this.initialNotes = keyMove.getNotes();
        this.notes.setText(keyMove.getNotes());
        this.checkForUpgrade();
        if (keyMove.getClass() == KeyMoveKey.class) {
            this.useKey.doClick();
        } else if (this.upgrade != null && this.upgrade.getFunction(this.cmd) != null) {
            this.useFunction.doClick();
        } else {
            this.useHex.doClick();
        }
    }

    private void setButton(int code, JComboBox comboBox, JCheckBox shiftBox, JCheckBox xShiftBox) {
        Remote remote = this.config.getRemote();
        Button b = remote.getButton(code);
        if (!Arrays.asList(remote.getBaseUpgradeButtons()).contains(b)) {
            b = null;
        }
        if (b == null) {
            int base = code & 0x3F;
            if (base != 0) {
                b = remote.getButton(base);
                if ((base | remote.getShiftMask()) == code) {
                    shiftBox.setEnabled(b.allowsShiftedMacro());
                    shiftBox.setSelected(true);
                    comboBox.setSelectedItem(b);
                    return;
                }
                if (remote.getXShiftEnabled() && (base | remote.getXShiftMask()) == code) {
                    xShiftBox.setEnabled(remote.getXShiftEnabled() & b.allowsXShiftedMacro());
                    xShiftBox.setSelected(true);
                    comboBox.setSelectedItem(b);
                    return;
                }
            }
            if ((b = remote.getButton(code & ~remote.getShiftMask())) != null) {
                shiftBox.setSelected(true);
            } else if (remote.getXShiftEnabled() && (b = remote.getButton(code ^ ~remote.getXShiftMask())) != null) {
                xShiftBox.setSelected(true);
            }
        }
        shiftBox.setEnabled(b.allowsShiftedKeyMove());
        xShiftBox.setEnabled(b.allowsXShiftedKeyMove());
        if (b.getIsXShifted()) {
            xShiftBox.setSelected(true);
        } else if (b.getIsShifted()) {
            shiftBox.setSelected(true);
        }
        comboBox.setSelectedItem(b);
    }

    private int getKeyCode(JComboBox comboBox, JCheckBox shiftBox, JCheckBox xShiftBox) {
        int keyCode = ((Button)comboBox.getSelectedItem()).getKeyCode();
        if (shiftBox.isSelected()) {
            keyCode |= this.config.getRemote().getShiftMask();
        } else if (xShiftBox.isSelected()) {
            keyCode |= this.config.getRemote().getXShiftMask();
        }
        return keyCode;
    }

    private void showWarning(String message) {
        JOptionPane.showMessageDialog(this, message, "Missing Information", 0);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        Remote remote = this.config.getRemote();
        Button b = (Button)this.boundKey.getSelectedItem();
        if (source == this.okButton) {
            int deviceIndex = ((DeviceButton)this.boundDevice.getSelectedItem()).getButtonIndex();
            if (deviceIndex == -1) {
                this.showWarning("You must select a device for the bound key.");
                return;
            }
            if (this.boundKey.getSelectedItem() == null) {
                this.showWarning("You must select a key for the bound key.");
                return;
            }
            int keyCode = this.getKeyCode(this.boundKey, this.shift, this.xShift);
            int deviceTypeIndex = this.deviceType.getSelectedIndex();
            if (deviceTypeIndex == -1) {
                this.showWarning("You must select a device type for the function to perform.");
                return;
            }
            if (this.setupCode.getValue() == null) {
                this.showWarning("You must specify a setup code for the function to perform.");
                return;
            }
            int setupId = (Integer)this.setupCode.getValue();
            String notesStr = this.notes.getText();
            if (this.cmd == null) {
                if (this.useEFC.isSelected()) {
                    if (remote.getEFCDigits() == 3) {
                        this.showWarning("You must specify an EFC for the function to perform.");
                    } else {
                        this.showWarning("You must specify an EFC-5 for the function to perform.");
                    }
                } else if (this.useHex.isSelected()) {
                    this.showWarning("You must specify a valid Hex command for the function to perform,\nsuch as 1B or 1B C2.");
                } else if (this.useKey.isSelected()) {
                    this.showWarning("You must select a key for the function to perform.");
                } else if (this.useFunction.isSelected()) {
                    this.showWarning("You must select a function to perform.");
                }
                return;
            }
            if (remote.getAdvCodeFormat() == AdvancedCode.Format.EFC) {
                if (remote.getEFCDigits() == 3 && this.cmd.length() > 1) {
                    this.showWarning("The " + remote.getName() + " doesn't support key moves with multi-byte commands.");
                } else if (remote.getEFCDigits() == 5 && this.cmd.length() > 2) {
                    this.showWarning("The " + remote.getName() + " doesn't support key moves with commands of more than two bytes.");
                }
            }
            if (this.useKey.isSelected()) {
                int movedKeyCode = this.getKeyCode(this.movedKey, this.shiftMovedKey, this.xShiftMovedKey);
                int offset = remote.getDeviceCodeOffset();
                this.keyMove = remote.createKeyMoveKey(keyCode, deviceIndex, deviceTypeIndex, setupId - offset, movedKeyCode, notesStr);
            } else {
                int offset = remote.getDeviceCodeOffset();
                this.keyMove = remote.createKeyMove(keyCode, deviceIndex, deviceTypeIndex, setupId - offset, this.cmd, notesStr);
            }
            if (this.config.hasSegments()) {
                this.keyMove.setSegmentFlags(255);
            }
            this.setVisible(false);
        } else if (source == this.cancelButton) {
            this.keyMove = null;
            this.setVisible(false);
        } else if (source == this.shift) {
            if (this.shift.isSelected()) {
                this.xShift.setSelected(false);
            } else if (b != null && remote.getXShiftEnabled()) {
                this.xShift.setSelected(b.needsShift(Button.MOVE_BIND));
            }
        } else if (source == this.xShift) {
            if (this.xShift.isSelected()) {
                this.shift.setSelected(false);
            } else if (b != null) {
                this.shift.setSelected(b.needsShift(Button.MOVE_BIND));
            }
        } else if (source == this.boundKey) {
            if (b != null) {
                b.setShiftBoxes(Button.MOVE_BIND, this.shift, this.xShift);
            }
        } else if (source == this.function) {
            this.setFunction();
        } else if (source == this.movedKey) {
            Button button = (Button)this.movedKey.getSelectedItem();
            this.cmd = new Hex(1);
            this.cmd.set(button.getKeyCode(), 0);
        } else if (source == this.useEFC) {
            if (this.cmd != null) {
                int value = 0;
                value = this.use3DigitEFCs ? new EFC(this.cmd).getValue() : new EFC5(this.cmd).getValue();
                this.efcField.removePropertyChangeListener(this);
                this.efcField.setValue(value);
                this.efcField.addPropertyChangeListener(this);
            }
        } else if (source == this.useHex) {
            this.hexField.removePropertyChangeListener(this);
            this.hexField.setValue(this.cmd);
            this.hexField.addPropertyChangeListener(this);
        } else if (source == this.useKey) {
            this.movedKey.removeActionListener(this);
            this.shiftMovedKey.removeActionListener(this);
            this.xShiftMovedKey.removeActionListener(this);
            this.movedKey.setSelectedIndex(-1);
            this.shiftMovedKey.setSelected(false);
            this.xShiftMovedKey.setSelected(false);
            if (this.cmd != null) {
                this.setButton(this.cmd.getData()[0], this.movedKey, this.shiftMovedKey, this.xShiftMovedKey);
            }
            this.movedKey.addActionListener(this);
            this.shiftMovedKey.addActionListener(this);
            this.xShiftMovedKey.addActionListener(this);
        } else if (source == this.useFunction) {
            Function func;
            if (this.cmd != null && this.upgrade != null && (func = this.upgrade.getFunction(this.cmd)) != null) {
                this.function.removeActionListener(this);
                this.function.setSelectedItem(func);
                this.function.addActionListener(this);
            }
        } else if (source == this.deviceType) {
            this.checkForUpgrade();
        } else if (source == this.chooseUpgrade) {
            this.popup.show(this.chooseUpgrade, 0, this.chooseUpgrade.getHeight());
        }
    }

    private void setFunction() {
        Function func = (Function)this.function.getSelectedItem();
        if (func == null) {
            return;
        }
        this.cmd = func.getHex();
        if ((this.initialNotes == null || this.initialNotes.trim().equals("")) && func != null) {
            String text = func.getNotes();
            if (text == null || text.trim().equals("")) {
                text = func.getName();
            }
            this.notes.setText(text);
        }
    }

    protected List<Function> getValidFunctions(DeviceUpgrade upgrade) {
        ArrayList<Function> functions = new ArrayList<Function>();
        for (Function function : upgrade.getFunctions()) {
            Hex hex = function.getHex();
            if (hex == null || hex.length() <= 0) continue;
            functions.add(function);
        }
        return functions;
    }

    protected DeviceUpgrade checkForUpgrade() {
        this.upgrade = null;
        int devTypeIndex = this.deviceType.getSelectedIndex();
        Integer code = (Integer)this.setupCode.getValue();
        if (devTypeIndex != -1 && code != null) {
            List<Function> functions;
            this.upgrade = this.config.findDeviceUpgrade(devTypeIndex, code);
            Function func = null;
            if (this.upgrade != null && (functions = this.getValidFunctions(this.upgrade)).size() > 0) {
                this.function.removeActionListener(this);
                this.function.setModel(new DefaultComboBoxModel<Object>(functions.toArray()));
                this.useFunction.setVisible(true);
                if (this.cmd != null) {
                    func = this.upgrade.getFunction(this.cmd);
                    if (func != null) {
                        this.function.setSelectedItem(func);
                    } else {
                        this.function.setSelectedIndex(-1);
                    }
                }
                this.function.addActionListener(this);
            }
        }
        return this.upgrade;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Hex hex;
        Object source = event.getSource();
        if (source == this.setupCode) {
            if (!this.setupCode.isEditValid()) {
                String value = this.setupCode.getText();
                if (value != null) {
                    value = value.trim();
                }
                if (value == null || value.isEmpty()) {
                    this.setupCode.setValue(null);
                } else {
                    this.showWarning("Setup code " + value + " is invalid.  It must be an integer between 0 and " + SetupCode.getMax() + ".");
                }
            } else {
                this.checkForUpgrade();
            }
        } else if (source == this.efcField) {
            Integer value = (Integer)this.efcField.getValue();
            if (value != null) {
                this.cmd = this.use3DigitEFCs ? EFC.toHex(value) : EFC5.toHex(value);
            }
        } else if (source == this.hexField && (hex = (Hex)this.hexField.getValue()) != null) {
            this.cmd = (Hex)this.hexField.getValue();
        }
    }

    @Override
    public void run() {
        if (this.buttonToSelect != null) {
            this.buttonToSelect.setSelected(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        boolean isSelect = event.getStateChange() == 1;
        JRadioButton source = (JRadioButton)event.getSource();
        if (source == this.useEFC) {
            this.efcField.setVisible(isSelect);
        } else if (source == this.useHex) {
            this.hexField.setVisible(isSelect);
        } else if (source == this.useFunction) {
            this.function.setVisible(isSelect);
            this.setFunction();
        } else if (source == this.useKey) {
            this.movedKey.setVisible(isSelect);
            this.shiftMovedKey.setVisible(isSelect);
            this.xShiftMovedKey.setVisible(isSelect);
        }
        if (isSelect) {
            source.getParent().validate();
        }
    }
}

