/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.DeviceUpgradeEditor;
import com.hifiremote.jp1.DeviceUpgradePanel;
import com.hifiremote.jp1.KeyMove;
import com.hifiremote.jp1.KeyMoveDialog;
import com.hifiremote.jp1.KeyMoveTableModel;
import com.hifiremote.jp1.RMConfirmationDialog;
import com.hifiremote.jp1.RMTablePanel;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RemoteMaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class KeyMovePanel
extends RMTablePanel<KeyMove> {
    private KeyMovePanel thisPanel = null;
    private RemoteConfiguration remoteConfig = null;
    private JTextPane notesPane = null;
    protected Action detach = null;
    protected Action editUpgrade = null;
    private DeviceUpgradeEditor upgradeEditor = null;
    private final String MULTI_DEVICE_DETACH_CONFIRM = "At least one of the device upgrades of the attached key moves selected for\ndetachment is assigned to more than one device button.  The corresponding\nkey moves of the other device buttons will also be detached.  Are you sure\nthat you want to proceed?";
    private final String DELETE_ATTACHED_CONFIRM = "The key move you are attempting to delete is attached to a device upgrade.\nIf you delete it, it will first be detached and this can potentially leave\nthe function not bound to any key. Are you sure that you want to proceed?";

    public KeyMovePanel() {
        super(new KeyMoveTableModel());
        this.table.removeMouseListener(this.openEditor);
        this.table.getSelectionModel().removeListSelectionListener(this);
        this.thisPanel = this;
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                int row = KeyMovePanel.this.table.getSelectedRow();
                if (row != -1) {
                    row = KeyMovePanel.this.sorter.modelIndex(row);
                }
                if (row == -1 || row >= KeyMovePanel.this.remoteConfig.getKeyMoves().size()) {
                    return;
                }
                if (!KeyMovePanel.this.table.isCellEditable(row, KeyMovePanel.this.table.columnAtPoint(e.getPoint()))) {
                    KeyMovePanel.this.editRowObject(row);
                }
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                KeyMovePanel.this.thisPanel.valueChanged(e);
                int[] rows = KeyMovePanel.this.table.getSelectedRows();
                boolean enableDetach = rows.length > 0;
                int limit = KeyMovePanel.this.remoteConfig.getKeyMoves().size();
                for (int tableRow : rows) {
                    int row = KeyMovePanel.this.sorter.modelIndex(tableRow);
                    if (row >= limit) {
                        KeyMovePanel.this.editButton.setEnabled(false);
                        KeyMovePanel.this.editItem.setEnabled(false);
                        KeyMovePanel.this.cloneButton.setEnabled(false);
                        KeyMovePanel.this.cloneItem.setEnabled(false);
                        KeyMovePanel.this.upButton.setEnabled(false);
                        KeyMovePanel.this.downButton.setEnabled(false);
                    } else if (row == limit - 1) {
                        KeyMovePanel.this.downButton.setEnabled(false);
                    }
                    if (row >= limit) continue;
                    enableDetach = false;
                }
                KeyMovePanel.this.detach.setEnabled(enableDetach);
                if (enableDetach) {
                    KeyMovePanel.this.editUpgrade.setEnabled(true);
                    int type = -1;
                    int code = -1;
                    for (int tableRow : rows) {
                        KeyMove km = (KeyMove)KeyMovePanel.this.getRowObject(tableRow);
                        if (type == -1) {
                            type = km.getDeviceType();
                            code = km.getSetupCode();
                            continue;
                        }
                        if (type == km.getDeviceType() && code == km.getSetupCode()) continue;
                        KeyMovePanel.this.editUpgrade.setEnabled(false);
                        break;
                    }
                } else {
                    KeyMovePanel.this.editUpgrade.setEnabled(false);
                }
            }
        });
        this.detach = new DetachAction();
        this.buttonPanel.add(new JButton(this.detach));
        this.detach.setEnabled(false);
        this.popup.add(this.detach);
        this.editUpgrade = new EditUpgradeAction();
        this.buttonPanel.add(new JButton(this.editUpgrade));
        this.editUpgrade.setEnabled(false);
        this.popup.add(this.editUpgrade);
        this.notesPane = new JTextPane();
        this.footerPanel.add((Component)this.notesPane, "First");
        this.notesPane.setBackground(this.getBackground());
        this.notesPane.setForeground(Color.BLACK);
        this.notesPane.setVisible(true);
    }

    @Override
    protected boolean showPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.finishEditing();
            this.popupRow = this.table.rowAtPoint(e.getPoint());
            int limit = this.remoteConfig.getKeyMoves().size();
            if (this.table.isRowSelected(this.popupRow)) {
                boolean canDetach = true;
                for (int row : this.table.getSelectedRows()) {
                    if (this.sorter.modelIndex(row) >= limit) continue;
                    canDetach = false;
                }
                this.detach.setEnabled(canDetach);
                if (canDetach) {
                    this.editUpgrade.setEnabled(true);
                    int type = -1;
                    int code = -1;
                    for (int tableRow : this.table.getSelectedRows()) {
                        KeyMove km = (KeyMove)this.getRowObject(tableRow);
                        if (type == -1) {
                            type = km.getDeviceType();
                            code = km.getSetupCode();
                            continue;
                        }
                        if (type == km.getDeviceType() && code == km.getSetupCode()) continue;
                        this.editUpgrade.setEnabled(false);
                        break;
                    }
                }
            } else {
                int row = this.sorter.modelIndex(this.popupRow);
                this.detach.setEnabled(row >= limit);
                if (this.detach.isEnabled()) {
                    this.editUpgrade.setEnabled(true);
                    int type = -1;
                    int code = -1;
                    KeyMove km = (KeyMove)this.getRowObject(this.popupRow);
                    if (type == -1) {
                        type = km.getDeviceType();
                        code = km.getSetupCode();
                    } else if (type != km.getDeviceType() || code != km.getSetupCode()) {
                        this.editUpgrade.setEnabled(false);
                    }
                }
            }
            this.popup.show(this.table, e.getX(), e.getY());
            return true;
        }
        return false;
    }

    @Override
    public void set(RemoteConfiguration remoteConfig) {
        ((KeyMoveTableModel)this.model).set(remoteConfig);
        this.remoteConfig = remoteConfig;
        Remote remote = remoteConfig.getRemote();
        this.table.initColumns(this.model);
        boolean learned = remote.hasLearnedSupport();
        boolean special = remote.getSpecialProtocols() != null;
        String notes = "Key Moves with Device Button and Key values shaded Pink (if selected, Red) conflict with another Key Move on the same Device Button/Key combination that has higher priority, so that Key Move will be saved in a .rmir file but not uploaded to the remote.";
        if (learned || special) {
            notes = notes + "  If shaded Orange (if selected, Brown) there is such a conflict with a ";
            notes = notes + (learned && special ? "Special Function or Learned Signal" : (learned ? "Learned Signal" : "Special Function"));
            notes = notes + ".  This is for information only, as both will be uploaded but they may not work as intended.";
        }
        notes = notes + "\n\nKey moves with other values shaded Light Grey (if selected, Dark Grey) are attached to a device upgrade.  In this panel they can be detached from the upgrade or can be deleted, but other editing can only be performed in the Device Upgrade Editor, which can be opened for the upgrade concerned by pressing the Edit Upgrade button";
        this.notesPane.setText(notes);
    }

    @Override
    protected KeyMove createRowObject(KeyMove baseKeyMove) {
        return KeyMoveDialog.showDialog((JFrame)SwingUtilities.getRoot(this), baseKeyMove, ((KeyMoveTableModel)this.model).getRemoteConfig());
    }

    @Override
    protected KeyMove newRowObject(KeyMove baseObject, int row, int modelRow, boolean select) {
        KeyMove km = this.createRowObject(baseObject);
        if (km == null) {
            return null;
        }
        int upgradeKeyMoveCount = ((KeyMoveTableModel)this.model).getUpgradeKeyMoveCount();
        int effectiveEnd = this.model.getRowCount() - upgradeKeyMoveCount;
        if (row == -1 || modelRow >= effectiveEnd) {
            if (upgradeKeyMoveCount == 0) {
                this.model.addRow(km);
                row = this.model.getRowCount();
            } else {
                this.model.insertRow(effectiveEnd, km);
                ++row;
            }
        } else {
            this.model.insertRow(modelRow, km);
        }
        if (select) {
            this.table.setRowSelectionInterval(row, row);
        }
        return km;
    }

    @Override
    protected void deleteRow(int row, boolean select) {
        int limit = this.remoteConfig.getKeyMoves().size();
        int modelRow = this.sorter.modelIndex(row);
        int colFirst = this.table.getSelectedColumn();
        int colCount = this.table.getSelectedColumnCount();
        int rowToSelect = row;
        if (rowToSelect == this.sorter.getRowCount() - 1) {
            --rowToSelect;
        }
        if (modelRow >= limit) {
            KeyMove keyMove = (KeyMove)this.model.getRow(this.sorter.modelIndex(row));
            if (RMConfirmationDialog.show("Delete Key Move from Device Upgrade", "The key move you are attempting to delete is attached to a device upgrade.\nIf you delete it, it will first be detached and this can potentially leave\nthe function not bound to any key. Are you sure that you want to proceed?", 0, "SuppressKeyMovePrompts")) {
                if (!this.DetachKeyMoves(new int[]{row})) {
                    return;
                }
            } else {
                return;
            }
            ((KeyMoveTableModel)this.model).refresh();
            this.model.fireTableDataChanged();
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                if (!((KeyMove)this.model.getRow(this.sorter.modelIndex(i))).equals(keyMove)) continue;
                super.deleteRow(i, false);
                break;
            }
        } else {
            super.deleteRow(row, false);
        }
        ((KeyMoveTableModel)this.model).refresh();
        this.model.fireTableDataChanged();
        if (select && rowToSelect > -1) {
            this.table.setRowSelectionInterval(rowToSelect, rowToSelect);
            this.table.setColumnSelectionInterval(colFirst, colFirst + colCount - 1);
        }
    }

    private boolean DetachKeyMoves(int[] rows) {
        List<KeyMove> keymoves = this.remoteConfig.getKeyMoves();
        ArrayList<KeyMove> toDetach = new ArrayList<KeyMove>(rows.length);
        ArrayList<KeyMove> alsoDetach = new ArrayList<KeyMove>();
        for (int row : rows) {
            KeyMove keyMove = (KeyMove)this.model.getRow(this.sorter.modelIndex(row));
            toDetach.add(keyMove);
            DeviceButton db = this.remoteConfig.getRemote().getDeviceButton(keyMove.getDeviceButtonIndex());
            DeviceUpgrade upgrade = this.remoteConfig.findDeviceUpgrade(db);
            block1: for (int i : this.remoteConfig.getDeviceButtonIndexList(upgrade)) {
                if (i == keyMove.getDeviceButtonIndex()) continue;
                for (int test = keymoves.size(); test < this.model.getData().size(); ++test) {
                    KeyMove km = (KeyMove)this.model.getData().get(test);
                    if (km.getDeviceButtonIndex() != i || km.getKeyCode() != keyMove.getKeyCode()) continue;
                    alsoDetach.add(km);
                    continue block1;
                }
            }
        }
        Iterator it = alsoDetach.iterator();
        while (it.hasNext()) {
            KeyMove km = (KeyMove)it.next();
            if (!toDetach.contains(km)) continue;
            it.remove();
        }
        if (!alsoDetach.isEmpty() && RMConfirmationDialog.show("Detach Key Moves from Device Upgrades", "At least one of the device upgrades of the attached key moves selected for\ndetachment is assigned to more than one device button.  The corresponding\nkey moves of the other device buttons will also be detached.  Are you sure\nthat you want to proceed?", 1, "SuppressKeyMovePrompts")) {
            return false;
        }
        Object object = toDetach.iterator();
        while (object.hasNext()) {
            KeyMove keyMove = (KeyMove)object.next();
            DeviceUpgrade upgrade = this.remoteConfig.findDeviceUpgrade(keyMove.getDeviceType(), keyMove.getSetupCode());
            keymoves.add(keyMove);
            DeviceButton db = this.remoteConfig.getRemote().getDeviceButton(keyMove.getDeviceButtonIndex());
            upgrade = this.remoteConfig.findDeviceUpgrade(db);
            upgrade.setFunction(keyMove.getKeyCode(), null);
        }
        keymoves.addAll(alsoDetach);
        return true;
    }

    public void endEditUpgrade() {
        this.editUpgrade.setEnabled(false);
        ((KeyMoveTableModel)this.model).refresh();
        this.model.fireTableDataChanged();
    }

    public DeviceUpgradeEditor getDeviceUpgradeEditor() {
        return this.upgradeEditor;
    }

    protected class DetachAction
    extends AbstractAction {
        public DetachAction() {
            super("Detach");
            this.putValue("ShortDescription", "Detach from upgrade");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            AbstractButton source = (AbstractButton)event.getSource();
            int[] rows = new int[]{KeyMovePanel.this.popupRow};
            if (source instanceof JButton) {
                rows = KeyMovePanel.this.table.getSelectedRows();
            } else if (source instanceof JMenuItem && KeyMovePanel.this.table.isRowSelected(KeyMovePanel.this.popupRow)) {
                rows = KeyMovePanel.this.table.getSelectedRows();
            }
            KeyMovePanel.this.DetachKeyMoves(rows);
            ((KeyMoveTableModel)KeyMovePanel.this.model).refresh();
            KeyMovePanel.this.model.fireTableDataChanged();
        }
    }

    protected class EditUpgradeAction
    extends AbstractAction {
        public EditUpgradeAction() {
            super("Edit Upgrade");
            this.putValue("ShortDescription", "Edit attached upgrade");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            AbstractButton source = (AbstractButton)event.getSource();
            int[] rows = new int[]{KeyMovePanel.this.popupRow};
            if (source instanceof JButton) {
                rows = KeyMovePanel.this.table.getSelectedRows();
            } else if (source instanceof JMenuItem && KeyMovePanel.this.table.isRowSelected(KeyMovePanel.this.popupRow)) {
                rows = KeyMovePanel.this.table.getSelectedRows();
            }
            if (rows.length == 0) {
                return;
            }
            KeyMove km = (KeyMove)KeyMovePanel.this.getRowObject(rows[0]);
            DeviceButton db = KeyMovePanel.this.remoteConfig.getRemote().getDeviceButton(km.getDeviceButtonIndex());
            if (db == null) {
                return;
            }
            DeviceUpgrade kmUpgrade = KeyMovePanel.this.remoteConfig.findDeviceUpgrade(db);
            DeviceUpgrade fnUpgrade = null;
            for (DeviceUpgrade du : KeyMovePanel.this.remoteConfig.getDeviceUpgrades()) {
                if (du.getDeviceType().getNumber() != km.getDeviceType() || du.getSetupCode() != km.getSetupCode()) continue;
                fnUpgrade = du;
                break;
            }
            DeviceUpgrade oldUpgrade = kmUpgrade;
            if (fnUpgrade != null && kmUpgrade != null && fnUpgrade != kmUpgrade) {
                String message = "This keymove is an External Function defined in one upgrade that performs a Function\ndefined in another upgrade.  Do you want to edit the upgrade with the External Function\nor the original upgrade where the function is defined?";
                String title = "Upgrade Selector";
                Object[] options = new String[]{"External Function", "Original Upgrade"};
                int result = JOptionPane.showOptionDialog(RemoteMaster.getFrame(), message, title, -1, -1, null, options, options[0]);
                DeviceUpgrade deviceUpgrade = result == 0 ? kmUpgrade : (oldUpgrade = result == 1 ? fnUpgrade : null);
            }
            if (oldUpgrade != null) {
                DeviceUpgradePanel dup = KeyMovePanel.this.remoteConfig.getOwner().getDeviceUpgradePanel();
                int dupRow = dup.getRow(oldUpgrade);
                dup.editRowObject(dupRow);
            }
        }
    }
}

