/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.DeviceType;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JP1TableModel;
import com.hifiremote.jp1.KeyEditor;
import com.hifiremote.jp1.KeyMove;
import com.hifiremote.jp1.KeyMoveEFC5;
import com.hifiremote.jp1.RMColorEditor;
import com.hifiremote.jp1.RMColorRenderer;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RowNumberRenderer;
import com.hifiremote.jp1.SelectAllCellEditor;
import com.hifiremote.jp1.SetupCode;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class KeyMoveTableModel
extends JP1TableModel<KeyMove> {
    private static String[] colNames = new String[]{"#", "<html>Device<br>Button</html>", "Key", "<html>Device<br>Type</html>", "<html>Setup<br>Code</html>", "Raw Data", "Hex", "<html>EFC, Key, or<br>Function Name</html>", "Notes", "<html>Size &amp<br>Color</html>"};
    private static final String[] colPrototypeNames = new String[]{" 00 ", "__VCR/DVD__", "_xshift-Thumbs_Down_", "__VCR/DVD__", "Setup", "00 (key code)___", "FF FF", "xshift-CBL/SAT", "A reasonable length long note", "Color_"};
    private static boolean[] colWidths = new boolean[]{true, true, false, true, true, true, true, false, false, true};
    private static final Class<?>[] colClasses = new Class[]{Integer.class, DeviceButton.class, Integer.class, DeviceType.class, SetupCode.class, Hex.class, Hex.class, String.class, String.class, Color.class};
    private RemoteConfiguration remoteConfig = null;
    private JComboBox deviceButtonBox = new JComboBox();
    private JComboBox deviceTypeBox = new JComboBox();
    private int upgradeKeyMoveCount = 0;
    private List<KeyMove> allKeyMoves = null;
    private KeyEditor keyEditor = new KeyEditor();
    private SelectAllCellEditor selectAllEditor = new SelectAllCellEditor();
    private RMColorEditor colorEditor = null;
    private RMColorRenderer colorRenderer = new RMColorRenderer();

    public void set(RemoteConfiguration remoteConfig) {
        this.remoteConfig = remoteConfig;
        if (remoteConfig != null) {
            this.colorEditor = new RMColorEditor(remoteConfig.getOwner());
            Remote remote = remoteConfig.getRemote();
            this.deviceButtonBox.setModel(new DefaultComboBoxModel<DeviceButton>(remoteConfig.getAllowedDeviceButtons()));
            this.highlightKeyRenderer.setRemote(remote);
            this.keyEditor.setRemote(remote);
            this.deviceTypeBox.setModel(new DefaultComboBoxModel<DeviceType>(remote.getDeviceTypes()));
            StringBuilder sb = new StringBuilder("<html>EFC");
            if (remote.getEFCDigits() == 5) {
                sb.append("-5");
            }
            if (remote.supportsKeyCodeKeyMoves()) {
                sb.append(", Key");
            }
            sb.append(" or<br/>Function Name</html>");
            KeyMoveTableModel.colNames[7] = sb.toString();
            this.refresh();
            this.setData(this.allKeyMoves);
        }
    }

    public void refresh() {
        this.remoteConfig.setUpgradeKeyMoves();
        this.allKeyMoves = new ArrayList<KeyMove>(this.remoteConfig.getKeyMoves());
        this.allKeyMoves.addAll(this.remoteConfig.getUpgradeKeyMoves());
        this.upgradeKeyMoveCount = this.remoteConfig.getUpgradeKeyMoves().size();
        this.data = this.allKeyMoves;
    }

    public RemoteConfiguration getRemoteConfig() {
        return this.remoteConfig;
    }

    @Override
    public int getColumnCount() {
        int count = colNames.length - 1;
        if (this.remoteConfig != null && this.remoteConfig.allowHighlighting()) {
            ++count;
        }
        return count;
    }

    @Override
    public String getColumnName(int col) {
        return colNames[col];
    }

    @Override
    public String getColumnPrototypeName(int col) {
        return colPrototypeNames[col];
    }

    @Override
    public boolean isColumnWidthFixed(int col) {
        return colWidths[col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return colClasses[col];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (row >= this.remoteConfig.getKeyMoves().size() && col < 9) {
            return false;
        }
        return col != 0 && (col <= 2 || col >= 8);
    }

    @Override
    public Object getValueAt(int row, int column) {
        KeyMove keyMove = (KeyMove)this.getRow(row);
        Remote r = this.remoteConfig.getRemote();
        switch (column) {
            case 0: {
                return new Integer(row + 1);
            }
            case 1: {
                return r.getDeviceButton(keyMove.getDeviceButtonIndex());
            }
            case 2: {
                return new Integer(keyMove.getKeyCode());
            }
            case 3: {
                return r.getDeviceTypeByIndex(keyMove.getDeviceType());
            }
            case 4: {
                return new SetupCode(keyMove.getSetupCode() + r.getDeviceCodeOffset());
            }
            case 5: {
                Hex data = keyMove.getData();
                if (r.getSegmentTypes() == null && keyMove instanceof KeyMoveEFC5) {
                    return data.subHex(0, data.length() - 1);
                }
                return data;
            }
            case 6: {
                return keyMove.getCmd();
            }
            case 7: {
                return keyMove.getValueString(this.remoteConfig);
            }
            case 8: {
                return keyMove.getNotes();
            }
            case 9: {
                return keyMove.getHighlight();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        KeyMove keyMove = (KeyMove)this.getRow(row);
        if (col == 1) {
            Remote r = this.remoteConfig.getRemote();
            DeviceButton[] deviceButtons = r.getDeviceButtons();
            for (int i = 0; i < deviceButtons.length; ++i) {
                if (deviceButtons[i] != value) continue;
                keyMove.setDeviceButtonIndex(deviceButtons[i].getButtonIndex());
                break;
            }
        } else if (col == 2) {
            keyMove.setKeyCode((Integer)value);
        } else if (col == 3) {
            keyMove.setDeviceType(((DeviceType)value).getNumber());
        } else if (col == 4) {
            Remote r = this.remoteConfig.getRemote();
            SetupCode setupCode = null;
            setupCode = value.getClass() == String.class ? new SetupCode((String)value, false) : (SetupCode)value;
            keyMove.setSetupCode(setupCode.getValue() - r.getDeviceCodeOffset());
        } else if (col == 8) {
            keyMove.setNotes((String)value);
        } else if (col == 9) {
            keyMove.setHighlight((Color)value);
            if (row >= this.remoteConfig.getKeyMoves().size()) {
                Remote remote = this.remoteConfig.getRemote();
                DeviceButton boundDeviceButton = remote.getDeviceButton(keyMove.getDeviceButtonIndex());
                DeviceUpgrade boundUpgrade = this.remoteConfig.findDeviceUpgrade(boundDeviceButton);
                boundUpgrade.setAssignmentColor(keyMove.getKeyCode(), keyMove.getDeviceButtonIndex(), (Color)value);
            }
        } else {
            return;
        }
        this.propertyChangeSupport.firePropertyChange(col == 9 ? "highlight" : "data", null, null);
    }

    @Override
    public TableCellEditor getColumnEditor(int col) {
        if (col == 1) {
            DefaultCellEditor editor = new DefaultCellEditor(this.deviceButtonBox);
            editor.setClickCountToStart(2);
            return editor;
        }
        if (col == 2) {
            return this.keyEditor;
        }
        if (col == 3) {
            DefaultCellEditor editor = new DefaultCellEditor(this.deviceTypeBox);
            editor.setClickCountToStart(2);
            return editor;
        }
        if (col == 4 || col == 8) {
            return this.selectAllEditor;
        }
        if (col == 9) {
            return this.colorEditor;
        }
        return null;
    }

    @Override
    public TableCellRenderer getColumnRenderer(int col) {
        if (col == 0) {
            return new RowNumberRenderer();
        }
        if (col == 2) {
            return this.highlightKeyRenderer;
        }
        if (col == 9) {
            return this.colorRenderer;
        }
        return this.highlightRenderer;
    }

    public void resetKeyMoves() {
        ArrayList<KeyMove> keymoves = new ArrayList<KeyMove>();
        keymoves.addAll(this.allKeyMoves.subList(0, this.allKeyMoves.size() - this.upgradeKeyMoveCount));
        this.remoteConfig.setKeyMoves(keymoves);
    }

    public int getUpgradeKeyMoveCount() {
        return this.upgradeKeyMoveCount;
    }
}

