/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.KeyMove;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.SpecialFunctionDialog;
import com.hifiremote.jp1.SpecialProtocolFunction;
import java.util.Properties;

public class LDKPFunction
extends SpecialProtocolFunction {
    public static int LKP = 0;
    public static int DKP = 1;
    public static String[] styleStrings = new String[]{"LKP", "DKP"};
    public static String[] firstStrings = new String[]{"Short", "Single"};
    public static String[] secondStrings = new String[]{"Long", "Double"};

    public LDKPFunction(KeyMove keyMove) {
        super(keyMove);
    }

    public LDKPFunction(Macro macro) {
        super(macro);
    }

    public LDKPFunction(int keyCode, int deviceButtonIndex, int deviceType, int setupCode, Hex cmd, String notes) {
        super(keyCode, deviceButtonIndex, deviceType, setupCode, cmd, notes);
    }

    public LDKPFunction(Properties props, Remote remote) {
        super(props, remote);
    }

    public int getDuration() {
        return this.getCmd().getData()[0] >> 4;
    }

    public int getStyle() {
        return (this.getCmd().getData()[0] & 8) >> 3;
    }

    public int getFirstLength() {
        return this.getCmd().getData()[0] & 7;
    }

    @Override
    public String get_Type(RemoteConfiguration remoteConfig) {
        return this.getUserFunctions(remoteConfig)[this.getStyle()];
    }

    @Override
    public String getDisplayType(RemoteConfiguration remoteConfig) {
        int style = this.getStyle();
        StringBuilder buff = new StringBuilder();
        buff.append(this.getUserFunctions(remoteConfig)[style]);
        buff.append('(');
        buff.append(Integer.toString(this.getDuration()));
        buff.append(')');
        return buff.toString();
    }

    @Override
    public String getValueString(RemoteConfiguration remoteConfig) {
        int i;
        Remote remote = remoteConfig.getRemote();
        StringBuilder buff = new StringBuilder();
        short[] vals = this.getCmd().getData();
        int style = this.getStyle();
        buff.append('[');
        buff.append(firstStrings[style]);
        buff.append("]:");
        int firstLength = this.getFirstLength();
        if (firstLength == 0) {
            buff.append("<none>");
        }
        for (i = 0; i < firstLength; ++i) {
            if (i != 0) {
                buff.append(';');
            }
            buff.append(remote.getButtonName(vals[i + 1]));
        }
        buff.append(" [");
        buff.append(secondStrings[style]);
        buff.append("]:");
        if (i == vals.length - 1) {
            buff.append("<none>");
        }
        while (i + 1 < vals.length) {
            if (i != firstLength) {
                buff.append(';');
            }
            buff.append(remote.getButtonName(vals[i + 1]));
            ++i;
        }
        return buff.toString();
    }

    @Override
    public void update(SpecialFunctionDialog dlg) {
        int i;
        dlg.setDuration(this.getDuration());
        short[] vals = this.getCmd().getData();
        int firstLength = vals[0] & 7;
        int secondLength = vals.length - firstLength - 1;
        int offset = 1;
        Integer[] temp = new Integer[firstLength];
        for (i = 0; i < firstLength; ++i) {
            temp[i] = new Integer(vals[offset++]);
        }
        dlg.setFirstMacroButtons(temp);
        temp = new Integer[secondLength];
        for (i = 0; i < secondLength; ++i) {
            temp[i] = new Integer(vals[offset++]);
        }
        dlg.setSecondMacroButtons(temp);
    }

    public static Hex createHex(SpecialFunctionDialog dlg) {
        int i;
        String type = dlg.get_Type();
        int style = LKP;
        for (int i2 = 0; i2 < styleStrings.length; ++i2) {
            if (!styleStrings[i2].equals(type)) continue;
            style = i2;
            break;
        }
        Integer[] firstKeyCodes = dlg.getFirstMacroButtons();
        Integer[] secondKeyCodes = dlg.getSecondMacroButtons();
        short[] temp = new short[1 + firstKeyCodes.length + secondKeyCodes.length];
        temp[0] = (short)(dlg.getDuration() << 4 | style << 3 | firstKeyCodes.length);
        int offset = 1;
        for (i = 0; i < firstKeyCodes.length; ++i) {
            temp[offset++] = firstKeyCodes[i].shortValue();
        }
        for (i = 0; i < secondKeyCodes.length; ++i) {
            temp[offset++] = secondKeyCodes[i].shortValue();
        }
        return new Hex(temp);
    }
}

