/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Activity;
import com.hifiremote.jp1.AdvancedCode;
import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.ButtonMap;
import com.hifiremote.jp1.ButtonPanel;
import com.hifiremote.jp1.ButtonShape;
import com.hifiremote.jp1.ButtonTableModel;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.DeviceType;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.Function;
import com.hifiremote.jp1.FunctionItem;
import com.hifiremote.jp1.FunctionLabel;
import com.hifiremote.jp1.GeneralFunction;
import com.hifiremote.jp1.GridFlowLayout;
import com.hifiremote.jp1.GridFlowPanel;
import com.hifiremote.jp1.ImageMap;
import com.hifiremote.jp1.JP1Frame;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.KMPanel;
import com.hifiremote.jp1.LearnedSignal;
import com.hifiremote.jp1.LocalObjectTransferable;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.WrapLayout;
import info.clearthought.layout.TableLayout;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LayoutPanel
extends KMPanel
implements ActionListener,
DocumentListener,
Runnable {
    private ImageMap[] maps = null;
    private ImageMap map = null;
    private int screenIndex = 0;
    private ButtonShape currentShape = null;
    private Box scrollPanel = null;
    private JButton scrollLeft = null;
    private JButton scrollRight = null;
    private ImagePanel imagePanel = null;
    private JPanel pagePanel = null;
    private JRadioButton pageUp = null;
    private JRadioButton pageDown = null;
    private JTextField pageNumber = null;
    private int page = 1;
    private JRadioButton normalMode = null;
    private JRadioButton shiftMode = null;
    private JRadioButton xShiftMode = null;
    private JTextField buttonName = null;
    private JTextField function = null;
    private JTextField device = null;
    private JTextField alias = null;
    private JLabel aliasLabel = null;
    private JP1Frame frame = null;
    private JButton autoAssign = null;
    private AbstractAction deleteAction = null;
    private JPopupMenu popup = null;
    private JPanel functionPanel = null;
    private JScrollPane scrollPane = null;
    private JSplitPane splitPane = null;
    private DoubleClickListener doubleClickListener = new DoubleClickListener();
    private ImageIcon image = null;
    private int minWidth = 0;
    private AffineTransform transform = null;
    private JPanel remotePanel = null;
    private ButtonPanel.SelectionPanel selector = null;
    private int dividerLocation = 0;
    private boolean updated = false;
    private JScrollPane functionScroll = null;
    private int rowHeight = 0;

    public LayoutPanel(DeviceUpgrade devUpgrade) {
        super("Layout", devUpgrade);
        double[] dArray;
        this.setLayout(new BorderLayout());
        this.imagePanel = new ImagePanel();
        this.imagePanel.setToolTipText("");
        this.imagePanel.setFocusable(true);
        this.imagePanel.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.deleteAction = new AbstractAction("Remove"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayoutPanel.this.setFunction(LayoutPanel.this.currentShape, null);
                LayoutPanel.this.doRepaint();
            }
        };
        this.imagePanel.getActionMap().put("delete", this.deleteAction);
        this.remotePanel = new JPanel(new BorderLayout());
        Remote remote = devUpgrade.getRemote();
        this.frame = RemoteMaster.getFrame();
        this.pagePanel = new JPanel(new GridLayout(2, 2));
        this.pagePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.pageDown = new JRadioButton("Page-");
        this.pageUp = new JRadioButton("Page+");
        this.pageDown.addActionListener(this);
        this.pageUp.addActionListener(this);
        this.pageDown.setEnabled(false);
        this.pageNumber = new JTextField();
        this.pageNumber.setText(Integer.toString(this.page));
        this.pageNumber.setEditable(false);
        this.pageNumber.setEnabled(false);
        this.pagePanel.add(this.pageDown);
        this.pagePanel.add(this.pageUp);
        this.pagePanel.add(new JLabel("Page:"));
        this.pagePanel.add(this.pageNumber);
        this.minWidth = this.pagePanel.getPreferredSize().width;
        this.remotePanel.add(Box.createHorizontalStrut(this.minWidth), "North");
        this.scrollPanel = Box.createHorizontalBox();
        this.remotePanel.add((Component)this.scrollPanel, "South");
        this.scrollLeft = new JButton("<");
        this.scrollLeft.setEnabled(false);
        this.scrollLeft.addActionListener(this);
        this.scrollPanel.add(this.scrollLeft);
        this.scrollPanel.add(Box.createHorizontalGlue());
        this.scrollPanel.add(new JLabel("Scroll"));
        this.scrollPanel.add(Box.createHorizontalGlue());
        this.scrollRight = new JButton(">");
        this.scrollRight.setEnabled(false);
        this.scrollRight.addActionListener(this);
        this.scrollPanel.add(this.scrollRight);
        int increment = new JLabel((String)"text").getPreferredSize().height;
        this.scrollPane = new JScrollPane(this.imagePanel, 22, 31);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(increment);
        this.scrollPane.getVerticalScrollBar().setBlockIncrement(increment * 3);
        this.remotePanel.add((Component)this.scrollPane, "Center");
        JPanel rightPanel = new JPanel(new BorderLayout());
        ComponentAdapter componentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                int width = ((LayoutPanel)LayoutPanel.this).scrollPane.getViewport().getExtentSize().width;
                if (LayoutPanel.this.updated) {
                    LayoutPanel.this.dividerLocation = LayoutPanel.this.splitPane.getDividerLocation();
                }
                Remote remote = LayoutPanel.this.deviceUpgrade.getRemote();
                int height = width * remote.getHeight() / remote.getWidth();
                Dimension d = new Dimension(width, height);
                LayoutPanel.this.imagePanel.setPreferredSize(d);
                if (width != remote.getWidth()) {
                    double scale = (double)width / (double)remote.getWidth();
                    LayoutPanel.this.transform = AffineTransform.getScaleInstance(scale, scale);
                } else {
                    LayoutPanel.this.transform = null;
                }
                LayoutPanel.this.scrollPane.revalidate();
            }
        };
        this.remotePanel.addComponentListener(componentListener);
        this.splitPane = new JSplitPane(1, this.remotePanel, rightPanel);
        this.add((Component)this.splitPane, "Center");
        Box box = Box.createVerticalBox();
        this.normalMode = new JRadioButton("Normal", true);
        this.shiftMode = new JRadioButton("Shift");
        this.xShiftMode = new JRadioButton("XShift");
        this.selector = new ButtonPanel.SelectionPanel(this, this);
        if (devUpgrade.getRemoteConfig() != null && devUpgrade.getRemote().usesEZRC()) {
            box.add(this.selector);
        } else {
            JPanel modePanel = new JPanel(new FlowLayout(0));
            modePanel.setBorder(BorderFactory.createTitledBorder("Mode"));
            ButtonGroup group = new ButtonGroup();
            this.normalMode.addActionListener(this);
            group.add(this.normalMode);
            modePanel.add(this.normalMode);
            this.shiftMode.addActionListener(this);
            group.add(this.shiftMode);
            modePanel.add(this.shiftMode);
            this.xShiftMode.addActionListener(this);
            group.add(this.xShiftMode);
            modePanel.add(this.xShiftMode);
            box.add(modePanel);
        }
        double b = 5.0;
        double c = 10.0;
        double pr = -2.0;
        double pf = -1.0;
        double[][] size = new double[][]{{b, pr, c, pf, b}, new double[0]};
        if (remote.usesEZRC()) {
            double[] dArray2 = new double[9];
            dArray2[0] = b;
            dArray2[1] = pr;
            dArray2[2] = b;
            dArray2[3] = pr;
            dArray2[4] = b;
            dArray2[5] = pr;
            dArray2[6] = b;
            dArray2[7] = pr;
            dArray = dArray2;
            dArray2[8] = b;
        } else {
            double[] dArray3 = new double[5];
            dArray3[0] = b;
            dArray3[1] = pr;
            dArray3[2] = b;
            dArray3[3] = pr;
            dArray = dArray3;
            dArray3[4] = b;
        }
        double[] rowSize = dArray;
        size[1] = rowSize;
        JPanel infoPanel = new JPanel(new TableLayout(size));
        JLabel label = new JLabel("Button:");
        label.setToolTipText("button label");
        infoPanel.add((Component)label, "1, 1");
        this.buttonName = new JTextField();
        this.buttonName.setEditable(false);
        infoPanel.add((Component)this.buttonName, "3, 1");
        String sRow = "3";
        if (this.frame instanceof RMIRSetup && remote.usesEZRC()) {
            infoPanel.add((Component)new JLabel("Device:"), "1, " + sRow);
            this.device = new JTextField();
            this.device.setEditable(false);
            infoPanel.add((Component)this.device, "3, " + sRow);
            if (remote.isSSD()) {
                sRow = "7";
                this.aliasLabel = new JLabel("Alias:");
                this.aliasLabel.setEnabled(false);
                infoPanel.add((Component)this.aliasLabel, "1, " + sRow);
                this.alias = new JTextField();
                this.alias.setEditable(true);
                this.alias.setEnabled(false);
                this.alias.getDocument().addDocumentListener(this);
                infoPanel.add((Component)this.alias, "3, " + sRow);
            }
            sRow = "5";
        }
        infoPanel.add((Component)new JLabel("Function:"), "1, " + sRow);
        this.function = new JTextField();
        this.function.setEditable(false);
        infoPanel.add((Component)this.function, "3, " + sRow);
        box.add(infoPanel);
        rightPanel.add((Component)box, "North");
        JPanel panel = new JPanel(new BorderLayout());
        label = new JLabel("Available Functions:");
        label.setToolTipText("available functions label");
        label.setBorder(BorderFactory.createEmptyBorder(2, 2, 3, 2));
        panel.add((Component)label, "North");
        rightPanel.add((Component)panel, "Center");
        JPanel outerPanel = new JPanel(new BorderLayout());
        this.functionPanel = new GridFlowPanel();
        this.functionScroll = new JScrollPane(this.functionPanel);
        outerPanel.add((Component)this.functionScroll, "Center");
        panel.add((Component)outerPanel, "Center");
        panel = new JPanel(new WrapLayout(1));
        this.autoAssign = new JButton("Auto assign");
        this.autoAssign.setToolTipText("Automatically assign functions to buttons, by matching names.");
        this.autoAssign.addActionListener(this);
        panel.add(this.autoAssign);
        JButton button = new JButton(this.deleteAction);
        button.setToolTipText("Remove the assigned function from the button.");
        panel.add(button);
        box = Box.createVerticalBox();
        box.add(new JSeparator());
        box.add(panel);
        rightPanel.add((Component)box, "South");
        LayoutDropTarget dropTarget = new LayoutDropTarget();
        dropTarget.setComponent(this.imagePanel);
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LayoutPanel.this.imagePanel.requestFocusInWindow();
                Point p = e.getPoint();
                ButtonShape savedShape = LayoutPanel.this.currentShape;
                LayoutPanel.this.currentShape = LayoutPanel.this.getShapeAtPoint(p);
                Button b = LayoutPanel.this.getButtonForShape(LayoutPanel.this.currentShape);
                if (b == null) {
                    LayoutPanel.this.currentShape = null;
                }
                if (LayoutPanel.this.currentShape == null) {
                    return;
                }
                if (LayoutPanel.this.currentShape != savedShape) {
                    LayoutPanel.this.setButtonText(LayoutPanel.this.currentShape, LayoutPanel.this.getButtonForShape(LayoutPanel.this.currentShape));
                    LayoutPanel.this.doRepaint();
                }
                this.showPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showPopup(e);
            }

            private void showPopup(MouseEvent e) {
                ButtonShape buttonShape;
                if (e.isPopupTrigger() && (buttonShape = LayoutPanel.this.getShapeAtPoint(e.getPoint())) != null && LayoutPanel.this.getButtonForShape(buttonShape) != null) {
                    LayoutPanel.this.currentShape = buttonShape;
                    LayoutPanel.this.doRepaint();
                    LayoutPanel.this.popup.show(LayoutPanel.this.imagePanel, e.getX(), e.getY());
                }
            }
        };
        this.imagePanel.addMouseListener(ml);
    }

    private GeneralFunction getFunction(Button b) {
        Remote remote = this.deviceUpgrade.getRemote();
        GeneralFunction f = null;
        if (this.normalMode.isSelected()) {
            Macro macro = null;
            if (remote.usesEZRC()) {
                LearnedSignal ls = this.deviceUpgrade.getLearnedMap().get(b.getKeyCode());
                if (ls != null) {
                    f = ls;
                }
                macro = this.deviceUpgrade.getMacroMap().get(b.getKeyCode());
                if (f == null && macro != null) {
                    GeneralFunction generalFunction = f = macro.isSystemMacro() ? macro.getItems().get((int)0).fn : macro;
                }
            }
            if (f == null) {
                f = this.deviceUpgrade.getFunction(b, 0);
            }
        } else if (this.shiftMode.isSelected()) {
            f = this.deviceUpgrade.getFunction(b, 1);
        } else if (this.xShiftMode.isSelected()) {
            f = this.deviceUpgrade.getFunction(b, 2);
        }
        return f;
    }

    @Override
    public void addFunction(GeneralFunction f) {
        if (f == null || f.hasData() && f.getName() != null && f.getName().length() > 0) {
            FunctionLabel l = f == null ? new FunctionLabel(null) : f.getLabel();
            l.addMouseListener(this.doubleClickListener);
            l.showAssigned(this.deviceUpgrade.getButtonRestriction());
            this.functionPanel.add(l);
            if (this.rowHeight == 0) {
                GridFlowLayout grid = (GridFlowLayout)this.functionPanel.getLayout();
                this.rowHeight = grid.preferredLayoutSize((Container)this.functionPanel).height;
                if (this.rowHeight > 0) {
                    this.functionScroll.getVerticalScrollBar().setUnitIncrement(this.rowHeight);
                    this.functionScroll.getVerticalScrollBar().setBlockIncrement(3 * this.rowHeight);
                }
            }
            FunctionItem item = f == null ? new FunctionItem(null) : f.getFunctionItem();
            item.addActionListener(this);
            this.popup.add(item);
        }
    }

    @Override
    public void revalidateFunctions() {
        this.functionPanel.revalidate();
    }

    private void setFunctions() {
        this.popup = new JPopupMenu();
        this.popup.setLayout(new GridLayout(0, 3));
        this.functionPanel.removeAll();
        this.selector.addFunctions();
    }

    private void enableScrollButtons() {
        if (this.maps.length > 1) {
            this.scrollPanel.setVisible(true);
            this.scrollLeft.setEnabled(this.screenIndex > 0);
            this.scrollRight.setEnabled(this.screenIndex < this.maps.length - 1);
        } else {
            this.scrollPanel.setVisible(false);
            this.scrollLeft.setEnabled(false);
            this.scrollRight.setEnabled(false);
        }
    }

    @Override
    public void update() {
        this.updated = true;
        Remote r = this.deviceUpgrade.getRemote();
        this.maps = r.getImageMaps(this.deviceUpgrade.getDeviceType());
        if (this.screenIndex >= this.maps.length) {
            this.screenIndex = this.maps.length - 1;
        }
        this.enableScrollButtons();
        this.map = this.maps[this.screenIndex];
        this.image = this.map.getImageFile() != null ? new ImageIcon(this.map.getImageFile().getAbsolutePath()) : null;
        double frameWidth = RemoteMaster.getFrame().getSize().getWidth();
        int imageWidth = r.getWidth() + this.scrollPane.getVerticalScrollBar().getWidth();
        int newWidth = this.dividerLocation > 0 ? this.dividerLocation : Math.min(imageWidth, (int)(frameWidth * 0.5));
        this.splitPane.setDividerLocation(Math.max(this.minWidth, newWidth));
        boolean found = false;
        for (ButtonShape shape : this.map.getShapes()) {
            if (this.currentShape != shape) continue;
            found = true;
            break;
        }
        if (!found) {
            this.currentShape = null;
        }
        this.setButtonText(this.currentShape, this.getButtonForShape(this.currentShape));
        if (!r.usesEZRC() || this.deviceUpgrade.getRemoteConfig() == null) {
            this.setFunctions();
            this.shiftMode.setText(r.getShiftLabel());
            if (r.getShiftEnabled()) {
                this.shiftMode.setEnabled(true);
            } else {
                this.shiftMode.setEnabled(false);
                if (this.shiftMode.isSelected()) {
                    this.normalMode.setSelected(true);
                }
            }
            this.xShiftMode.setText(r.getXShiftLabel());
            if (r.getXShiftEnabled()) {
                this.xShiftMode.setEnabled(true);
            } else {
                this.xShiftMode.setEnabled(false);
                if (this.xShiftMode.isSelected()) {
                    this.normalMode.setSelected(true);
                }
            }
        } else {
            this.selector.deviceBox.setSelectedItem(this.deviceUpgrade.getButtonRestriction());
        }
        boolean hasPagePanel = Arrays.asList(this.remotePanel.getComponents()).contains(this.pagePanel);
        if (r.isSSD() && !hasPagePanel) {
            this.remotePanel.add((Component)this.pagePanel, "First");
            this.remotePanel.revalidate();
        } else if (!r.isSSD() && hasPagePanel) {
            this.remotePanel.remove(this.pagePanel);
            this.remotePanel.revalidate();
        }
        this.doRepaint();
    }

    private void doRepaint() {
        this.imagePanel.repaint(0L, 0, 0, this.imagePanel.getWidth(), this.imagePanel.getHeight());
    }

    private void setButtonText(ButtonShape buttonShape, Button b) {
        Remote remote = this.deviceUpgrade.getRemote();
        if (buttonShape != null && b != null) {
            boolean doEnable;
            String name = buttonShape.getName();
            if (name == null) {
                if (this.normalMode.isSelected()) {
                    name = b.getName();
                } else if (this.shiftMode.isSelected()) {
                    name = b.getShiftedName();
                } else if (this.xShiftMode.isSelected()) {
                    name = b.getXShiftedName();
                }
            }
            this.buttonName.setText(name);
            GeneralFunction f = this.getFunction(b);
            boolean bl = doEnable = f != null;
            if (f != null) {
                this.function.setText(f.getDisplayName(this.deviceUpgrade.getRemote()));
            } else {
                this.function.setText("");
            }
            if (this.frame instanceof RMIRSetup && remote.usesEZRC()) {
                DeviceButton db;
                Activity activity;
                Macro macro = null;
                String aliasName = null;
                macro = this.deviceUpgrade.getMacroMap().get(b.getKeyCode());
                Activity activity2 = activity = macro != null ? macro.getActivity() : null;
                if (macro != null && !macro.isSystemMacro()) {
                    macro = null;
                }
                DeviceButton deviceButton = macro != null ? macro.getItems().get((int)0).db : (db = f != null && f.getUpgrade(remote) != null ? f.getUpgrade(remote).getButtonRestriction() : null);
                this.device.setText(activity != null ? "Activity: " + activity : (db != null ? db.getName() : null));
                if (this.alias != null) {
                    if (f != null && f instanceof Function && db != null) {
                        aliasName = db.getGeneralFunction(b).getName();
                        if (aliasName == null) {
                            db.getGeneralFunction(b).setName(f.getName());
                            aliasName = "";
                        } else if (aliasName.equals(f.getName())) {
                            aliasName = "";
                        }
                    }
                    this.alias.setText(aliasName);
                    this.alias.setEnabled(aliasName != null);
                    this.aliasLabel.setEnabled(aliasName != null);
                    String tip = "An alias is a display name for a function from a different device<br>that may differ from its name for its home device.<br><br>";
                    tip = tip + (aliasName != null ? "Edit this value to change the alias.</html>" : "This assignment does not permit an alias.");
                    this.alias.setToolTipText(JTableX.getHtmlToolTip(tip));
                }
                if (doEnable && f instanceof LearnedSignal) {
                    doEnable = ((LearnedSignal)f).getKeyCode() != b.getKeyCode();
                } else if (doEnable && f instanceof Macro) {
                    doEnable = ((Macro)f).getKeyCode() != b.getKeyCode();
                }
            }
            this.deleteAction.setEnabled(doEnable);
        } else {
            this.buttonName.setText("");
            this.function.setText("");
            if (this.frame instanceof RMIRSetup && remote.usesEZRC()) {
                this.device.setText("");
                if (this.alias != null) {
                    this.alias.setText("");
                }
            }
            this.deleteAction.setEnabled(false);
        }
    }

    public ButtonShape getShapeAtPoint(Point p) {
        ButtonMap buttonMap = this.deviceUpgrade.getDeviceType().getButtonMap();
        ButtonShape closestMatch = null;
        for (ButtonShape buttonShape : this.map.getShapes()) {
            Button b;
            Shape s = buttonShape.getShape();
            if (s == null) continue;
            if (this.transform != null) {
                s = this.transform.createTransformedShape(s);
            }
            if (!s.contains(p)) continue;
            if (closestMatch == null) {
                closestMatch = buttonShape;
            }
            if (!buttonMap.isPresent(b = this.getButtonForShape(buttonShape))) continue;
            return buttonShape;
        }
        return closestMatch;
    }

    public Button getButtonForShape(ButtonShape buttonShape) {
        int keyCode;
        if (buttonShape == null) {
            return null;
        }
        Remote remote = this.deviceUpgrade.getRemote();
        Button b = buttonShape.getButton();
        if (remote.isSSD() && remote.isSoftButton(b) && (keyCode = b.getKeyCode()) < 55) {
            b = remote.getButton(keyCode += 6 * (this.page - 1));
        }
        ButtonMap buttonMap = this.deviceUpgrade.getDeviceType().getButtonMap();
        if (!b.getIsNormal() && !this.normalMode.isSelected()) {
            return null;
        }
        if (this.normalMode.isSelected()) {
            if (b.allowsKeyMove() || buttonMap.isPresent(b)) {
                return b;
            }
        } else {
            if (this.shiftMode.isSelected()) {
                if (b.getIsNormal()) {
                    if (!b.allowsShiftedKeyMove()) {
                        return null;
                    }
                    if (b.getShiftedButton() != null) {
                        b = b.getShiftedButton();
                    } else {
                        return b;
                    }
                }
                if (b.getIsShifted()) {
                    if (b.allowsKeyMove() || buttonMap.isPresent(b)) {
                        return b.getBaseButton();
                    }
                    return null;
                }
                return null;
            }
            if (this.xShiftMode.isSelected()) {
                if (b.getIsNormal()) {
                    if (!b.allowsXShiftedKeyMove()) {
                        return null;
                    }
                    if (b.getXShiftedButton() != null) {
                        b = b.getXShiftedButton();
                    } else {
                        return b;
                    }
                }
                if (b.getIsXShifted()) {
                    if (b.allowsKeyMove() || buttonMap.isPresent(b)) {
                        return b.getBaseButton();
                    }
                } else if (b.allowsXShiftedKeyMove()) {
                    return b;
                }
            }
        }
        return null;
    }

    private void setFunction(ButtonShape shape, GeneralFunction gf) {
        Button b = this.getButtonForShape(shape);
        if (b != null) {
            if (this.normalMode.isSelected()) {
                GeneralFunction current = this.getFunction(b);
                ButtonTableModel.setFunction(this.deviceUpgrade, b, current, gf, this);
            } else if (this.shiftMode.isSelected() && (gf == null || gf instanceof Function)) {
                this.deviceUpgrade.setFunction(b, (Function)gf, 1);
            } else if (this.xShiftMode.isSelected() && (gf == null || gf instanceof Function)) {
                this.deviceUpgrade.setFunction(b, (Function)gf, 2);
            } else {
                return;
            }
            this.setButtonText(shape, b);
            this.deviceUpgrade.checkSize();
        }
    }

    public void updateAlias() {
        if (!this.alias.isEnabled()) {
            return;
        }
        String name = this.alias.getText();
        Button b = this.getButtonForShape(this.currentShape);
        if (name != null && b != null) {
            if (name.isEmpty()) {
                name = this.function.getText();
            }
            this.deviceUpgrade.getButtonRestriction().getGeneralFunction(b).setName(name);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateAlias();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateAlias();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateAlias();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        Remote remote = this.deviceUpgrade.getRemote();
        if (source == this.scrollLeft) {
            this.map = this.maps[--this.screenIndex];
            this.image = new ImageIcon(this.map.getImageFile().getAbsolutePath());
            this.enableScrollButtons();
            this.doRepaint();
        } else if (source == this.scrollRight) {
            this.map = this.maps[++this.screenIndex];
            this.image = new ImageIcon(this.map.getImageFile().getAbsolutePath());
            this.enableScrollButtons();
            this.doRepaint();
        } else if (source == this.autoAssign) {
            this.deviceUpgrade.autoAssignFunctions();
            this.doRepaint();
        } else if (source == this.normalMode || source == this.shiftMode || source == this.xShiftMode) {
            Button b = this.getButtonForShape(this.currentShape);
            if (b == null) {
                this.currentShape = null;
            }
            this.setButtonText(this.currentShape, b);
            this.doRepaint();
        } else if (source == this.pageUp) {
            ++this.page;
            this.pageUp.setSelected(false);
            this.pageUp.setEnabled(this.page < 5);
            this.pageDown.setEnabled(true);
            this.pageNumber.setText(Integer.toString(this.page));
            Button b = this.getButtonForShape(this.currentShape);
            if (remote.isSoftButton(b)) {
                this.currentShape = null;
                this.setButtonText(null, b);
            }
            this.doRepaint();
        } else if (source == this.pageDown) {
            --this.page;
            this.pageDown.setSelected(false);
            this.pageUp.setEnabled(true);
            this.pageDown.setEnabled(this.page > 1);
            this.pageNumber.setText(Integer.toString(this.page));
            Button b = this.getButtonForShape(this.currentShape);
            if (remote.isSoftButton(b)) {
                this.currentShape = null;
                this.setButtonText(null, b);
            }
            this.doRepaint();
        } else if (source == this.selector.deviceBox || source instanceof JRadioButton) {
            this.setFunctions();
            this.functionPanel.revalidate();
        } else {
            this.setFunction(this.currentShape, ((FunctionItem)source).getFunction());
            this.doRepaint();
        }
    }

    @Override
    public void run() {
        this.doRepaint();
    }

    private class ImagePanel
    extends JPanel
    implements Scrollable {
        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Remote r = LayoutPanel.this.deviceUpgrade.getRemote();
            if (LayoutPanel.this.transform != null) {
                g2.transform(LayoutPanel.this.transform);
            }
            if (LayoutPanel.this.image != null) {
                g2.drawImage(LayoutPanel.this.image.getImage(), null, null);
            }
            g2.setPaint(Color.darkGray);
            for (ButtonShape shape : r.getPhantomShapes()) {
                g2.fill(shape.getShape());
            }
            if (LayoutPanel.this.currentShape != null) {
                g2.setPaint(Color.white);
                g2.setStroke(new BasicStroke(6.0f, 1, 1));
                g2.draw(LayoutPanel.this.currentShape.getShape());
            }
            g2.setStroke(new BasicStroke(2.0f, 1, 1));
            DeviceType devType = LayoutPanel.this.deviceUpgrade.getDeviceType();
            ButtonMap buttonMap = devType.getButtonMap();
            for (ButtonShape buttonShape : LayoutPanel.this.map.getShapes()) {
                Button b = LayoutPanel.this.getButtonForShape(buttonShape);
                if (b == null) continue;
                Shape s = buttonShape.getShape();
                GeneralFunction f = LayoutPanel.this.getFunction(b);
                if (f != null) {
                    g2.setPaint(Color.yellow);
                    g2.fill(s);
                }
                if (LayoutPanel.this.shiftMode.isSelected()) {
                    b = b.getShiftedButton();
                } else if (LayoutPanel.this.xShiftMode.isSelected()) {
                    b = b.getXShiftedButton();
                }
                if (!buttonMap.isPresent(b)) continue;
                if (LayoutPanel.this.currentShape != null && s == LayoutPanel.this.currentShape.getShape()) {
                    g2.setPaint(Color.white);
                    g2.setStroke(new BasicStroke(6.0f, 1, 1));
                    g2.draw(LayoutPanel.this.currentShape.getShape());
                    g2.setStroke(new BasicStroke(2.0f, 1, 1));
                }
                g2.setPaint(Color.orange);
                g2.draw(s);
            }
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            Remote remote = LayoutPanel.this.deviceUpgrade.getRemote();
            ButtonShape buttonShape = LayoutPanel.this.getShapeAtPoint(e.getPoint());
            if (buttonShape == null) {
                return null;
            }
            Button b = LayoutPanel.this.getButtonForShape(buttonShape);
            if (b == null) {
                return null;
            }
            String name = buttonShape.getName();
            if (name == null) {
                if (LayoutPanel.this.normalMode.isSelected()) {
                    name = b.getName();
                } else if (LayoutPanel.this.shiftMode.isSelected()) {
                    name = b.getShiftedName();
                } else if (LayoutPanel.this.xShiftMode.isSelected()) {
                    name = b.getXShiftedName();
                }
            }
            GeneralFunction f = LayoutPanel.this.getFunction(b);
            String text = name;
            if (f != null) {
                if (LayoutPanel.this.frame instanceof RMIRSetup && remote.usesEZRC()) {
                    AdvancedCode macro = null;
                    if (f instanceof Function && (macro = LayoutPanel.this.deviceUpgrade.getMacroMap().get(b.getKeyCode())) != null && !((Macro)macro).isSystemMacro()) {
                        macro = null;
                    }
                    DeviceButton db = macro != null ? macro.getItems().get((int)0).db : f.getUpgrade(remote).getButtonRestriction();
                    text = "Button: " + name;
                    text = text + "<br>Device: " + db.getName();
                    text = text + "<br>Function: " + f.getDisplayName(remote);
                    if (macro != null) {
                        text = text + "<br>Alias: " + macro.getName();
                    }
                } else {
                    text = name + " = " + f.getDisplayName(remote);
                }
            }
            return JTableX.getHtmlToolTip(text);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 1;
        }
    }

    class DoubleClickListener
    extends MouseAdapter {
        DoubleClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (LayoutPanel.this.currentShape != null && e.getClickCount() >= 2) {
                Button button = LayoutPanel.this.getButtonForShape(LayoutPanel.this.currentShape);
                if (button == null) {
                    return;
                }
                Function f = (Function)((FunctionLabel)e.getSource()).getFunction();
                LayoutPanel.this.setFunction(LayoutPanel.this.currentShape, f);
            }
            LayoutPanel.this.doRepaint();
        }
    }

    class LayoutDropTarget
    extends DropTarget {
        public LayoutDropTarget() {
            this.setDefaultActions(1);
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            Point p = dtde.getLocation();
            LayoutPanel.this.currentShape = LayoutPanel.this.getShapeAtPoint(p);
            Button button = LayoutPanel.this.getButtonForShape(LayoutPanel.this.currentShape);
            if (button != null) {
                dtde.acceptDrag(dtde.getDropAction());
            } else {
                LayoutPanel.this.currentShape = null;
                dtde.rejectDrag();
            }
            LayoutPanel.this.doRepaint();
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Point p = dtde.getLocation();
            LayoutPanel.this.currentShape = LayoutPanel.this.getShapeAtPoint(p);
            Button button = LayoutPanel.this.getButtonForShape(LayoutPanel.this.currentShape);
            if (button != null) {
                int action = dtde.getDropAction();
                dtde.acceptDrop(action);
                Transferable tf = dtde.getTransferable();
                try {
                    GeneralFunction f = (GeneralFunction)tf.getTransferData(LocalObjectTransferable.getFlavor());
                    LayoutPanel.this.setFunction(LayoutPanel.this.currentShape, f);
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            } else {
                dtde.rejectDrop();
            }
            LayoutPanel.this.doRepaint();
        }
    }
}

