/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.decodeir.DecodeIRCaller;
import com.hifiremote.jp1.Executor;
import com.hifiremote.jp1.GeneralSignal;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.HexReader;
import com.hifiremote.jp1.Highlight;
import com.hifiremote.jp1.LearnedSignalDecode;
import com.hifiremote.jp1.LearnedSignalTimingAnalyzer;
import com.hifiremote.jp1.ProntoSignal;
import com.hifiremote.jp1.PropertyWriter;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.UnpackLearned;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.harctoolbox.analyze.Analyzer;
import org.harctoolbox.analyze.NoDecoderMatchException;
import org.harctoolbox.girr.Command;
import org.harctoolbox.ircore.InvalidArgumentException;
import org.harctoolbox.ircore.IrCoreException;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.ircore.ModulatedIrSequence;
import org.harctoolbox.irp.Decoder;
import org.harctoolbox.irp.IrpDatabase;
import org.harctoolbox.irp.IrpException;
import org.harctoolbox.irp.IrpParseException;
import org.harctoolbox.irp.NamedProtocol;
import org.harctoolbox.irp.Protocol;
import org.harctoolbox.irp.UnknownProtocolException;
import org.xml.sax.SAXException;

public class LearnedSignal
extends Highlight
implements GeneralSignal {
    private Hex header = null;
    private int format = 0;
    private UnpackLearned unpackLearned = null;
    private ArrayList<LearnedSignalDecode> decodes = null;
    private Decoder.SimpleDecodesSet sigDecodes = null;
    private LearnedSignalDecode preferredLSDecode = null;
    private boolean usingDecodeIR = false;
    private LearnedSignalTimingAnalyzer timingAnalyzer = null;
    private static DecodeIRCaller decodeIR = null;
    private static int hasDecodeIR = 0;
    private static Decoder tmDecoder = null;
    private static IrpDatabase tmDatabase = null;
    private static Executor.ExecutorWrapperDatabase ewDatabase = null;
    private static Decoder.DecoderParameters tmDecoderParams = null;
    private IrSignal irSignal = null;
    private LearnedSignalDecode tableDecode = null;

    public LearnedSignal(int keyCode, int deviceButtonIndex, int format, Hex data, String notes) {
        this.keyCode = keyCode;
        this.deviceButtonIndex = deviceButtonIndex;
        this.format = format;
        this.data = data;
        this.notes = notes;
    }

    public LearnedSignal(LearnedSignal signal) {
        this.keyCode = signal.keyCode;
        this.deviceButtonIndex = signal.deviceButtonIndex;
        this.format = signal.format;
        this.header = signal.header == null ? null : new Hex(signal.header);
        this.name = signal.name;
        this.data = new Hex(signal.data);
        this.notes = signal.notes;
        this.irSignal = signal.irSignal;
        this.users = new ArrayList();
        this.setSegmentFlags(signal.getSegmentFlags());
        this.setUploadStatus(signal.getUploadStatus());
        this.unpackLearned = signal.unpackLearned;
        if (signal.decodes != null) {
            ArrayList<LearnedSignalDecode> signalDecodes = signal.getDecodes();
            this.decodes = new ArrayList(signalDecodes.size());
            for (LearnedSignalDecode decode : signalDecodes) {
                this.decodes.add(new LearnedSignalDecode(decode));
            }
        }
        this.timingAnalyzer = signal.getTimingAnalyzer();
    }

    public LearnedSignal(int keyCode, Command command) throws IrpException, IrCoreException {
        IrSignal signal = command.toIrSignal();
        this.unpackLearned = new UnpackLearned(signal);
        ProntoSignal ps = new ProntoSignal(this.unpackLearned);
        this.name = command.getName();
        this.notes = command.getName();
        this.data = ps.error == null ? ps.makeLearned(0).getData() : new Hex(0);
        this.keyCode = keyCode;
        this.setDeviceButtonIndex(128);
    }

    public static LearnedSignal read(HexReader reader, Remote remote) {
        if (reader.peek() == remote.getSectionTerminator()) {
            return null;
        }
        if (reader.available() < 4) {
            return null;
        }
        short keyCode = reader.read();
        short type = reader.read();
        int deviceButtonIndex = 0;
        if (remote.hasDeviceSelection()) {
            deviceButtonIndex = remote.getLearnedDevBtnSwapped() ? type & 0xF : type >> 4;
        }
        short length = reader.read();
        short[] data = reader.read(length);
        return new LearnedSignal(keyCode, deviceButtonIndex, 0, new Hex(data), null);
    }

    public LearnedSignal(Properties properties) {
        super(properties);
        this.keyCode = Integer.parseInt(properties.getProperty("KeyCode"));
        this.deviceButtonIndex = Integer.parseInt(properties.getProperty("DeviceButtonIndex"));
        this.format = Integer.parseInt(properties.getProperty("Format", "0"));
        String temp = properties.getProperty("Header");
        if (temp != null) {
            this.header = new Hex(temp);
        }
        if ((temp = properties.getProperty("Users")) != null) {
            this.setUserItems(new ArrayList<Integer>());
            StringTokenizer st = new StringTokenizer(temp, ",/");
            while (st.hasMoreTokens()) {
                int val = Integer.parseInt(st.nextToken()) << 16;
                this.getUserItems().add(val |= Integer.parseInt(st.nextToken()));
            }
        }
    }

    public String getSignalHexText() {
        short burstNum;
        boolean convert;
        Hex hex = new Hex(this.data);
        boolean bl = convert = this.format > 0 && this.format < 4;
        if (!convert && ((burstNum = hex.getData()[2]) & 0x80) != 0 && (burstNum & 0x1F) > 17) {
            convert = true;
        }
        if (convert) {
            ProntoSignal ps = new ProntoSignal(this);
            if (ps.error == null) {
                hex = ps.makeLearned(0).getData();
            }
            if (ps.error != null) {
                return "This signal cannot be displayed in standard UEI learned signal form.  Select Pronto format to clone or copy this signal.";
            }
        }
        return hex.toString();
    }

    public int getSize() {
        return this.data.length() + 3;
    }

    @Override
    public void store(PropertyWriter pw) {
        super.store(pw);
        pw.print("KeyCode", this.keyCode);
        pw.print("DeviceButtonIndex", this.deviceButtonIndex);
        if (this.format > 0) {
            pw.print("Format", this.format);
        }
        if (this.header != null) {
            pw.print("Header", this.header);
        }
        if (this.users.isEmpty()) {
            pw.print("Users", "256/256");
        }
    }

    @Override
    public Integer getIKeyCode() {
        return this.keyCode;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setNotes(String notes) {
        if (!(notes == this.notes || notes != null && notes.equals(this.notes))) {
            this.notes = notes;
        }
    }

    @Override
    public String getSignalName(Remote remote) {
        String sName = this.name == null || this.name.isEmpty() ? this.notes : this.name;
        return sName == null || sName.isEmpty() ? remote.getButtonName(this.keyCode) : sName;
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(int format) {
        this.format = format;
    }

    public Hex getHeader() {
        return this.header;
    }

    public void setHeader(Hex header) {
        this.header = header;
    }

    public int store(short[] buffer, int offset, Remote remote) {
        buffer[offset++] = (short)this.keyCode;
        buffer[offset] = remote.getLearnedDevBtnSwapped() ? (short)(0xFF & (this.deviceButtonIndex | 0x20)) : (short)(0xFF & (this.deviceButtonIndex << 4 | 2));
        int dataLength = this.data.length();
        int n = ++offset;
        buffer[n] = (short)dataLength;
        Hex.put(this.data, buffer, ++offset);
        return offset + dataLength;
    }

    public UnpackLearned getUnpackLearned() {
        if (this.unpackLearned == null) {
            this.unpackLearned = new UnpackLearned(this.data, this.format);
        }
        return this.unpackLearned;
    }

    private int compare(Decoder.Decode dc1, Decoder.Decode dc2) {
        String s1 = dc1.getName();
        String s2 = dc2.getName();
        boolean preferDc1 = dc1.getPreferOverNames().contains(s2);
        boolean preferDc2 = dc2.getPreferOverNames().contains(s1);
        return preferDc1 && !preferDc2 ? -1 : (preferDc2 && !preferDc1 ? 1 : 0);
    }

    @Override
    public LearnedSignalDecode getPreferredLSDecode() {
        return this.preferredLSDecode;
    }

    @Override
    public void setPreferredLSDecode(LearnedSignalDecode preferredLSDecode) {
        this.preferredLSDecode = preferredLSDecode;
    }

    @Override
    public ArrayList<LearnedSignalDecode> getDecodes() {
        return this.getDecodes(false);
    }

    public ArrayList<LearnedSignalDecode> getDecodes(boolean forceChanged) {
        boolean nowUsingDecodeIR;
        boolean bl = nowUsingDecodeIR = LearnedSignal.hasDecodeIR() && Boolean.parseBoolean(RMIRSetup.getProperties().getProperty("UseDecodeIR", "false"));
        boolean decoderChanged = this.decodes == null ? false : this.usingDecodeIR != nowUsingDecodeIR;
        this.usingDecodeIR = nowUsingDecodeIR;
        if (this.decodes == null || decoderChanged || forceChanged) {
            UnpackLearned ul = this.getUnpackLearned();
            if (!ul.ok) {
                return null;
            }
            try {
                if (forceChanged) {
                    this.irSignal = null;
                }
                if (this.irSignal == null) {
                    this.getIrSignal();
                }
                this.decodes = new ArrayList();
                if (this.usingDecodeIR) {
                    LearnedSignal.getDecodeIR();
                    decodeIR.setBursts(ul.durations, ul.repeat, ul.extra);
                    decodeIR.setFrequency(ul.frequency);
                    decodeIR.initDecoder();
                    this.sigDecodes = null;
                    while (decodeIR.decode()) {
                        this.decodes.add(new LearnedSignalDecode(decodeIR));
                    }
                } else {
                    Decoder.TrunkDecodeTree tree;
                    ArrayList<Decoder.Decode> decodeList;
                    Iterator it;
                    ModulatedIrSequence sequence;
                    tmDecoder = LearnedSignal.getTmDecoder();
                    if (tmDecoder == null) {
                        return null;
                    }
                    if (ul.extra > 0) {
                        sequence = this.irSignal.toModulatedIrSequence();
                        tmDecoderParams.setAllDecodes(true);
                        it = tmDecoder.decode(sequence, tmDecoderParams).iterator();
                        tmDecoderParams.setAllDecodes(false);
                        decodeList = new ArrayList<Decoder.Decode>();
                        while (it.hasNext()) {
                            tree = (Decoder.TrunkDecodeTree)it.next();
                            if (!tree.getRest().toString().isEmpty()) continue;
                            Decoder.Decode dcTest = tree.getTrunk();
                            boolean addTest = true;
                            ArrayList<Decoder.Decode> deletions = new ArrayList<Decoder.Decode>();
                            for (Decoder.Decode dc : decodeList) {
                                int n = this.compare(dcTest, dc);
                                if (n < 0) {
                                    deletions.add(dc);
                                    continue;
                                }
                                if (n <= 0) continue;
                                addTest = false;
                            }
                            for (Decoder.Decode dc : deletions) {
                                decodeList.remove(dc);
                            }
                            if (!addTest) continue;
                            decodeList.add(dcTest);
                        }
                        if (!decodeList.isEmpty()) {
                            this.sigDecodes = new Decoder.SimpleDecodesSet((List<Decoder.Decode>)decodeList);
                        }
                    }
                    if (this.sigDecodes == null || this.sigDecodes.size() == 0) {
                        this.sigDecodes = tmDecoder.decodeIrSignal(this.irSignal, tmDecoderParams);
                    }
                    if (this.sigDecodes == null || this.sigDecodes.size() == 0) {
                        int[] dur = Arrays.copyOfRange(ul.durations, ul.oneTime, ul.durations.length);
                        IrSignal irSignal2 = new IrSignal(dur, 0, ul.repeat, (double)ul.frequency);
                        this.sigDecodes = tmDecoder.decodeIrSignal(irSignal2, tmDecoderParams);
                    }
                    if ((this.sigDecodes == null || this.sigDecodes.size() == 0) && (this.irSignal.introOnly() || this.irSignal.repeatOnly())) {
                        sequence = this.irSignal.toModulatedIrSequence();
                        it = tmDecoder.decode(sequence, tmDecoderParams).iterator();
                        decodeList = new ArrayList();
                        while (it.hasNext()) {
                            tree = (Decoder.TrunkDecodeTree)it.next();
                            decodeList.add(tree.getTrunk());
                        }
                        this.sigDecodes = new Decoder.SimpleDecodesSet((List<Decoder.Decode>)decodeList);
                    }
                }
            }
            catch (InvalidArgumentException e) {
                System.err.println("*** Error: Invalid argument in IrSignal");
                return null;
            }
        }
        if (this.sigDecodes != null) {
            this.decodes.clear();
            for (Decoder.Decode dc : this.sigDecodes) {
                LearnedSignalDecode lsd = new LearnedSignalDecode(dc);
                if (lsd.decode == null) continue;
                this.decodes.add(lsd);
            }
        }
        return this.decodes;
    }

    public String getAnalysis(Analyzer.AnalyzerParams aParms, int radix) {
        if (this.irSignal == null) {
            return null;
        }
        String s = null;
        try {
            Analyzer analyzer;
            List<Protocol> pList;
            Double absTol = 100.0;
            Double relTol = 0.3;
            if (this.decodes.size() > 0) {
                NamedProtocol np = this.decodes.get((int)0).decode.getNamedProtocol();
                absTol = np.getAbsoluteToleranceWithDefault();
                relTol = np.getRelativeToleranceWithDefault();
            }
            if ((pList = (analyzer = new Analyzer(this.irSignal, absTol, relTol)).searchBestProtocol(aParms)).size() > 0) {
                s = pList.get(0).toIrpString(radix);
            }
        }
        catch (InvalidArgumentException e) {
            e.printStackTrace();
        }
        catch (NoDecoderMatchException e) {
            return null;
        }
        return s;
    }

    public LearnedSignalTimingAnalyzer getTimingAnalyzer() {
        if (this.timingAnalyzer == null) {
            this.timingAnalyzer = new LearnedSignalTimingAnalyzer(this.getUnpackLearned());
        }
        return this.timingAnalyzer;
    }

    public void clearTimingAnalyzer() {
        this.timingAnalyzer = null;
        this.unpackLearned = null;
        this.decodes = null;
    }

    public static boolean hasDecodeIR() {
        if (hasDecodeIR == 0) {
            LearnedSignal.getDecodeIR();
        }
        return hasDecodeIR == 2;
    }

    public static String getDecodeIRVersion() {
        return LearnedSignal.hasDecodeIR() ? LearnedSignal.getDecodeIR().getVersion() : null;
    }

    private static DecodeIRCaller getDecodeIR() {
        if (decodeIR == null) {
            System.err.println("Using DecodeIR to decode Learned Signals");
            try {
                decodeIR = new DecodeIRCaller(RemoteMaster.getWorkDir());
                hasDecodeIR = 2;
            }
            catch (UnsatisfiedLinkError ule) {
                System.err.println("Failed to load DecodeIR JNI interface!");
                hasDecodeIR = 1;
            }
        }
        return decodeIR;
    }

    public static Decoder getTmDecoder() {
        if (tmDecoder == null) {
            try {
                tmDatabase = new IrpDatabase((String)null);
                File patchFile = new File(RemoteMaster.getWorkDir(), "rmProtocols.xml");
                if (patchFile.exists()) {
                    tmDatabase.patch(patchFile);
                    Command.setIrpDatabase(tmDatabase);
                }
                ewDatabase = new Executor.ExecutorWrapperDatabase(tmDatabase);
                tmDecoder = new Decoder(tmDatabase);
                tmDecoderParams = new Decoder.DecoderParameters();
                tmDecoderParams.setRemoveDefaultedParameters(false);
                tmDecoderParams.setIgnoreLeadingGarbage(true);
            }
            catch (IOException | SAXException ioe) {
                System.err.println("*** Error: Unable to open protocol database");
                return null;
            }
            catch (IrpParseException ipe) {
                System.err.println("*** Error: Unable to parse protocol database");
                return null;
            }
        }
        return tmDecoder;
    }

    public static Decoder.DecoderParameters getTmDecoderParams() {
        return tmDecoderParams;
    }

    public static IrpDatabase getTmDatabase() {
        return tmDatabase;
    }

    public static Executor.ExecutorWrapperDatabase getEwDatabase() {
        return ewDatabase;
    }

    public static List<Executor.ExecutorWrapper> getExecutorWrappers(NamedProtocol np) {
        String npName = np.getName();
        ArrayList<Executor.ExecutorWrapper> list = new ArrayList<Executor.ExecutorWrapper>();
        List<Executor.ExecutorWrapper> wrapperList = LearnedSignal.getEwDatabase().get(npName);
        if (wrapperList != null) {
            list.addAll(wrapperList);
        }
        List<String> nonXmlList = null;
        try {
            nonXmlList = tmDatabase.getProperties(npName, "uei-executor");
        }
        catch (UnknownProtocolException e) {
            e.printStackTrace();
        }
        if (nonXmlList != null) {
            for (String executorDescriptor : nonXmlList) {
                list.add(new Executor.ExecutorWrapper(executorDescriptor));
            }
        }
        return list;
    }

    public LearnedSignalDecode getTableDecode() {
        return this.tableDecode;
    }

    public void setTableDecode(LearnedSignalDecode tableDecode) {
        this.tableDecode = tableDecode;
    }

    @Override
    public String getError() {
        return null;
    }

    public IrSignal getIrSignal() {
        if (this.irSignal == null) {
            UnpackLearned ul = this.getUnpackLearned();
            if (!ul.ok) {
                return null;
            }
            try {
                this.irSignal = new IrSignal(ul.durations, ul.oneTime, ul.repeat, (double)ul.frequency);
            }
            catch (InvalidArgumentException e) {
                return null;
            }
        }
        return this.irSignal;
    }
}

