/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.decodeir.DecodeIRCaller;
import com.hifiremote.jp1.CmdParameter;
import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.Executor;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JP1Frame;
import com.hifiremote.jp1.LearnedSignal;
import com.hifiremote.jp1.LearnedSignalPanel;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.ProtocolManager;
import com.hifiremote.jp1.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.harctoolbox.irp.Decoder;
import org.harctoolbox.irp.Expression;
import org.harctoolbox.irp.IrpDatabase;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.NamedProtocol;

public class LearnedSignalDecode {
    public String protocolName = null;
    public int device = -1;
    public int subDevice = -1;
    public int obc = -1;
    public int[] hex;
    public List<Integer> devParmList = null;
    public List<Integer> cmdParmList = null;
    public Executor executor = null;
    public Decoder.Decode decode = null;
    public static HashMap<NamedProtocol, Executor> defaultExecutorMap = new HashMap();
    public String miscMessage = null;
    public String errorMessage = null;
    public boolean ignore = false;
    public boolean match = false;

    public LearnedSignalDecode(DecodeIRCaller decodeIRCaller) {
        this.protocolName = decodeIRCaller.getProtocolName();
        this.device = decodeIRCaller.getDevice();
        this.subDevice = decodeIRCaller.getSubDevice();
        this.obc = decodeIRCaller.getOBC();
        int[] temp = decodeIRCaller.getHex();
        int len = 0;
        for (int i = 0; i < temp.length && temp[i] >= 0; ++i) {
            ++len;
        }
        this.hex = new int[len];
        System.arraycopy(temp, 0, this.hex, 0, len);
        this.miscMessage = decodeIRCaller.getMiscMessage();
        this.errorMessage = decodeIRCaller.getErrorMessage();
    }

    public boolean isValidDecode() {
        if (this.executor != null && this.executor.qualifier != null) {
            NameEngine engine = new NameEngine(this.evaluate(this.decode.getMap(), 0, true));
            Expression exp = Expression.newExpression(this.executor.qualifier);
            long value = 0L;
            try {
                value = exp.toLong(engine);
            }
            catch (NameUnassignedException e) {
                System.err.println("*** Error: Unassigned name in qualifier");
                return true;
            }
            return value != 0L;
        }
        return true;
    }

    public LearnedSignalDecode(Decoder.Decode decode) {
        this(decode, null, null);
    }

    public LearnedSignalDecode(Decoder.Decode decode, Value[] matchDevParms, Executor executor) {
        if (decode == null) {
            return;
        }
        this.decode = decode;
        Map<String, Long> map = decode.getMap();
        NamedProtocol np = decode.getNamedProtocol();
        this.protocolName = np.getName();
        if (executor == null && (executor = defaultExecutorMap.get(np)) == null) {
            executor = LearnedSignalDecode.getExecutor(np, null, decode);
        }
        this.executor = executor;
        Executor.ExecutorWrapper wrapper = null;
        if (executor != null) {
            wrapper = executor.wrapper;
        } else {
            List<Executor.ExecutorWrapper> lew = LearnedSignal.getEwDatabase().get(np.getName());
            if (lew != null && lew.size() > 0) {
                for (Executor.ExecutorWrapper ew : lew) {
                    if (ew.executorDescriptor != null && !ew.executorDescriptor.isEmpty()) continue;
                    wrapper = ew;
                    break;
                }
            }
        }
        Map<String, Long> newMap = this.evaluate(map, 0, true);
        String commentItem = null;
        Map<String, List<String>> translators = null;
        if (wrapper != null) {
            if (wrapper.assignments != null) {
                try {
                    NameEngine engine = new NameEngine(newMap);
                    decode = wrapper.fixDecode(this.protocolName, np, engine);
                    newMap = decode.getMap();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (wrapper.protocolName != null) {
                this.protocolName = wrapper.protocolName;
            }
            if (wrapper.commentItem != null) {
                commentItem = wrapper.commentItem;
            }
            if (wrapper.translators != null) {
                translators = wrapper.translators;
            }
        }
        this.miscMessage = "";
        LinkedHashMap<String, Object> miscMap = new LinkedHashMap<String, Object>();
        if (Boolean.parseBoolean(JP1Frame.getProperties().getProperty("HideNECDefaultSubs", "true")) && this.protocolName.startsWith("NEC") && newMap.get("D") != null && newMap.get("S") != null && newMap.get("D") + newMap.get("S") == 255L) {
            newMap.remove("S");
        }
        for (String key : newMap.keySet()) {
            if (key.equals("D")) {
                this.device = newMap.get("D").intValue();
                continue;
            }
            if (key.equals("S")) {
                this.subDevice = newMap.get("S").intValue();
                continue;
            }
            if (key.equals("F")) {
                this.obc = newMap.get("F").intValue();
                continue;
            }
            miscMap.put(key, newMap.get(key));
        }
        if (translators != null) {
            for (String key : translators.keySet()) {
                if (!miscMap.containsKey(key)) continue;
                List<String> tValues = translators.get(key);
                Object mValue = miscMap.get(key);
                int ndx = -1;
                if (tValues.size() > 1 && tValues.get(0).contains("%")) {
                    String format = tValues.get(0);
                    Object[] data = new Object[tValues.size() - 1];
                    for (int i = 1; i < tValues.size(); ++i) {
                        data[i - 1] = miscMap.remove(tValues.get(i));
                    }
                    miscMap.put(key, String.format(format, data));
                    continue;
                }
                if (tValues.size() > 1 && mValue instanceof Long) {
                    int val = ((Long)mValue).intValue();
                    if (!key.equals(tValues.get(0))) {
                        miscMap.remove(key);
                    }
                    miscMap.put(tValues.get(0), tValues.get(val + 1));
                    continue;
                }
                ndx = LearnedSignalPanel.radixPfx.indexOf(tValues.get(0));
                if (ndx < 0) continue;
                String pfx = LearnedSignalPanel.radixPfx.get(ndx);
                int radix = LearnedSignalPanel.radixInts.get(ndx);
                miscMap.put(key, pfx + Long.toString(newMap.get(key), radix));
            }
        }
        for (String key : miscMap.keySet()) {
            Object obj = miscMap.get(key);
            if (obj instanceof Long && (Long)obj < 0L) continue;
            if (!this.miscMessage.isEmpty()) {
                this.miscMessage = this.miscMessage + ", ";
            }
            this.miscMessage = this.miscMessage + key + "=" + miscMap.get(key).toString();
        }
        if (commentItem != null) {
            if (!this.miscMessage.isEmpty()) {
                this.miscMessage = this.miscMessage + ", ";
            }
            this.miscMessage = this.miscMessage + commentItem;
        }
        if (matchDevParms == null) {
            this.hex = new int[0];
            if (executor != null && this.isValidDecode()) {
                this.evaluate(map, 0, false);
                ArrayList<String> error = new ArrayList<String>();
                if (executor.protocol != null) {
                    short[] data;
                    try {
                        data = this.getProtocolHex(error).getData();
                    }
                    catch (Exception e) {
                        return;
                    }
                    this.hex = new int[data.length];
                    for (int i = 0; i < data.length; ++i) {
                        this.hex[i] = data[i];
                    }
                }
            }
            this.errorMessage = "";
            return;
        }
        int preferredChoice = 0;
        int countOfNewValues = matchDevParms.length + 1;
        for (int i = 0; i < Math.max(executor.choiceList.size(), 1); ++i) {
            this.evaluate(map, i, false);
            Value[] testParms = this.getDevParmValues(decode);
            if (testParms == null) continue;
            boolean ok = true;
            int count = 0;
            for (int j = 0; j < matchDevParms.length; ++j) {
                if (j >= testParms.length) {
                    ok = false;
                    break;
                }
                Integer tInt = (Integer)testParms[j].getUserValue();
                Integer mInt = (Integer)matchDevParms[j].getUserValue();
                if (tInt != null && mInt != null && tInt.intValue() != mInt.intValue()) {
                    ok = false;
                    break;
                }
                if (tInt == null || mInt != null) continue;
                ++count;
            }
            if (!ok) continue;
            this.match = true;
            if (count < countOfNewValues) {
                countOfNewValues = count;
                preferredChoice = i;
            }
            if (countOfNewValues == 0) break;
        }
        if (!this.match) {
            return;
        }
        this.evaluate(map, preferredChoice, false);
        Value[] testParms = this.getDevParmValues(decode);
        for (int j = 0; j < matchDevParms.length; ++j) {
            Integer tInt = (Integer)testParms[j].getUserValue();
            if (tInt == null) continue;
            matchDevParms[j].setValue(tInt);
        }
    }

    private Value[] getDevParmValues(Decoder.Decode decode) {
        int i;
        Protocol protocol = this.executor.protocol;
        DeviceParameter[] protocolDevParms = protocol.getDeviceParameters();
        Value[] parmValues = new Value[protocolDevParms.length];
        for (i = 0; i < parmValues.length; ++i) {
            parmValues[i] = new Value(null, protocol.devParms[i].getDefaultValue());
        }
        if (this.devParmList != null) {
            for (i = 0; i < this.devParmList.size(); ++i) {
                Integer newVal = this.devParmList.get(i);
                if (newVal == null) continue;
                int index = this.executor.parms.devIndices.get(i);
                if (index < parmValues.length) {
                    Integer val = (Integer)parmValues[index].getUserValue();
                    if (val != null && val.intValue() != newVal.intValue()) {
                        return null;
                    }
                    if (newVal == null) continue;
                    parmValues[index].setValue(newVal);
                    continue;
                }
                System.err.println("*** Error in uei-executor parameters");
                return null;
            }
        } else {
            Map<String, Long> map = decode.getMap();
            String devMatch = LearnedSignalDecode.getMatchName("Device");
            String subMatch = LearnedSignalDecode.getMatchName("Subdevice");
            for (int i2 = 0; i2 < parmValues.length; ++i2) {
                String parmMatch = LearnedSignalDecode.getMatchName(protocolDevParms[i2].getName());
                if (parmMatch.equals(devMatch)) {
                    parmValues[i2].setValue(map.get("D") != null ? Integer.valueOf(map.get("D").intValue()) : null);
                    continue;
                }
                if (!parmMatch.equals(subMatch)) continue;
                parmValues[i2].setValue(map.get("S") != null ? Integer.valueOf(map.get("S").intValue()) : null);
            }
        }
        return parmValues;
    }

    public Map<String, Long> evaluate(Map<String, Long> map, int index, boolean mapOnly) {
        LinkedHashMap<String, Long> newMap = new LinkedHashMap<String, Long>();
        for (String s : map.keySet()) {
            newMap.put(s, map.get(s));
        }
        if (mapOnly && this.executor == null) {
            return newMap;
        }
        NameEngine currentParameters = new NameEngine(newMap);
        Executor.Parameters eParms = this.executor.preprocessParms(index);
        if (eParms.newParms != null) {
            StringTokenizer st = new StringTokenizer(eParms.newParms, "{,}");
            try {
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    int ndx = s.indexOf("=");
                    if (ndx < 0) continue;
                    String name = s.substring(0, ndx).trim();
                    Expression exp = Expression.newExpression(s.substring(ndx + 1));
                    long value = exp.toLong(currentParameters);
                    newMap.put(name, value);
                    currentParameters = new NameEngine(newMap);
                }
            }
            catch (NameUnassignedException e) {
                e.printStackTrace();
            }
        }
        if (mapOnly) {
            return newMap;
        }
        if (eParms.devParms != null) {
            this.devParmList = new ArrayList<Integer>();
            this.evaluateParms(eParms.devParms, this.devParmList, currentParameters);
        }
        if (this.executor.parms.cmdParms != null) {
            this.cmdParmList = new ArrayList<Integer>();
            this.evaluateParms(eParms.cmdParms, this.cmdParmList, currentParameters);
        }
        return newMap;
    }

    private void evaluateParms(List<String> parms, List<Integer> values, NameEngine engine) {
        for (String parm : parms) {
            if (parm.isEmpty()) {
                values.add(null);
                continue;
            }
            Expression exp = Expression.newExpression(parm);
            long value = 0L;
            try {
                value = exp.toLong(engine);
            }
            catch (NameUnassignedException e) {
                System.err.println("*** Error: Unassigned name");
                break;
            }
            values.add(value >= 0L ? Integer.valueOf((int)value) : null);
        }
    }

    public LearnedSignalDecode(LearnedSignalDecode decode) {
        this.protocolName = decode.protocolName;
        this.device = decode.device;
        this.subDevice = decode.subDevice;
        this.obc = decode.obc;
        this.hex = decode.hex;
        this.miscMessage = decode.miscMessage;
        this.errorMessage = decode.errorMessage;
        this.ignore = decode.ignore;
    }

    public Hex getProtocolHex(List<String> error) {
        int i;
        Protocol protocol = null;
        if (this.executor == null || (protocol = this.executor.protocol) == null) {
            return null;
        }
        Value[] values = new Value[protocol.cmdParms.length];
        for (int i2 = 0; i2 < values.length; ++i2) {
            values[i2] = new Value(null, protocol.cmdParms[i2].getDefaultValue());
        }
        Hex pHex = protocol.getDefaultCmd();
        CmdParameter[] parms = protocol.cmdParms;
        if (this.cmdParmList != null) {
            for (i = 0; i < parms.length && i < this.cmdParmList.size(); ++i) {
                Integer listVal = this.cmdParmList.get(i);
                if (listVal == null) continue;
                values[i] = new Value(listVal);
            }
        } else {
            String obcMatch = LearnedSignalDecode.getMatchName("OBC");
            for (int i3 = 0; i3 < parms.length; ++i3) {
                String parmMatch = LearnedSignalDecode.getMatchName(parms[i3].getName());
                if (!parmMatch.equals(obcMatch)) continue;
                values[i3] = new Value(this.obc);
                break;
            }
        }
        try {
            for (i = 0; i < protocol.cmdTranslators.length; ++i) {
                for (int j = 0; j < values.length; ++j) {
                    protocol.cmdTranslators[i].in(values, pHex, protocol.devParms, j);
                }
            }
        }
        catch (IllegalArgumentException ex) {
            pHex = null;
            error.add("");
            error.add(ex.getMessage());
        }
        return pHex;
    }

    public static String getMatchName(String name) {
        String brackets = "([{";
        for (int pos = 0; pos < name.length(); ++pos) {
            char ch = name.charAt(pos);
            int ndx = brackets.indexOf(ch);
            if (ndx < 0) continue;
            name = name.substring(0, pos);
            break;
        }
        name = name.replaceAll("\\W|_|\\s", "");
        return name.toLowerCase();
    }

    public static Executor getExecutor(NamedProtocol np, Executor.ExecutorWrapper wrapper, Decoder.Decode decode) {
        IrpDatabase tmDatabase = LearnedSignal.getTmDatabase();
        if (np == null || np.getName() == null || tmDatabase == null) {
            return null;
        }
        String npName = np.getName();
        List<Executor.ExecutorWrapper> wrappers = null;
        ArrayList<Protocol> protList = new ArrayList<Protocol>();
        Executor executor = null;
        String qidString = null;
        if (wrapper == null) {
            wrappers = LearnedSignal.getExecutorWrappers(np);
        } else {
            wrappers = new ArrayList<Executor.ExecutorWrapper>();
            wrappers.add(wrapper);
        }
        for (Executor.ExecutorWrapper ew : wrappers) {
            LearnedSignalDecode test;
            if (ew == null || ew.executorDescriptor == null || ew.executorDescriptor.isEmpty()) {
                return null;
            }
            executor = new Executor();
            executor.wrapper = ew;
            int start = 0;
            int qidEnd = -1;
            int ndx = 0;
            Executor.ExecutorWrapper.BracketData bd = null;
            while ((bd = ew.getBrackettedData(start)) != null) {
                if (qidEnd < 0) {
                    qidEnd = bd.start;
                }
                switch (bd.type) {
                    case 0: {
                        ndx = bd.text.indexOf(";");
                        if (ndx >= 0) {
                            executor.name = bd.text.substring(0, ndx).trim();
                            bd.text = bd.text.substring(ndx + 1).trim();
                            ndx = bd.text.indexOf(";");
                            if (ndx >= 0) {
                                executor.qualifier = bd.text.substring(0, ndx).replaceAll("\\s", "");
                                executor.sequencer = bd.text.substring(ndx + 1).replaceAll("\\s", "");
                            } else {
                                executor.qualifier = bd.text.replaceAll("\\s", "");
                            }
                        } else {
                            executor.name = bd.text.trim();
                        }
                        if (executor.name != null && executor.name.isEmpty()) {
                            executor.name = null;
                        }
                        if (executor.qualifier != null && executor.qualifier.isEmpty()) {
                            executor.qualifier = null;
                        }
                        if (executor.sequencer == null || !executor.sequencer.isEmpty()) break;
                        executor.sequencer = null;
                        break;
                    }
                    case 1: {
                        String devParmString = null;
                        String cmdParmString = null;
                        ndx = bd.text.indexOf(";");
                        if (ndx >= 0) {
                            devParmString = bd.text.substring(0, ndx).replaceAll("\\s", "");
                            cmdParmString = bd.text.substring(ndx + 1).replaceAll("\\s", "");
                        } else {
                            devParmString = bd.text.replaceAll("\\s", "");
                        }
                        if (devParmString != null && !devParmString.isEmpty()) {
                            executor.parms.devParms = new ArrayList<String>();
                            executor.parms.devIndices = new ArrayList<Integer>();
                            LearnedSignalDecode.parseParameterString(devParmString, executor.parms.devParms, executor.parms.devIndices);
                        }
                        if (cmdParmString == null || cmdParmString.isEmpty()) break;
                        executor.parms.cmdParms = new ArrayList<String>();
                        LearnedSignalDecode.parseParameterString(cmdParmString, executor.parms.cmdParms, null);
                        break;
                    }
                    case 2: {
                        executor.parms.newParms = "{" + bd.text.replaceAll("\\s", "") + "}";
                    }
                }
                start = bd.end;
            }
            qidString = qidEnd >= 0 ? ew.executorDescriptor.substring(0, qidEnd).replaceAll("\\s", "") : ew.executorDescriptor.replaceAll("\\s", "");
            executor.setSelectors();
            LearnedSignalDecode learnedSignalDecode = test = wrapper == null && decode != null ? new LearnedSignalDecode(decode, null, executor) : null;
            if (test != null && !test.isValidDecode()) continue;
            ProtocolManager.QualifiedID qid = new ProtocolManager.QualifiedID(qidString);
            Hashtable<Hex, List<Protocol>> byPid = ProtocolManager.getProtocolManager().getByPID();
            for (Protocol pTest : byPid.get(qid.pid)) {
                if (!pTest.getVariantName().equals(qid.variantName)) continue;
                protList.add(pTest);
            }
            if (protList.size() <= 0) continue;
            break;
        }
        Protocol protocol = null;
        if (protList.size() > 1) {
            for (Protocol test : protList) {
                if ((executor.name == null || !test.getName().equals(executor.name)) && (executor.name != null || !LearnedSignalDecode.getMatchName(test.getName()).equals(LearnedSignalDecode.getMatchName(npName)))) continue;
                protocol = test;
                break;
            }
        } else if (protList.size() == 1) {
            protocol = (Protocol)protList.get(0);
        } else {
            return null;
        }
        if (wrapper == null && executor.qualifier == null && executor.wrapper == wrappers.get(0)) {
            defaultExecutorMap.put(np, executor);
        }
        if (protocol == null) {
            if (wrapper != null) {
                System.err.println("No protocol found for executor descriptor " + wrapper.executorDescriptor);
            }
            return null;
        }
        protocol.reset();
        executor.protocol = protocol;
        return executor;
    }

    public static void parseParameterString(String parmString, List<String> parmList, List<Integer> indexList) {
        if (parmString == null || parmList == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(parmString, ",", true);
        String parm = "";
        int index = 0;
        String lastToken = ",";
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals(",")) {
                if (lastToken.equals(",")) {
                    parmList.add("");
                    if (indexList != null) {
                        indexList.add(index);
                    }
                    ++index;
                }
            } else {
                parm = token;
                int ndx = -1;
                while ((ndx = parm.indexOf("|||")) >= 0) {
                    parmList.add(parm.substring(0, ndx));
                    if (indexList != null) {
                        indexList.add(index);
                    }
                    parm = parm.substring(ndx + 3);
                }
                parmList.add(parm);
                if (indexList != null) {
                    indexList.add(index);
                }
                ++index;
            }
            lastToken = token;
        }
    }

    public static boolean displayErrors(String protocolName, List<List<String>> failedToConvert) {
        String message = "<html>The following learned signals could not be converted for use with the " + protocolName + " protocol.<p>If you need help figuring out what to do about this, please post<br>a question in the JP1 Forums at http://www.hifi-remote.com/forums</html>";
        JPanel panel = Protocol.getErrorPanel(message, failedToConvert);
        Object[] buttonText = new String[]{"Continue conversion", "Abort conversion"};
        int rc = JOptionPane.showOptionDialog(null, panel, "Protocol Conversion Error", 0, 2, null, buttonText, buttonText[0]);
        return rc == 0;
    }

    public boolean isMatch() {
        return this.match;
    }
}

