/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.DecodeTableModel;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JP1Table;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.LearnedSignal;
import com.hifiremote.jp1.LearnedSignalTimingAnalysis;
import com.hifiremote.jp1.LearnedSignalTimingAnalyzer;
import com.hifiremote.jp1.LearnedSignalTimingAnalyzerBase;
import com.hifiremote.jp1.ProntoSignal;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.UnpackLearned;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LearnedSignalDialog
extends JDialog
implements ActionListener,
DocumentListener,
ItemListener {
    DocumentListener dl = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent e) {
            LearnedSignalDialog.this.roundingChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            LearnedSignalDialog.this.roundingChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            LearnedSignalDialog.this.roundingChanged();
        }
    };
    private boolean signalTextHasChanged = false;
    private boolean signalTextLock = false;
    private RemoteConfiguration config = null;
    private JComboBox boundDevice = new JComboBox();
    private JComboBox boundKey = new JComboBox();
    private JCheckBox shift = new JCheckBox();
    private JCheckBox xShift = new JCheckBox();
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private JButton applyButton = new JButton("Apply");
    private JButton unlockButton = new JButton("Unlock");
    private JButton advancedButton = new JButton();
    private JPanel advancedArea = null;
    private boolean advancedAreaUpdating = false;
    private boolean analysisUpdating = false;
    private JPanel namePanel = null;
    private JTextField nameField = new JTextField(10);
    private Component nameStrut = Box.createHorizontalStrut(5);
    private JPanel advancedAreaControls = new JPanel();
    private JTextField burstRoundBox = new JTextField();
    private JComboBox analyzerBox = new JComboBox();
    private JComboBox analysisBox = new JComboBox();
    private JLabel analysisMessageLabel = new JLabel();
    private JTextArea burstTextArea = new JTextArea(4, 70);
    private JTextArea onceDurationTextArea = new JTextArea(8, 70);
    private JTextArea repeatDurationTextArea = new JTextArea(8, 70);
    private JTextArea extraDurationTextArea = new JTextArea(8, 70);
    private JTextArea signalTextArea = new JTextArea(6, 70);
    private JRadioButton learnButton = new JRadioButton("UEI Learned");
    private JRadioButton prontoButton = new JRadioButton("Pronto");
    private JRadioButton oddButton = new JRadioButton("Odd");
    private JRadioButton evenButton = new JRadioButton("Even");
    private JLabel keypressLabel = new JLabel("Keypress:");
    private LearnedSignal learnedSignal = null;
    private boolean cancelOnExit = true;
    private JP1Table table = null;
    private DecodeTableModel model = new DecodeTableModel();
    private static LearnedSignalDialog dialog = null;

    public static LearnedSignal showDialog(Component locationComp, LearnedSignal learnedSignal, RemoteConfiguration config) {
        if (dialog == null) {
            dialog = new LearnedSignalDialog(locationComp);
        }
        LearnedSignalDialog.dialog.cancelOnExit = true;
        dialog.setRemoteConfiguration(config);
        dialog.setLearnedSignal(learnedSignal, false);
        dialog.setAdvancedButtonText(false);
        dialog.pack();
        LearnedSignalDialog.dialog.advancedButton.setPreferredSize(LearnedSignalDialog.dialog.advancedButton.getSize());
        dialog.setAdvancedButtonText(LearnedSignalDialog.dialog.advancedArea.isVisible());
        LearnedSignalDialog.dialog.applyButton.setEnabled(false);
        dialog.pack();
        dialog.setLocationRelativeTo(locationComp);
        ProntoSignal.setFix(false);
        dialog.setVisible(true);
        if (LearnedSignalDialog.dialog.cancelOnExit) {
            LearnedSignalDialog.dialog.learnedSignal.getTimingAnalyzer().restoreState();
            LearnedSignalDialog.dialog.learnedSignal = null;
        }
        return LearnedSignalDialog.dialog.learnedSignal;
    }

    public static void reset() {
        if (dialog != null) {
            dialog.dispose();
            dialog = null;
        }
    }

    private LearnedSignalDialog(Component c) {
        super((JFrame)SwingUtilities.getRoot(c));
        this.setTitle("Learned Signal Details");
        this.setModal(true);
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Box box = Box.createVerticalBox();
        contentPane.add((Component)box, "First");
        JPanel topPanel = new JPanel(new BorderLayout());
        box.add(topPanel);
        JPanel idPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.namePanel = new JPanel(new FlowLayout(0, 5, 1));
        this.namePanel.setBorder(BorderFactory.createTitledBorder("Signal Name"));
        this.namePanel.add(new JLabel("Name:"));
        this.namePanel.add(this.nameField);
        this.namePanel.setVisible(false);
        this.nameStrut.setVisible(false);
        idPanel.add(this.namePanel);
        idPanel.add(this.nameStrut);
        JPanel panel = new JPanel(new FlowLayout(0, 5, 0));
        panel.setAlignmentX(0.0f);
        panel.setBorder(BorderFactory.createTitledBorder("Bound Key"));
        panel.add(new JLabel("Device:"));
        panel.add(this.boundDevice);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(new JLabel("Key:"));
        panel.add(this.boundKey);
        panel.add(this.shift);
        panel.add(this.xShift);
        idPanel.add(panel);
        topPanel.add((Component)idPanel, "Before");
        this.boundKey.addActionListener(this);
        this.shift.addActionListener(this);
        this.xShift.addActionListener(this);
        topPanel.add((Component)this.advancedButton, "After");
        this.advancedButton.setToolTipText("Shows or hides the signal timing details");
        this.advancedButton.addActionListener(this);
        this.signalTextArea.setEditable(true);
        this.signalTextArea.setLineWrap(true);
        this.signalTextArea.setWrapStyleWord(true);
        this.signalTextArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                LearnedSignalDialog.this.signalTextChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LearnedSignalDialog.this.signalTextChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                LearnedSignalDialog.this.signalTextChanged();
            }
        });
        this.signalTextArea.setToolTipText("Edits to Signal Data do not take effect until you press Apply or OK");
        JScrollPane scrollPane = new JScrollPane(this.signalTextArea);
        panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Signal Data"), panel.getBorder()));
        ButtonGroup bg1 = new ButtonGroup();
        bg1.add(this.learnButton);
        bg1.add(this.prontoButton);
        this.prontoButton.setSelected(true);
        this.learnButton.addItemListener(this);
        this.prontoButton.addItemListener(this);
        ButtonGroup bg2 = new ButtonGroup();
        bg2.add(this.oddButton);
        bg2.add(this.evenButton);
        this.oddButton.setSelected(true);
        this.oddButton.setEnabled(this.prontoButton.isSelected());
        this.evenButton.setEnabled(this.prontoButton.isSelected());
        this.keypressLabel.setEnabled(this.prontoButton.isSelected());
        JPanel formatPanel = new JPanel(new FlowLayout());
        JLabel formatLabel = new JLabel("Data format:");
        formatLabel.setToolTipText(JTableX.getHtmlToolTip("When the Apply button is disabled, the Signal Data area displays its<br>data in the selected format.  The display will switch between the two<br>formats when the selection is changed.  When the Apply button is enabled,<br>the data in the Signal Data area will be interpreted as being in the<br>selected format when Apply or OK is pressed.  Changing the selected format<br>will have no effect on the displayed data.  Make sure that the selected<br>format is correct before pressing Apply or OK."));
        formatPanel.add(formatLabel);
        formatPanel.add(this.learnButton);
        this.learnButton.setToolTipText(JTableX.getHtmlToolTip("UEI Learned format represents an IR signal in the original internal format<br>used by UEI remotes.  Remotes with a Maxim (MAXQ) or Texas Instruments (TI)<br>processor use a newer format.  RMIR converts those formats to and from the<br>original one as required, to provide a consistent display across all remotes."));
        formatPanel.add(this.prontoButton);
        this.prontoButton.setToolTipText(JTableX.getHtmlToolTip("For conversion to UEI Learned, Pronto format accepts all formats other than those<br>beginning with 8000.  Those are an index into an internal database to which RMIR<br>has no access.  On conversion from UEI Learned, Pronto format provides only the<br>Pronto raw formats, those beginning 0000 or 0100."));
        this.keypressLabel.setToolTipText(JTableX.getHtmlToolTip("Predefined Pronto formats support protocols that toggle.  These are<br>protocols that alternate between two distinct signals on succesive<br>keypresses.  UEI learned format does not support toggles, so you can<br>here select whether the Pronto should be converted to the learned signal<br>for an odd-numbered or even-numbered keypress."));
        formatPanel.add(new JLabel("        "));
        formatPanel.add(this.keypressLabel);
        formatPanel.add(this.oddButton);
        formatPanel.add(this.evenButton);
        this.oddButton.setToolTipText(JTableX.getHtmlToolTip("When selected, Pronto signals for protocols that toggle will be<br>interpreted as sent on the 1st, 3rd, 5th etc. keypress"));
        this.evenButton.setToolTipText(JTableX.getHtmlToolTip(">When selected, Pronto signals for protocols that toggle will be<br>interpreted as sent on the 2nd, 4th, 6th etc. keypress"));
        panel.add((Component)formatPanel, "First");
        panel.add((Component)scrollPane, "Center");
        topPanel.add((Component)panel, "Last");
        ItemListener i = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    LearnedSignalDialog.this.applyButton.setEnabled(true);
                }
            }
        };
        this.oddButton.addItemListener(i);
        this.evenButton.addItemListener(i);
        this.table = new JP1Table(this.model);
        this.table.setCellSelectionEnabled(false);
        this.table.setRowSelectionAllowed(true);
        this.table.getTableHeader().setPreferredSize(new Dimension(this.table.getColumnModel().getTotalColumnWidth(), 2 * this.table.getRowHeight()));
        Dimension d = this.table.getPreferredScrollableViewportSize();
        d.width = this.table.getPreferredSize().width;
        d.height = 3 * this.table.getRowHeight();
        this.table.setPreferredScrollableViewportSize(d);
        this.table.initColumns(this.model);
        scrollPane = new JScrollPane(this.table);
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Decodes"), scrollPane.getBorder()));
        box.add(scrollPane);
        this.advancedArea = new JPanel(new BorderLayout());
        this.advancedArea.setBorder(BorderFactory.createTitledBorder("Advanced Details"));
        Dimension dim = this.advancedArea.getPreferredSize();
        dim.height = 300;
        this.advancedArea.setPreferredSize(dim);
        contentPane.add((Component)this.advancedArea, "Center");
        this.advancedAreaControls = new JPanel(new FlowLayout(0, 1, 1));
        this.advancedAreaControls.add(new JLabel(" Round To: "));
        this.advancedAreaControls.add(this.burstRoundBox);
        this.advancedAreaControls.add(new JLabel("  Analyzer: "));
        this.advancedAreaControls.add(this.analyzerBox);
        this.advancedAreaControls.add(new JLabel("  Analysis: "));
        this.advancedAreaControls.add(this.analysisBox);
        this.advancedAreaControls.add(new JLabel("  "));
        this.advancedAreaControls.add(this.analysisMessageLabel);
        this.advancedArea.add((Component)this.advancedAreaControls, "First");
        this.analysisMessageLabel.setText(null);
        i = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    LearnedSignalDialog.this.onAnalysisChange();
                }
            }
        };
        this.analyzerBox.addItemListener(i);
        this.analysisBox.addItemListener(i);
        this.burstRoundBox.setColumns(4);
        this.burstRoundBox.getDocument().addDocumentListener(this.dl);
        box = Box.createVerticalBox();
        this.advancedArea.add((Component)box, "Center");
        this.burstTextArea.setEditable(false);
        this.burstTextArea.setLineWrap(true);
        this.burstTextArea.setWrapStyleWord(true);
        scrollPane = new JScrollPane(this.burstTextArea);
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Bursts"), scrollPane.getBorder()));
        box.add(scrollPane);
        this.burstTextArea.getParent().getParent().setVisible(false);
        this.onceDurationTextArea.setEditable(false);
        this.onceDurationTextArea.setLineWrap(true);
        this.onceDurationTextArea.setWrapStyleWord(true);
        scrollPane = new JScrollPane(this.onceDurationTextArea);
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Sent Once"), scrollPane.getBorder()));
        box.add(scrollPane);
        this.repeatDurationTextArea.setEditable(false);
        this.repeatDurationTextArea.setLineWrap(true);
        this.repeatDurationTextArea.setWrapStyleWord(true);
        scrollPane = new JScrollPane(this.repeatDurationTextArea);
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Sent Repeatedly"), scrollPane.getBorder()));
        box.add(scrollPane);
        this.extraDurationTextArea.setEditable(false);
        this.extraDurationTextArea.setLineWrap(true);
        this.extraDurationTextArea.setWrapStyleWord(true);
        scrollPane = new JScrollPane(this.extraDurationTextArea);
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Sent on Release"), scrollPane.getBorder()));
        box.add(scrollPane);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        contentPane.add((Component)buttonPanel, "Last");
        this.unlockButton.addActionListener(this);
        this.unlockButton.setEnabled(false);
        this.unlockButton.setToolTipText(JTableX.getHtmlToolTip("Release lock that makes Timing summary use rounding set here for<br>this signal and analysis.  When button is disabled, rounding is unlocked."));
        buttonPanel.add(this.unlockButton);
        this.applyButton.addActionListener(this);
        this.applyButton.setEnabled(false);
        this.applyButton.setToolTipText(JTableX.getHtmlToolTip("Apply edits made in the Signal Data panel without closing dialog.<br>Save the current analysis settings."));
        buttonPanel.add(this.applyButton);
        this.okButton.addActionListener(this);
        this.okButton.setToolTipText("Apply all Signal Data edits, save current analysis settings and exit dialog.");
        buttonPanel.add(this.okButton);
        this.cancelButton.addActionListener(this);
        this.cancelButton.setToolTipText("Abandon all edits since they were last applied, then exit dialog.");
        buttonPanel.add(this.cancelButton);
        this.advancedArea.setVisible(false);
        this.setAdvancedButtonText(this.advancedArea.isVisible());
    }

    private void roundingChanged() {
        this.setAdvancedAreaTextFields();
        this.applyButton.setEnabled(true);
    }

    private void setLearnedSignal(LearnedSignal learnedSignal, boolean applyOnly) {
        LearnedSignalTimingAnalyzer timingAnalyzer;
        if (!applyOnly) {
            this.table.initColumns(this.model);
            if (learnedSignal == null) {
                this.learnedSignal = new LearnedSignal(0, 0, 0, new Hex(), null);
                this.nameField.setText(null);
                this.boundKey.setSelectedIndex(0);
                this.shift.setSelected(false);
                this.xShift.setSelected(false);
                this.model.set(this.learnedSignal);
                this.signalTextArea.setText(null);
                this.burstRoundBox.getDocument().removeDocumentListener(this.dl);
                this.burstRoundBox.setText(null);
                this.burstRoundBox.getDocument().addDocumentListener(this.dl);
                this.burstTextArea.setText(null);
                this.onceDurationTextArea.setText(null);
                this.repeatDurationTextArea.setText(null);
                this.extraDurationTextArea.setText(null);
                this.analyzerBox.setModel(new DefaultComboBoxModel<String>(new String[]{"..."}));
                this.analysisBox.setModel(new DefaultComboBoxModel<String>(new String[]{"..."}));
                return;
            }
            this.learnedSignal = learnedSignal;
            Remote remote = this.config.getRemote();
            this.nameField.setText(learnedSignal.getName());
            this.boundDevice.setSelectedItem(remote.getDeviceButton(learnedSignal.getDeviceButtonIndex()));
            this.setButton(learnedSignal.getKeyCode(), this.boundKey, this.shift, this.xShift);
            this.model.set(learnedSignal);
            this.prontoButton.setSelected(true);
            this.signalTextLock = true;
            if (this.learnButton.isSelected()) {
                this.signalTextArea.setText(learnedSignal.getSignalHexText());
            } else if (this.prontoButton.isSelected() && learnedSignal != null && learnedSignal.getData().length() > 0) {
                ProntoSignal ps = new ProntoSignal(learnedSignal);
                ps.makePronto();
                this.signalTextArea.setText(ps.toString());
            }
            this.signalTextLock = false;
        }
        if (!(timingAnalyzer = this.learnedSignal.getTimingAnalyzer()).getIsValid()) {
            this.burstRoundBox.setText(null);
            this.analysisMessageLabel.setText(null);
            this.burstTextArea.setText("Unable to unpack learned signal data...analysis not possible.");
            this.onceDurationTextArea.setText(null);
            this.repeatDurationTextArea.setText(null);
            this.extraDurationTextArea.setText(null);
            this.burstTextArea.setRows(1);
            this.onceDurationTextArea.setRows(1);
            this.repeatDurationTextArea.setRows(1);
            this.extraDurationTextArea.setRows(1);
            this.onceDurationTextArea.getParent().getParent().setVisible(false);
            this.repeatDurationTextArea.getParent().getParent().setVisible(false);
            this.extraDurationTextArea.getParent().getParent().setVisible(false);
            this.analyzerBox.setModel(new DefaultComboBoxModel<String>(new String[]{"..."}));
            this.analysisBox.setModel(new DefaultComboBoxModel<String>(new String[]{"..."}));
            this.pack();
        } else {
            this.analysisUpdating = true;
            this.advancedAreaUpdating = true;
            this.analyzerBox.setModel(new DefaultComboBoxModel<String>(timingAnalyzer.getAnalyzerNames()));
            this.analyzerBox.setSelectedItem(timingAnalyzer.getSelectedAnalyzer().getName());
            this.analysisBox.setModel(new DefaultComboBoxModel<String>(timingAnalyzer.getSelectedAnalyzer().getAnalysisNames()));
            this.analysisBox.setSelectedItem(timingAnalyzer.getSelectedAnalysisName());
            this.analysisMessageLabel.setText(timingAnalyzer.getSelectedAnalysis() != null ? timingAnalyzer.getSelectedAnalysis().getMessage() : "No valid analysis");
            this.burstRoundBox.setText(Integer.toString(timingAnalyzer.getSelectedAnalyzer().getRoundTo()));
            timingAnalyzer.saveState();
            this.advancedAreaUpdating = false;
            this.analysisUpdating = false;
            this.setAdvancedAreaTextFields();
        }
    }

    private void onAnalysisChange() {
        if (this.analysisUpdating) {
            return;
        }
        this.analysisUpdating = true;
        this.applyButton.setEnabled(true);
        LearnedSignalTimingAnalyzer timingAnalyzer = this.learnedSignal.getTimingAnalyzer();
        if (!timingAnalyzer.getSelectedAnalyzer().getName().equals(this.analyzerBox.getSelectedItem().toString())) {
            timingAnalyzer.setSelectedAnalyzer(this.analyzerBox.getSelectedItem().toString());
            this.analysisBox.setModel(new DefaultComboBoxModel<String>(timingAnalyzer.getSelectedAnalyzer().getAnalysisNames()));
            this.analysisBox.setSelectedItem(timingAnalyzer.getSelectedAnalysisName());
            this.burstRoundBox.getDocument().removeDocumentListener(this.dl);
            this.burstRoundBox.setText(Integer.toString(timingAnalyzer.getSelectedAnalyzer().getRoundTo()));
            this.burstRoundBox.getDocument().addDocumentListener(this.dl);
            this.setAdvancedAreaTextFields();
        } else {
            timingAnalyzer.setSelectedAnalysisName(this.analysisBox.getSelectedItem().toString());
            this.setAdvancedAreaTextFields();
        }
        this.analysisUpdating = false;
    }

    private void setAdvancedAreaTextFields() {
        LearnedSignalTimingAnalysis analysis;
        if (this.advancedAreaUpdating) {
            return;
        }
        this.advancedAreaUpdating = true;
        if (Boolean.parseBoolean(RMIRSetup.getProperties().getProperty("LearnedSignalTimingAnalysis", "false"))) {
            this.advancedAreaControls.setVisible(true);
            int r = 1;
            String roundText = this.burstRoundBox.getText();
            if (roundText != null && !roundText.isEmpty()) {
                try {
                    r = Integer.parseInt(roundText);
                }
                catch (NumberFormatException e) {
                    r = 1;
                }
            }
            LearnedSignalTimingAnalyzerBase analyzer = this.learnedSignal.getTimingAnalyzer().getSelectedAnalyzer();
            this.unlockButton.setEnabled(analyzer.getIsRoundingLocked());
            if (r != analyzer.getRoundTo()) {
                analyzer.unlockRounding();
                analyzer.setRoundTo(r);
                analyzer.lockRounding();
                this.unlockButton.setEnabled(true);
            }
            if ((analysis = this.learnedSignal.getTimingAnalyzer().getSelectedAnalysis()) == null) {
                LearnedSignalTimingAnalyzer timingAnalyzer = this.learnedSignal.getTimingAnalyzer();
                analysis = timingAnalyzer.getSelectedAnalyzer().getPreferredAnalysis();
                this.analysisBox.setModel(new DefaultComboBoxModel<String>(timingAnalyzer.getSelectedAnalyzer().getAnalysisNames()));
                if (analysis != null) {
                    this.analysisBox.setSelectedItem(analysis.getName());
                }
            }
            this.analysisMessageLabel.setText(analysis != null ? analysis.getMessage() : "No valid analysis");
        } else {
            this.advancedAreaControls.setVisible(false);
            analysis = this.learnedSignal.getTimingAnalyzer().getAnalyzer("Raw Data").getAnalysis("Even");
        }
        String temp = analysis != null ? analysis.getBurstString() : "** No signal **";
        this.burstTextArea.setText(temp);
        this.burstTextArea.setRows((int)Math.ceil((double)temp.length() / 75.0));
        temp = analysis != null ? analysis.getOneTimeDurationString() : "** No signal **";
        this.onceDurationTextArea.setText(temp);
        this.onceDurationTextArea.setRows((int)Math.ceil((double)temp.length() / 75.0));
        this.onceDurationTextArea.getParent().getParent().setVisible(!temp.equals("** No signal **"));
        temp = analysis != null ? analysis.getRepeatDurationString() : "** No signal **";
        this.repeatDurationTextArea.setText(temp);
        this.repeatDurationTextArea.setRows((int)Math.ceil((double)temp.length() / 75.0));
        this.repeatDurationTextArea.getParent().getParent().setVisible(!temp.equals("** No signal **"));
        temp = analysis != null ? analysis.getExtraDurationString() : "** No signal **";
        this.extraDurationTextArea.setText(temp);
        this.extraDurationTextArea.setRows((int)Math.ceil((double)temp.length() / 75.0));
        this.extraDurationTextArea.getParent().getParent().setVisible(!temp.equals("** No signal **"));
        this.pack();
        this.advancedAreaUpdating = false;
    }

    private void setRemoteConfiguration(RemoteConfiguration config) {
        this.config = config;
        Remote remote = config.getRemote();
        this.shift.setText(remote.getShiftLabel());
        this.xShift.setText(remote.getXShiftLabel());
        this.xShift.setVisible(remote.getXShiftEnabled());
        this.boundDevice.setModel(new DefaultComboBoxModel<DeviceButton>(remote.getDeviceButtons()));
        this.boundKey.setModel(new DefaultComboBoxModel<Button>(remote.getLearnButtons()));
        this.namePanel.setVisible(remote.usesEZRC());
        this.nameStrut.setVisible(remote.usesEZRC());
    }

    private void setButton(int code, JComboBox comboBox, JCheckBox shiftBox, JCheckBox xShiftBox) {
        Remote remote = this.config.getRemote();
        Button b = remote.getButton(code);
        if (!Arrays.asList(remote.getLearnButtons()).contains(b)) {
            b = null;
        }
        if (b == null) {
            int base = code & 0x3F;
            if (base != 0) {
                b = remote.getButton(base);
                if ((base | remote.getShiftMask()) == code) {
                    shiftBox.setEnabled(b.allowsShiftedMacro());
                    shiftBox.setSelected(true);
                    comboBox.setSelectedItem(b);
                    return;
                }
                if (remote.getXShiftEnabled() && (base | remote.getXShiftMask()) == code) {
                    xShiftBox.setEnabled(remote.getXShiftEnabled() & b.allowsXShiftedMacro());
                    xShiftBox.setSelected(true);
                    comboBox.setSelectedItem(b);
                    return;
                }
            }
            if ((b = remote.getButton(code & ~remote.getShiftMask())) != null) {
                shiftBox.setSelected(true);
            } else if (remote.getXShiftEnabled() && (b = remote.getButton(code ^ ~remote.getXShiftMask())) != null) {
                xShiftBox.setSelected(true);
            }
        }
        shiftBox.setEnabled(b.allowsShiftedKeyMove());
        xShiftBox.setEnabled(b.allowsXShiftedKeyMove());
        if (b.getIsXShifted()) {
            xShiftBox.setSelected(true);
        } else if (b.getIsShifted()) {
            shiftBox.setSelected(true);
        }
        comboBox.removeActionListener(this);
        comboBox.setSelectedItem(b);
        comboBox.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        Remote remote = this.config.getRemote();
        Button b = (Button)this.boundKey.getSelectedItem();
        boolean ok = true;
        if (source == this.applyButton || source == this.okButton) {
            String notes = this.learnedSignal.getNotes();
            int deviceIndex = ((DeviceButton)this.boundDevice.getSelectedItem()).getButtonIndex();
            int keyCode = this.getKeyCode(this.boundKey, this.shift, this.xShift);
            this.learnedSignal.setDeviceButtonIndex(deviceIndex);
            this.learnedSignal.setKeyCode(keyCode);
            this.learnedSignal.setName(this.nameField.getText());
            if (this.signalTextHasChanged) {
                int format = remote.getLearnedFormat();
                ProntoSignal ps = null;
                if (this.learnButton.isSelected()) {
                    Hex data = new Hex(Hex.parseHex(this.signalTextArea.getText()));
                    this.learnedSignal.setData(data);
                    this.learnedSignal.setFormat(0);
                } else if (this.prontoButton.isSelected()) {
                    ps = new ProntoSignal(this.signalTextArea.getText());
                    ps.unpack(this.oddButton.isSelected() ? 0 : 1);
                    if (ps.error == null) {
                        LearnedSignal ls = ps.makeLearned(format);
                        if (ps.error == null) {
                            this.learnedSignal.setData(ls.getData());
                            this.learnedSignal.setFormat(format);
                        }
                    }
                }
                this.learnedSignal.clearTimingAnalyzer();
                if (this.config.hasSegments()) {
                    this.learnedSignal.setSegmentFlags(255);
                }
                if (remote.isSSD() && this.learnedSignal.getHeader() == null) {
                    this.learnedSignal.setHeader(new Hex(new short[]{16, 0, 0, 24, 32, 0, 0}));
                }
                UnpackLearned ul = this.learnedSignal.getUnpackLearned();
                if (ps != null && ps.error != null) {
                    ok = false;
                    String message = ps.error.startsWith("Maximum length") ? "Conversion error: " : "Malformed Pronto signal: ";
                    message = message + ps.error;
                    String title = "Pronto Signal Error";
                    JOptionPane.showMessageDialog(this, message, title, 0);
                } else if (!ul.ok) {
                    ok = false;
                    String message = "Malformed learned signal: " + ul.error;
                    String title = "Learned Signal Error";
                    JOptionPane.showMessageDialog(this, message, title, 0);
                } else if (format != this.learnedSignal.getFormat()) {
                    ps = new ProntoSignal(this.learnedSignal);
                    this.learnedSignal.setData(ps.makeLearned(format).getData());
                    this.learnedSignal.setFormat(format);
                }
            } else {
                this.learnedSignal.getTimingAnalyzer().saveState();
            }
        }
        if (source == this.applyButton && ok) {
            this.setLearnedSignal(this.learnedSignal, true);
            this.model.set(this.learnedSignal);
            this.applyButton.setEnabled(false);
        } else if (source == this.okButton && ok) {
            this.cancelOnExit = false;
            ProntoSignal.setFix(false);
            this.setVisible(false);
        } else if (source == this.cancelButton) {
            this.cancelOnExit = true;
            ProntoSignal.setFix(false);
            this.setVisible(false);
        } else if (source == this.unlockButton) {
            this.learnedSignal.getTimingAnalyzer().getSelectedAnalyzer().unlockRounding();
            this.unlockButton.setEnabled(false);
        } else if (source == this.advancedButton) {
            this.advancedArea.setVisible(!this.advancedArea.isVisible());
            this.setAdvancedButtonText(this.advancedArea.isVisible());
            this.pack();
        } else if (source == this.shift) {
            if (this.shift.isSelected()) {
                this.xShift.setSelected(false);
            } else if (b != null && remote.getXShiftEnabled()) {
                this.xShift.setSelected(b.needsShift(Button.LEARN_BIND));
            }
        } else if (source == this.xShift) {
            if (this.xShift.isSelected()) {
                this.shift.setSelected(false);
            } else if (b != null) {
                this.shift.setSelected(b.needsShift(Button.LEARN_BIND));
            }
        } else if (source == this.boundKey && b != null) {
            b.setShiftBoxes(Button.LEARN_BIND, this.shift, this.xShift);
        }
    }

    private void setAdvancedButtonText(boolean hide) {
        String text = "<html><center>";
        text = text + (hide ? "Hide " : "Show ");
        text = text + "Advanced<br>Details</center></html>";
        this.advancedButton.setText(text);
    }

    private int getKeyCode(JComboBox comboBox, JCheckBox shiftBox, JCheckBox xShiftBox) {
        int keyCode = ((Button)comboBox.getSelectedItem()).getKeyCode();
        if (shiftBox.isSelected()) {
            keyCode |= this.config.getRemote().getShiftMask();
        } else if (xShiftBox.isSelected()) {
            keyCode |= this.config.getRemote().getXShiftMask();
        }
        return keyCode;
    }

    private void signalTextChanged() {
        if (this.signalTextLock) {
            return;
        }
        this.signalTextHasChanged = true;
        this.applyButton.setEnabled(true);
        ProntoSignal.setFix(false);
    }

    private void documentChanged(DocumentEvent e) {
        this.applyButton.setEnabled(true);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.oddButton.setEnabled(this.prontoButton.isSelected());
            this.evenButton.setEnabled(this.prontoButton.isSelected());
            this.keypressLabel.setEnabled(this.prontoButton.isSelected());
            if (this.applyButton.isEnabled()) {
                return;
            }
            this.signalTextLock = true;
            if (this.learnButton.isSelected()) {
                this.signalTextArea.setText(this.learnedSignal.getSignalHexText());
            } else if (this.prontoButton.isSelected() && this.learnedSignal != null && this.learnedSignal.getData().length() > 0) {
                ProntoSignal ps = new ProntoSignal(this.learnedSignal);
                ps.makePronto();
                this.signalTextArea.setText(ps.toString());
            }
            this.signalTextLock = false;
        }
    }
}

