/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.DeviceUpgradeConverter;
import com.hifiremote.jp1.JP1Frame;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.LearnedSignal;
import com.hifiremote.jp1.LearnedSignalDecode;
import com.hifiremote.jp1.LearnedSignalDialog;
import com.hifiremote.jp1.LearnedSignalTableModel;
import com.hifiremote.jp1.LearnedSignalTimingSummaryDialog;
import com.hifiremote.jp1.LocalObjectTransferable;
import com.hifiremote.jp1.ProtocolDataPanel;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.RMTablePanel;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RemoteMaster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableCellRenderer;
import org.harctoolbox.analyze.Analyzer;
import org.harctoolbox.analyze.Burst;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.irp.BitDirection;
import org.harctoolbox.irp.NamedProtocol;
import org.harctoolbox.xml.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LearnedSignalPanel
extends RMTablePanel<LearnedSignal> {
    private RemoteConfiguration remoteConfig = null;
    private JButton convertToUpgradeButton = null;
    private JButton timingSummaryButton = null;
    private JButton docuButton = null;
    private JButton refreshButton = null;
    private JTextField irpAnalysisField = null;
    private JTextField irpDecodeField = null;
    private JButton copyButton = null;
    private Clipboard clipboard = null;
    private Toolkit kit = Toolkit.getDefaultToolkit();
    private JRadioButton lsbBtn = null;
    private JRadioButton msbBtn = null;
    private List<JRadioButton> radixBtns = null;
    private int radix = 16;
    private JCheckBox invertCheck = null;
    private Analyzer.AnalyzerParams aParms = null;
    private JTextField frequencyToleranceField = null;
    private JTextField minLeadoutField = null;
    private JLabel workingLabel = null;
    private Box optionsBox = null;
    private JTextPane notesPane = null;
    public static List<Integer> radixInts = Arrays.asList(2, 4, 8, 10, 16);
    public static List<String> radixPfx = Arrays.asList("0b", "0q", "0", "", "0x");

    public LearnedSignalPanel() {
        super(new LearnedSignalTableModel());
        this.clipboard = this.kit.getSystemClipboard();
        TransferHandler th = new TransferHandler(){

            @Override
            protected Transferable createTransferable(JComponent c) {
                return new LocalObjectTransferable(new Integer(LearnedSignalPanel.this.table.getSelectedRow()));
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }

            @Override
            public void exportToClipboard(JComponent comp, Clipboard clip, int action) {
                JTable table = (JTable)comp;
                int[] selectedRows = table.getSelectedRows();
                int[] selectedCols = table.getSelectedColumns();
                StringBuilder buff = new StringBuilder(200);
                for (int rowNum = 0; rowNum < selectedRows.length; ++rowNum) {
                    if (rowNum != 0) {
                        buff.append("\n");
                    }
                    for (int colNum = 0; colNum < selectedCols.length; ++colNum) {
                        if (colNum != 0) {
                            buff.append("\t");
                        }
                        int selRow = selectedRows[rowNum];
                        int selCol = selectedCols[colNum];
                        int convertedCol = table.convertColumnIndexToModel(selCol);
                        Object value = table.getValueAt(selRow, selCol);
                        if (value == null) continue;
                        DefaultTableCellRenderer cellRenderer = (DefaultTableCellRenderer)table.getColumnModel().getColumn(selCol).getCellRenderer();
                        if (cellRenderer != null) {
                            cellRenderer.getTableCellRendererComponent(table, value, false, false, selRow, convertedCol);
                            value = cellRenderer.getText();
                        }
                        buff.append(value.toString());
                    }
                }
                StringSelection data = new StringSelection(buff.toString());
                LearnedSignalPanel.this.clipboard.setContents(data, data);
            }
        };
        this.table.setTransferHandler(th);
        this.deleteAllButton.setVisible(true);
        this.copyButton = new JButton("Copy");
        this.copyButton.addActionListener(this);
        this.copyButton.setToolTipText("Copy to clipboard for pasting to Functions tab of a device upgrade");
        this.copyButton.setEnabled(false);
        this.buttonPanel.add(this.copyButton);
        this.convertToUpgradeButton = new JButton("Convert to Device Upgrade");
        this.convertToUpgradeButton.addActionListener(this);
        this.convertToUpgradeButton.setToolTipText("Convert the selected set of consecutive items to a Device Upgrade.");
        this.buttonPanel.add(this.convertToUpgradeButton);
        this.timingSummaryButton = new JButton("Timing Summary");
        this.timingSummaryButton.addActionListener(this);
        this.timingSummaryButton.setToolTipText("View the Timing Summary for all of the Learned Signals.");
        this.timingSummaryButton.setEnabled(true);
        this.buttonPanel.add(this.timingSummaryButton);
        this.lsbBtn = new JRadioButton("lsb");
        this.msbBtn = new JRadioButton("msb");
        this.lsbBtn.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.lsbBtn);
        group.add(this.msbBtn);
        this.lsbBtn.addActionListener(this);
        this.msbBtn.addActionListener(this);
        this.invertCheck = new JCheckBox("invert");
        this.invertCheck.addActionListener(this);
        this.docuButton = new JButton("Open documentation");
        this.docuButton.setToolTipText(JTableX.getHtmlToolTip("Displays documentation for the protocol identified<br>by the decode for the selected signal.  Not available<br>when the decoder is DecodeIR."));
        this.docuButton.addActionListener(this);
        JLabel irpAnalysisLabel = new JLabel("IRP from analysis: ");
        Dimension d1 = irpAnalysisLabel.getPreferredSize();
        JLabel irpDecodeLabel = new JLabel("IRP from decode: ");
        Dimension d2 = irpDecodeLabel.getPreferredSize();
        int maxw = Math.max(d1.width, d2.width);
        irpAnalysisLabel.setPreferredSize(new Dimension(maxw, d1.height));
        irpDecodeLabel.setPreferredSize(new Dimension(maxw, d2.height));
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.addActionListener(this);
        this.workingLabel = new JLabel("WORKING");
        this.workingLabel.setForeground(Color.RED);
        this.workingLabel.setFont(this.workingLabel.getFont().deriveFont(1));
        this.workingLabel.setVisible(false);
        this.optionsBox = Box.createVerticalBox();
        this.optionsBox.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Decode options: "), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        String text = "To change the frequency tolerance or minimum leadout from their defaults of 2000Hz and 20.0ms, enter values in the boxes and press Refresh.  Leave a box blank to set default.  To disable frequency checking, set tolerance to -1.  Note that it may take several seconds for the revised decodes to be calculated.";
        this.optionsBox.add(new ProtocolDataPanel.DisplayArea(text, null));
        JPanel optionsPanel = new JPanel(new FlowLayout(0));
        optionsPanel.add(new JLabel("Frequency tolerance (Hz): "));
        this.frequencyToleranceField = new JTextField(8);
        this.minLeadoutField = new JTextField(8);
        optionsPanel.add(this.frequencyToleranceField);
        optionsPanel.add(Box.createHorizontalStrut(10));
        optionsPanel.add(new JLabel("Minumum leadout (us): "));
        optionsPanel.add(this.minLeadoutField);
        optionsPanel.add(Box.createHorizontalStrut(10));
        optionsPanel.add(this.refreshButton);
        optionsPanel.add(Box.createHorizontalStrut(10));
        optionsPanel.add(this.workingLabel);
        this.optionsBox.add(optionsPanel);
        Box analysisBox = Box.createVerticalBox();
        analysisBox.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Selected signal: "), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.notesPane = new JTextPane();
        this.notesPane.setBackground(this.getBackground());
        this.notesPane.setForeground(Color.BLACK);
        this.notesPane.setVisible(true);
        this.notesPane.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        Box footerBox = Box.createVerticalBox();
        footerBox.add(this.notesPane);
        footerBox.add(this.optionsBox);
        footerBox.add(analysisBox);
        this.footerPanel.add((Component)footerBox, "First");
        this.footerPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        optionsPanel = new JPanel(new BorderLayout());
        JPanel analysisPanel = new JPanel(new FlowLayout(0));
        optionsPanel.add((Component)analysisPanel, "Before");
        analysisPanel.add(new JLabel("Options: "));
        analysisPanel.add(this.lsbBtn);
        analysisPanel.add(this.msbBtn);
        analysisPanel.add(Box.createHorizontalStrut(10));
        analysisPanel.add(this.invertCheck);
        analysisPanel.add(Box.createHorizontalStrut(10));
        analysisPanel.add(new JLabel("Value base: "));
        group = new ButtonGroup();
        HashMap<String, Integer> radixMap = new HashMap<String, Integer>(radixInts.size());
        this.radixBtns = new ArrayList<JRadioButton>(radixInts.size());
        for (int i = 0; i < radixInts.size(); ++i) {
            JRadioButton rBtn = new JRadioButton("" + radixInts.get(i));
            this.radixBtns.add(rBtn);
            radixMap.put(radixPfx.get(i), radixInts.get(i));
            group.add(rBtn);
            rBtn.addActionListener(this);
            analysisPanel.add(rBtn);
        }
        IrCoreUtils.setRadixPrefixes(radixMap);
        this.radix = 16;
        this.radixBtns.get(4).setSelected(true);
        analysisPanel = new JPanel(new FlowLayout(2));
        analysisPanel.add(this.docuButton);
        optionsPanel.add((Component)analysisPanel, "After");
        analysisBox.add(optionsPanel);
        this.irpAnalysisField = new JTextField();
        analysisPanel = new JPanel(new BorderLayout());
        analysisPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        analysisPanel.add((Component)irpAnalysisLabel, "Before");
        analysisPanel.add((Component)this.irpAnalysisField, "Center");
        analysisBox.add(analysisPanel);
        this.irpDecodeField = new JTextField();
        analysisPanel = new JPanel(new BorderLayout());
        analysisPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        analysisPanel.add((Component)irpDecodeLabel, "Before");
        analysisPanel.add((Component)this.irpDecodeField, "Center");
        analysisBox.add(analysisPanel);
        this.aParms = new Analyzer.AnalyzerParams(null, null, BitDirection.lsb, false, null, 32, false, new Burst.Preferences(), new ArrayList<String>(0));
        this.refresh();
    }

    @Override
    protected void refresh() {
        boolean usingDecodeIR = Boolean.parseBoolean(RMIRSetup.getProperties().getProperty("UseDecodeIR", "false"));
        this.convertToUpgradeButton.setEnabled(!usingDecodeIR);
        this.docuButton.setEnabled(false);
        this.irpDecodeField.setEnabled(!usingDecodeIR);
        this.enableRecursively(this.optionsBox, !usingDecodeIR);
        this.timingSummaryButton.setVisible(Boolean.parseBoolean(RMIRSetup.getProperties().getProperty("LearnedSignalTimingAnalysis", "false")));
    }

    private void enableRecursively(Component component, boolean enable) {
        Component[] components = ((Container)component).getComponents();
        component.setEnabled(enable);
        for (Component inner : components) {
            if (!(inner instanceof Container)) continue;
            this.enableRecursively((Container)inner, enable);
        }
    }

    @Override
    public void set(RemoteConfiguration remoteConfig) {
        this.remoteConfig = remoteConfig;
        Remote remote = remoteConfig.getRemote();
        ((LearnedSignalTableModel)this.model).set(remoteConfig);
        this.table.initColumns(this.model);
        this.newButton.setEnabled(remoteConfig != null);
        boolean keymove = remote.hasKeyMoveSupport();
        boolean special = remote.getSpecialProtocols() != null;
        String notes = null;
        if (remote.usesEZRC()) {
            notes = "Learned Signals with Device Button and Key values shaded Pink (if selected, Red) are unassigned, so will be saved in a .rmir file but not uploaded to the remote.  If shaded Orange (if selected, Brown) there is a conflict with a Macro on the same Device Button/Key combination.  This is for information only, as both will be uploaded but they may not work as intended.";
        } else {
            notes = "Learned Signals with Device Button and Key values shaded Pink (if selected, Red) conflict with another Learned Signal on the same Device Button/Key combination that has higher priority, so that Learned Signal will be saved in a .rmir file but not uploaded to the remote.";
            if (keymove || special) {
                notes = notes + "  If shaded Orange (if selected, Brown) there is such a conflict with a ";
                notes = notes + (keymove && special ? "Key Move or Special Function" : (keymove ? "Key Move" : "Special Function"));
                notes = notes + ".  This is for information only, as both will be uploaded but they may not work as intended.";
            }
        }
        this.notesPane.setText(notes);
    }

    @Override
    public LearnedSignal createRowObject(LearnedSignal learnedSignal) {
        Remote remote = this.remoteConfig.getRemote();
        LearnedSignal newSignal = null;
        if (learnedSignal != null) {
            newSignal = new LearnedSignal(learnedSignal);
        }
        LearnedSignal ls = LearnedSignalDialog.showDialog(SwingUtilities.getRoot(this), newSignal, this.remoteConfig);
        return ls;
    }

    @Override
    protected void editRowObject(int row) {
        List<LearnedSignal> lsList = this.remoteConfig.getLearnedSignals();
        LearnedSignal baseLS = (LearnedSignal)this.getRowObject(row);
        int ndx = lsList.indexOf(baseLS);
        LearnedSignal newLS = this.createRowObject(baseLS);
        if (newLS != null) {
            lsList.remove(ndx);
            lsList.add(ndx, newLS);
            this.model.setRow(this.sorter.modelIndex(row), newLS);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.convertToUpgradeButton) {
            String message = null;
            int[] rows = null;
            this.finishEditing();
            if (this.table.getRowCount() == 0) {
                message = "There are no learned signals in this table.";
            } else {
                rows = this.table.getSelectedRows();
                if (rows.length == 0) {
                    message = "No signals selected.  You must select a consecutive set of signals to convert.";
                }
            }
            if (message != null) {
                String title = "Learned Signal Conversion";
                JOptionPane.showMessageDialog(RemoteMaster.getFrame(), message, title, 0, null);
                return;
            }
            ArrayList<LearnedSignal> signals = new ArrayList<LearnedSignal>();
            for (int i = 0; i < rows.length; ++i) {
                LearnedSignal s = (LearnedSignal)this.getRowObject(rows[i]);
                if (s.getDecodes().isEmpty()) continue;
                signals.add(s);
            }
            if (!signals.isEmpty()) {
                DeviceUpgradeConverter converter = new DeviceUpgradeConverter(this.remoteConfig, null);
                DeviceUpgrade upgrade = converter.convertToDeviceUpgrade(signals.toArray(new LearnedSignal[signals.size()]), false);
                String description = "Learned Signal Upgrade";
                String notes = "Device Upgrade automatically created by RemoteMaster from " + signals.size() + " Learned Signals.";
                upgrade.setDescription(description);
                upgrade.setNotes(notes);
                this.remoteConfig.updateImage();
            }
        } else if (source == this.timingSummaryButton) {
            LearnedSignalTimingSummaryDialog.showDialog(SwingUtilities.getRoot(this), this.remoteConfig);
        } else if (source == this.copyButton) {
            this.table.getTransferHandler().exportToClipboard(this.table, this.clipboard, 1);
        } else if (source == this.refreshButton) {
            final LearnedSignalTableModel lsModel = (LearnedSignalTableModel)this.model;
            String ftfVal = this.frequencyToleranceField.getText();
            String mlfVal = this.minLeadoutField.getText();
            if (ftfVal != null && !ftfVal.isEmpty() || mlfVal != null && !mlfVal.isEmpty()) {
                try {
                    final double currentFreqTol = LearnedSignal.getTmDecoderParams().getFrequencyTolerance();
                    double currentMinLdo = LearnedSignal.getTmDecoderParams().getMinimumLeadout();
                    if (ftfVal != null && !ftfVal.isEmpty()) {
                        double freqTol = Integer.parseInt(ftfVal);
                        LearnedSignal.getTmDecoderParams().setFrequencyTolerance(freqTol);
                    }
                    if (mlfVal != null && !mlfVal.isEmpty()) {
                        double minLdo = Double.parseDouble(mlfVal);
                        LearnedSignal.getTmDecoderParams().setMinimumLeadout(minLdo);
                    }
                    this.workingLabel.setVisible(true);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            for (LearnedSignal ls : LearnedSignalPanel.this.remoteConfig.getLearnedSignals()) {
                                ls.getDecodes(true);
                            }
                            lsModel.fireTableDataChanged();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    LearnedSignalPanel.this.workingLabel.setVisible(false);
                                    LearnedSignal.getTmDecoderParams().setFrequencyTolerance(currentFreqTol);
                                }
                            });
                        }
                    });
                }
                catch (NumberFormatException currentFreqTol) {}
            }
        } else if (source == this.lsbBtn || source == this.msbBtn || source == this.invertCheck) {
            BitDirection bDir = this.lsbBtn.isSelected() ? BitDirection.lsb : BitDirection.msb;
            boolean doInvert = this.invertCheck.isSelected();
            if (this.aParms.getBitDirection() != bDir || this.aParms.isInvert() != doInvert) {
                this.aParms = new Analyzer.AnalyzerParams(this.aParms.getFrequency(), null, bDir, false, null, 32, doInvert, new Burst.Preferences(), new ArrayList<String>(0));
                this.analyzeRow();
            }
        } else if (this.radixBtns.contains(source)) {
            int newRadix = radixInts.get(this.radixBtns.indexOf(source));
            if (this.radix != newRadix) {
                this.radix = newRadix;
                this.analyzeRow();
            }
        } else if (source == this.docuButton) {
            int row = this.table.getSelectedRow();
            LearnedSignal ls = (LearnedSignal)this.model.getRow(row);
            LearnedSignalDecode lsd = ls.getTableDecode();
            NamedProtocol np = null;
            String docu = null;
            String docuTitle = "Documentation";
            if (lsd != null && lsd.decode != null && (np = lsd.decode.getNamedProtocol()) != null) {
                docuTitle = np.getName() + " Documentation";
                if (np.getDocumentation() != null) {
                    Document doc = XmlUtils.newDocument(true);
                    Element root = doc.createElementNS(null, "html");
                    doc.appendChild(root);
                    root.appendChild(doc.importNode(np.getDocumentation(), true));
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try {
                        XmlUtils.printHtmlDOM(baos, doc, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e1) {
                        e1.printStackTrace();
                    }
                    docu = baos.toString();
                } else {
                    docu = "There is no documentation for this protocol.";
                }
            } else {
                docu = "No documentation available.";
            }
            JPanel panel = new JPanel(new BorderLayout());
            String info = "This is an extract from the menu item \"Help > IrpTransmogrifier Protocols\"";
            ProtocolDataPanel.DisplayArea da = new ProtocolDataPanel.DisplayArea(info, null);
            JTextPane docuPane = new JTextPane();
            docuPane.setContentType("text/html");
            docuPane.setText(docu);
            docuPane.setCaretPosition(0);
            docuPane.setEditable(false);
            JScrollPane scrollPane = new JScrollPane(docuPane);
            scrollPane.setPreferredSize(new Dimension(400, 400));
            panel.add((Component)da, "First");
            panel.add((Component)scrollPane, "Center");
            Object[] options = new String[]{"Close"};
            docuPane.addHyperlinkListener(ev -> {
                if (ev.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        URI base = new URI("file://" + RemoteMaster.getWorkDir() + "/RMProtocols.html");
                        URL url = ev.getURL() != null ? ev.getURL() : base.resolve(ev.getDescription()).toURL();
                        JP1Frame.browse(url);
                    }
                    catch (IOException | URISyntaxException ex) {
                        ex.printStackTrace();
                    }
                }
            });
            JOptionPane.showOptionDialog(this, panel, docuTitle, 0, -1, null, options, options[0]);
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        if (!e.getValueIsAdjusting()) {
            this.copyButton.setEnabled(this.table.getSelectedRowCount() >= 1);
        }
        this.analyzeRow();
    }

    private void analyzeRow() {
        if (this.table.getSelectedRowCount() == 1) {
            int row = this.table.getSelectedRow();
            LearnedSignal ls = (LearnedSignal)this.model.getRow(this.sorter.modelIndex(row));
            double freq = ls.getUnpackLearned().frequency;
            this.aParms = new Analyzer.AnalyzerParams(freq, null, this.aParms.getBitDirection(), false, null, 32, this.aParms.isInvert(), new Burst.Preferences(), new ArrayList<String>(0));
            this.irpAnalysisField.setText(ls.getAnalysis(this.aParms, this.radix));
            LearnedSignalDecode lsd = ls.getTableDecode();
            NamedProtocol np = null;
            if (lsd != null && lsd.decode != null && (np = lsd.decode.getNamedProtocol()) != null) {
                String params;
                String irpStr = np.toIrpString(this.radix);
                int split = irpStr.lastIndexOf(91);
                if (split >= 0) {
                    irpStr = irpStr.substring(0, split);
                }
                if ((split = (params = lsd.decode.toString(this.radix, ",")).indexOf(123)) >= 0) {
                    params = params.substring(split);
                    split = params.indexOf(125);
                    params = params.substring(0, split + 1);
                } else {
                    params = "";
                }
                irpStr = irpStr + params;
                irpStr = irpStr.replace("}{", ",");
                this.irpDecodeField.setText(irpStr);
                this.docuButton.setEnabled(true);
            } else {
                this.irpDecodeField.setText(null);
                this.docuButton.setEnabled(false);
            }
        } else {
            this.irpAnalysisField.setText(null);
            this.irpDecodeField.setText(null);
            this.docuButton.setEnabled(false);
        }
    }
}

