/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.Function;
import com.hifiremote.jp1.GeneralFunction;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JP1TableModel;
import com.hifiremote.jp1.KeyEditor;
import com.hifiremote.jp1.LearnedSignal;
import com.hifiremote.jp1.LearnedSignalDecode;
import com.hifiremote.jp1.RMColorEditor;
import com.hifiremote.jp1.RMColorRenderer;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RowNumberRenderer;
import com.hifiremote.jp1.SelectAllCellEditor;
import com.hifiremote.jp1.UnpackLearned;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class LearnedSignalTableModel
extends JP1TableModel<LearnedSignal> {
    private static final String[] colNames = new String[]{"#", "Name", "<html>Device<br>Button</html>", "Key", "Notes", "Size", "Freq.", "Protocol", "Device", "<html>Sub<br>Device</html>", "OBC", "Hex Cmd", "Misc", "<html>Size &amp<br>Color</html>"};
    private static final String[] colPrototypeNames = new String[]{" 00 ", "Name______", "__VCR/DVD__", "_xshift-VCR/DVD_", "A longish comment", "1024", "99999", "Proto", "Device", "Device", "OBC", "Hex Cmd", "Miscellaneous_________", "Color_"};
    private static final Class<?>[] colClasses = new Class[]{Integer.class, String.class, DeviceButton.class, Integer.class, String.class, Integer.class, Integer.class, String.class, Integer.class, Integer.class, Integer.class, String.class, String.class, Color.class};
    private RemoteConfiguration remoteConfig = null;
    private JComboBox deviceComboBox = new JComboBox();
    private DefaultCellEditor deviceEditor = new DefaultCellEditor(this.deviceComboBox);
    private KeyEditor keyEditor = new KeyEditor();
    private SelectAllCellEditor noteEditor = new SelectAllCellEditor();
    private RMColorEditor colorEditor = null;
    private RMColorRenderer colorRenderer = new RMColorRenderer();
    private SelectAllCellEditor selectAllEditor = null;

    public LearnedSignalTableModel() {
        this.deviceEditor.setClickCountToStart(2);
    }

    public void set(RemoteConfiguration remoteConfig) {
        this.remoteConfig = remoteConfig;
        if (remoteConfig != null) {
            this.colorEditor = new RMColorEditor(remoteConfig.getOwner());
            this.deviceComboBox.setModel(new DefaultComboBoxModel<DeviceButton>(remoteConfig.getRemote().getDeviceButtons()));
            this.highlightKeyRenderer.setRemote(remoteConfig.getRemote());
            this.keyEditor.setRemote(remoteConfig.getRemote());
            this.keyEditor.setType(Button.LEARN_BIND);
            this.setData(remoteConfig.getLearnedSignals());
            if (remoteConfig.getRemote().usesEZRC()) {
                this.selectAllEditor = new SelectAllCellEditor();
            }
        }
    }

    @Override
    public int getColumnCount() {
        int count = colNames.length - 2;
        if (this.remoteConfig != null && this.remoteConfig.allowHighlighting()) {
            ++count;
        }
        if (this.remoteConfig != null && this.remoteConfig.getRemote().usesEZRC()) {
            ++count;
        }
        if (this.remoteConfig != null && !this.remoteConfig.getRemote().hasDeviceSelection()) {
            --count;
        }
        return count;
    }

    private int getEffectiveColumn(int col) {
        if (!(col <= 0 || this.remoteConfig != null && this.remoteConfig.getRemote().usesEZRC())) {
            ++col;
        }
        if (col > 1 && this.remoteConfig != null && !this.remoteConfig.getRemote().hasDeviceSelection()) {
            ++col;
        }
        return col;
    }

    @Override
    public String getColumnName(int col) {
        col = this.getEffectiveColumn(col);
        return colNames[col];
    }

    @Override
    public String getColumnPrototypeName(int col) {
        col = this.getEffectiveColumn(col);
        return colPrototypeNames[col];
    }

    @Override
    public boolean isColumnWidthFixed(int col) {
        return (col = this.getEffectiveColumn(col)) != 1 && col != 4 && col != 7 && col != 12;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        col = this.getEffectiveColumn(col);
        return colClasses[col];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return (col = this.getEffectiveColumn(col)) > 0 && col < 5 || col == 13;
    }

    @Override
    public Object getValueAt(int row, int column) {
        column = this.getEffectiveColumn(column);
        LearnedSignal l = (LearnedSignal)this.getRow(row);
        UnpackLearned ul = l.getUnpackLearned();
        ArrayList<LearnedSignalDecode> da = l.getDecodes();
        int numDecodes = 0;
        int decodeIndex = 0;
        LearnedSignalDecode decode = null;
        if (da != null && (numDecodes = da.size()) > 1) {
            for (int i = 0; i < da.size(); ++i) {
                decode = da.get(i);
                if (decode.ignore) {
                    --numDecodes;
                    continue;
                }
                decodeIndex = i;
            }
        }
        if (numDecodes != 1 && column > 7 && column < 13 && (column != 12 || ul.error.isEmpty())) {
            return null;
        }
        if (numDecodes == 1 && column > 6 && column < 13) {
            decode = da.get(decodeIndex);
        }
        switch (column) {
            case 0: {
                return new Integer(row + 1);
            }
            case 1: {
                return l.getName();
            }
            case 2: {
                DeviceButton db = this.remoteConfig.getRemote().getDeviceButton(l.getDeviceButtonIndex());
                return db;
            }
            case 3: {
                return new Integer(l.getKeyCode());
            }
            case 4: {
                return l.getNotes();
            }
            case 5: {
                return l.getData().length();
            }
            case 6: {
                return new Integer(ul.frequency);
            }
            case 7: {
                if (numDecodes == 0) {
                    l.setTableDecode(null);
                    return "** None **";
                }
                if (numDecodes > 1) {
                    l.setTableDecode(null);
                    return "** Multiple **";
                }
                l.setTableDecode(decode);
                return decode.protocolName;
            }
            case 8: {
                if (decode.device == -1) {
                    return null;
                }
                return new Integer(decode.device);
            }
            case 9: {
                if (decode.subDevice == -1) {
                    return null;
                }
                return new Integer(decode.subDevice);
            }
            case 10: {
                if (decode.obc == -1) {
                    return null;
                }
                return new Integer(decode.obc);
            }
            case 11: {
                return Hex.toString(decode.hex);
            }
            case 12: {
                String message;
                String string = message = ul.error.isEmpty() ? "" : "Malformed signal: " + ul.error;
                if (numDecodes == 1) {
                    message = message + (ul.error.isEmpty() ? "" : "; ");
                    message = message + decode.miscMessage;
                }
                return message;
            }
            case 13: {
                return l.getHighlight();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        col = this.getEffectiveColumn(col);
        LearnedSignal l = (LearnedSignal)this.getRow(row);
        Remote remote = null;
        DeviceButton db = null;
        DeviceUpgrade upg = null;
        if (this.remoteConfig != null && (remote = this.remoteConfig.getRemote()).usesEZRC()) {
            db = remote.getDeviceButton(l.getDeviceButtonIndex());
            upg = db.getUpgrade();
        }
        switch (col) {
            case 1: {
                Function fn;
                l.setName((String)value);
                if (upg == null || (fn = upg.getFunction(l.getKeyCode())) == null) break;
                fn.setName((String)value);
                break;
            }
            case 2: {
                db = (DeviceButton)value;
                upg = db.getUpgrade();
                if (upg != null) {
                    GeneralFunction.User u = null;
                    if (l.getUsers().size() > 0) {
                        u = l.getUsers().get(0);
                    }
                    int keyCode = l.getKeyCode();
                    if (u != null) {
                        upg.getLearnedMap().remove(u.button.getKeyCode());
                        l.removeReference(u.db, u.button);
                    }
                    if (db != DeviceButton.noButton) {
                        l.setKeyCode(keyCode);
                    }
                    l.setDeviceButtonIndex(db.getButtonIndex());
                    if (upg == null) break;
                    u = l.setReference(this.remoteConfig);
                    if (l.getUsers().size() <= 0 || u.db.getUpgrade() == null) break;
                    u.db.getUpgrade().getLearnedMap().put(Integer.valueOf(u.button.getKeyCode()), l);
                    break;
                }
                db = (DeviceButton)value;
                l.setDeviceButtonIndex(db.getButtonIndex());
                break;
            }
            case 3: {
                if (upg != null) {
                    int keyCode;
                    GeneralFunction.User u = null;
                    if (l.getUsers().size() > 0) {
                        u = l.getUsers().get(0);
                    }
                    if (u != null) {
                        upg.getLearnedMap().remove(u.button.getKeyCode());
                        l.removeReference(u.db, u.button);
                    }
                    if ((keyCode = ((Integer)value).intValue()) != Button.noButton.getKeyCode()) {
                        l.setDeviceButtonIndex(db.getButtonIndex());
                    }
                    l.setKeyCode(((Integer)value).shortValue());
                    u = l.setReference(this.remoteConfig);
                    if (l.getUsers().size() <= 0 || u.db.getUpgrade() == null) break;
                    u.db.getUpgrade().getLearnedMap().put(Integer.valueOf(u.button.getKeyCode()), l);
                    break;
                }
                l.setKeyCode(((Integer)value).shortValue());
                break;
            }
            case 4: {
                l.setNotes((String)value);
                break;
            }
            case 13: {
                l.setHighlight((Color)value);
            }
        }
        this.propertyChangeSupport.firePropertyChange(col == 13 ? "highlight" : "data", null, null);
    }

    @Override
    public TableCellRenderer getColumnRenderer(int col) {
        if ((col = this.getEffectiveColumn(col)) == 0) {
            return new RowNumberRenderer();
        }
        if (col == 3) {
            return this.highlightKeyRenderer;
        }
        if (col == 13) {
            return this.colorRenderer;
        }
        return this.highlightRenderer;
    }

    @Override
    public TableCellEditor getColumnEditor(int col) {
        if ((col = this.getEffectiveColumn(col)) == 1) {
            return this.selectAllEditor;
        }
        if (col == 2) {
            DefaultCellEditor e = new DefaultCellEditor(this.deviceComboBox);
            e.setClickCountToStart(2);
            return e;
        }
        if (col == 3) {
            return this.keyEditor;
        }
        if (col == 4) {
            return this.noteEditor;
        }
        if (col == 13) {
            return this.colorEditor;
        }
        return null;
    }

    @Override
    public void setRow(int row, LearnedSignal value) {
        Remote remote = null;
        if (this.remoteConfig != null && (remote = this.remoteConfig.getRemote()).usesEZRC()) {
            LearnedSignal ls = (LearnedSignal)this.getRow(row);
            if (ls.getUsers().size() > 0) {
                for (GeneralFunction.User user : ls.getUsers()) {
                    DeviceButton db = user.db;
                    DeviceUpgrade upg = db.getUpgrade();
                    if (upg == null || upg.getLearnedMap() == null) continue;
                    upg.getLearnedMap().remove(user.button.getKeyCode());
                }
                value.getUsers().clear();
            }
            GeneralFunction.User u = value.setReference(this.remoteConfig);
            if (value.getUsers().size() > 0 && u.db.getUpgrade() != null) {
                u.db.getUpgrade().getLearnedMap().put(Integer.valueOf(u.button.getKeyCode()), value);
            }
        }
        super.setRow(row, value);
    }

    @Override
    public void insertRow(int row, LearnedSignal value) {
        if (this.remoteConfig != null && this.remoteConfig.getRemote().usesEZRC()) {
            Remote remote = this.remoteConfig.getRemote();
            DeviceButton db = remote.getDeviceButton(value.getDeviceButtonIndex());
            LearnedSignal ls = db.getUpgrade().getLearnedMap().get(value.getKeyCode());
            if (ls != null) {
                Button b = remote.getBaseButton(value.getKeyCode());
                ls.removeReference(db, b);
            }
            GeneralFunction.User u = value.setReference(this.remoteConfig);
            if (value.getUsers().size() > 0 && u.db.getUpgrade() != null) {
                u.db.getUpgrade().getLearnedMap().put(Integer.valueOf(u.button.getKeyCode()), value);
            }
        }
        super.insertRow(row, value);
    }

    @Override
    public void addRow(LearnedSignal value) {
        if (this.remoteConfig != null && this.remoteConfig.getRemote().usesEZRC()) {
            Remote remote = this.remoteConfig.getRemote();
            DeviceButton db = remote.getDeviceButton(value.getDeviceButtonIndex());
            LearnedSignal ls = db.getUpgrade().getLearnedMap().get(value.getKeyCode());
            if (ls != null) {
                Button b = remote.getBaseButton(value.getKeyCode());
                ls.removeReference(db, b);
            }
            GeneralFunction.User u = value.setReference(this.remoteConfig);
            if (value.getUsers().size() > 0 && u.db.getUpgrade() != null) {
                u.db.getUpgrade().getLearnedMap().put(Integer.valueOf(u.button.getKeyCode()), value);
            }
        }
        super.addRow(value);
    }

    @Override
    public void removeRow(int row) {
        if (this.remoteConfig != null && this.remoteConfig.getRemote().usesEZRC()) {
            LearnedSignal ls = (LearnedSignal)this.getRow(row);
            for (GeneralFunction.User user : ls.getUsers()) {
                DeviceButton db = user.db;
                DeviceUpgrade upg = db.getUpgrade();
                if (upg == null || upg.getLearnedMap() == null) continue;
                upg.getLearnedMap().remove(user.button.getKeyCode());
            }
        }
        super.removeRow(row);
    }
}

