/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

public class LearnedSignalTimingAnalysis {
    private String _Name;
    private String _Message;
    private int[] _Bursts;
    private int[][] _OneTimeDurations;
    private int[][] _RepeatDurations;
    private int[][] _ExtraDurations;
    private String _Separator;
    private int _SeparatorFirst;
    private int _SeparatorInterval;

    public String getName() {
        return this._Name;
    }

    public String getMessage() {
        return this._Message;
    }

    public int[] getBursts() {
        return this._Bursts;
    }

    public int[][] getOneTimeDurations() {
        return this._OneTimeDurations;
    }

    public int[][] getRepeatDurations() {
        return this._RepeatDurations;
    }

    public int[][] getExtraDurations() {
        return this._ExtraDurations;
    }

    public LearnedSignalTimingAnalysis(String name, int[] bursts, int[][] oneTime, int[][] repeat, int[][] extra, String sep, int sepFirst, int sepInterval, String message) {
        this._Name = name;
        this._Bursts = bursts;
        this._OneTimeDurations = oneTime;
        this._RepeatDurations = repeat;
        this._ExtraDurations = extra;
        this._Separator = sep;
        this._SeparatorFirst = sepFirst;
        this._SeparatorInterval = sepInterval;
        this._Message = message;
    }

    private String[] makeDurationStringList(int[][] durations) {
        if (durations == null || durations.length == 0) {
            return new String[0];
        }
        int r = 0;
        String[] results = new String[durations.length];
        for (int[] d : durations) {
            results[r++] = this.durationsToString(d, this._Separator, this._SeparatorFirst, this._SeparatorInterval);
        }
        return results;
    }

    public String[] getOneTimeDurationStringList() {
        return this.makeDurationStringList(this.getOneTimeDurations());
    }

    public String[] getRepeatDurationStringList() {
        return this.makeDurationStringList(this.getRepeatDurations());
    }

    public String[] getExtraDurationStringList() {
        return this.makeDurationStringList(this.getExtraDurations());
    }

    public String getBurstString() {
        return this.durationsToString(this.getBursts(), this._Separator, -2, 2);
    }

    public String getOneTimeDurationString() {
        return this.joinedDurationsToString(this.getOneTimeDurations(), this._Separator, this._SeparatorFirst, this._SeparatorInterval);
    }

    public String getRepeatDurationString() {
        return this.joinedDurationsToString(this.getRepeatDurations(), this._Separator, this._SeparatorFirst, this._SeparatorInterval);
    }

    public String getExtraDurationString() {
        return this.joinedDurationsToString(this.getExtraDurations(), this._Separator, this._SeparatorFirst, this._SeparatorInterval);
    }

    /*
     * WARNING - void declaration
     */
    public String durationsToString(int[] data, String sep, int sepFirst, int sepInterval) {
        StringBuilder str = new StringBuilder();
        if (data != null && data.length != 0) {
            void var8_11;
            int ndx;
            String string;
            int unit = 0;
            if (!(!this._Name.startsWith("LI") || sepFirst <= 0 || data[0] != (unit = Integer.parseInt(string = this._Message.substring((ndx = this._Message.lastIndexOf(32)) + 1, this._Message.length() - 1))) && data[0] != 2 * unit || data[1] != -unit && data[1] != -2 * unit)) {
                for (int i = 0; i < data.length - 1; ++i) {
                    if (data[i] != data[i + 1]) continue;
                    sepFirst = data[i] > 0 ? 1 : 2;
                    break;
                }
            }
            sepFirst = Math.abs(sepFirst);
            boolean isSigned = false;
            for (int d : data) {
                if (d >= 0) continue;
                isSigned = true;
                break;
            }
            boolean bl = false;
            while (var8_11 < data.length) {
                if (var8_11 > 0) {
                    str.append(' ');
                }
                if (!isSigned) {
                    str.append((var8_11 & 1) == 0 ? "+" : "-");
                } else if (data[var8_11] > 0) {
                    str.append('+');
                }
                str.append(data[var8_11]);
                if (var8_11 + true == sepFirst || (var8_11 + true - sepFirst) % sepInterval == false) {
                    str.append(sep);
                }
                ++var8_11;
            }
        }
        if (str.length() == 0) {
            return "** No signal **";
        }
        return str.toString();
    }

    public String joinedDurationsToString(int[][] data, String sep, int sepFirst, int sepInterval) {
        if (data == null) {
            return "** No signal **";
        }
        StringBuilder sb = new StringBuilder();
        for (int[] d : data) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(this.durationsToString(d, sep, sepFirst, sepInterval));
        }
        return sb.toString();
    }
}

