/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.LearnedSignalTimingAnalysis;
import com.hifiremote.jp1.LearnedSignalTimingAnalyzerBase;
import com.hifiremote.jp1.LearnedSignalTimingAnalyzerBiPhase;
import com.hifiremote.jp1.LearnedSignalTimingAnalyzerRaw;
import com.hifiremote.jp1.UnpackLearned;
import java.util.Iterator;

public class LearnedSignalTimingAnalyzer {
    private LearnedSignalTimingAnalyzerBase[] _Analyzers;
    private String[] _AnalyzerNames;
    private UnpackLearned _Data;
    private int _SelectedAnalyzer = -1;
    private String _SelectedAnalysisName = null;
    private int _SavedAnalyzer = -1;
    private String _SavedAnalysisName = null;

    public LearnedSignalTimingAnalyzer(UnpackLearned u) {
        this._Data = u;
        this._Analyzers = new LearnedSignalTimingAnalyzerBase[]{new LearnedSignalTimingAnalyzerBiPhase(u), new LearnedSignalTimingAnalyzerRaw(u)};
        this._AnalyzerNames = new String[this._Analyzers.length];
        for (int n = 0; n < this._Analyzers.length; ++n) {
            this._AnalyzerNames[n] = this._Analyzers[n].getName();
        }
    }

    public boolean getIsValid() {
        return this._Data.ok;
    }

    public String[] getAnalyzerNames() {
        return this._AnalyzerNames;
    }

    public LearnedSignalTimingAnalyzerBase getAnalyzer(String name) {
        for (int i = 0; i < this._AnalyzerNames.length; ++i) {
            if (!this._AnalyzerNames[i].equals(name)) continue;
            return this.getAnalyzer(i);
        }
        return null;
    }

    public LearnedSignalTimingAnalyzerBase getAnalyzer(int i) {
        return this._Analyzers[i];
    }

    public LearnedSignalTimingAnalyzerBase getPreferredAnalyzer() {
        for (LearnedSignalTimingAnalyzerBase a : this._Analyzers) {
            if (!a.hasAnalyses()) continue;
            return a;
        }
        return null;
    }

    public int getNumAnalyzers() {
        return this._Analyzers.length;
    }

    public Iterator<LearnedSignalTimingAnalyzerBase> getAnalyzers() {
        return new Iterator<LearnedSignalTimingAnalyzerBase>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i + 1 < LearnedSignalTimingAnalyzer.this._Analyzers.length;
            }

            @Override
            public LearnedSignalTimingAnalyzerBase next() {
                return LearnedSignalTimingAnalyzer.this._Analyzers[++this.i];
            }

            @Override
            public void remove() {
            }
        };
    }

    public void setSelectedAnalyzer(String name) {
        for (int i = 0; i < this._AnalyzerNames.length; ++i) {
            if (!this._AnalyzerNames[i].equals(name)) continue;
            this._SelectedAnalyzer = i;
            if (this.getSelectedAnalyzer().getPreferredAnalysis() != null) {
                this.setSelectedAnalysisName(this.getSelectedAnalyzer().getPreferredAnalysis().getName());
            }
            return;
        }
    }

    public void setSelectedAnalysisName(String name) {
        for (String n : this.getSelectedAnalyzer().getAnalysisNames()) {
            if (!n.equals(name)) continue;
            this._SelectedAnalysisName = name;
            return;
        }
    }

    public LearnedSignalTimingAnalyzerBase getSelectedAnalyzer() {
        this.initSelectedToPreferred();
        return this.getAnalyzer(this._SelectedAnalyzer);
    }

    public String getSelectedAnalysisName() {
        this.initSelectedToPreferred();
        return this._SelectedAnalysisName;
    }

    public LearnedSignalTimingAnalysis getSelectedAnalysis() {
        this.initSelectedToPreferred();
        return this.getSelectedAnalyzer().getAnalysis(this.getSelectedAnalysisName());
    }

    private void initSelectedToPreferred() {
        if (this._SelectedAnalyzer > -1) {
            return;
        }
        this.setSelectedAnalyzer(this.getPreferredAnalyzer().getName());
        this.setSelectedAnalysisName(this.getSelectedAnalyzer().getPreferredAnalysis().getName());
    }

    public void saveState() {
        this._SavedAnalyzer = this._SelectedAnalyzer;
        this._SavedAnalysisName = this._SelectedAnalysisName;
        for (LearnedSignalTimingAnalyzerBase a : this._Analyzers) {
            a.saveState();
        }
    }

    public void restoreState() {
        this._SelectedAnalyzer = this._SavedAnalyzer;
        this._SelectedAnalysisName = this._SavedAnalysisName;
        for (LearnedSignalTimingAnalyzerBase a : this._Analyzers) {
            a.restoreState();
        }
    }
}

