/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.LearnedSignalTimingAnalysis;
import com.hifiremote.jp1.UnpackLearned;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class LearnedSignalTimingAnalyzerBase {
    private HashMap<String, LearnedSignalTimingAnalysis> _Analyses;
    private UnpackLearned _Unpacked;
    private int _RoundTo = -1;
    private boolean _IsRoundingLocked = false;
    private int _SavedRoundTo = -1;
    private HashMap<String, LearnedSignalTimingAnalysis> _SavedAnalyses;

    protected void clearAnalyses() {
        this._Analyses = null;
    }

    protected UnpackLearned getUnpacked() {
        return this._Unpacked;
    }

    public int getRoundTo() {
        if (this._RoundTo == -1) {
            this._RoundTo = this.calcAutoRoundTo();
            this._Analyses = null;
        }
        return this._RoundTo;
    }

    public void setRoundTo(int roundTo) {
        if (!this._IsRoundingLocked && roundTo > 0 && this._RoundTo != roundTo && this.checkCandidacy(roundTo)) {
            this._RoundTo = roundTo;
            this._Analyses = null;
        }
    }

    public boolean getIsRoundingLocked() {
        return this._IsRoundingLocked;
    }

    public void lockRounding() {
        this._IsRoundingLocked = true;
    }

    public void unlockRounding() {
        this._IsRoundingLocked = false;
    }

    public void saveState() {
        this._SavedRoundTo = this._RoundTo;
        this._SavedAnalyses = this._Analyses;
    }

    public void restoreState() {
        if (this._RoundTo != this._SavedRoundTo) {
            this._Analyses = this._SavedAnalyses;
            this._RoundTo = this._SavedRoundTo;
        }
    }

    public LearnedSignalTimingAnalyzerBase(UnpackLearned u) {
        this._Unpacked = u;
    }

    public abstract String getName();

    protected abstract int calcAutoRoundTo();

    protected abstract int checkCandidacyImpl(int var1);

    protected abstract void analyzeImpl();

    protected abstract String getPreferredAnalysisName();

    protected boolean checkCandidacy(int roundTo) {
        int c = this.checkCandidacyImpl(roundTo);
        if (c == 0) {
            return false;
        }
        if (c == 2) {
            return true;
        }
        if (c != 1) {
            System.err.println("The checkCandidacyImpl method for analyzer " + this.getClass().getName() + " returned invalid value " + c + ".");
            return false;
        }
        try {
            LearnedSignalTimingAnalyzerBase a = (LearnedSignalTimingAnalyzerBase)this.getClass().getConstructor(UnpackLearned.class).newInstance(this._Unpacked);
            a._RoundTo = roundTo;
            a.analyze();
            return a.hasAnalyses();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyze() {
        LearnedSignalTimingAnalyzerBase learnedSignalTimingAnalyzerBase = this;
        synchronized (learnedSignalTimingAnalyzerBase) {
            if (this._Analyses != null) {
                return;
            }
            int r = this.getRoundTo();
            this._Analyses = new HashMap();
            if (r == 0) {
                return;
            }
            this.analyzeImpl();
        }
    }

    public boolean hasAnalyses() {
        return this.getAnalyses().size() > 0;
    }

    public LearnedSignalTimingAnalysis getPreferredAnalysis() {
        return this.getAnalysis(this.getPreferredAnalysisName());
    }

    public LearnedSignalTimingAnalysis getAnalysis(String name) {
        return this.getAnalyses().get(name);
    }

    public String[] getAnalysisNames() {
        String[] names = new String[this.getAnalyses().size()];
        return this.getAnalyses().keySet().toArray(names);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, LearnedSignalTimingAnalysis> getAnalyses() {
        LearnedSignalTimingAnalyzerBase learnedSignalTimingAnalyzerBase = this;
        synchronized (learnedSignalTimingAnalyzerBase) {
            if (this._Analyses == null) {
                this.analyze();
            }
            return this._Analyses;
        }
    }

    protected void addAnalysis(LearnedSignalTimingAnalysis analysis) {
        if (this._Analyses == null) {
            return;
        }
        this._Analyses.put(analysis.getName(), analysis);
    }

    protected static int[] arrayListToArray(ArrayList<Integer> data) {
        int r = 0;
        int[] result = new int[data.size()];
        for (int d : data) {
            result[r++] = d;
        }
        return result;
    }

    public static int[][] splitDurationsBeforeLeadIn(int[] durations) {
        int[][] seps = new int[][]{new int[2]};
        seps[0][0] = durations[0];
        seps[0][1] = durations[1];
        return LearnedSignalTimingAnalyzerBase.splitDurations(durations, seps, false);
    }

    public static int[][] splitDurations(int[] durations, int[][] separators, boolean splitAfter) {
        Object object;
        ArrayList<int[]> results = new ArrayList<int[]>();
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (i < durations.length) {
            Object separator = null;
            object = separators;
            int n = ((int[][])object).length;
            for (int j = 0; j < n; ++j) {
                Object tempSeparator;
                separator = tempSeparator = object[j];
                boolean found = false;
                if (separator != null && ((Object)separator).length > 0 && durations[i] == separator[0]) {
                    found = true;
                    for (int s = 1; s < ((Object)separator).length; ++s) {
                        found = found && i + s < durations.length && durations[i + s] == separator[s];
                    }
                }
                if (found) break;
                separator = null;
            }
            if (separator == null || i == 0 && !splitAfter) {
                list.add(durations[i++]);
                continue;
            }
            if (splitAfter) {
                for (int s = 0; s < ((Object)separator).length; ++s) {
                    list.add(durations[i++]);
                }
                results.add(LearnedSignalTimingAnalyzerBase.arrayListToArray(list));
                list.clear();
                continue;
            }
            results.add(LearnedSignalTimingAnalyzerBase.arrayListToArray(list));
            list.clear();
            for (int s = 0; s < ((Object)separator).length; ++s) {
                list.add(durations[i++]);
            }
        }
        if (!list.isEmpty()) {
            results.add(LearnedSignalTimingAnalyzerBase.arrayListToArray(list));
        }
        i = 0;
        int[][] data = new int[results.size()][];
        object = results.iterator();
        while (object.hasNext()) {
            int[] r = (int[])object.next();
            data[i++] = r;
        }
        return data;
    }
}

