/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.LearnedSignalTimingAnalysis;
import com.hifiremote.jp1.LearnedSignalTimingAnalyzerBase;
import com.hifiremote.jp1.UnpackLearned;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class LearnedSignalTimingAnalyzerBiPhase
extends LearnedSignalTimingAnalyzerBase {
    private int _Unit;
    private String _PreferredName;
    private int _SavedUnit;

    public LearnedSignalTimingAnalyzerBiPhase(UnpackLearned u) {
        super(u);
    }

    @Override
    public String getName() {
        return "Bi-Phase";
    }

    private HashMap<Integer, Integer> getDurationHistogram(int roundTo) {
        int[] durations = this.getUnpacked().getDurations(roundTo, true);
        HashMap<Integer, Integer> hist = new HashMap<Integer, Integer>();
        int unit = Integer.MAX_VALUE;
        for (int d : durations) {
            if (Math.abs(d) >= unit) continue;
            unit = Math.abs(d);
        }
        int leadIn1 = durations[0];
        int leadIn2 = durations[1];
        boolean leadInSpurious = !(leadIn1 != unit && leadIn1 != 2 * unit || leadIn2 != -unit && leadIn2 != -2 * unit);
        for (int i = 2; i < durations.length - 2; ++i) {
            int value = durations[i];
            int absValue = Math.abs(value);
            if (!hist.containsKey(absValue)) {
                if (value < 0 && (!leadInSpurious && durations[i + 1] == leadIn1 && durations[i + 2] == leadIn2 || leadInSpurious && absValue > 2 * unit)) {
                    i += 2;
                    continue;
                }
                hist.put(absValue, 1);
                continue;
            }
            hist.put(absValue, hist.get(absValue) + 1);
        }
        return hist;
    }

    private int[][] getDurationSplit(int[] durations) {
        boolean leadInMissing;
        if (durations == null || durations.length < 4) {
            return null;
        }
        boolean bl = leadInMissing = !(durations[0] != this._Unit && durations[0] != 2 * this._Unit || durations[1] != -this._Unit && durations[1] != -2 * this._Unit);
        if (!leadInMissing) {
            return LearnedSignalTimingAnalyzerBiPhase.splitDurationsBeforeLeadIn(durations);
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int d : durations) {
            int dAbs = Math.abs(d);
            if (d >= 0 || dAbs <= 2 * this._Unit) continue;
            list.add(d);
        }
        int[][] sep = new int[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            sep[i] = new int[]{(Integer)list.get(i)};
        }
        return LearnedSignalTimingAnalyzerBiPhase.splitDurations(durations, sep, true);
    }

    @Override
    protected int calcAutoRoundTo() {
        HashMap<Integer, Integer> hist = this.getDurationHistogram(1);
        int min = Integer.MAX_VALUE;
        for (int k : hist.keySet()) {
            if (k >= min) continue;
            min = k;
        }
        int limit = min + (int)(Math.pow(10.0, Math.floor(Math.log10(min))) / 2.0);
        int roundTo = 0;
        while (roundTo < limit) {
            if (!this.checkCandidacy(roundTo += 10)) continue;
            return roundTo;
        }
        return 0;
    }

    @Override
    protected int checkCandidacyImpl(int roundTo) {
        HashMap<Integer, Integer> hist = this.getDurationHistogram(roundTo);
        int min = Integer.MAX_VALUE;
        for (int d : hist.keySet()) {
            if (d >= min) continue;
            min = d;
        }
        if (min <= 0) {
            return 0;
        }
        for (int d : hist.keySet()) {
            if (d % min == 0 && d / min <= 2) continue;
            return 0;
        }
        return 1;
    }

    @Override
    public void saveState() {
        this._SavedUnit = this._Unit;
        super.saveState();
    }

    @Override
    public void restoreState() {
        super.restoreState();
        this._Unit = this._SavedUnit;
    }

    @Override
    protected void analyzeImpl() {
        HashMap<Integer, Integer> hist = this.getDurationHistogram(this.getRoundTo());
        this._Unit = Integer.MAX_VALUE;
        for (int d : hist.keySet()) {
            if (d >= this._Unit) continue;
            this._Unit = d;
        }
        System.err.println("BiPhaseAnalyzer: (" + this.hashCode() + ") Analyze beginning with rounding of " + this.getRoundTo() + " yielding unit size of " + this._Unit + "...");
        HashMap<String, int[][]> oneTime = this.AnalyzeDurationSet(this.getUnpacked().getOneTimeDurations(this.getRoundTo(), true));
        HashMap<String, int[][]> repeat = this.AnalyzeDurationSet(this.getUnpacked().getRepeatDurations(this.getRoundTo(), true));
        HashMap<String, int[][]> extra = this.AnalyzeDurationSet(this.getUnpacked().getExtraDurations(this.getRoundTo(), true));
        HashMap<String, Integer> codes = new HashMap<String, Integer>();
        if (oneTime != null) {
            for (String k : oneTime.keySet()) {
                codes.put(k, 0);
            }
        }
        if (repeat != null) {
            for (String k : repeat.keySet()) {
                codes.put(k, 0);
            }
        }
        if (extra != null) {
            for (String k : extra.keySet()) {
                codes.put(k, 0);
            }
        }
        String preferredCode = null;
        String preferredName = null;
        boolean allAlt = true;
        for (String code : codes.keySet()) {
            if (code.startsWith("?")) continue;
            allAlt = false;
            break;
        }
        for (String code : codes.keySet()) {
            int[][] tempRepeat;
            int[][] tempOneTime;
            if (!allAlt && code.startsWith("?")) continue;
            String altCode = "?,?" + code.substring(code.lastIndexOf(44));
            boolean valid = oneTime == null || oneTime.containsKey(code) || oneTime.containsKey(altCode);
            valid = valid && (repeat == null || repeat.containsKey(code) || repeat.containsKey(altCode));
            if (!(valid = valid && (extra == null || extra.containsKey(code) || extra.containsKey(altCode)))) continue;
            int[][] nArray = oneTime == null ? null : (tempOneTime = oneTime.get(code) != null ? oneTime.get(code) : oneTime.get(altCode));
            int[][] nArray2 = repeat == null ? null : (tempRepeat = repeat.get(code) != null ? repeat.get(code) : repeat.get(altCode));
            int[][] tempExtra = extra == null ? null : (extra.get(code) != null ? extra.get(code) : extra.get(altCode));
            String[] codeSplit = code.split(",");
            String msg = "Bi-Phase unit size is " + this._Unit + ".";
            String name = "LI " + codeSplit[0] + " LO " + codeSplit[2] + " " + (codeSplit[1].equals("1") ? "ODD" : "EVEN");
            this.addAnalysis(new LearnedSignalTimingAnalysis(name, this.getUnpacked().getBursts(this.getRoundTo()), tempOneTime, tempRepeat, tempExtra, ";", codeSplit[1].equals("1") ? 1 : 2, 2, msg));
            if (preferredCode != null && code.compareTo(preferredCode) >= 0) continue;
            preferredCode = code;
            preferredName = name;
        }
        this._PreferredName = preferredName;
        System.err.println("BiPhaseAnalyzer: analyzeImpl complete yielding " + this.getAnalyses().size() + " analyses preferring '" + this._PreferredName + "'.");
    }

    private HashMap<String, int[][]> AnalyzeDurationSet(int[] durations) {
        int[][] temp = this.getDurationSplit(durations);
        if (temp == null) {
            return null;
        }
        boolean leadInMissing = !(durations[0] != this._Unit && durations[0] != 2 * this._Unit || durations[1] != -this._Unit && durations[1] != -2 * this._Unit);
        HashMap<String, int[][]> results = new HashMap<String, int[][]>();
        int i = 0;
        HashMap<String, int[]> tempResults = null;
        for (int[] t : temp) {
            tempResults = this.AnalyzeDurations(t);
            if (tempResults == null || tempResults.size() == 0) {
                results.clear();
                return results;
            }
            Iterator<String> iterator = tempResults.keySet().iterator();
            while (iterator.hasNext()) {
                String k;
                String m = k = iterator.next();
                if (i == 0 && leadInMissing) {
                    m = "?,?" + k.substring(k.lastIndexOf(44));
                }
                if (!results.containsKey(m)) {
                    results.put(m, new int[temp.length][]);
                }
                results.get((Object)m)[i] = tempResults.get(k);
            }
            ++i;
        }
        ArrayList<String> codes = new ArrayList<String>();
        for (String k : results.keySet()) {
            codes.add(k);
        }
        for (String code : codes) {
            String altCode;
            if (code.startsWith("?") || results.get(altCode = "?,?" + code.substring(code.lastIndexOf(44))) == null) continue;
            results.get((Object)code)[0] = results.get(altCode)[0];
        }
        return results;
    }

    private HashMap<String, int[]> AnalyzeDurations(int[] durations) {
        if (durations == null || durations.length < 4) {
            return null;
        }
        int[] leadIn = new int[]{durations[0], durations[1]};
        int leadOut = durations[durations.length - 1];
        int[] temp = new int[durations.length - 2];
        for (int i = 2; i < durations.length - 1; ++i) {
            temp[i - 1] = durations[i];
        }
        HashMap<String, int[]> results = new HashMap<String, int[]>();
        HashMap<String, ArrayList<int[]>> tempResults = null;
        int num = Math.abs(leadIn[1]) / this._Unit;
        if (num > Math.abs(temp[1]) / this._Unit) {
            num = Math.abs(temp[1]) / this._Unit;
        }
        for (int n = 0; n <= num; ++n) {
            temp[0] = -1 * this._Unit * n;
            tempResults = this.analyzeSignalData(temp, leadOut);
            if (tempResults == null) continue;
            int leadIn1 = leadIn[1] + this._Unit * n;
            for (String k : tempResults.keySet()) {
                String code = Integer.toString(n) + "," + (leadIn1 == 0 ? 1 : 0) + "," + k;
                results.put(code, this.mergeAnalysisResult(leadIn[0], leadIn1, tempResults.get(k), k));
            }
        }
        return results;
    }

    private int[] mergeAnalysisResult(int leadIn0, int leadIn1, ArrayList<int[]> pairs, String code) {
        int[] data = new int[pairs.size() * 2 + (code == "2" ? 2 : 1)];
        int i = 0;
        data[i++] = leadIn0;
        if (leadIn1 != 0) {
            data[i++] = leadIn1;
        }
        for (int[] r : pairs) {
            if (r[0] != 0) {
                data[i++] = r[0];
            }
            if (r[1] == 0) continue;
            data[i++] = r[1];
        }
        return data;
    }

    private HashMap<String, ArrayList<int[]>> analyzeSignalData(int[] durations, int leadOut) {
        ArrayList<int[]> result = new ArrayList<int[]>();
        int[] p = null;
        for (int d : durations) {
            if (d == 0) continue;
            if (p == null) {
                if (Math.abs(d) != this._Unit) {
                    return null;
                }
                p = new int[2];
                p[0] = d;
                continue;
            }
            if (p[0] == -d) {
                p[1] = d;
                result.add(p);
                p = null;
                continue;
            }
            if (d == -2 * p[0]) {
                p[1] = d / 2;
                result.add(p);
                p = new int[2];
                p[0] = d / 2;
                continue;
            }
            return null;
        }
        if (p == null) {
            p = new int[]{leadOut, 0};
            result.add(p);
            HashMap<String, ArrayList<int[]>> results = new HashMap<String, ArrayList<int[]>>();
            results.put("0", result);
            return results;
        }
        ArrayList result2 = (ArrayList)result.clone();
        p[1] = -p[0];
        result.add(p);
        int[] lo = new int[]{leadOut + p[0], 0};
        result.add(lo);
        int[] lo2 = new int[]{p[0], leadOut};
        result2.add(lo2);
        HashMap<String, ArrayList<int[]>> results = new HashMap<String, ArrayList<int[]>>();
        results.put("1", result);
        results.put("2", result2);
        return results;
    }

    @Override
    protected String getPreferredAnalysisName() {
        return this._PreferredName;
    }
}

