/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.EndingFileFilter;
import com.hifiremote.jp1.JP1Frame;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.LearnedSignal;
import com.hifiremote.jp1.LearnedSignalTimingAnalysis;
import com.hifiremote.jp1.LearnedSignalTimingAnalyzer;
import com.hifiremote.jp1.LearnedSignalTimingAnalyzerBase;
import com.hifiremote.jp1.PropertyFile;
import com.hifiremote.jp1.RMFileChooser;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.UnpackLearned;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.harctoolbox.girr.Command;
import org.harctoolbox.girr.Remote;
import org.harctoolbox.girr.RemoteSet;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.irp.IrpTransmogrifier;

public class LearnedSignalTimingSummaryDialog
extends JDialog
implements ActionListener {
    private static final Class<?>[] colClasses = new Class[]{BurstPair.class, String.class};
    private static final String[] colPrototypeNames = new String[]{"Burst Pair_____", "Coding________"};
    private static final String[] colNames = new String[]{"Burst Pair", "Coding"};
    private RemoteConfiguration config = null;
    private JTextField burstRoundBox = new JTextField();
    private JComboBox<String> parityBox = null;
    private JRadioButton rawButton = new JRadioButton("Raw Data");
    private JRadioButton analyzedButton = new JRadioButton("Analyzed Data");
    private JRadioButton rawCodedButton = new JRadioButton("Raw Coded");
    private JRadioButton analyzedCodedButton = new JRadioButton("Analyzed Coded");
    private int display = 0;
    private LinkedHashMap<BurstPair, String>[] translation = new LinkedHashMap[2];
    private List<BurstPair> burstList = new ArrayList<BurstPair>();
    private TranslationTableModel model = null;
    private JTableX codingTable = null;
    private JScrollPane summaryScrollPane = null;
    private JPanel notePanel = null;
    private JButton okButton = new JButton("Close");
    private JButton saveButton = new JButton("Save");
    private String[] roundSettings = null;
    private int[] paritySettings = null;
    private String summaryText = null;
    private JTextArea summaryTextArea = null;
    private RMFileChooser fileChooser = null;
    private static LearnedSignalTimingSummaryDialog dialog = null;
    private static String[] parityList = new String[]{"", "Even", "Odd"};
    private static Rectangle bounds = null;

    public static void showDialog(Component locationComp, RemoteConfiguration config) {
        if (dialog == null) {
            dialog = new LearnedSignalTimingSummaryDialog(locationComp);
        }
        LearnedSignalTimingSummaryDialog.dialog.config = config;
        LearnedSignalTimingSummaryDialog.dialog.notePanel.setVisible(!RMIRSetup.suppressTimingSummaryInfo.isSelected());
        dialog.generateSummary();
        dialog.pack();
        dialog.setLocationRelativeTo(locationComp);
        if (bounds != null) {
            dialog.setBounds(bounds);
        }
        dialog.setVisible(true);
    }

    public static void reset() {
        if (dialog != null) {
            dialog.dispose();
            dialog = null;
        }
    }

    private LearnedSignalTimingSummaryDialog(Component c) {
        super((JFrame)SwingUtilities.getRoot(c));
        this.setTitle("Learned Signal Timing Summary");
        this.setModal(true);
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.notePanel = new JPanel(new BorderLayout());
        this.notePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0), BorderFactory.createLineBorder(Color.GRAY)));
        JTextArea noteTextArea = new JTextArea();
        noteTextArea.setEditable(false);
        noteTextArea.setLineWrap(true);
        noteTextArea.setWrapStyleWord(true);
        noteTextArea.setFont(new JLabel().getFont());
        noteTextArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        noteTextArea.setText("There are two displays, Raw and Analyzed, and two modes, Data and Coded, selected together by the radio buttons. The Raw display shows the burst pair timings as learned, the Analyzed display splits bursts to display as bi-phase pairs when this interpretation is possible.  The Data mode shows the burst timings, the Coded mode replaces burst pairs by coding strings set in the Coding table.  Uncoded burst pairs remain shown as timings.  The Burst Pair column in the Coding table gives an ordered list of all distinct burst pairs in the display.\nThe Parity and Round To boxes override the default settings but are overridden for individual signals by the Advanced Details editor if rounding has been set there.  These boxes, and the Coding table, can be edited only in Data mode.\nUse the \"Options > Suppress messages\" menu to suppress this message in future.");
        this.notePanel.add((Component)noteTextArea, "Center");
        contentPane.add((Component)this.notePanel, "First");
        int rows = RMIRSetup.suppressTimingSummaryInfo.isSelected() ? 25 : 21;
        this.summaryTextArea = new JTextArea(rows, 80);
        this.summaryTextArea.setEditable(false);
        this.summaryTextArea.setLineWrap(false);
        this.summaryScrollPane = new JScrollPane(this.summaryTextArea);
        this.summaryScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Timing Summary"), this.summaryScrollPane.getBorder()));
        contentPane.add((Component)this.summaryScrollPane, "Center");
        Box bottomBox = Box.createVerticalBox();
        contentPane.add((Component)bottomBox, "Last");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        bottomBox.add(buttonPanel);
        Box notes = Box.createVerticalBox();
        notes.add(new JLabel("Notes: Parity and rounding here does not override selected analysis settings."));
        notes.add(new JLabel("Also analyzed signals will only change if the new settings yields a valid analysis."));
        this.paritySettings = new int[]{0, 0};
        this.roundSettings = new String[]{null, null};
        this.parityBox = new JComboBox<String>(parityList);
        buttonPanel.add(notes);
        buttonPanel.add(new JLabel("  Parity:"));
        buttonPanel.add(this.parityBox);
        buttonPanel.add(new JLabel("  Round To: "));
        buttonPanel.add(this.burstRoundBox);
        buttonPanel.add(new JLabel("   "));
        this.parityBox.addActionListener(this);
        this.burstRoundBox.setColumns(4);
        this.burstRoundBox.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                LearnedSignalTimingSummaryDialog.this.generateSummary();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LearnedSignalTimingSummaryDialog.this.generateSummary();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                LearnedSignalTimingSummaryDialog.this.generateSummary();
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.rawButton);
        group.add(this.analyzedButton);
        group.add(this.rawCodedButton);
        group.add(this.analyzedCodedButton);
        this.rawButton.addActionListener(this);
        this.rawButton.setToolTipText("Display raw data for each signal");
        this.rawButton.setSelected(true);
        this.rawCodedButton.addActionListener(this);
        this.rawCodedButton.setToolTipText("Display raw data with burst pairs converted to codes");
        this.analyzedButton.addActionListener(this);
        this.analyzedButton.setToolTipText("Display the selected analysis for each signal");
        this.analyzedCodedButton.addActionListener(this);
        this.analyzedCodedButton.setToolTipText("Display analysis with burst pairs converted to codes");
        this.saveButton.addActionListener(this);
        this.saveButton.setToolTipText("Save Summary as .girr or .csv file");
        buttonPanel.add(this.saveButton);
        this.okButton.addActionListener(this);
        this.okButton.setToolTipText("Close the Summary");
        buttonPanel.add(this.okButton);
        this.model = new TranslationTableModel();
        this.codingTable = new JTableX(this.model);
        JPanel codePanel = new JPanel(new BorderLayout());
        codePanel.setBorder(BorderFactory.createTitledBorder("Set burst codes:"));
        JScrollPane scrollPane = new JScrollPane(this.codingTable, 20, 31);
        codePanel.add((Component)scrollPane, "Center");
        contentPane.add((Component)codePanel, "Before");
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0), BorderFactory.createTitledBorder("Select display:")));
        codePanel.add((Component)box, "Last");
        box.add(this.rawButton);
        box.add(this.rawCodedButton);
        box.add(Box.createVerticalStrut(5));
        box.add(this.analyzedButton);
        box.add(this.analyzedCodedButton);
        TableColumnModel columnModel = this.codingTable.getColumnModel();
        JLabel l = new JLabel();
        int width = 0;
        for (int i = 0; i < colPrototypeNames.length; ++i) {
            l.setText(colPrototypeNames[i]);
            width = Math.max(width, l.getPreferredSize().width);
            TableColumn column = columnModel.getColumn(i);
            column.setMinWidth(width);
            column.setMaxWidth(2 * width);
            column.setPreferredWidth((int)(1.5 * (double)width));
        }
        Dimension d = this.codingTable.getPreferredSize();
        d.width -= scrollPane.getVerticalScrollBar().getPreferredSize().width;
        this.codingTable.setPreferredScrollableViewportSize(d);
        this.translation[0] = new LinkedHashMap();
        this.translation[1] = new LinkedHashMap();
    }

    private void appendDurations(StringBuilder summary, String[] durationStrings, boolean autoCode, String intro) {
        boolean first = true;
        for (String d : durationStrings) {
            if (first) {
                first = false;
                summary.append(intro);
            } else {
                summary.append("\n\t\t\t\t\t\tMore:\t");
            }
            if (this.display < 2) {
                summary.append(d);
                this.addTranslationKeys(d, autoCode);
                continue;
            }
            summary.append(this.durationsToCoding(d));
        }
        summary.append('\n');
    }

    private void generateSummary() {
        String roundText;
        int r = 1;
        this.roundSettings[this.display & 1] = roundText = this.burstRoundBox.getText();
        int parity = this.paritySettings[this.display & 1];
        boolean roundingSet = false;
        if (roundText != null && !roundText.isEmpty()) {
            try {
                r = Integer.parseInt(roundText);
                roundingSet = true;
            }
            catch (NumberFormatException e) {
                r = 1;
            }
        }
        if (this.codingTable.getCellEditor() != null) {
            this.codingTable.getCellEditor().stopCellEditing();
        }
        List<LearnedSignal> signals = this.config.getLearnedSignals();
        Remote remote = this.config.getRemote();
        if (this.display < 2) {
            this.burstList.clear();
        }
        StringBuilder summary = new StringBuilder();
        summary.append("LEARNED SIGNALS:\n");
        summary.append(this.display == 0 ? "RAW TIMING DATA:\n" : (this.display == 1 ? "SELECTED DATA ANALYSES:\n" : (this.display == 2 ? "CODED RAW DATA:\n" : "CODED ANALYSES:\n")));
        summary.append("#\tName\tDevice\tKey\tNotes\tFreq\t");
        summary.append(this.display == 0 ? "Raw Timing Data\n" : (this.display == 1 ? "Analyzed Timing Data\n" : (this.display == 2 ? "Raw Timing Data with Coding\n" : "Analyzed Timing Data with Coding\n")));
        int i = 1;
        for (LearnedSignal s : signals) {
            UnpackLearned ul = s.getUnpackLearned();
            summary.append(i++);
            summary.append('\t');
            summary.append(s.getName() != null ? s.getName() : "");
            summary.append('\t');
            summary.append(remote.getDeviceButton(s.getDeviceButtonIndex()).getName());
            summary.append('\t');
            summary.append(remote.getButtonName(s.getKeyCode()));
            summary.append('\t');
            summary.append(s.getNotes() == null ? "" : s.getNotes());
            if (ul.ok) {
                summary.append('\t');
                summary.append(ul.frequency);
                summary.append('\t');
                LearnedSignalTimingAnalyzer lsta = s.getTimingAnalyzer();
                LearnedSignalTimingAnalyzerBase analyzer = (this.display & 1) == 0 ? lsta.getAnalyzer("Raw Data") : lsta.getSelectedAnalyzer();
                LearnedSignalTimingAnalysis analysis = null;
                boolean autoCode = analyzer.getName().equals("Bi-Phase");
                if (!analyzer.getIsRoundingLocked()) {
                    analyzer.saveState();
                    analyzer.clearAnalyses();
                    analyzer.setRoundTo(roundingSet ? r : analyzer.calcAutoRoundTo());
                }
                String displayAnalysisName = lsta.getSelectedAnalysisName();
                String[] analysisNames = analyzer.getAnalysisNames();
                String currentParity = parityList[parity];
                if (!(parity <= 0 || (this.display & 1) != 0 && displayAnalysisName.toUpperCase().contains(parityList[parity].toUpperCase()))) {
                    if (analyzer.getName().equals("Raw Data")) {
                        displayAnalysisName = currentParity;
                    } else {
                        displayAnalysisName = null;
                        for (String name : analysisNames) {
                            if (!name.toUpperCase().contains(currentParity.toUpperCase())) continue;
                            displayAnalysisName = name;
                            break;
                        }
                    }
                } else if (parity == 0 && (this.display & 1) == 0 && !lsta.getSelectedAnalyzer().getName().equals("Raw Data")) {
                    displayAnalysisName = "Even";
                }
                analysis = analyzer.getAnalysis(displayAnalysisName);
                if (analysis == null) {
                    analysis = analyzer.getPreferredAnalysis();
                }
                if (!analyzer.getIsRoundingLocked()) {
                    analyzer.restoreState();
                }
                if (analysis != null && ul.oneTime > 0 && ul.extra > 0 && ul.repeat == 0) {
                    this.appendDurations(summary, analysis.getOneTimeDurationStringList(), autoCode, "Once:\t");
                    this.appendDurations(summary, analysis.getExtraDurationStringList(), autoCode, "\t\t\t\t\t\tMore:\t");
                    continue;
                }
                if (analysis != null) {
                    String prefix = "";
                    if (ul.oneTime > 0) {
                        this.appendDurations(summary, analysis.getOneTimeDurationStringList(), autoCode, prefix + "Once:\t");
                        prefix = "\t\t\t\t\t\t";
                    }
                    if (ul.repeat > 0) {
                        this.appendDurations(summary, analysis.getRepeatDurationStringList(), autoCode, prefix + "Repeat:\t");
                        prefix = "\t\t\t\t\t\t";
                    }
                    if (ul.extra <= 0) continue;
                    this.appendDurations(summary, analysis.getExtraDurationStringList(), autoCode, prefix + "Extra:\t");
                    continue;
                }
                summary.append("** No valid analysis **\n");
                continue;
            }
            summary.append("** No signal **\n");
        }
        this.model.set();
        this.summaryText = summary.toString();
        this.summaryTextArea.setText(this.summaryText);
        dialog.validate();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LearnedSignalTimingSummaryDialog.this.summaryScrollPane.getVerticalScrollBar().setValue(0);
            }
        });
    }

    private void saveRawGirr(File file) {
        List<LearnedSignal> signals = this.config.getLearnedSignals();
        Remote remote = this.config.getRemote();
        LinkedHashMap devices = new LinkedHashMap(8);
        int failureCount = 0;
        for (LearnedSignal learnedSignal : signals) {
            Map<String, Command> device;
            IrSignal irSignal = learnedSignal.getIrSignal();
            if (irSignal == null) {
                ++failureCount;
                System.err.println("Failed due to null irSignal for " + learnedSignal.getName() + " on device " + remote.getDeviceButton(learnedSignal.getDeviceButtonIndex()).getName().trim());
                continue;
            }
            String commandName = learnedSignal.getName() != null ? learnedSignal.getName() : remote.getButtonName(learnedSignal.getKeyCode());
            String notes = learnedSignal.getNotes() != null ? learnedSignal.getNotes() : "";
            Command command = new Command(commandName, notes, irSignal);
            String deviceName = remote.getDeviceButton(learnedSignal.getDeviceButtonIndex()).getName().trim();
            if (!devices.containsKey(deviceName)) {
                device = new LinkedHashMap(16);
                devices.put(deviceName, device);
            }
            device = (Map)devices.get(deviceName);
            device.put(commandName, command);
        }
        LinkedHashMap<String, org.harctoolbox.girr.Remote> girrRemotes = new LinkedHashMap<String, org.harctoolbox.girr.Remote>(devices.size());
        for (Map.Entry entry : devices.entrySet()) {
            String deviceName = (String)entry.getKey();
            org.harctoolbox.girr.Remote girrRemote = new org.harctoolbox.girr.Remote(new Remote.MetaData(deviceName), null, null, (Map)entry.getValue(), null);
            girrRemotes.put(deviceName, girrRemote);
        }
        RemoteSet remoteSet = new RemoteSet(System.getProperty("user.name", ""), "Raw export from Learning Signal Timing Summary of RemoteMaster", new Date().toString(), RemoteMaster.class.getSimpleName(), RemoteMaster.getFullVersion(), IrpTransmogrifier.class.getSimpleName(), "1.2.14", null, girrRemotes);
        if (failureCount > 0) {
            String string = "Failed to include " + failureCount + " signals, see rmaster.err for list.";
            JOptionPane.showMessageDialog(this, string, "Raw Girr File", 1);
        }
        try {
            remoteSet.print(file.getAbsolutePath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void save(File file) {
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            String temp = this.summaryText.substring(this.summaryText.indexOf(35));
            temp = temp.replaceAll("Once:\t", "");
            temp = temp.replaceAll("\n\t\t\t\t\t\tRepeat:\t", "\t");
            temp = temp.replaceAll("\"", "\"\"");
            temp = temp.replaceAll("\t", "\",\"");
            temp = temp.replaceAll("\n", "\"\n\"");
            out.print("\"" + temp + "\"");
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.okButton) {
            bounds = this.getBounds();
            this.setVisible(false);
        } else if (source == this.saveButton) {
            int returnVal;
            PropertyFile properties = JP1Frame.getProperties();
            File dir = properties.getFileProperty("IRPath");
            EndingFileFilter girrFilter = new EndingFileFilter("Girr files (*.girr)", new String[]{".girr"});
            EndingFileFilter csvFilter = new EndingFileFilter("Comma-separated values (*.csv)", new String[]{".csv"});
            if (this.fileChooser == null) {
                this.fileChooser = new RMFileChooser(dir);
                this.fileChooser.setAcceptAllFileFilterUsed(false);
                this.fileChooser.addChoosableFileFilter(girrFilter);
                this.fileChooser.addChoosableFileFilter(csvFilter);
                this.fileChooser.setFileFilter(girrFilter);
                this.fileChooser.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent event) {
                        RMIRSetup.fileFilterChangeEvent(event);
                    }
                });
            }
            if ((returnVal = this.fileChooser.showSaveDialog(this)) == 0) {
                String name = this.fileChooser.getSelectedFile().getAbsolutePath();
                String ending = ((EndingFileFilter)this.fileChooser.getFileFilter()).getEndings()[0];
                if (!name.toLowerCase().endsWith(ending)) {
                    name = name + ending;
                }
                File file = new File(name);
                dir = file.getParentFile();
                properties.setProperty("IRPath", dir);
                int rc = 0;
                if (file.exists()) {
                    rc = JOptionPane.showConfirmDialog(this, file.getName() + " already exists.  Do you want to replace it?", "Replace existing file?", 0);
                }
                if (rc == 0) {
                    if (ending.equals(girrFilter.getEndings()[0])) {
                        this.saveRawGirr(file);
                    } else if (ending.equals(csvFilter.getEndings()[0])) {
                        this.save(file);
                    }
                }
            }
        } else if (source == this.rawButton && this.rawButton.isSelected()) {
            this.display = 0;
            this.burstRoundBox.setText(this.roundSettings[0]);
            this.parityBox.setSelectedIndex(this.paritySettings[0]);
            this.generateSummary();
        } else if (source == this.analyzedButton && this.analyzedButton.isSelected()) {
            this.display = 1;
            this.burstRoundBox.setText(this.roundSettings[1]);
            this.parityBox.setSelectedIndex(this.paritySettings[1]);
            this.generateSummary();
        } else if (source == this.rawCodedButton && this.rawCodedButton.isSelected()) {
            this.display = 2;
            this.burstRoundBox.setText(this.roundSettings[0]);
            this.parityBox.setSelectedIndex(this.paritySettings[0]);
            this.generateSummary();
        } else if (source == this.analyzedCodedButton && this.analyzedCodedButton.isSelected()) {
            this.display = 3;
            this.burstRoundBox.setText(this.roundSettings[1]);
            this.parityBox.setSelectedIndex(this.paritySettings[1]);
            this.generateSummary();
        } else if (source == this.parityBox) {
            this.paritySettings[this.display & 1] = this.parityBox.getSelectedIndex();
            this.generateSummary();
        }
    }

    private void addTranslationKeys(String durationString, boolean autoCode) {
        StringTokenizer st = new StringTokenizer(durationString, ";");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            int pos = token.indexOf(32);
            int p1 = 0;
            int p2 = 0;
            if (pos < 0 || token.contains("No signal")) continue;
            try {
                p1 = Integer.parseInt(token.substring(0, pos));
                p2 = Integer.parseInt(token.substring(pos + 1).trim());
                BurstPair bp = new BurstPair(p1, p2);
                if (!this.burstList.contains(bp)) {
                    this.burstList.add(bp);
                }
                if (!autoCode || p2 != -p1 || this.translation[this.display & 1].get(bp) != null) continue;
                this.translation[this.display & 1].put(bp, p1 < 0 ? "0" : "1");
            }
            catch (Exception e) {
                System.err.println("Bad burst pair in string " + durationString);
            }
        }
    }

    private String durationsToCoding(String durationString) {
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(durationString, ";");
        BurstPair bp = null;
        int count = st.countTokens();
        String lastCode = null;
        for (int i = 0; i < count; ++i) {
            String token = st.nextToken().trim();
            String code = null;
            int pos = token.indexOf(32);
            int p1 = 0;
            int p2 = 0;
            if (pos >= 0) {
                if (token.contains("No signal")) continue;
                try {
                    p1 = Integer.parseInt(token.substring(0, pos));
                    p2 = Integer.parseInt(token.substring(pos + 1).trim());
                    bp = new BurstPair(p1, p2);
                    code = this.translation[this.display & 1].get(bp);
                }
                catch (Exception e) {
                    System.err.println("Bad burst pair in string " + durationString);
                }
            }
            if (i > 0 && lastCode == null && code != null) {
                sb.append("; " + code);
            } else if (i > 0 && code == null) {
                sb.append("; " + token);
            } else if (code != null) {
                sb.append(code);
            } else {
                sb.append(token);
            }
            lastCode = code;
        }
        return sb.toString();
    }

    public class TranslationTableModel
    extends AbstractTableModel {
        @Override
        public Class<?> getColumnClass(int col) {
            if (col < colClasses.length) {
                return colClasses[col];
            }
            return null;
        }

        @Override
        public String getColumnName(int col) {
            if (col < colNames.length) {
                return colNames[col];
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1 && LearnedSignalTimingSummaryDialog.this.display < 2;
        }

        @Override
        public int getRowCount() {
            return LearnedSignalTimingSummaryDialog.this.burstList.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int column) {
            BurstPair key = row < LearnedSignalTimingSummaryDialog.this.burstList.size() ? (BurstPair)LearnedSignalTimingSummaryDialog.this.burstList.get(row) : null;
            switch (column) {
                case 0: {
                    return key;
                }
                case 1: {
                    return key == null ? null : LearnedSignalTimingSummaryDialog.this.translation[LearnedSignalTimingSummaryDialog.this.display & 1].get(key);
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            BurstPair key = (BurstPair)LearnedSignalTimingSummaryDialog.this.burstList.get(row);
            switch (column) {
                case 1: {
                    String s = ((String)value).trim();
                    if (s == null || s.isEmpty()) {
                        LearnedSignalTimingSummaryDialog.this.translation[LearnedSignalTimingSummaryDialog.this.display & 1].remove(key);
                        break;
                    }
                    LearnedSignalTimingSummaryDialog.this.translation[LearnedSignalTimingSummaryDialog.this.display & 1].put(key, s);
                }
            }
            this.fireTableCellUpdated(row, column);
        }

        public void set() {
            LearnedSignalTimingSummaryDialog.this.burstRoundBox.setEnabled(LearnedSignalTimingSummaryDialog.this.display < 2);
            LearnedSignalTimingSummaryDialog.this.parityBox.setEnabled(LearnedSignalTimingSummaryDialog.this.display < 2);
            Collections.sort(LearnedSignalTimingSummaryDialog.this.burstList, new Comparator<BurstPair>(){

                @Override
                public int compare(BurstPair bp1, BurstPair bp2) {
                    if (Math.abs(bp1.b1) < Math.abs(bp2.b1)) {
                        return -1;
                    }
                    if (Math.abs(bp1.b1) > Math.abs(bp2.b1)) {
                        return 1;
                    }
                    if (Math.abs(bp1.b2) < Math.abs(bp2.b2)) {
                        return -1;
                    }
                    if (Math.abs(bp1.b2) > Math.abs(bp2.b2)) {
                        return 1;
                    }
                    if (bp1.b1 < bp2.b1) {
                        return -1;
                    }
                    if (bp1.b1 > bp2.b1) {
                        return 1;
                    }
                    return 0;
                }
            });
            this.fireTableDataChanged();
        }
    }

    private class BurstPair {
        public int b1;
        public int b2;

        public BurstPair(int b1, int b2) {
            this.b1 = b1;
            this.b2 = b2;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof BurstPair)) {
                return false;
            }
            BurstPair bp = (BurstPair)obj;
            return this.b1 == bp.b1 && this.b2 == bp.b2;
        }

        public int hashCode() {
            return Objects.hash(this.b1, this.b2);
        }

        private String signed(int b) {
            String sign = b > 0 ? "+" : "";
            return sign + b;
        }

        public String toString() {
            return this.signed(this.b1) + " " + this.signed(this.b2);
        }
    }
}

