/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.AssemblerOpCode;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JP2Analyzer;
import com.hifiremote.jp1.LittleEndianProcessor;
import com.hifiremote.jp1.assembler.MAXQ610data;
import java.util.LinkedHashMap;

public class MAXQProcessor
extends LittleEndianProcessor {
    private PFX pfx = new PFX();

    public MAXQProcessor(String name) {
        super(name);
        this.setRAMAddress(256);
        this.setPageSize(512);
    }

    @Override
    public String getEquivalentName() {
        return "MAXQ610";
    }

    @Override
    public AssemblerOpCode.AddressMode disasmModify(AssemblerOpCode.AddressMode mode, Object[] obj) {
        int sIndex = 0;
        int sMod = 0;
        int dIndex = 0;
        int dMod = 0;
        mode.nibbleArgs = 0;
        switch (mode.modifier) {
            case 1: {
                LinkedHashMap<String, AssemblerOpCode.AddressMode> modes = this.getAddressModes();
                int op1 = (Integer)obj[0];
                if (op1 < 112) {
                    mode = modes.get("Fun1");
                    break;
                }
                if (op1 >= 128) break;
                mode = modes.get("Fun1B");
                break;
            }
            case 2: {
                sIndex = (Integer)obj[0];
                sMod = (Integer)obj[1];
                obj[0] = (this.pfx.state == 2 ? (this.pfx.val & 0xFF) << 8 : 0) | sIndex << 4 | sMod;
                if (this.pfx.state != 2) break;
                mode = new AssemblerOpCode.AddressMode(mode);
                mode.format = mode.format.replace("02X", "04X");
                mode.relMap = 0;
                mode.absMap = 1;
                if (this.addressList.contains(this.pfx.addr)) break;
                this.addressList.add(this.pfx.addr);
                break;
            }
            case 3: {
                sIndex = this.applySrcPrefix((Integer)obj[0]);
                sMod = (Integer)obj[1];
                dIndex = (Integer)obj[2] & 7;
                obj[0] = this.getSource(sIndex, sMod);
                obj[2] = dIndex;
                break;
            }
            case 4: {
                dIndex = this.applyDstPrefix(2, (Integer)obj[0] & 7);
                dMod = (Integer)obj[1];
                obj[0] = this.getDest(dIndex, dMod);
                break;
            }
            case 5: {
                sIndex = (Integer)obj[0];
                dIndex = this.applyDstPrefix(2, (Integer)obj[1] & 7);
                dMod = (Integer)obj[2];
                obj[0] = sIndex & 7;
                obj[1] = this.getDest(dIndex, dMod);
                break;
            }
            case 6: {
                sIndex = (Integer)obj[0];
                sMod = (Integer)obj[1];
                dIndex = this.applyDstPrefix(2, (Integer)obj[2] & 7);
                dMod = (Integer)obj[3];
                obj[0] = (this.pfx.state == 2 ? (this.pfx.val & 0xFF) << 8 : 0) | sIndex << 4 | sMod;
                obj[2] = this.getDest(dIndex, dMod);
                if (this.pfx.state != 2) break;
                mode = new AssemblerOpCode.AddressMode(mode);
                mode.format = mode.format.replace("02X", "04X");
                break;
            }
            case 7: {
                sIndex = this.applySrcPrefix((Integer)obj[0]);
                sMod = (Integer)obj[1];
                dIndex = this.applyDstPrefix(2, (Integer)obj[2] & 7);
                dMod = (Integer)obj[3];
                obj[0] = this.getSource(sIndex, sMod);
                obj[2] = this.getDest(dIndex, dMod);
            }
        }
        return mode;
    }

    private int applyDstPrefix(int state, int dIndex) {
        if (this.pfx.state == state) {
            dIndex += (this.pfx.ndx >> 1) * 8;
            if (!this.addressList.contains(this.pfx.addr)) {
                this.addressList.add(this.pfx.addr);
            }
        }
        return dIndex;
    }

    private int applySrcPrefix(int sIndex) {
        if (this.pfx.state == 2) {
            sIndex += (this.pfx.ndx & 1) * 16;
        }
        return sIndex;
    }

    @Override
    public AssemblerOpCode getOpCode(Hex hex) {
        if (!this.getName().contains("Native")) {
            return super.getOpCode(hex);
        }
        if (hex == null || hex.length() == 0) {
            return null;
        }
        AssemblerOpCode opCode = new AssemblerOpCode();
        LinkedHashMap<String, AssemblerOpCode.AddressMode> modes = this.getAddressModes();
        opCode.setHex(hex.subHex(0, 2));
        opCode.setLength(1);
        short[] data = opCode.getHex().getData();
        int flag = data[1] >> 7;
        int dIndex = this.applyDstPrefix(1, data[1] >> 4 & 7);
        int dMod = data[1] & 0xF;
        int sIndex = data[0] >> 4;
        int sMod = data[0] & 0xF;
        if (flag == 0 || this.getSource(sIndex, sMod).length() > 1 && (dMod != 10 || sMod != 10)) {
            if (dMod == 13 && dIndex == 0) {
                opCode.setName("PUSH");
                opCode.setMode(modes.get(flag == 0 ? "Imm" : "Src"));
            } else if (this.getDest(dIndex, dMod).length() > 1) {
                if (flag == 1 && sMod == 13 && (sIndex & 7) == 0) {
                    opCode.setName(sIndex == 0 ? "POP" : "POPI");
                    opCode.setMode(modes.get("Dst"));
                } else {
                    opCode.setName("MOVE");
                    opCode.setMode(modes.get(flag == 0 ? "DstImm" : "DstSrc"));
                    if (dMod == 11 && flag == 0) {
                        this.pfx.set(JP2Analyzer.currentAddr, dIndex, sIndex << 4 | sMod);
                    } else if (flag == 0 && dMod == 15 && (dIndex & 3) == 3) {
                        opCode.setMode(modes.get("DstImmZ"));
                    }
                }
            } else if (dMod == 7) {
                opCode.setName("MOVE");
                opCode.setMode(modes.get(flag == 0 ? "CImmb" : "CSrcb"));
            } else if (dMod == 8 && dIndex == 7) {
                opCode.setName("CMP");
                opCode.setMode(modes.get(flag == 0 ? "Imm" : "Src"));
            } else if (dMod == 10) {
                opCode.setName(MAXQ610data.aluOps[dIndex]);
                opCode.setMode(modes.get(flag == 0 ? "Imm" : "Src"));
            } else if (dMod == 12 && (flag == 0 || (dIndex & 3) != 3)) {
                if (flag == 1 && sMod == 13 && (sIndex & 7) == 0) {
                    opCode.setName(sIndex == 0 ? "RET" : "RETI");
                    opCode.setMode(modes.get(dIndex == 0 ? "Nil" : "Cond"));
                } else {
                    opCode.setName("JUMP");
                    opCode.setMode(modes.get(dIndex == 0 ? (flag == 0 ? "Rel" : "Src") : (flag == 0 ? "CondRel" : "CondSrc")));
                }
            } else if (dMod == 13) {
                opCode.setName(MAXQ610data.miscOpsP[dIndex]);
                opCode.setMode(new AssemblerOpCode.AddressMode(flag == 0 ? MAXQ610data.miscModesPImm[dIndex] : MAXQ610data.miscModesP[dIndex]));
            }
        } else if (dMod == 10 && sMod == 10) {
            if (dIndex == 0) {
                opCode.setName(MAXQ610data.accOps[sIndex]);
                opCode.setMode(modes.get("Nil"));
            } else if (dIndex == 5 && sIndex < 4) {
                opCode.setName(MAXQ610data.miscOpsC[sIndex]);
                opCode.setMode(new AssemblerOpCode.AddressMode(MAXQ610data.miscModesC[sIndex]));
            } else {
                opCode.setName(MAXQ610data.bitOps[dIndex]);
                opCode.setMode(modes.get(MAXQ610data.bitModes[dIndex]));
            }
        } else if (sMod == 7) {
            opCode.setName("MOVE");
            opCode.setMode(modes.get(sIndex < 8 ? "DstbImm0" : "DstbImm1"));
        } else {
            opCode.setName("*");
        }
        if (opCode.getName().equals("*")) {
            opCode.setMode(modes.get("Nil"));
        }
        this.pfx.check();
        return opCode;
    }

    @Override
    public String getConditionCode(int n) {
        if (!this.getName().contains("Native")) {
            return super.getConditionCode(n);
        }
        return MAXQ610data.conditionCodes[n & 7];
    }

    private String getSource(int sIndex, int sMod) {
        if (sMod < 6) {
            return "MN[" + sIndex + "]";
        }
        if (sMod >= 8 && sIndex < MAXQ610data.sources[sMod - 8].length) {
            return MAXQ610data.sources[sMod - 8][sIndex];
        }
        return "*";
    }

    private String getDest(int dIndex, int dMod) {
        if (dMod < 6) {
            return "MN[" + dIndex + "]";
        }
        if (dMod == 6 && dIndex == 7) {
            return "NUL";
        }
        if (dMod >= 8 && dIndex < MAXQ610data.dests[dMod - 8].length) {
            return MAXQ610data.dests[dMod - 8][dIndex];
        }
        return "*";
    }

    @Override
    public int[] getCarrierData(Hex hex) {
        int[] result = new int[2];
        short[] data = hex.getData();
        short on = data[0];
        short off = data[1];
        if (on == 0 && off == 0) {
            result = new int[]{12, 0};
        } else {
            int carrier = on + off + this.getCarrierTotalOffset();
            int duty = (int)((double)(on + this.getCarrierOnOffset()) * 1000.0 / (double)carrier + 0.5);
            result = new int[]{carrier, duty};
        }
        return result;
    }

    private static class PFX {
        public int addr = 0;
        public int val = 0;
        public int ndx = 0;
        private int state = 3;

        private PFX() {
        }

        public void set(int addr, int ndx, int val) {
            this.addr = addr;
            this.ndx = ndx;
            this.val = val;
            this.state = 0;
        }

        public void check() {
            if (this.state < 3) {
                ++this.state;
            } else {
                this.ndx = 0;
                this.val = 0;
            }
        }
    }
}

