/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Activity;
import com.hifiremote.jp1.AdvancedCode;
import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.GeneralFunction;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.PropertyWriter;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.Segment;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class Macro
extends AdvancedCode {
    private int sequenceNumber = 0;
    private MacroClass macroClass = null;
    private boolean systemMacro = false;
    private Activity activity = null;
    private LinkedHashMap<Integer, List<Activity.Assister>> assists = null;
    public static boolean showControlledHoldWarning = true;

    public Macro(Macro macro) {
        this(macro.keyCode, macro.data, macro.deviceButtonIndex, macro.sequenceNumber, macro.notes);
        this.setSegmentFlags(macro.getSegmentFlags());
        this.setItems(macro.getItems());
        this.setMacroClass(macro.getMacroClass());
        this.setUploadStatus(macro.getUploadStatus());
    }

    public Macro(int keyCode, Hex keyCodes, String notes) {
        super(keyCode, keyCodes, notes);
    }

    public Macro(int keyCode, Hex keyCodes, int deviceButtonIndex, int sequenceNumber, String notes) {
        super(keyCode, keyCodes, notes);
        this.deviceButtonIndex = deviceButtonIndex;
        this.sequenceNumber = sequenceNumber;
    }

    public Macro(Properties props, Remote remote) {
        super(props);
        String temp = props.getProperty("SystemMacro");
        if (temp != null) {
            this.systemMacro = true;
        }
        if ((temp = props.getProperty("RealTime")) != null || remote.usesEZRC()) {
            this.setMacroClass(MacroClass.REALTIME);
        } else {
            temp = props.getProperty("Controlled");
            if (temp != null) {
                this.setMacroClass(MacroClass.CONTROLLED);
            } else {
                String temp2 = props.getProperty("Multi");
                if (temp2 != null) {
                    this.setMacroClass(Boolean.parseBoolean(temp2) ? MacroClass.MULTI : MacroClass.NORMAL);
                } else {
                    this.setMacroClass(MacroClass.UNDETERMINED);
                }
            }
        }
        if (remote.usesEZRC() || temp != null) {
            this.setItems(this.getData(), remote);
            this.setData(null);
        }
        try {
            temp = props.getProperty("SequenceNumber");
            if (temp != null) {
                this.sequenceNumber = Integer.parseInt(temp);
            }
            if ((temp = props.getProperty("DeviceIndex")) != null) {
                this.deviceButtonIndex = Integer.parseInt(temp);
                if (remote.usesEZRC()) {
                    DeviceButton db = remote.getDeviceButton(this.deviceButtonIndex);
                    Button b = remote.getButton(this.keyCode);
                    if (db != null && b != null) {
                        this.addReference(db, b);
                        GeneralFunction gf = db.getGeneralFunction(b);
                        gf.setName(this.name);
                    }
                }
                if ((this.deviceButtonIndex == 0 || this.deviceButtonIndex == 15 || this.deviceButtonIndex == DeviceButton.noButton.getButtonIndex()) && remote.getSegmentTypes() != null) {
                    this.deviceButtonIndex = -1;
                }
            }
            if ((temp = props.getProperty("Users")) != null) {
                this.setUserItems(new ArrayList<Integer>());
                StringTokenizer st = new StringTokenizer(temp, ",/");
                while (st.hasMoreTokens()) {
                    DeviceButton db = remote.getDeviceButton(Integer.parseInt(st.nextToken()));
                    Button b = remote.getButton(Integer.parseInt(st.nextToken()));
                    if (db == null || b == null) continue;
                    this.addReference(db, b);
                    GeneralFunction gf = db.getGeneralFunction(b);
                    gf.setName(this.name);
                }
            }
            if ((temp = props.getProperty("Serial")) != null) {
                this.serial = (short)Integer.parseInt(temp);
            }
            this.assists = Activity.Assister.load(props);
            if (this.assists == null && props.getProperty("Assistant") != null) {
                this.assists = new LinkedHashMap();
                for (int j = 0; j < 3; ++j) {
                    this.assists.put(j, new ArrayList());
                }
            }
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace(System.err);
        }
    }

    public Object getValue() {
        if (this.items != null) {
            return this.items;
        }
        return this.getData();
    }

    @Override
    public String getValueString(RemoteConfiguration remoteConfig) {
        if (this.items != null) {
            return Macro.getValueString(this.items);
        }
        return Macro.getValueString(this.data, remoteConfig);
    }

    public static String getValueString(List<RemoteConfiguration.KeySpec> items) {
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < items.size(); ++i) {
            if (i != 0) {
                buff.append(';');
            }
            buff.append(items.get(i));
        }
        return buff.toString();
    }

    public static String getValueString(Hex hex, RemoteConfiguration remoteConfig) {
        Remote remote = remoteConfig.getRemote();
        StringBuilder buff = new StringBuilder();
        short[] data = hex.getData();
        for (int i = 0; i < hex.length(); ++i) {
            if (i != 0) {
                buff.append(';');
            }
            String name = remote.getButtonName(data[i] & 0xFF);
            buff.append(name);
            int duration = data[i] >> 8 & 0xFF;
            if (duration <= 0) continue;
            if (duration == 255) {
                duration = 0;
            }
            buff.append("(" + duration / 10 + "." + duration % 10 + ")");
        }
        return buff.toString();
    }

    public void setValue(Object value) {
        if (value instanceof Hex) {
            this.setData((Hex)value);
        } else if (value instanceof List) {
            this.setItems((List)value);
        }
    }

    public int dataLength() {
        if (this.items != null) {
            int length = 0;
            DeviceButton db = null;
            for (RemoteConfiguration.KeySpec ks : this.items) {
                if (!ks.isValid()) continue;
                if (ks.getCodeSize() == 2) {
                    length += 2;
                    continue;
                }
                if (ks.isEZRC) {
                    length += ks.db != db ? 1 : 0;
                }
                length += ks.duration >= 0 ? 1 : 0;
                length += ks.getButton() != null ? 1 : (ks.fn != null ? (ks.db.getUpgrade().getRemote().isSSD() ? 2 : 1) : 0);
                db = ks.db;
            }
            return length;
        }
        if (this.data != null) {
            return this.data.length();
        }
        return 0;
    }

    public Hex getItemData(boolean full) {
        if (this.items == null) {
            return new Hex(0);
        }
        int size = this.dataLength();
        short[] vals = new short[2 * size];
        DeviceButton db = null;
        int pos = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            Button btn;
            RemoteConfiguration.KeySpec ks = (RemoteConfiguration.KeySpec)this.items.get(i);
            if (!ks.isValid()) {
                String str = "Invalid keySpec";
                if (ks.db != null) {
                    str = str + " for upgrade \"" + ks.db + "\"";
                }
                if (ks.fn != null) {
                    str = str + ", function \"" + ks.fn + "\"";
                } else if (ks.btn != null) {
                    str = str + ", button \"" + ks.btn + "\"";
                }
                str = str + " in macro " + this;
                System.err.println(str);
                continue;
            }
            if (ks.getCodeSize() == 2) {
                vals[pos] = 0;
                vals[pos + 1] = ks.btn.getKeyCode(ks.btnState);
                vals[pos + size] = (short)ks.duration;
                vals[pos + size + 1] = (short)ks.delay;
                pos += 2;
                continue;
            }
            if (ks.isEZRC && ks.db != db) {
                vals[pos + size] = 0;
                vals[pos++] = (short)ks.db.getButtonIndex();
                db = ks.db;
            }
            if (ks.duration >= 0) {
                int code = ks.isEZRC ? 254 : RemoteConfiguration.KeySpec.remote.getRealTimeCodeBase();
                int val = ks.duration;
                if (!ks.isEZRC && val > 255) {
                    int val1 = Macro.holdToValueMid(Macro.valueLowToHold(val));
                    ++code;
                    if (val1 > 255) {
                        val1 = Macro.holdToValueHigh(Macro.valueLowToHold(val));
                        ++code;
                    }
                    if (val1 > 255) {
                        val1 = 255;
                    }
                    val = val1;
                }
                vals[pos + size] = (short)val;
                vals[pos++] = (short)code;
            }
            if ((btn = ks.getButton()) != null) {
                int delay = ks.isEZRC || full || i < this.items.size() - 1 ? ks.delay : 0;
                vals[pos + size] = (short)delay;
                vals[pos++] = btn.getKeyCode(ks.btnState);
                continue;
            }
            if (ks.fn == null) continue;
            int serial = ks.fn.getSerial();
            Remote remote = ks.db.getUpgrade().getRemote();
            if (remote.isSSD()) {
                vals[pos + size] = 255;
                vals[pos++] = (short)(serial & 0xFF);
                vals[pos + size] = (short)ks.delay;
                vals[pos++] = (short)(serial >> 8);
                continue;
            }
            vals[pos + size] = (short)ks.delay;
            GeneralFunction.User u = null;
            if (ks.fn.getUsers() != null && ks.fn.getUsers().size() > 0) {
                u = ks.fn.getUsers().get(0);
            }
            vals[pos++] = u != null ? u.button.getKeyCode() : (short)0;
        }
        return new Hex(vals);
    }

    public void setItems(Hex hex, Remote remote) {
        int codeSize = remote.getMacroSupport();
        if (codeSize > 2 || codeSize == 2 && !remote.getBaseButton(this.keyCode).allowsControlledMacro()) {
            codeSize = 1;
        }
        int count = hex.length() / (2 * codeSize);
        DeviceButton db = remote.getDeviceButtons()[0];
        int duration = -1;
        this.items = new ArrayList();
        for (int i = 0; i < count; ++i) {
            short keyCode = hex.getData()[(i + 1) * codeSize - 1];
            DeviceButton db2 = remote.getDeviceButton(keyCode);
            Button btn = remote.getButton(keyCode);
            int btnState = 0;
            if (!remote.usesEZRC()) {
                Remote.ButtonSplit split = remote.getButtonSplit(keyCode);
                btn = split.base;
                btnState = split.state;
            }
            int realTimeCodeBase = RemoteConfiguration.KeySpec.remote.getRealTimeCodeBase();
            if (db2 != null) {
                db = db2;
                if (remote.usesEZRC()) continue;
            }
            if (codeSize == 1 && (keyCode == 254 || remote.isJP2style() && keyCode >= realTimeCodeBase && keyCode <= realTimeCodeBase + 2)) {
                duration = hex.getData()[i + count];
                if (keyCode == realTimeCodeBase + 1) {
                    duration = Macro.holdToValueLow(Macro.valueMidToHold(duration));
                    continue;
                }
                if (keyCode != realTimeCodeBase + 2) continue;
                duration = Macro.holdToValueLow(Macro.valueHighToHold(duration));
                continue;
            }
            if (remote.usesEZRC() && hex.getData()[i + count] == 255) {
                int irSerial = hex.getData()[i++];
                RemoteConfiguration.KeySpec ks = new RemoteConfiguration.KeySpec(db, irSerial += hex.getData()[i] << 8);
                ks.delay = hex.getData()[i + count];
                ks.duration = duration;
                this.items.add(ks);
                duration = -1;
                continue;
            }
            if (btn == null) continue;
            RemoteConfiguration.KeySpec ks = null;
            int serial = -1;
            if (remote.getSystemButtons() != null && (serial = remote.getSystemButtons().indexOf(btn)) >= 0) {
                ks = new RemoteConfiguration.KeySpec(db, serial);
            }
            if (ks == null) {
                ks = new RemoteConfiguration.KeySpec(db, btn);
            }
            ks.btnState = btnState;
            if (codeSize == 2) {
                ks.duration = hex.getData()[2 * (i + count)];
                ks.delay = hex.getData()[2 * (i + count) + 1];
                ks.setEZRC(false);
                ks.setCodeSize(2);
                this.items.add(ks);
                continue;
            }
            ks.delay = hex.getData()[i + count];
            ks.duration = duration;
            if (remote.isJP2style()) {
                ks.setEZRC(false);
            }
            this.items.add(ks);
            duration = -1;
        }
    }

    @Override
    public int store(short[] buffer, int offset, Remote remote) {
        if (remote.getSegmentTypes() == null) {
            int deviceIndex;
            buffer[offset++] = (short)this.getKeyCode();
            if (remote.getAdvCodeBindFormat() == AdvancedCode.BindFormat.NORMAL) {
                buffer[offset] = 16;
            } else if (remote.getMacroCodingType().get_Type() == 2) {
                deviceIndex = this.deviceButtonIndex == -1 ? 15 : this.deviceButtonIndex;
                buffer[offset] = (short)(48 + (this.sequenceNumber << 4) + deviceIndex & 0xFF);
                buffer[++offset] = 0;
            } else {
                deviceIndex = this.deviceButtonIndex == -1 ? 15 : this.deviceButtonIndex;
                buffer[offset] = (short)((0x80 | this.sequenceNumber << 4 | deviceIndex) & 0xFF);
                buffer[++offset] = 0;
            }
            int dataLength = this.data.length();
            int n = offset++;
            buffer[n] = (short)(buffer[n] | (short)dataLength);
            Hex.put(this.data, buffer, offset);
            return offset + dataLength;
        }
        int size = this.dataLength();
        buffer[offset++] = (short)size;
        if (this.macroClass == MacroClass.CONTROLLED || this.macroClass == MacroClass.REALTIME || remote.isFDRA()) {
            if (this.getItems().size() > 0 && this.getItems().get(0).getCodeSize() == 2) {
                buffer[offset - 1] = (short)(size / 2);
            }
            Hex hex = this.getItemData(false);
            Hex.put(hex, buffer, offset);
            offset += hex.length();
            if (remote.usesEZRC() && this.activity == null) {
                buffer[offset++] = (short)this.name.length();
                System.arraycopy(new Hex(this.name, 8).getData(), 0, buffer, offset, this.name.length());
                Hex.put(this.getSerial(), buffer, offset += this.name.length());
                offset += 2;
            }
        } else {
            short[] data = this.getData().getData();
            for (int i = 0; i < size; ++i) {
                buffer[offset++] = (short)(data[i] & 0xFF);
            }
        }
        return offset;
    }

    public void store(PropertyWriter pw, Remote remote) {
        if (this.items != null && this.items.size() > 0 && !((RemoteConfiguration.KeySpec)this.items.get((int)0)).isEZRC) {
            boolean controlled = ((RemoteConfiguration.KeySpec)this.items.get(0)).getCodeSize() == 2;
            pw.print(controlled ? "Controlled" : "RealTime", "true");
            pw.print("Data", this.getItemData(true));
            int segmentFlags = this.getSegmentFlags();
            if (segmentFlags > 0) {
                pw.print("SegmentFlags", segmentFlags);
            }
            pw.print("KeyCode", this.keyCode);
            if (this.deviceButtonIndex != -1) {
                pw.print("DeviceIndex", this.deviceButtonIndex);
            }
            if (this.notes != null && this.notes.length() > 0) {
                pw.print("Notes", this.notes);
            }
            return;
        }
        if (this.name != null) {
            int segmentFlags = this.getSegmentFlags();
            if (segmentFlags > 0) {
                pw.print("SegmentFlags", segmentFlags);
            }
            Hex hex = null;
            if (this.items != null) {
                hex = this.getItemData(true);
            } else {
                int dataLen = this.dataLength();
                hex = new Hex(2 * dataLen);
                for (int i = 0; i < dataLen; ++i) {
                    short val = this.data.getData()[i];
                    hex.set((short)(val & 0xFF), i);
                    hex.set((short)(val >> 8 & 0xFF), dataLen + i);
                }
            }
            pw.print("Name", this.name);
            int activityCode = this.activity != null ? (int)this.activity.getSelector().getKeyCode() : -1;
            pw.print("KeyCode", activityCode < 0 ? this.keyCode : activityCode);
            pw.print("DeviceIndex", activityCode < 0 ? this.deviceButtonIndex : activityCode);
            String userStr = "";
            if (this.users.isEmpty()) {
                userStr = "256/256";
            } else {
                for (GeneralFunction.User u : this.users) {
                    int dbi = u.db.getButtonIndex();
                    short kc = u.button.getKeyCode();
                    if (activityCode < 0 && dbi == this.deviceButtonIndex && kc == this.keyCode) continue;
                    userStr = userStr + (userStr.isEmpty() ? "" : ",") + Integer.toString(dbi) + "/" + Integer.toString(kc);
                }
            }
            if (!userStr.isEmpty()) {
                pw.print("Users", userStr);
            }
            if (this.systemMacro) {
                pw.print("SystemMacro", 1);
            }
            pw.print("Data", hex);
            pw.print("Serial", this.serial);
            boolean hasAssists = false;
            if (this.assists != null) {
                for (int i = 0; i < this.assists.size(); ++i) {
                    if (this.assists.get(i).isEmpty()) continue;
                    hasAssists = true;
                    break;
                }
            }
            if (hasAssists) {
                pw.print("Assistant", 1);
                Activity.Assister.store(this.assists, pw);
            }
            if (this.notes != null && this.notes.length() > 0) {
                pw.print("Notes", this.notes);
            }
            return;
        }
        pw.print("Multi", MacroClass.MULTI == this.macroClass);
        super.store(pw);
        if (this.sequenceNumber != 0) {
            pw.print("SequenceNumber", this.sequenceNumber);
        }
        if (this.deviceButtonIndex != -1) {
            pw.print("DeviceIndex", this.deviceButtonIndex);
        }
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public DeviceButton getDeviceButton(RemoteConfiguration config) {
        return config.getRemote().getDeviceButton(this.deviceButtonIndex);
    }

    public static int holdToValueLow(double hold) {
        double durMult = 250.0;
        return (int)(durMult * hold + 0.5);
    }

    public static int holdToValueMid(double hold) {
        double durMult = 40.0;
        return (int)(durMult * hold + 0.5);
    }

    public static int holdToValueHigh(double hold) {
        double durMult = 10.0;
        return (int)(durMult * hold + 0.5);
    }

    public static double valueLowToHold(int value) {
        double durMult = 250.0;
        return (double)value / durMult;
    }

    public static double valueMidToHold(int value) {
        double durMult = 40.0;
        return (double)value / durMult;
    }

    public static double valueHighToHold(int value) {
        double durMult = 10.0;
        return (double)value / durMult;
    }

    public MacroClass getMacroClass() {
        return this.macroClass;
    }

    public void setMacroClass(MacroClass macroClass) {
        this.macroClass = macroClass;
    }

    public boolean isSystemMacro() {
        return this.systemMacro;
    }

    public void setSystemMacro(boolean systemMacro) {
        this.systemMacro = systemMacro;
    }

    public int getRealTimeMacroKeycode() {
        Segment seg = this.getSegment();
        if (seg == null || seg.get_Type() != 3) {
            return 0;
        }
        return this.keyCode;
    }

    public Activity getActivity() {
        return this.activity;
    }

    public void setActivity(Activity activity) {
        this.activity = activity;
    }

    public LinkedHashMap<Integer, List<Activity.Assister>> getAssists() {
        return this.assists;
    }

    public void setAssists(LinkedHashMap<Integer, List<Activity.Assister>> assists) {
        this.assists = assists;
    }

    @Override
    public String toString() {
        return this.name != null && !this.name.isEmpty() ? this.name : super.toString();
    }

    public static enum MacroClass {
        NORMAL,
        MULTI,
        REALTIME,
        CONTROLLED,
        MASTERPOWER,
        ACTIVITYPOWER,
        UNDETERMINED;

    }
}

