/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class MacroButtonRenderer
extends DefaultListCellRenderer {
    private Remote remote = null;

    public void setRemote(Remote remote) {
        this.remote = remote;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String text = null;
        if (value instanceof Number) {
            int iVal = ((Number)value).intValue();
            text = this.remote.getButtonName(iVal & 0xFF);
            int duration = iVal >> 8;
            if (duration > 0) {
                text = text + "(" + duration / 10 + "." + duration % 10 + ")";
            }
        } else if (value instanceof RemoteConfiguration.KeySpec) {
            RemoteConfiguration.KeySpec ks = (RemoteConfiguration.KeySpec)value;
            text = ks.toString();
        }
        return super.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
    }
}

