/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.ButtonEnabler;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.GeneralFunction;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.MacroButtonRenderer;
import com.hifiremote.jp1.RMSetter;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.NumberFormatter;

public class MacroDefinitionBox
extends Box
implements ActionListener,
ListSelectionListener,
PropertyChangeListener,
RMSetter<Object> {
    protected JButton add = new JButton("Add");
    protected JButton insert = new JButton("Insert");
    protected JButton addShift = new JButton("Add Shift");
    protected JButton insertShift = new JButton("Ins Shift");
    protected JButton addXShift = new JButton("Add xShift");
    protected JButton insertXShift = new JButton("Ins xShift");
    protected JLabel keysBoxLabel = null;
    private JButton moveUp = new JButton("Move up");
    private JButton moveDown = new JButton("Move down");
    private JButton remove = new JButton("Remove");
    private JButton clear = new JButton("Clear");
    private JButton deselect = new JButton("Clear selection");
    private JComboBox deviceBox = null;
    private JComboBox functionBox = null;
    private JComboBox buttonBox = null;
    private JCheckBox shift = new JCheckBox();
    private JPanel creationPanel = null;
    private JPanel itemPanel = null;
    private JLabel durationLabel = new JLabel("Duration:  ");
    private XFormattedTextField duration = null;
    private XFormattedTextField delay = null;
    private JCheckBox holdCheck = null;
    private RemoteConfiguration config = null;
    protected JList availableButtons = new JList();
    private DefaultListModel availableButtonModel = new DefaultListModel();
    private JList macroButtons = new JList();
    private JPanel panel = null;
    private ButtonEnabler buttonEnabler = null;
    private DefaultListModel macroButtonModel = new DefaultListModel();
    private MacroButtonRenderer macroButtonRenderer = new MacroButtonRenderer();
    private boolean itemStyle = false;
    private boolean itemStyleFromRemote = false;
    private int codeSize = 1;

    public MacroDefinitionBox() {
        this(false);
        this.itemStyleFromRemote = true;
    }

    public MacroDefinitionBox(boolean itemStyle) {
        super(0);
        this.itemStyle = itemStyle;
        this.macroButtons.setModel(this.macroButtonModel);
        this.setBorder(BorderFactory.createTitledBorder("Macro Definition"));
        this.creationPanel = new JPanel(new CardLayout());
        JPanel availableBox = new JPanel(new BorderLayout());
        this.add(availableBox);
        availableBox.add((Component)this.creationPanel, "Center");
        JPanel availablePanel = new JPanel(new BorderLayout());
        availablePanel.add((Component)new JLabel("Available keys:"), "North");
        this.availableButtons.setFixedCellWidth(100);
        availablePanel.add((Component)new JScrollPane(this.availableButtons), "Center");
        this.availableButtons.setSelectionMode(0);
        this.availableButtons.addListSelectionListener(this);
        this.availableButtons.setToolTipText(JTableX.getHtmlToolTip("Double-click to add/insert.<br>Shift/double-click to add/insert shifted.<br>This will insert if a macro key is selected, add otherwise.<br>Right-click (either box) to clear macro key selection."));
        double b = 5.0;
        double c = 10.0;
        double pr = -2.0;
        double pf = -1.0;
        double[][] size = new double[][]{{b, pr, c, pf, b}, {b, pr, b, pr, b, pr, b, pr, pr, b}};
        JPanel ssdPanel = new JPanel(new BorderLayout());
        ssdPanel.add((Component)new JLabel("Specify macro item:"), "First");
        this.itemPanel = new JPanel(new TableLayout(size));
        ssdPanel.add((Component)this.itemPanel, "Center");
        this.deviceBox = new JComboBox();
        this.functionBox = new JComboBox();
        this.buttonBox = new JComboBox();
        this.creationPanel.add((Component)availablePanel, "Normal");
        this.creationPanel.add((Component)ssdPanel, "SSD");
        this.panel = new JPanel(new GridLayout(3, 2, 2, 2));
        this.panel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        availableBox.add((Component)this.panel, "South");
        this.add.addActionListener(this);
        this.panel.add(this.add);
        this.insert.addActionListener(this);
        this.panel.add(this.insert);
        this.addShift.addActionListener(this);
        this.panel.add(this.addShift);
        this.insertShift.addActionListener(this);
        this.panel.add(this.insertShift);
        this.addXShift.addActionListener(this);
        this.panel.add(this.addXShift);
        this.insertXShift.addActionListener(this);
        this.panel.add(this.insertXShift);
        this.add(Box.createHorizontalStrut(20));
        JPanel keysBox = new JPanel(new BorderLayout());
        this.keysBoxLabel = new JLabel("Macro Keys:");
        this.add(keysBox);
        keysBox.add((Component)this.keysBoxLabel, "North");
        this.macroButtons.setCellRenderer(this.macroButtonRenderer);
        this.macroButtons.setSelectionMode(0);
        this.macroButtons.addListSelectionListener(this);
        this.macroButtons.setFixedCellWidth(100);
        this.macroButtons.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                MacroDefinitionBox.this.enableButtons();
            }

            @Override
            public void focusGained(FocusEvent e) {
                MacroDefinitionBox.this.enableButtons();
            }
        });
        keysBox.add((Component)new JScrollPane(this.macroButtons), "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        keysBox.add((Component)buttonPanel, "South");
        b = 2.0;
        double[][] size2 = new double[][]{{pf, b, pf}, {pr, b, pr, b, pr}};
        JPanel pushbtnBox = new JPanel(new TableLayout(size2));
        buttonPanel.add((Component)pushbtnBox, "First");
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this.moveUp.addActionListener(this);
        pushbtnBox.add((Component)this.moveUp, "0,0");
        this.moveDown.addActionListener(this);
        pushbtnBox.add((Component)this.moveDown, "2,0");
        this.remove.addActionListener(this);
        this.remove.setToolTipText("Remove selected item.  Key: DEL");
        this.remove.setFocusable(false);
        pushbtnBox.add((Component)this.remove, "0,2");
        this.clear.addActionListener(this);
        pushbtnBox.add((Component)this.clear, "2,2");
        this.deselect.addActionListener(this);
        this.deselect.setToolTipText("Deselects current selection.  Mouse: Right-click box");
        pushbtnBox.add((Component)this.deselect, "0,4,2,4");
        this.macroButtons.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && MacroDefinitionBox.this.remove.isVisible() && MacroDefinitionBox.this.remove.isEnabled()) {
                    MacroDefinitionBox.this.remove.doClick();
                }
            }
        });
        this.availableButtons.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    if (MacroDefinitionBox.this.macroButtons.getSelectedValue() != null) {
                        if ((e.getModifiers() & 1) != 0) {
                            if (MacroDefinitionBox.this.insertShift.isVisible() && MacroDefinitionBox.this.insertShift.isEnabled()) {
                                MacroDefinitionBox.this.insertShift.doClick();
                            }
                        } else if (MacroDefinitionBox.this.insert.isVisible() && MacroDefinitionBox.this.insert.isEnabled()) {
                            MacroDefinitionBox.this.insert.doClick();
                        }
                    } else if ((e.getModifiers() & 1) != 0) {
                        if (MacroDefinitionBox.this.addShift.isVisible() && MacroDefinitionBox.this.addShift.isEnabled()) {
                            MacroDefinitionBox.this.addShift.doClick();
                        }
                    } else if (MacroDefinitionBox.this.add.isVisible() && MacroDefinitionBox.this.add.isEnabled()) {
                        MacroDefinitionBox.this.add.doClick();
                    }
                } else if ((e.getButton() == 2 || e.getButton() == 3) && MacroDefinitionBox.this.deselect.isVisible() && MacroDefinitionBox.this.deselect.isEnabled()) {
                    MacroDefinitionBox.this.deselect.doClick();
                }
            }
        });
        this.macroButtons.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getButton() == 2 || e.getButton() == 3) && MacroDefinitionBox.this.deselect.isVisible() && MacroDefinitionBox.this.deselect.isEnabled()) {
                    MacroDefinitionBox.this.deselect.doClick();
                }
            }
        });
    }

    public void setButtonEnabler(ButtonEnabler buttonEnabler) {
        this.buttonEnabler = buttonEnabler;
    }

    public void setCodeSize(int codeSize) {
        this.codeSize = codeSize;
    }

    @Override
    public void setRemoteConfiguration(RemoteConfiguration config) {
        this.config = config;
        Remote remote = config.getRemote();
        ArrayList<Button> availableButtonList = new ArrayList<Button>();
        if (this.itemStyleFromRemote) {
            this.itemStyle = config.getRemote().usesEZRC();
        }
        this.macroButtonRenderer.setRemote(remote);
        List<Button> buttons = remote.getButtons();
        for (Button b : buttons) {
            if (!this.buttonEnabler.isAvailable(b)) continue;
            this.availableButtonModel.addElement(b);
            availableButtonList.add(b);
        }
        this.availableButtons.setModel(this.availableButtonModel);
        CardLayout cl = (CardLayout)this.creationPanel.getLayout();
        cl.show(this.creationPanel, this.itemStyle ? "SSD" : "Normal");
        if (this.itemStyle) {
            NumberFormatter formatter = new NumberFormatter(new DecimalFormat("0.0"));
            formatter.setValueClass(Float.class);
            this.delay = new XFormattedTextField(formatter);
            this.delay.addPropertyChangeListener("value", this);
            this.holdCheck = new JCheckBox("Hold?");
            formatter = new NumberFormatter(new DecimalFormat(remote.usesEZRC() || this.codeSize == 2 ? "0.0" : "0.00"));
            formatter.setValueClass(Float.class);
            this.duration = new XFormattedTextField(formatter);
            this.duration.setColumns(4);
            this.duration.addActionListener(this);
            if (remote.usesEZRC()) {
                remote.setDeviceComboBox(this.deviceBox);
                this.holdCheck.addActionListener(this);
                this.itemPanel.add((Component)new JLabel("Device:"), "1, 1");
                this.itemPanel.add((Component)this.deviceBox, "3, 1");
                this.itemPanel.add((Component)new JLabel("Function:"), "1, 3");
                this.deviceBox.addActionListener(this);
                this.itemPanel.add((Component)this.functionBox, "3, 3");
                this.itemPanel.add((Component)new JLabel("Pause after (secs):"), "1, 5");
                this.itemPanel.add((Component)this.delay, "3, 5");
                this.delay.setValue(Float.valueOf(0.3f));
                this.itemPanel.add((Component)this.holdCheck, "1, 7");
                this.durationLabel.setText("Hold for (secs):");
                this.itemPanel.add((Component)this.durationLabel, "1, 8");
                this.itemPanel.add((Component)this.duration, "3, 8");
                this.duration.setValue(Float.valueOf(0.0f));
                this.duration.setEnabled(false);
                this.durationLabel.setEnabled(false);
                int ndx = this.deviceBox.getSelectedIndex();
                if (ndx >= 0) {
                    this.deviceBox.setSelectedIndex(ndx);
                }
            } else {
                this.holdCheck.setSelected(true);
                this.durationLabel.setText("Hold for (secs):");
                this.itemPanel.add((Component)this.durationLabel, "1, 3");
                this.itemPanel.add((Component)this.duration, "3, 3");
                this.itemPanel.add((Component)new JLabel("Pause after (secs):"), "1, 5");
                this.itemPanel.add((Component)this.delay, "3, 5");
                this.itemPanel.add((Component)new JLabel("Button:"), "1, 7");
                this.itemPanel.add((Component)this.buttonBox, "3, 7");
                this.itemPanel.add((Component)new JLabel("Shift:"), "1, 8");
                this.itemPanel.add((Component)this.shift, "3, 8");
                this.delay.setValue(Float.valueOf(0.3f));
                this.duration.setValue(Float.valueOf(0.0f));
                DefaultComboBoxModel<Button> model = new DefaultComboBoxModel<Button>(availableButtonList.toArray(new Button[0]));
                this.buttonBox.setModel(model);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        Remote remote = this.config.getRemote();
        if (source == this.add) {
            this.addKey(0);
        } else if (source == this.insert) {
            this.insertKey(0);
        } else if (source == this.addShift) {
            if (this.addShift.getText().equals("Replace")) {
                this.replaceKey(0);
            } else {
                this.addKey(remote.getShiftMask());
            }
        } else if (source == this.insertShift) {
            this.insertKey(remote.getShiftMask());
        } else if (source == this.addXShift) {
            this.addKey(remote.getXShiftMask());
        } else if (source == this.insertXShift) {
            this.insertKey(remote.getXShiftMask());
        } else if (source == this.moveUp) {
            int index = this.macroButtons.getSelectedIndex();
            this.swap(index, index - 1);
        } else if (source == this.moveDown) {
            int index = this.macroButtons.getSelectedIndex();
            this.swap(index, index + 1);
        } else if (source == this.remove) {
            int index = this.macroButtons.getSelectedIndex();
            this.macroButtonModel.removeElementAt(index);
            int last = this.macroButtonModel.getSize() - 1;
            if (index > last) {
                index = last;
            }
            this.macroButtons.setSelectedIndex(index);
        } else if (source == this.clear) {
            this.macroButtonModel.clear();
        } else if (source == this.deselect) {
            this.macroButtons.clearSelection();
        } else if (source == this.deviceBox) {
            DeviceButton db = (DeviceButton)this.deviceBox.getSelectedItem();
            DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(db.getUpgrade().getGeneralFunctionList().toArray());
            this.functionBox.setModel(model);
        } else if (source == this.holdCheck) {
            this.duration.setEnabled(this.holdCheck.isSelected());
            this.durationLabel.setEnabled(this.holdCheck.isSelected());
            if (!this.holdCheck.isSelected()) {
                this.duration.setValue(Float.valueOf(0.0f));
            }
        }
        this.enableButtons();
    }

    private RemoteConfiguration.KeySpec getKeySpec() {
        DeviceButton db;
        RemoteConfiguration.KeySpec ks = null;
        Remote remote = this.config.getRemote();
        if (remote.usesEZRC()) {
            db = (DeviceButton)this.deviceBox.getSelectedItem();
            GeneralFunction f = (GeneralFunction)this.functionBox.getSelectedItem();
            ks = new RemoteConfiguration.KeySpec(db, f);
        } else {
            db = remote.getDeviceButtons()[0];
            Button btn = (Button)this.buttonBox.getSelectedItem();
            ks = new RemoteConfiguration.KeySpec(db, btn);
            if (this.shift.isSelected()) {
                ks.btnState = 1;
            }
            ks.setEZRC(false);
            ks.setCodeSize(this.codeSize);
        }
        Float fv = this.valueToFloat(this.delay.getValue());
        int n = ks.delay = fv == null ? 0 : (int)(10.0 * (double)fv.floatValue() + 0.5);
        ks.duration = this.holdCheck.isSelected() ? ((fv = this.valueToFloat(this.duration.getValue())) == null ? 0 : (ks.isEZRC() || this.codeSize == 2 ? (int)(10.0 * (double)fv.floatValue() + 0.5) : Macro.holdToValueLow(fv.floatValue()))) : -1;
        return ks;
    }

    private Float valueToFloat(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Double) {
            return Float.valueOf(((Double)value).floatValue());
        }
        return null;
    }

    private void addKey(int mask) {
        Remote remote = this.config.getRemote();
        if (this.itemStyle) {
            this.macroButtonModel.addElement(this.getKeySpec());
            return;
        }
        Integer value = new Integer(this.getSelectedKeyCode() | mask);
        this.macroButtonModel.addElement(value);
    }

    private void replaceKey(int mask) {
        int index = this.macroButtons.getSelectedIndex();
        if (index == -1) {
            return;
        }
        if (this.itemStyle) {
            RemoteConfiguration.KeySpec value = this.getKeySpec();
            this.macroButtonModel.setElementAt(value, index);
        } else {
            Integer value = new Integer(this.getSelectedKeyCode() | mask);
            this.macroButtonModel.setElementAt(value, index);
        }
        this.macroButtons.setSelectedIndex(index);
        this.macroButtons.ensureIndexIsVisible(index);
    }

    private void insertKey(int mask) {
        int index = this.macroButtons.getSelectedIndex();
        if (this.itemStyle) {
            RemoteConfiguration.KeySpec value = this.getKeySpec();
            this.macroButtonModel.add(index, value);
        } else {
            Integer value = new Integer(this.getSelectedKeyCode() | mask);
            if (index == -1) {
                this.macroButtonModel.add(0, value);
            } else {
                this.macroButtonModel.add(index, value);
            }
        }
        this.macroButtons.setSelectedIndex(index + 1);
        this.macroButtons.ensureIndexIsVisible(index + 1);
    }

    private void swap(int index1, int index2) {
        Object o1 = this.macroButtonModel.get(index1);
        Object o2 = this.macroButtonModel.get(index2);
        this.macroButtonModel.set(index1, o2);
        this.macroButtonModel.set(index2, o1);
        this.macroButtons.setSelectedIndex(index2);
        this.macroButtons.ensureIndexIsVisible(index2);
    }

    private int getSelectedKeyCode() {
        return ((Button)this.availableButtons.getSelectedValue()).getKeyCode();
    }

    public boolean isMoreRoom(int limit) {
        return this.macroButtonModel.getSize() < limit;
    }

    public boolean isEmpty() {
        return this.macroButtonModel.getSize() == 0;
    }

    public JList getMacroButtons() {
        return this.macroButtons;
    }

    @Override
    public Object getValue() {
        int length = this.macroButtonModel.getSize();
        if (this.itemStyle) {
            ArrayList<RemoteConfiguration.KeySpec> items = new ArrayList<RemoteConfiguration.KeySpec>();
            for (int i = 0; i < length; ++i) {
                items.add((RemoteConfiguration.KeySpec)this.macroButtonModel.elementAt(i));
            }
            return items;
        }
        short[] keyCodes = new short[length];
        for (int i = 0; i < length; ++i) {
            keyCodes[i] = ((Number)this.macroButtonModel.elementAt(i)).shortValue();
        }
        return new Hex(keyCodes);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.enableButtons();
        if (this.itemStyle) {
            RemoteConfiguration.KeySpec ks = (RemoteConfiguration.KeySpec)this.macroButtons.getSelectedValue();
            if (ks == null) {
                return;
            }
            if (this.config.getRemote().usesEZRC()) {
                this.deviceBox.setSelectedItem(ks.db);
                GeneralFunction gf = ks.fn != null ? ks.fn : (ks.btn != null ? ks.db.getUpgrade().getGeneralFunction(ks.btn.getKeyCode(), false) : null);
                this.functionBox.getModel().setSelectedItem(null);
                this.functionBox.setSelectedItem(gf);
                boolean showDuration = ks.duration >= 0;
                this.holdCheck.setSelected(showDuration);
                this.duration.setEnabled(showDuration);
                this.durationLabel.setEnabled(showDuration);
                this.duration.setValue(Float.valueOf(showDuration ? (float)ks.duration * 0.1f : 0.0f));
            } else {
                this.buttonBox.getModel().setSelectedItem(null);
                this.buttonBox.setSelectedItem(ks.btn);
                this.shift.setSelected(ks.btnState == 1);
                float value = (float)(this.codeSize == 2 ? (double)ks.duration * 0.1 : Macro.valueLowToHold(ks.duration));
                this.duration.setValue(Float.valueOf(value));
            }
            this.delay.setValue(Float.valueOf((float)ks.delay / 10.0f));
        }
    }

    @Override
    public void setValue(Object value) {
        this.macroButtonModel.clear();
        if (value == null) {
            return;
        }
        if (value instanceof List) {
            List list = (List)value;
            for (RemoteConfiguration.KeySpec ks : list) {
                this.macroButtonModel.addElement(ks);
            }
        } else {
            Hex hex = (Hex)value;
            this.availableButtons.setSelectedIndex(-1);
            short[] data = hex.getData();
            for (int i = 0; i < data.length; ++i) {
                this.macroButtonModel.addElement(new Integer(data[i]));
            }
            this.macroButtons.setSelectedIndex(-1);
        }
    }

    public void enableButtons() {
        boolean usesEZRC = this.config.getRemote().usesEZRC();
        int selected = this.macroButtons.getSelectedIndex();
        this.moveUp.setEnabled(selected > 0);
        this.moveDown.setEnabled(selected != -1 && selected < this.macroButtonModel.getSize() - 1);
        this.remove.setEnabled(this.macroButtons.isFocusOwner() && selected != -1);
        this.clear.setEnabled(this.macroButtonModel.getSize() > 0);
        this.deselect.setEnabled(selected != -1);
        Button baseButton = (Button)(usesEZRC ? null : (this.itemStyle ? this.buttonBox.getSelectedItem() : this.availableButtons.getSelectedValue()));
        this.buttonEnabler.enableButtons(baseButton, this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Object source = e.getSource();
        if (source == this.delay) {
            Float f = (Float)this.delay.getValue();
            if (this.config != null && this.config.getRemote().usesEZRC()) {
                if ((double)f.floatValue() < 0.1) {
                    this.delay.setValue(Float.valueOf(0.1f));
                }
                if ((double)f.floatValue() > 10.0) {
                    this.delay.setValue(Float.valueOf(10.0f));
                }
            }
        }
    }

    private class XFormattedTextField
    extends JFormattedTextField {
        XFormattedTextField(NumberFormatter formatter) {
            super(formatter);
            this.setFocusLostBehavior(1);
        }

        @Override
        protected void processFocusEvent(FocusEvent e) {
            super.processFocusEvent(e);
            if (e.getID() == 1004) {
                this.selectAll();
            }
        }
    }
}

