/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.AdvancedCode;
import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.ButtonEnabler;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.MacroDefinitionBox;
import com.hifiremote.jp1.MultiMacro;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.WrapLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class MacroDialog
extends JDialog
implements ActionListener,
ButtonEnabler {
    private JPanel upperPanel = null;
    private JPanel boundPanel = null;
    private JComboBox boundKey = new JComboBox();
    private JComboBox boundDevice = null;
    private JTextField nameField = null;
    private JCheckBox shift = new JCheckBox();
    private JCheckBox xShift = new JCheckBox();
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private JTextArea notes = new JTextArea(2, 10);
    private RemoteConfiguration config = null;
    private Macro macro = null;
    private MacroDefinitionBox macroBox = null;
    private boolean itemStyle = false;
    private boolean realTime = false;
    private boolean controlled = false;
    private boolean multi = false;
    private boolean dsm = false;
    private Macro.MacroClass macroClass = null;
    private static MacroDialog dialog = null;

    public static Macro showDialog(Component locationComp, Macro macro, RemoteConfiguration config, int mode, boolean dsm) {
        boolean ezrc = config.getRemote().usesEZRC();
        boolean controlled = mode == 1;
        boolean realTime = !ezrc && (mode == 2 || macro != null && macro.getItems() != null);
        boolean itemStyle = ezrc || controlled || realTime;
        dialog = new MacroDialog(locationComp, itemStyle);
        MacroDialog.dialog.dsm = dsm;
        MacroDialog.dialog.controlled = controlled;
        MacroDialog.dialog.realTime = realTime;
        MacroDialog.dialog.multi = mode == 3;
        dialog.setRemoteConfiguration(config);
        dialog.setMacro(macro);
        dialog.pack();
        dialog.setLocationRelativeTo(locationComp);
        dialog.setVisible(true);
        return MacroDialog.dialog.macro;
    }

    public static void reset() {
        if (dialog != null) {
            dialog.dispose();
            dialog = null;
        }
    }

    private MacroDialog(Component c, boolean itemStyle) {
        super((JFrame)SwingUtilities.getRoot(c));
        this.setTitle("Macro");
        this.setModal(true);
        this.itemStyle = itemStyle;
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.upperPanel = new JPanel(new BorderLayout());
        contentPane.add((Component)this.upperPanel, "North");
        this.boundPanel = new JPanel(new WrapLayout(0));
        this.upperPanel.add((Component)this.boundPanel, "Center");
        this.boundPanel.setBorder(BorderFactory.createTitledBorder("Bound Key"));
        this.macroBox = new MacroDefinitionBox(itemStyle);
        this.macroBox.setButtonEnabler(this);
        contentPane.add((Component)this.macroBox, "Center");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        contentPane.add((Component)bottomPanel, "South");
        JPanel panel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)panel, "North");
        panel.setBorder(BorderFactory.createTitledBorder("Notes"));
        this.notes.setLineWrap(true);
        panel.add(new JScrollPane(this.notes, 22, 31));
        panel = new JPanel(new FlowLayout(2));
        bottomPanel.add((Component)panel, "South");
        this.okButton.addActionListener(this);
        panel.add(this.okButton);
        this.cancelButton.addActionListener(this);
        panel.add(this.cancelButton);
    }

    private void setRemoteConfiguration(RemoteConfiguration config) {
        if (this.config == config) {
            return;
        }
        this.config = config;
        Remote remote = config.getRemote();
        this.setTitle(this.controlled ? (this.dsm ? "Controlled DSM" : "Controlled Macro") : (this.realTime ? (this.dsm ? "Real-time DSM" : "Real-time Macro") : (this.multi ? (this.dsm ? "DSM of MultiDSM" : "Macro of MultiMacro") : (this.dsm ? "DSM" : "Macro"))));
        this.macroBox.setCodeSize(this.controlled ? 2 : 1);
        if (remote.usesEZRC()) {
            this.nameField = new JTextField(20);
            JPanel panel = new JPanel(new WrapLayout());
            panel.add(new JLabel("Name:"));
            panel.add(this.nameField);
            this.upperPanel.add((Component)panel, "First");
            this.boundDevice = new JComboBox();
            remote.setDeviceComboBox(this.boundDevice);
            this.boundPanel.add(new JLabel("Device:"));
            this.boundPanel.add(this.boundDevice);
            this.boundPanel.add(Box.createHorizontalStrut(5));
            this.boundPanel.add(new JLabel("Key:"));
            this.boundPanel.add(this.boundKey);
            this.macroClass = Macro.MacroClass.REALTIME;
        } else {
            this.shift.setText(remote.getShiftLabel());
            this.shift.setEnabled(remote.getShiftEnabled() & !this.multi);
            this.xShift.setText(remote.getXShiftLabel());
            this.xShift.setEnabled(remote.getXShiftEnabled());
            if (this.dsm) {
                this.boundDevice = new JComboBox<DeviceButton>(remote.getDeviceButtons());
                this.boundPanel.add(new JLabel("Device:"));
                this.boundPanel.add(this.boundDevice);
                this.boundPanel.add(Box.createHorizontalStrut(5));
            }
            this.boundPanel.add(new JLabel("Key:"));
            this.boundPanel.add(this.boundKey);
            this.shift.addActionListener(this);
            this.boundPanel.add(this.shift);
            this.xShift.addActionListener(this);
            this.boundPanel.add(this.xShift);
            this.macroClass = this.multi ? Macro.MacroClass.MULTI : (this.controlled ? Macro.MacroClass.CONTROLLED : (this.realTime ? Macro.MacroClass.REALTIME : Macro.MacroClass.NORMAL));
        }
        Button[] macroButtons = remote.getMacroButtons(this.macroClass, RMIRSetup.disableUploadRestrictionsItem.isSelected());
        this.boundKey.setModel(new DefaultComboBoxModel<Button>(macroButtons));
        this.boundKey.addActionListener(this);
        if (macroButtons.length > 0) {
            this.boundKey.setSelectedIndex(0);
        }
        this.macroBox.setRemoteConfiguration(config);
    }

    private void setMacro(Macro macro) {
        this.macro = macro;
        if (macro == null) {
            this.boundKey.setSelectedIndex(-1);
            this.shift.setSelected(false);
            this.xShift.setSelected(false);
            this.macroBox.setValue((Object)null);
            this.notes.setText(null);
        } else {
            this.setButton(macro.getKeyCode(), this.boundKey, this.shift, this.xShift);
            Remote remote = this.config.getRemote();
            this.macroBox.setCodeSize(this.realTime || remote.getMacroSupport() != 2 ? 1 : 2);
            Object val = macro.getValue();
            if (this.multi) {
                this.shift.setEnabled(false);
            }
            if (val instanceof Hex) {
                this.macroBox.setValue((Hex)val);
            } else if (val instanceof List) {
                this.macroBox.setValue((List)val);
            }
            if (this.config.getRemote().usesEZRC()) {
                this.boundDevice.setSelectedItem(macro.getDeviceButton(this.config));
                this.nameField.setText(macro.getName());
            } else if (this.dsm) {
                this.boundDevice.setSelectedItem(macro.getDeviceButton(this.config));
            }
            this.notes.setText(macro.getNotes());
        }
        this.macroBox.enableButtons();
    }

    private void setButton(int code, JComboBox comboBox, JCheckBox shiftBox, JCheckBox xShiftBox) {
        Remote remote = this.config.getRemote();
        Button b = remote.getButton(code);
        shiftBox.setSelected(false);
        xShiftBox.setSelected(false);
        if (!Arrays.asList(remote.getMacroButtons()).contains(b)) {
            b = null;
        }
        if (b == null) {
            int base = code & 0x3F;
            if (base != 0) {
                b = remote.getButton(base);
                if (remote.getShiftEnabled() && (base | remote.getShiftMask()) == code) {
                    shiftBox.setEnabled(remote.getShiftEnabled() && b.allowsShiftedMacro());
                    shiftBox.setSelected(true);
                    comboBox.setSelectedItem(b);
                    return;
                }
                if (remote.getXShiftEnabled() && (base | remote.getXShiftMask()) == code) {
                    xShiftBox.setEnabled(remote.getXShiftEnabled() && b.allowsXShiftedMacro());
                    xShiftBox.setSelected(true);
                    comboBox.setSelectedItem(b);
                    return;
                }
            }
            if ((b = remote.getButton(code & ~remote.getShiftMask())) != null) {
                shiftBox.setSelected(true);
            } else if (remote.getXShiftEnabled() && (b = remote.getButton(code ^ ~remote.getXShiftMask())) != null) {
                xShiftBox.setSelected(true);
            }
        }
        shiftBox.setEnabled(remote.getShiftEnabled() && b.allowsShiftedMacro());
        xShiftBox.setEnabled(remote.getXShiftEnabled() && b.allowsXShiftedMacro());
        if (remote.getXShiftEnabled() && b.getIsXShifted()) {
            xShiftBox.setSelected(true);
        } else if (remote.getShiftEnabled() && b.getIsShifted()) {
            shiftBox.setSelected(true);
        }
        comboBox.removeActionListener(this);
        comboBox.setSelectedItem(b);
        comboBox.addActionListener(this);
    }

    private int getKeyCode(JComboBox comboBox, JCheckBox shiftBox, JCheckBox xShiftBox) {
        Remote remote = this.config.getRemote();
        Button btn = (Button)comboBox.getSelectedItem();
        int keyCode = btn.getKeyCode();
        if (shiftBox.isSelected()) {
            keyCode |= remote.getShiftMask();
        } else if (xShiftBox.isSelected()) {
            keyCode |= remote.getXShiftMask();
        }
        if (this.multi && btn.getMultiMacro() == null) {
            btn.setMultiMacro(new MultiMacro());
        }
        return keyCode;
    }

    private void showWarning(String message) {
        JOptionPane.showMessageDialog(this, message, "Missing Information", 0);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        Remote remote = this.config.getRemote();
        Button b = (Button)this.boundKey.getSelectedItem();
        if (source == this.okButton) {
            String name = null;
            DeviceButton db = null;
            if (remote.usesEZRC() && ((name = this.nameField.getText()) == null || name.isEmpty())) {
                this.showWarning("You must give a name for this macro.");
                return;
            }
            if (remote.usesEZRC() || this.dsm) {
                if (this.boundDevice.getSelectedItem() == null) {
                    this.showWarning("You must select a device for the bound key.");
                    return;
                }
                db = (DeviceButton)this.boundDevice.getSelectedItem();
            }
            if (this.boundKey.getSelectedItem() == null) {
                this.showWarning("You must select a key for the bound key.");
                return;
            }
            int keyCode = this.getKeyCode(this.boundKey, this.shift, this.xShift);
            if (this.macroBox.isEmpty()) {
                this.showWarning("You haven't included any keys in your macro!");
                return;
            }
            String notesStr = this.notes.getText();
            Object value = this.macroBox.getValue();
            Macro newMacro = new Macro(keyCode, null, notesStr);
            newMacro.setMacroClass(this.controlled ? Macro.MacroClass.CONTROLLED : (this.itemStyle ? Macro.MacroClass.REALTIME : (this.multi ? Macro.MacroClass.MULTI : Macro.MacroClass.NORMAL)));
            if (this.itemStyle) {
                List items = (List)value;
                if (this.controlled && this.holdWarnCheck(items)) {
                    this.macro = null;
                    this.setVisible(false);
                    return;
                }
                newMacro.setItems(items);
                if (remote.usesEZRC() || this.dsm) {
                    newMacro.setDeviceButtonIndex(db.getButtonIndex());
                }
                if (remote.usesEZRC()) {
                    newMacro.setName(name);
                }
                if (remote.isSSD()) {
                    newMacro.setSerial(this.config.getNewMacroSerial());
                } else {
                    newMacro.setSegmentFlags(this.macro == null ? 255 : this.macro.getSegmentFlags());
                }
            } else {
                Hex data = (Hex)value;
                newMacro.setData(data);
                if (this.dsm) {
                    newMacro.setDeviceButtonIndex(db.getButtonIndex());
                    if (remote.hasFlaggedDSM()) {
                        newMacro.setSequenceNumber(4);
                    }
                }
            }
            if (this.config.hasSegments() && !remote.usesEZRC()) {
                if (this.macro == null) {
                    newMacro.setSegmentFlags(255);
                } else {
                    if (!this.dsm) {
                        newMacro.setDeviceButtonIndex(this.macro.getDeviceButtonIndex());
                    }
                    newMacro.setName(this.macro.getName());
                    newMacro.setSegmentFlags(this.macro.getSegmentFlags());
                    newMacro.setSerial(this.macro.getSerial());
                }
            }
            this.macro = newMacro;
            this.setVisible(false);
        } else if (source == this.cancelButton) {
            this.macro = null;
            this.setVisible(false);
        } else if (source == this.shift) {
            if (this.shift.isSelected()) {
                this.xShift.setSelected(false);
            } else if (b != null && remote.getXShiftEnabled()) {
                this.xShift.setSelected(b.needsShift(Button.MACRO_BIND));
            }
        } else if (source == this.xShift) {
            if (this.xShift.isSelected()) {
                this.shift.setSelected(false);
            } else if (b != null) {
                this.shift.setSelected(b.needsShift(Button.MACRO_BIND));
            }
        } else if (source == this.boundKey && b != null) {
            b.setShiftBoxes(Button.MACRO_BIND, this.shift, this.xShift);
            if (this.multi) {
                this.shift.setEnabled(false);
            }
        }
    }

    @Override
    public void enableButtons(Button b, MacroDefinitionBox macroBox) {
        if (this.itemStyle) {
            boolean selected = macroBox.getMacroButtons().getSelectedIndex() >= 0;
            macroBox.add.setEnabled(true);
            macroBox.insert.setEnabled(selected);
            macroBox.addShift.setText("Replace");
            macroBox.addShift.setVisible(true);
            macroBox.addShift.setEnabled(selected);
            macroBox.addXShift.setVisible(false);
            macroBox.insertShift.setVisible(false);
            macroBox.insertXShift.setVisible(false);
            return;
        }
        int limit = 15;
        if (this.config.getRemote().getAdvCodeBindFormat() == AdvancedCode.BindFormat.LONG) {
            limit = 255;
        }
        boolean canAdd = b != null && macroBox.isMoreRoom(limit);
        macroBox.add.setEnabled(canAdd && b.canAssignToMacro());
        macroBox.insert.setEnabled(canAdd && b.canAssignToMacro());
        macroBox.addShift.setVisible(true);
        macroBox.addXShift.setVisible(true);
        macroBox.insertShift.setVisible(true);
        macroBox.insertXShift.setVisible(true);
        boolean shiftEnabled = this.config.getRemote().getShiftEnabled();
        macroBox.addShift.setEnabled(shiftEnabled && canAdd && b.canAssignShiftedToMacro());
        macroBox.insertShift.setEnabled(shiftEnabled && canAdd && b.canAssignShiftedToMacro());
        boolean xShiftEnabled = this.config.getRemote().getXShiftEnabled();
        macroBox.addXShift.setEnabled(xShiftEnabled && canAdd && b.canAssignXShiftedToMacro());
        macroBox.insertXShift.setEnabled(xShiftEnabled && canAdd && b.canAssignXShiftedToMacro());
    }

    @Override
    public boolean isAvailable(Button b) {
        return this.config.getRemote().getDistinctButtons().contains(b) && (b.canAssignToMacro() || b.canAssignShiftedToMacro() || b.canAssignXShiftedToMacro());
    }

    private boolean holdWarnCheck(List<RemoteConfiguration.KeySpec> items) {
        if (!Macro.showControlledHoldWarning) {
            return false;
        }
        Remote remote = this.config.getRemote();
        boolean warn = false;
        for (RemoteConfiguration.KeySpec item : items) {
            short keyCode = item.btn.getKeyCode();
            if (remote.getDeviceButton(keyCode) != null || item.duration <= 1) continue;
            warn = true;
            break;
        }
        if (!warn) {
            return false;
        }
        Macro.showControlledHoldWarning = false;
        String title = "Hold behaviour warning";
        String message = "Controlled Macros are designed to have the buttons of the macro set in pairs, a device button\nfollowed by a function button, with the hold duration set on the device button and the following\ndelay set on the function button, the other two times being zero.  RMIR does not enforce this,\nbut this design means that in a macro composed only of function buttons, the hold duration set\non a button applies not to that button but to the next one.  You may need to take this into\naccount in constructing your macros.\n\nThis message will be displayed only once in any RMIR session.\n\nDo you want to continue?";
        int reply = JOptionPane.showConfirmDialog(this.config.getOwner(), message, title, 0, 2);
        return reply != 0;
    }
}

