/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Activity;
import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.GeneralFunction;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.MacroDialog;
import com.hifiremote.jp1.MacroTableModel;
import com.hifiremote.jp1.RMTablePanel;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;

public class MacroPanel
extends RMTablePanel<Macro> {
    private JTextPane notesPane = new JTextPane();

    public MacroPanel() {
        super(new MacroTableModel());
        this.footerPanel.add((Component)this.notesPane, "First");
        this.notesPane.setBackground(this.getBackground());
        this.notesPane.setForeground(Color.BLACK);
        this.notesPane.setVisible(true);
    }

    @Override
    public void set(RemoteConfiguration remoteConfig) {
        Remote remote = remoteConfig.getRemote();
        ((MacroTableModel)this.model).set(remoteConfig);
        this.table.initColumns(this.model);
        String notes = null;
        if (remote.usesEZRC()) {
            notes = "Macros with Device Button and Key values shaded Pink (if selected, Red) are unassigned, so will be saved in a .rmir file but not uploaded to the remote.  If shaded Orange (if selected, Brown) there is a conflict with a Learned Signal on the same Device Button/Key combination.  This is for information only, as both will be uploaded but they may not work as intended.";
        } else {
            notes = "Macros with Key values shaded Pink (if selected, Red) conflict with another Macro on the same ";
            notes = notes + (remote.usesEZRC() ? "Device/Key combination " : "Key ");
            notes = notes + "that has higher priority, so that Macro will be saved in a .rmir file but not uploaded to the remote.";
            if (!remote.usesEZRC()) {
                notes = notes + "\nKey values are shaded Green (if selected, Olive) if there is a device-specific item in another table on the same key.  The macro will be uploaded to the remote but the device-specific item will take priority when that device is selected.";
            }
        }
        this.notesPane.setText(notes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Macro createRowObject(Macro baseMacro) {
        boolean supportsMultiMacros;
        RemoteConfiguration config = ((MacroTableModel)this.model).getRemoteConfig();
        Remote remote = config.getRemote();
        int mode = 0;
        boolean supportsControlled = remote.getMacroSupport() == 2;
        Button[] realTimeMacroButtons = remote.getMacroButtons(Macro.MacroClass.REALTIME, false);
        Button[] multiMacroButtons = remote.getMacroButtons(Macro.MacroClass.MULTI, false);
        boolean supportsRealTime = realTimeMacroButtons != null && realTimeMacroButtons.length > 0;
        boolean bl = supportsMultiMacros = multiMacroButtons != null && multiMacroButtons.length > 0;
        if (baseMacro == null && remote.usesEZRC()) {
            mode = 2;
            return MacroDialog.showDialog(this, baseMacro, config, mode, false);
        } else if (baseMacro == null && (supportsControlled || supportsRealTime || supportsMultiMacros)) {
            int reply;
            Object[] options = new String[supportsRealTime && (supportsControlled || supportsMultiMacros) ? 3 : 2];
            options[0] = "Normal";
            String string = supportsControlled ? "Controlled" : (options[1] = supportsMultiMacros && options.length == 2 ? "MultiMacro" : "RealTime");
            if (options.length == 3) {
                options[2] = supportsMultiMacros ? "MultiMacro" : "RealTime";
            }
            String title = "Macro choice";
            String message = "This remote supports creating more than one type of macro, according to the option buttons shown below.\nThe keys to which a macro may be bound depend on the type of macro.\n\nNormal: This sends the signals of the list of keys given in the macro.\n";
            if (options[1].equals("RealTime") || options.length > 2 && options[2].equals("RealTime")) {
                message = message + "Real-time: This allow you to specify, for each key in the macro, how long the key is held for and the delay\nbefore the next key.  Remotes supporting real-time macros have keys capable of recording this data.  Hold\ntimes can be recorded fairly accurately but delay times only in multiples of 100ms.\n";
            }
            if (options[1].equals("Controlled")) {
                message = message + "Controlled: Controlled macros are similar to real-time ones but can only be created by RMIR.  Hold times,\nlike delay times, are set as multiples of 100ms.\n";
            }
            if (options[1].equals("MultiMacro") || options.length > 2 && options[2].equals("MultiMacro")) {
                message = message + "MultiMacro: This is a set of normal macros bound to the same key that are sent in turn on successive\nkeypresses.  Each macro of the set is created and listed separately in RMIR.  Remotes supporting\nmultimacros usually have dedicated keys to which they may be bound.\n";
            }
            if ((reply = JOptionPane.showOptionDialog(this, message = message + "\nPlease choose which type of macro you wish to create.", title, 0, -1, null, options, options[0])) < 0) return null;
            mode = reply == 1 ? (supportsControlled ? 1 : (supportsMultiMacros && options.length == 2 ? 3 : 2)) : (reply == 2 && supportsMultiMacros ? 3 : reply);
            return MacroDialog.showDialog(this, baseMacro, config, mode, false);
        } else {
            mode = baseMacro == null ? 0 : (baseMacro.getMacroClass() == Macro.MacroClass.CONTROLLED ? 1 : (baseMacro.getMacroClass() == Macro.MacroClass.MULTI ? 3 : (baseMacro.getMacroClass() == Macro.MacroClass.REALTIME ? 2 : 0)));
        }
        return MacroDialog.showDialog(this, baseMacro, config, mode, false);
    }

    @Override
    protected void editRowObject(int row) {
        RemoteConfiguration config = ((MacroTableModel)this.model).getRemoteConfig();
        Remote remote = config.getRemote();
        List<Macro> macros = config.getMacros();
        Macro baseMacro = (Macro)this.getRowObject(row);
        int ndx = macros.indexOf(baseMacro);
        GeneralFunction.User baseUser = new GeneralFunction.User(baseMacro.getDeviceButton(config), remote.getButton(baseMacro.getKeyCode()));
        Macro newMacro = this.createRowObject(baseMacro);
        if (newMacro != null) {
            macros.remove(ndx);
            macros.add(ndx, newMacro);
            Activity activity = baseMacro.getActivity();
            if (activity != null) {
                newMacro.setActivity(activity);
                newMacro.setMacroClass(baseMacro.getMacroClass());
                activity.setMacro(newMacro);
            }
            this.model.setRow(this.sorter.modelIndex(row), newMacro);
        }
    }
}

