/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.GeneralFunction;
import com.hifiremote.jp1.JP1TableModel;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.RMColorEditor;
import com.hifiremote.jp1.RMColorRenderer;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.RowNumberRenderer;
import com.hifiremote.jp1.SelectAllCellEditor;
import java.awt.Color;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class MacroTableModel
extends JP1TableModel<Macro> {
    private static final String[] colNames = new String[]{"#", "Name", "<html>Device<br>Button</html>", "Key", "Macro Keys", "Type", "Serial", "Notes", "<html>Size &amp<br>Color</html>"};
    private static final Class<?>[] colClasses = new Class[]{Integer.class, String.class, DeviceButton.class, Integer.class, String.class, String.class, Integer.class, String.class, Color.class};
    private static final String[] colPrototypeNames = new String[]{" 00 ", "MacroName_____", "DeviceName", "_xShift-VCR/DVD_", "A reasonable length macro with a reasonable number of steps ", "Controlled_", "0000_", "A reasonable length note for a macro", "Color_"};
    private static final boolean[] colWidths = new boolean[]{true, false, false, true, false, true, true, false, true};
    private RemoteConfiguration remoteConfig = null;
    private JComboBox deviceButtonBox = new JComboBox();
    private SelectAllCellEditor selectAllEditor = new SelectAllCellEditor();
    private RMColorEditor colorEditor = null;
    private RMColorRenderer colorRenderer = new RMColorRenderer();

    public void set(RemoteConfiguration remoteConfig) {
        this.remoteConfig = remoteConfig;
        if (remoteConfig != null) {
            Remote remote = remoteConfig.getRemote();
            this.deviceButtonBox.setModel(new DefaultComboBoxModel<Object>(remote.usesEZRC() ? remoteConfig.getDeviceButtonList().toArray() : remote.getDeviceButtons()));
            this.colorEditor = new RMColorEditor(remoteConfig.getOwner());
            this.highlightKeyRenderer.setRemote(remote);
            if (remoteConfig != null) {
                this.setData(remoteConfig.getTableMacros());
            }
        }
    }

    public RemoteConfiguration getRemoteConfig() {
        return this.remoteConfig;
    }

    @Override
    public int getColumnCount() {
        int count = colNames.length - 5;
        if (this.remoteConfig != null && this.remoteConfig.getRemote().usesEZRC()) {
            count += RemoteMaster.admin ? 3 : 2;
        }
        if (this.remoteConfig != null && this.remoteConfig.allowHighlighting()) {
            ++count;
        }
        if (MacroTableModel.useTypeCol(this.remoteConfig)) {
            ++count;
        }
        return count;
    }

    @Override
    public String getColumnName(int col) {
        return colNames[this.getEffectiveColumn(col)];
    }

    private int getEffectiveColumn(int col) {
        if (this.remoteConfig == null || !this.remoteConfig.getRemote().usesEZRC()) {
            int val;
            int n = val = MacroTableModel.useTypeCol(this.remoteConfig) ? 3 : 2;
            col += col > val ? 6 - val : (col > 0 ? 2 : 0);
        } else if (col > 4) {
            col += RemoteMaster.admin ? 1 : 2;
        }
        return col;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return colClasses[this.getEffectiveColumn(col)];
    }

    @Override
    public String getColumnPrototypeName(int col) {
        return colPrototypeNames[this.getEffectiveColumn(col)];
    }

    @Override
    public boolean isColumnWidthFixed(int col) {
        return colWidths[this.getEffectiveColumn(col)];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return (col = this.getEffectiveColumn(col)) != 0 && col != 3 && col != 4 && col != 5;
    }

    @Override
    public Object getValueAt(int row, int column) {
        column = this.getEffectiveColumn(column);
        Macro macro = (Macro)this.getRow(row);
        switch (column) {
            case 0: {
                return new Integer(row + 1);
            }
            case 1: {
                return macro.getName();
            }
            case 2: {
                return macro.getDeviceButton(this.remoteConfig);
            }
            case 3: {
                return new Integer(macro.getKeyCode());
            }
            case 4: {
                return macro.getValueString(this.remoteConfig);
            }
            case 5: {
                String classText = macro.getMacroClass().toString().toLowerCase();
                return classText.equals("multi") ? "multi item" : classText;
            }
            case 6: {
                return macro.getSerial();
            }
            case 7: {
                return macro.getNotes();
            }
            case 8: {
                return macro.getHighlight();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        DeviceUpgrade du;
        col = this.getEffectiveColumn(col);
        Macro macro = (Macro)this.getRow(row);
        Remote remote = this.remoteConfig.getRemote();
        DeviceUpgrade deviceUpgrade = du = remote.usesEZRC() ? macro.getUpgrade(remote) : null;
        if (col == 1) {
            macro.setName((String)value);
        } else if (col == 2) {
            DeviceButton db = (DeviceButton)value;
            if (remote.usesEZRC()) {
                Button b = remote.getButton(macro.getKeyCode());
                DeviceButton dbx = remote.getDeviceButton(macro.getDeviceButtonIndex());
                if (macro.getUsers().contains(new GeneralFunction.User(dbx, b))) {
                    dbx.getUpgrade().setFunction(b, null, 0);
                }
                du = db.getUpgrade();
                macro.setDeviceButtonIndex(db.getButtonIndex());
                macro.setKeyCode(b.getKeyCode());
                du.setFunction(b, macro, 0);
            } else {
                macro.setDeviceButtonIndex(db.getButtonIndex());
            }
        } else if (col == 3) {
            int keyCode = (Integer)value;
            if (remote.usesEZRC()) {
                Button b = remote.getButton(macro.getKeyCode());
                int devNdx = macro.getDeviceButtonIndex();
                DeviceButton dbx = remote.getDeviceButton(devNdx);
                if (macro.getUsers().contains(new GeneralFunction.User(dbx, b))) {
                    dbx.getUpgrade().setFunction(b, null, 0);
                }
                macro.setDeviceButtonIndex(devNdx);
                macro.setKeyCode(keyCode);
                b = remote.getButton(keyCode);
                du.setFunction(b, macro, 0);
            } else {
                macro.setKeyCode(keyCode);
            }
        } else if (col == 6) {
            macro.setSerial((Integer)value);
        } else if (col == 7) {
            macro.setNotes((String)value);
        } else if (col == 8) {
            macro.setHighlight((Color)value);
        }
        this.propertyChangeSupport.firePropertyChange(col == 8 ? "highlight" : "data", null, null);
    }

    @Override
    public TableCellRenderer getColumnRenderer(int col) {
        if ((col = this.getEffectiveColumn(col)) == 0) {
            return new RowNumberRenderer();
        }
        if (col == 3) {
            return this.highlightKeyRenderer;
        }
        if (col == 8) {
            return this.colorRenderer;
        }
        return this.highlightRenderer;
    }

    @Override
    public TableCellEditor getColumnEditor(int col) {
        if ((col = this.getEffectiveColumn(col)) == 1 || col == 7) {
            return this.selectAllEditor;
        }
        if (col == 2) {
            DefaultCellEditor editor = new DefaultCellEditor(this.deviceButtonBox);
            editor.setClickCountToStart(2);
            return editor;
        }
        if (col == 8) {
            return this.colorEditor;
        }
        return null;
    }

    @Override
    public void moveRow(int from, int to) {
        if (this.remoteConfig != null) {
            Macro m1 = (Macro)this.data.get(from);
            Macro m2 = (Macro)this.data.get(to);
            List<Macro> macros = this.remoteConfig.getMacros();
            int ndx1 = macros.indexOf(m1);
            int ndx2 = macros.indexOf(m2);
            macros.remove(ndx1);
            macros.add(ndx2, m1);
        }
        super.moveRow(from, to);
    }

    @Override
    public void setRow(int row, Macro value) {
        if (this.remoteConfig != null && this.remoteConfig.getRemote().usesEZRC()) {
            Macro macro = (Macro)this.getRow(row);
            for (GeneralFunction.User user : macro.getUsers()) {
                DeviceButton db = user.db;
                DeviceUpgrade upg = db.getUpgrade();
                if (upg == null || upg.getMacroMap() == null || upg.getMacroMap().get(user.button.getKeyCode()) != macro) continue;
                upg.getMacroMap().remove(user.button.getKeyCode());
            }
            GeneralFunction.User u = value.setReference(this.remoteConfig);
            if (value.getUsers().size() > 0) {
                DeviceUpgrade du = u.db.getUpgrade();
                du.getMacroMap().put(Integer.valueOf(u.button.getKeyCode()), value);
            }
        }
        super.setRow(row, value);
    }

    @Override
    public void insertRow(int row, Macro value) {
        if (this.remoteConfig != null) {
            Macro macro = (Macro)this.getRow(row);
            List<Macro> macros = this.remoteConfig.getMacros();
            int ndx = macros.indexOf(macro);
            macros.add(ndx, value);
            value.setReference(this.remoteConfig);
        }
        super.insertRow(row, value);
    }

    @Override
    public void addRow(Macro value) {
        if (this.remoteConfig != null) {
            List<Macro> macros = this.remoteConfig.getMacros();
            macros.add(value);
            value.setReference(this.remoteConfig);
        }
        super.addRow(value);
    }

    @Override
    public void removeRow(int row) {
        if (this.remoteConfig != null) {
            Macro macro = (Macro)this.getRow(row);
            for (GeneralFunction.User user : macro.getUsers()) {
                DeviceButton db = user.db;
                DeviceUpgrade upg = db.getUpgrade();
                if (upg == null || upg.getMacroMap() == null) continue;
                upg.getMacroMap().remove(user.button.getKeyCode());
            }
            this.remoteConfig.getMacros().remove(macro);
        }
        super.removeRow(row);
    }

    @Override
    public String getToolTipText(int row, int col) {
        if (this.remoteConfig == null || !this.remoteConfig.getRemote().usesEZRC()) {
            return null;
        }
        if ((col = this.getEffectiveColumn(col)) == 0 || col > 3) {
            return null;
        }
        Macro macro = (Macro)this.getRow(row);
        String str = "Edit the Device Upgrade to put this macro on additional<br>devices or buttons.  Currently assigned to:<br><br>";
        str = str + GeneralFunction.User.getUserNames(macro.getUsers());
        return JTableX.getHtmlToolTip(str);
    }

    public static boolean useTypeCol(RemoteConfiguration config) {
        if (config == null) {
            return false;
        }
        Remote remote = config.getRemote();
        List<Integer> segTypes = config.getRemote().getSegmentTypes();
        if (segTypes == null) {
            return remote.getMacroSupport() == 1 && remote.hasMultiMacroSupport();
        }
        int count = 0;
        if (segTypes.contains(1)) {
            ++count;
        }
        if (segTypes.contains(2)) {
            ++count;
        }
        if (segTypes.contains(3)) {
            ++count;
        }
        return count > 1;
    }
}

