/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.HexCodeEditor;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.ManualProtocol;
import com.hifiremote.jp1.ManualSettingsPanel;
import com.hifiremote.jp1.Processor;
import com.hifiremote.jp1.ProcessorManager;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.ProtocolDataPanel;
import com.hifiremote.jp1.S3C80Processor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ManualCodePanel
extends JPanel {
    private static final String[] colNames = new String[]{"Processor", "Protocol Code"};
    private static final Class<?>[] classes = new Class[]{Processor.class, Hex.class, List.class};
    private static Processor[] procs = new Processor[0];
    private static JComboBox<Processor> procBox = new JComboBox();
    private ManualSettingsPanel owner = null;
    private JTableX codeTable = null;
    private CodeTableModel codeModel = null;
    private ManualProtocol protocol = null;
    private Protocol displayProtocol = null;
    private Processor displayProcessor = null;
    private ProtocolDataPanel.DisplayArea noteArea = null;
    private boolean[] isEmpty = null;

    public ManualCodePanel(ManualSettingsPanel owner) {
        int i;
        this.owner = owner;
        this.setLayout(new BorderLayout());
        this.codeModel = new CodeTableModel();
        this.codeTable = new JTableX(this.codeModel);
        this.codeTable.setSelectionMode(2);
        this.codeTable.getSelectionModel().addListSelectionListener(owner);
        JPanel panel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.codeTable);
        JPanel codePanel = new JPanel(new BorderLayout());
        codePanel.setBorder(BorderFactory.createTitledBorder("Protocol code"));
        codePanel.add((Component)scrollPane, "Center");
        panel.add((Component)codePanel, "Center");
        this.add((Component)panel, "Center");
        this.noteArea = new ProtocolDataPanel.DisplayArea(null, null);
        this.noteArea.setBorder(BorderFactory.createTitledBorder("Notes: "));
        panel.add((Component)this.noteArea, "Last");
        DefaultTableCellRenderer r = (DefaultTableCellRenderer)this.codeTable.getDefaultRenderer(String.class);
        r.setHorizontalAlignment(0);
        this.codeTable.setDefaultEditor(Hex.class, new HexCodeEditor());
        this.codeTable.setLongToolTipTimeout();
        TableColumnModel columnModel = this.codeTable.getColumnModel();
        TableColumn column = columnModel.getColumn(0);
        JLabel l = (JLabel)this.codeTable.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(this.codeTable, colNames[0], false, false, 0, 0);
        int width = l.getPreferredSize().width;
        this.setProcs();
        for (i = 0; i < procs.length; ++i) {
            l.setText(procs[i].getFullName());
            width = Math.max(width, l.getPreferredSize().width);
        }
        for (i = 0; i < procs.length; ++i) {
            column.setMinWidth(width);
            column.setMaxWidth(width);
            column.setPreferredWidth(width);
        }
        columnModel.getColumn(1).setCellRenderer(new CodeCellRenderer());
        this.codeTable.doLayout();
    }

    private void setProcs() {
        procs = ProcessorManager.getProcessors();
        int count = 0;
        for (int i = 0; i < procs.length; ++i) {
            Processor proc = procs[i];
            if (!proc.getEquivalentName().equals(proc.getFullName())) continue;
            ++count;
        }
        Processor[] uProcs = new Processor[count];
        count = 0;
        for (int i = 0; i < procs.length; ++i) {
            Processor proc = procs[i];
            if (!proc.getEquivalentName().equals(proc.getFullName())) continue;
            uProcs[count++] = proc;
        }
        procs = uProcs;
        ArrayList<Processor> asmProcs = new ArrayList<Processor>();
        ArrayList<Processor> boxProcs = new ArrayList<Processor>();
        for (Processor proc : procs) {
            if (proc.getDataStyle() >= 0) {
                asmProcs.add(proc);
                boxProcs.add(proc);
                continue;
            }
            boxProcs.add(proc);
        }
        procBox.setModel(new DefaultComboBoxModel<Processor>(boxProcs.toArray(new Processor[0])));
    }

    public void setProtocol(ManualProtocol protocol) {
        this.protocol = protocol;
        this.isEmpty = new boolean[procs.length];
        for (int i = 0; i < procs.length; ++i) {
            Hex hex = this.displayProtocol != null ? this.displayProtocol.getCode(procs[i]) : null;
            this.isEmpty[i] = hex == null || hex.length() == 0;
        }
    }

    public ManualProtocol getProtocol() {
        return this.protocol;
    }

    public String[] importProtocolCode(String string, boolean idOnly) {
        StringTokenizer st = new StringTokenizer(string, "\n");
        String text = null;
        String processor = null;
        String name = null;
        String variantName = null;
        String pidStr = null;
        String procStr = null;
        while (st.hasMoreTokens()) {
            String temp;
            while (st.hasMoreTokens()) {
                text = st.nextToken();
                System.err.println("got '" + text);
                if (!text.toUpperCase().startsWith("UPGRADE PROTOCOL 0 =")) continue;
                StringTokenizer st2 = new StringTokenizer(text, "()=");
                st2.nextToken();
                pidStr = st2.nextToken().toUpperCase().trim();
                System.err.println("Imported pid is " + pidStr);
                processor = st2.nextToken().toUpperCase().trim();
                System.err.println("processorName is " + processor);
                if (processor.startsWith("S3C8")) {
                    processor = "S3C80";
                } else if (processor.startsWith("S3F8")) {
                    processor = "S3F80";
                }
                if (!st2.hasMoreTokens()) break;
                name = st2.nextToken().trim();
                System.err.println("importedName is " + name);
                int ndx = name.indexOf(58);
                if (ndx <= 0) break;
                variantName = name.substring(ndx + 1).trim();
                name = name.substring(0, ndx).trim();
                break;
            }
            if (idOnly) break;
            if (!st.hasMoreTokens()) continue;
            text = st.nextToken();
            while (st.hasMoreTokens() && !(temp = st.nextToken()).trim().equals("End")) {
                text = text + ' ' + temp;
            }
            System.err.println("getting processor with name " + processor);
            Processor p = ProcessorManager.getProcessor(processor);
            if (p != null) {
                processor = p.getEquivalentName();
                p = ProcessorManager.getProcessor(processor);
                if (this.owner instanceof ManualSettingsPanel) {
                    ManualSettingsPanel msp = this.owner;
                    msp.selectProcessor(p);
                }
            }
            if (procStr == null) {
                procStr = processor;
            }
            System.err.println("Adding code for processor " + processor);
            System.err.println("Code is " + text);
            for (int i = 0; i < procs.length; ++i) {
                if (procs[i] != p) continue;
                this.codeModel.setValueAt(new Hex(text), i, 1);
            }
        }
        return new String[]{name, variantName, pidStr, procStr};
    }

    public void setDisplayProtocol(Protocol displayProtocol) {
        this.displayProtocol = displayProtocol;
    }

    public void setDisplayProcessor(Processor displayProcessor) {
        this.displayProcessor = displayProcessor;
    }

    public JTableX getCodeTable() {
        return this.codeTable;
    }

    public static Processor[] getProcs() {
        return procs;
    }

    public static JComboBox<Processor> getProcBox() {
        return procBox;
    }

    public CodeTableModel getCodeModel() {
        return this.codeModel;
    }

    public ProtocolDataPanel.DisplayArea getNoteArea() {
        return this.noteArea;
    }

    public class CodeTableModel
    extends AbstractTableModel {
        private Hex codeWhenNull = null;

        @Override
        public int getRowCount() {
            return procs.length;
        }

        @Override
        public int getColumnCount() {
            return colNames.length;
        }

        @Override
        public String getColumnName(int col) {
            return colNames[col];
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return classes[col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (ManualCodePanel.this.displayProcessor != null && !procs[row].getEquivalentName().equals(ManualCodePanel.this.displayProcessor.getEquivalentName())) {
                return false;
            }
            return col == 1;
        }

        @Override
        public Object getValueAt(int row, int col) {
            Hex dispHex;
            Hex hex = ManualCodePanel.this.protocol.getCode(procs[row]);
            Hex hex2 = dispHex = ManualCodePanel.this.displayProtocol == null ? null : ManualCodePanel.this.displayProtocol.getCode(procs[row]);
            if (dispHex == null) {
                dispHex = new Hex();
            }
            switch (col) {
                case 0: {
                    return procs[row];
                }
                case 1: {
                    return hex == null || hex.length() == 0 ? dispHex : hex;
                }
            }
            return hex == null || hex.length() == 0 || ManualCodePanel.this.isEmpty[row] && hex.equals(dispHex);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            switch (col) {
                case 1: {
                    Hex newCode = (Hex)value;
                    String procName = procs[row].getEquivalentName();
                    if (newCode != null && newCode.length() != 0) {
                        if (!ManualCodePanel.this.protocol.hasAnyCode() || ManualCodePanel.this.protocol.getCode().size() == 1 && ManualCodePanel.this.protocol.getCode().keySet().contains(procName)) {
                            ManualCodePanel.this.owner.getDevicePanel().update(procName, newCode);
                        }
                    } else if (this.codeWhenNull != null) {
                        String message = "This protocol is not built in to the remote.  Do you want to restore\nthe code to the standard code for this protocol?\n\nIf you select NO then the protocol upgrade for this device upgrade\nwill be deleted.  The device upgrade will not function until you\nrestore the protocol upgrade, which you may do by deleting this\nnull entry and answering this question again.";
                        String title = "Code deletion";
                        boolean restore = JOptionPane.showConfirmDialog(null, message, title, 0, 3) == 0;
                        newCode = restore ? this.codeWhenNull : new Hex();
                    }
                    Processor proc = procs[row];
                    ManualCodePanel.this.protocol.setCode(newCode, proc);
                    this.fireTableRowsUpdated(row, row);
                    if (proc.getDataStyle() < 0) break;
                    ProtocolDataPanel pdp = ManualCodePanel.this.owner.getProtDataPanel();
                    ManualCodePanel.this.owner.getDevicePanel().enableButtons();
                    if (ManualCodePanel.this.owner.getAssemblerPanel().isAssembled()) {
                        pdp.pfMainPanel.setPFData(proc, newCode);
                    } else {
                        ManualCodePanel.this.owner.getAssemblerModel().disassemble(newCode, proc);
                    }
                    procBox.setSelectedItem(proc);
                    if (proc instanceof S3C80Processor && ((S3C80Processor)proc).testCode(newCode) == S3C80Processor.CodeType.NEW) {
                        proc = ProcessorManager.getProcessor("S3F80");
                    }
                    ManualCodePanel.this.owner.interpretPFPD();
                    pdp.pfMainPanel.set();
                    pdp.pdMainPanel.set();
                    pdp.fnMainPanel.set();
                    break;
                }
                case 2: {
                    ManualSettingsPanel.getItemLists()[row] = (List)value;
                }
            }
        }

        public void setCodeWhenNull(Hex codeWhenNull) {
            this.codeWhenNull = codeWhenNull;
        }
    }

    public class CodeCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            CodeTableModel model = (CodeTableModel)table.getModel();
            if (isSelected) {
                c.setForeground((Boolean)model.getValueAt(row, 4) != false ? Color.YELLOW : Color.WHITE);
            } else {
                c.setForeground((Boolean)model.getValueAt(row, 4) != false ? Color.GRAY : Color.BLACK);
            }
            return c;
        }
    }
}

