/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.ManualProtocol;
import com.hifiremote.jp1.ManualSettingsDialog;
import com.hifiremote.jp1.ManualSettingsPanel;
import com.hifiremote.jp1.ParameterTableModel;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.ProtocolDataPanel;
import com.hifiremote.jp1.RMProtocolBuilder;
import com.hifiremote.jp1.SpinnerCellEditor;
import com.hifiremote.jp1.TextPopupMenu;
import com.hifiremote.jp1.Value;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class ManualDevicePanel
extends JPanel
implements ChangeListener,
DocumentListener {
    private ParameterTableModel deviceModel = null;
    private JTableX deviceTable = null;
    private ParameterTableModel commandModel = null;
    private JTableX commandTable = null;
    private JTextField rawHexData = null;
    private JSpinner cmdIndex = null;
    private ManualProtocol protocol = null;
    private Object owner = null;
    private ManualSettingsDialog settingsDialog = null;

    public ManualDevicePanel() {
        ManualProtocol protocol = new ManualProtocol(null, null);
        double scale = 0.75;
        double b = 5.0;
        double c = 10.0;
        double pr = -2.0;
        double pf = -1.0;
        double[][] size2 = new double[][]{{b, pr, c, pf, b}, {b, pr, b, pr, b, pr, b, pr, b, pr, pf, pr, b}};
        this.setLayout(new TableLayout(size2));
        this.deviceModel = new ParameterTableModel(protocol, ParameterTableModel.Type.DEVICE);
        this.deviceTable = new JTableX(this.deviceModel);
        SpinnerCellEditor editor = new SpinnerCellEditor(0, 8, 1);
        new TextPopupMenu((JTextField)((DefaultCellEditor)this.deviceTable.getDefaultEditor(String.class)).getComponent());
        this.deviceTable.setDefaultEditor(Integer.class, editor);
        JScrollPane scrollPane = new JScrollPane(this.deviceTable);
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.setBorder(BorderFactory.createTitledBorder("Device Parameters"));
        tablePanel.add((Component)scrollPane, "Center");
        this.add((Component)tablePanel, "1, 1, 3, 1");
        Dimension d = this.deviceTable.getPreferredScrollableViewportSize();
        d.height = this.deviceTable.getRowHeight() * 4;
        d.width = (int)((double)d.width * scale);
        this.deviceTable.setPreferredScrollableViewportSize(d);
        JLabel label = new JLabel("Default Fixed Data:", 4);
        this.add((Component)label, "1, 3");
        this.rawHexData = new JTextField();
        this.rawHexData.getDocument().addDocumentListener(this);
        this.rawHexData.setText(protocol.getFixedData(new Value[protocol.getFixedDataLength()]).toString());
        new TextPopupMenu(this.rawHexData);
        this.add((Component)this.rawHexData, "3, 3");
        this.commandModel = new ParameterTableModel(protocol, ParameterTableModel.Type.COMMAND);
        this.commandTable = new JTableX(this.commandModel);
        this.commandTable.setDefaultEditor(Integer.class, editor);
        new TextPopupMenu((JTextField)((DefaultCellEditor)this.commandTable.getDefaultEditor(String.class)).getComponent());
        scrollPane = new JScrollPane(this.commandTable);
        tablePanel = new JPanel(new BorderLayout());
        tablePanel.setBorder(BorderFactory.createTitledBorder("Command Parameters"));
        tablePanel.add((Component)scrollPane, "Center");
        this.add((Component)tablePanel, "1, 5, 3, 5");
        d = this.commandTable.getPreferredScrollableViewportSize();
        d.height = this.commandTable.getRowHeight() * 4;
        d.width = (int)((double)d.width * scale);
        this.commandTable.setPreferredScrollableViewportSize(d);
        label = new JLabel("Command Index:", 4);
        this.add((Component)label, "1, 7");
        this.cmdIndex = new JSpinner(new SpinnerNumberModel(protocol.getCmdIndex(), 0, protocol.getDefaultCmdLength() - 1, 1));
        this.cmdIndex.addChangeListener(this);
        this.add((Component)this.cmdIndex, "3, 7");
        String note = "If editing a Manual Protocol in RM, the Data Translators are read-only and set automatically to match the parameter tables.\n\nIf editing a protocol in RMPB, the Data Translators panel is editable. The parameter tables and Create Translators button are there to provide an easy means to create simple translators.";
        ProtocolDataPanel.DisplayArea noteArea = new ProtocolDataPanel.DisplayArea(note, null);
        noteArea.setColumns(40);
        JPanel notePanel = new JPanel(new FlowLayout(0));
        notePanel.add(noteArea);
        this.add((Component)notePanel, "1, 9, 3, 9");
    }

    public void setOwner(Object owner) {
        this.owner = owner;
        if (!(owner instanceof ManualSettingsDialog)) {
            return;
        }
        this.settingsDialog = (ManualSettingsDialog)owner;
    }

    public void setProtocol(ManualProtocol protocol) {
        this.protocol = protocol;
        this.deviceModel = new ParameterTableModel(protocol, ParameterTableModel.Type.DEVICE);
        this.deviceTable.setModel(this.deviceModel);
        this.commandModel = new ParameterTableModel(protocol, ParameterTableModel.Type.COMMAND);
        this.commandTable.setModel(this.commandModel);
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(protocol.getCmdIndex(), 0, protocol.getDefaultCmdLength() - 1, 1);
        this.cmdIndex.setModel(spinnerModel);
        this.rawHexData.setText(protocol.getFixedData(new Value[protocol.getFixedDataLength()]).toString());
        if (this.settingsDialog != null) {
            this.deviceModel.setManualSettingsPanel(this.settingsDialog.getManualSettingsPanel());
            this.commandModel.setManualSettingsPanel(this.settingsDialog.getManualSettingsPanel());
        }
    }

    public void updateFixedData() {
        this.protocol.setRawHex(new Hex(this.rawHexData.getText()));
    }

    public void setForCustomCode() {
        this.deviceTable.setEnabled(false);
        this.deviceTable.setForeground(Color.GRAY);
        this.commandTable.setEnabled(false);
        this.commandTable.setForeground(Color.GRAY);
        this.rawHexData.setEnabled(false);
        this.cmdIndex.setEnabled(false);
        this.enableButtons();
    }

    public void update(String procName, Hex hex) {
        ManualSettingsPanel msp;
        ManualSettingsPanel manualSettingsPanel = msp = this.settingsDialog != null ? this.settingsDialog.getManualSettingsPanel() : null;
        if (msp != null && msp.isLoadInProgress()) {
            return;
        }
        int oldFixedDataLength = this.protocol.getDeviceTranslators().length;
        int oldCmdLength = this.protocol.getCmdTranslators().length;
        int fixedDataLength = Protocol.getFixedDataLengthFromCode(procName, hex);
        int cmdLength = Protocol.getCmdLengthFromCode(procName, hex);
        if (msp != null && !msp.isLoadInProgress() && fixedDataLength == oldFixedDataLength && cmdLength == oldCmdLength) {
            return;
        }
        if (this.settingsDialog != null && this.settingsDialog.getModeIndex() >= 0 && this.settingsDialog.getModeIndex() <= 1 && msp != null) {
            String title = "Code update";
            String message = "The device and command translators have been reset to default\ndue to a change in the number of parameters.";
            JOptionPane.showMessageDialog(null, message, title, 1);
        }
        this.rawHexData.setText(Hex.toString(new short[fixedDataLength]));
        ArrayList<Value> devParms = new ArrayList<Value>();
        Value zero = new Value(0);
        for (int i = 0; i < fixedDataLength; ++i) {
            devParms.add(zero);
        }
        SpinnerNumberModel spinnerModel = (SpinnerNumberModel)this.cmdIndex.getModel();
        spinnerModel.setMaximum(Integer.valueOf(cmdLength - 1));
        this.protocol.createDefaultParmsAndTranslators(cmdLength << 4, false, false, 8, devParms, new short[0], 8);
        this.deviceModel.fireTableDataChanged();
        this.commandModel.fireTableDataChanged();
        if (this.settingsDialog != null) {
            this.deviceModel.setProtocolText(this.settingsDialog.getModeIndex());
            this.commandModel.setProtocolText(this.settingsDialog.getModeIndex());
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.protocol.setCmdIndex((Integer)this.cmdIndex.getValue())) {
            this.commandModel.fireTableDataChanged();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    public void documentChanged(DocumentEvent e) {
        Document doc = e.getDocument();
        if (doc == this.rawHexData.getDocument()) {
            this.protocol.setRawHex(new Hex(this.rawHexData.getText()));
            this.enableButtons();
            ManualSettingsPanel msp = null;
            if (this.owner instanceof ManualSettingsDialog) {
                msp = ((ManualSettingsDialog)this.owner).getManualSettingsPanel();
                msp.setChanged(true);
            } else if (this.owner instanceof RMProtocolBuilder) {
                msp = ((RMProtocolBuilder)this.owner).getManualSettingsPanel();
                msp.setChanged(true);
            }
        }
    }

    public void enableButtons() {
        if (this.settingsDialog == null) {
            return;
        }
        ManualSettingsPanel p = this.settingsDialog.getManualSettingsPanel();
        JFormattedTextField pid = p.getPid();
        if (this.deviceTable.isEnabled()) {
            Hex id = (Hex)pid.getValue();
            boolean flag = id != null && id.length() != 0 && this.protocol.hasAnyCode();
            this.settingsDialog.ok.setEnabled(flag);
        } else {
            this.settingsDialog.ok.setEnabled(true);
        }
    }

    public ManualSettingsDialog getSettingsDialog() {
        return this.settingsDialog;
    }

    public void stopEditing() {
        if (this.commandTable.getCellEditor() != null) {
            this.commandTable.getCellEditor().stopCellEditing();
        }
        if (this.deviceTable.getCellEditor() != null) {
            this.deviceTable.getCellEditor().stopCellEditing();
        }
    }
}

