/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.ManualCodePanel;
import com.hifiremote.jp1.ManualDevicePanel;
import com.hifiremote.jp1.ManualProtocol;
import com.hifiremote.jp1.ManualSettingsPanel;
import com.hifiremote.jp1.Processor;
import com.hifiremote.jp1.ProtocolDataPanel;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.ScrollablePanel;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ManualEditorPanel
extends JPanel
implements ActionListener,
ChangeListener,
DocumentListener {
    private ManualSettingsPanel manualSettingsPanel = null;
    private JSplitPane outerPane = null;
    private JTabbedPane tabbedPane = null;
    private ManualDevicePanel devicePanel = null;
    private JButton translationButton = null;
    private JComboBox<Processor> procBox = new JComboBox();
    private Component owner = null;
    private boolean inJP2mode = false;

    public ManualEditorPanel(Component owner) {
        double b = 10.0;
        double i = 5.0;
        double f = -1.0;
        double p = -2.0;
        double[][] size = new double[][]{{b, p, b, f, b, p, b, 100.0, b}, {b, p, i, p, b}};
        this.owner = owner;
        this.setLayout(new BorderLayout());
        this.manualSettingsPanel = new ManualSettingsPanel();
        this.tabbedPane = new JTabbedPane();
        this.add((Component)this.tabbedPane, "Center");
        ManualCodePanel tablePanel = this.manualSettingsPanel.getTablePanel();
        this.tabbedPane.addTab("Assembler", this.manualSettingsPanel);
        this.tabbedPane.addTab("Hex Code", tablePanel);
        this.tabbedPane.addTab("Disassembler", null);
        this.tabbedPane.addChangeListener(this);
        this.devicePanel = this.manualSettingsPanel.getDevicePanel();
        this.devicePanel.setOwner(owner);
        JTextArea deviceText = this.manualSettingsPanel.getDeviceText();
        ScrollablePanel iniBodyPanel = new ScrollablePanel(new BorderLayout());
        iniBodyPanel.setScrollableWidth(ScrollablePanel.ScrollableSizeHint.FIT);
        iniBodyPanel.add((Component)deviceText, "Center");
        JScrollPane scrollPane = new JScrollPane(iniBodyPanel);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder("Data translators:")));
        this.outerPane = new JSplitPane(1, this.devicePanel, scrollPane);
        this.outerPane.setResizeWeight(0.5);
        this.tabbedPane.addTab("Device Data", this.outerPane);
        this.procBox = this.manualSettingsPanel.getProcBox();
        this.procBox.addActionListener(this);
        TableLayout tl = new TableLayout(size);
        JPanel identPanel = new JPanel(tl);
        identPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.manualSettingsPanel.getProtocolName().setColumns(50);
        this.manualSettingsPanel.getProtocolName().getDocument().addDocumentListener(this);
        this.manualSettingsPanel.getVariantName().getDocument().addDocumentListener(this);
        this.manualSettingsPanel.getPid().getDocument().addDocumentListener(this);
        JLabel label = new JLabel("Name:", 4);
        identPanel.add((Component)label, "1, 1");
        identPanel.add((Component)this.manualSettingsPanel.getProtocolName(), "3, 1");
        label = new JLabel("VariantName:", 4);
        identPanel.add((Component)label, "1, 3");
        identPanel.add((Component)this.manualSettingsPanel.getVariantName(), "3, 3");
        label = new JLabel("Protocol ID:", 4);
        identPanel.add((Component)label, "5, 1");
        identPanel.add((Component)this.manualSettingsPanel.getPid(), "7, 1");
        label = new JLabel("Processor:", 4);
        identPanel.add((Component)label, "5, 3");
        identPanel.add(this.procBox, "7, 3");
        this.add((Component)identPanel, "First");
        this.translationButton = new JButton("Create translators");
        this.translationButton.setToolTipText("Set Data translators panel to represent the above parameters");
        this.translationButton.addActionListener(this);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(this.translationButton);
        this.devicePanel.add((Component)buttonPanel, "1, 11, 3, 11");
    }

    public void setRemote(Remote remote) {
        this.manualSettingsPanel.getAssemblerModel().setRemote(remote);
    }

    public JButton getTranslationButton() {
        return this.translationButton;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        JTextArea deviceText = this.manualSettingsPanel.getDeviceText();
        if (source == this.translationButton) {
            String title;
            String message;
            this.devicePanel.stopEditing();
            if (!deviceText.getText().trim().isEmpty() && JOptionPane.showConfirmDialog(this, message = "<html>This will overwrite the text that is now in the Data translators panel.<br>Do you wish to proceed?</html>", title = "Data translation", 0, 2) != 0) {
                return;
            }
            deviceText.setText(this.manualSettingsPanel.getProtocolText(true, true));
        } else if (source == this.procBox) {
            this.resetTabbedPanes();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int indexAsm = this.tabbedPane.indexOfTab("Assembler");
        int indexDisasm = this.tabbedPane.indexOfTab("Disassembler");
        int indexOutput = this.tabbedPane.indexOfTab("Output Data");
        int indexAnalyzer = this.tabbedPane.indexOfTab("Analyzer");
        int index = this.tabbedPane.getSelectedIndex();
        if (index < 0) {
            return;
        }
        if (index == indexAsm && indexDisasm >= 0) {
            this.tabbedPane.setComponentAt(indexDisasm, null);
            this.tabbedPane.setComponentAt(indexAsm, this.manualSettingsPanel);
            this.manualSettingsPanel.setMode(ProtocolDataPanel.Mode.ASM);
            this.manualSettingsPanel.getAssemblerPanel().optionsPanel.setVisible(false);
            this.manualSettingsPanel.setVisibility();
        } else if (index == indexDisasm && indexAsm >= 0) {
            this.tabbedPane.setComponentAt(indexAsm, null);
            this.tabbedPane.setComponentAt(indexDisasm, this.manualSettingsPanel);
            this.manualSettingsPanel.setMode(ProtocolDataPanel.Mode.DISASM);
            this.manualSettingsPanel.getAssemblerPanel().optionsPanel.setVisible(true);
            this.manualSettingsPanel.setVisibility();
        } else if (index == indexOutput) {
            this.manualSettingsPanel.getOutputPanel().updatePBOutput();
        } else if (index == indexAnalyzer) {
            Processor proc = (Processor)this.procBox.getSelectedItem();
            if (proc.getDataStyle() >= 0) {
                return;
            }
            ManualProtocol prot = this.manualSettingsPanel.getProtocol();
            if (proc != null && prot != null) {
                this.manualSettingsPanel.getAnalyzerPanel().set(proc, prot.getCode(proc));
            }
        }
    }

    private int getTabIndex(Component c) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            if (!this.tabbedPane.getComponentAt(i).equals(c)) continue;
            return i;
        }
        return -1;
    }

    private int checkTabbedPane(String name, Component c, boolean test, int index) {
        return this.checkTabbedPane(name, c, test, index, null, true);
    }

    private int checkTabbedPane(String name, Component c, boolean test, int index, String tooltip, boolean enabled) {
        int tabIndex = this.tabbedPane.indexOfTab(name);
        if (test) {
            if (tabIndex < 0) {
                this.tabbedPane.insertTab(name, null, c, tooltip, index);
                this.tabbedPane.setEnabledAt(index, enabled);
            }
            ++index;
        } else if (tabIndex >= 0) {
            this.tabbedPane.remove(index);
        }
        return index;
    }

    private void resetTabbedPanes() {
        boolean jp2;
        Processor p = (Processor)this.procBox.getSelectedItem();
        boolean bl = jp2 = p.getDataStyle() < 0;
        if (this.inJP2mode == jp2) {
            return;
        }
        this.inJP2mode = jp2;
        int index = this.checkTabbedPane("Assembler", this.manualSettingsPanel, !jp2, 0);
        index = this.checkTabbedPane("Hex Code", this.manualSettingsPanel.getTablePanel(), true, index);
        index = this.checkTabbedPane("Disassembler", null, !jp2, index);
        index = this.checkTabbedPane("Analyzer", this.manualSettingsPanel.getAnalyzerPanel(), jp2, index);
        index = this.checkTabbedPane("PF Description", this.manualSettingsPanel.getPfDescriptionPanel(), jp2, index);
        index = this.checkTabbedPane("Device Data", this.outerPane, true, index);
        this.tabbedPane.setSelectedIndex(0);
    }

    public void documentChanged(DocumentEvent e) {
        int indexOutput = this.tabbedPane.indexOfTab("Output Data");
        int index = this.tabbedPane.getSelectedIndex();
        if (index < 0) {
            return;
        }
        if (index == indexOutput) {
            this.manualSettingsPanel.getOutputPanel().updatePBOutput();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public ManualDevicePanel getDevicePanel() {
        return this.devicePanel;
    }

    public ManualSettingsPanel getManualSettingsPanel() {
        return this.manualSettingsPanel;
    }
}

