/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.CmdParameter;
import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.DirectDefaultValue;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.IniSection;
import com.hifiremote.jp1.NumberCmdParm;
import com.hifiremote.jp1.NumberDeviceParm;
import com.hifiremote.jp1.Processor;
import com.hifiremote.jp1.PropertyReader;
import com.hifiremote.jp1.PropertyWriter;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.ProtocolManager;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.Value;
import com.hifiremote.jp1.translate.Translate;
import com.hifiremote.jp1.translate.Translator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class ManualProtocol
extends Protocol {
    public static final int ONE_BYTE = 0;
    public static final int BEFORE_CMD = 1;
    public static final int AFTER_CMD = 2;

    public ManualProtocol(Hex id, Properties props) {
        super(null, id, props);
        if (props != null) {
            this.notes = props.getProperty("Protocol.notes");
        }
    }

    public ManualProtocol(Properties props) {
        this(null, props);
        this.name = props.getProperty("Name");
        this.id = new Hex(props.getProperty("PID"));
    }

    public ManualProtocol(ManualProtocol p) {
        super(p.getName(), p.id, null);
        if (p.defaultFixedData != null) {
            this.defaultFixedData = p.defaultFixedData;
        }
    }

    public ManualProtocol(String name, Hex id, int cmdType, String signalStyle, int devBits, List<Value> parms, short[] rawHex, int cmdBits) {
        super(name, id, new Properties());
        System.err.println("ManualProtocol constructor:");
        System.err.println("  name=" + name);
        System.err.println("  id=" + id);
        System.err.println("  cmdType=" + cmdType);
        System.err.println("  signalStyle=" + signalStyle);
        System.err.println("  devBits=" + devBits);
        System.err.println("  parms.size()=" + parms.size());
        System.err.println("  rawHex=" + Hex.toString(rawHex));
        System.err.println("  cmdBits=" + cmdBits);
        boolean lsb = false;
        boolean comp = false;
        if (signalStyle.startsWith("LSB")) {
            lsb = true;
        }
        if (signalStyle.endsWith("COMP")) {
            comp = true;
        }
        this.createDefaultParmsAndTranslators(cmdType, lsb, comp, devBits, parms, rawHex, cmdBits);
    }

    public boolean equivalentForRemoteTo(ManualProtocol mp, Remote remote) {
        Translate t2;
        Translate t1;
        int i;
        if (this.getCode(remote) == null || !this.getCode(remote).equals(mp.getCode(remote)) || this.deviceTranslators.length != mp.getDeviceTranslators().length || this.cmdTranslators.length != mp.cmdTranslators.length) {
            return false;
        }
        for (i = 0; i < this.deviceTranslators.length; ++i) {
            t1 = this.deviceTranslators[i];
            if (t1 != null && t1 instanceof Translator && (t2 = mp.deviceTranslators[i]) != null && t2 instanceof Translator && ((Translator)t1).equals((Translator)t2)) continue;
            return false;
        }
        for (i = 0; i < this.cmdTranslators.length; ++i) {
            t1 = this.cmdTranslators[i];
            if (t1 != null && t1 instanceof Translator && (t2 = mp.cmdTranslators[i]) != null && t2 instanceof Translator && ((Translator)t1).equals((Translator)t2)) continue;
            return false;
        }
        return true;
    }

    public void createDefaultParmsAndTranslators(int cmdType, boolean lsb, boolean comp, int devBits, List<Value> parms, short[] rawHex, int cmdBits) {
        int i;
        DirectDefaultValue defaultValue = new DirectDefaultValue(new Integer(0));
        this.devParms = new DeviceParameter[parms.size()];
        this.deviceTranslators = new Translator[parms.size()];
        int offset = parms.size();
        short[] fixedBytes = new short[offset + rawHex.length];
        for (i = 0; i < parms.size(); ++i) {
            this.devParms[i] = new NumberDeviceParm("Device " + (i + 1), defaultValue, 10, devBits);
            System.err.println("Setting devParms[ " + i + " ]=" + parms.get(i));
            this.devParms[i].setValue(parms.get(i));
            fixedBytes[i] = ((Integer)parms.get(i).getUserValue()).shortValue();
            this.deviceTranslators[i] = new Translator(lsb, comp, i, devBits, i * 8);
        }
        for (i = 0; i < rawHex.length; ++i) {
            fixedBytes[i + offset] = rawHex[i];
        }
        this.defaultFixedData = new Hex(fixedBytes);
        short[] mask = new short[this.defaultFixedData.length()];
        for (int i2 = 0; i2 < mask.length; ++i2) {
            mask[i2] = 255;
        }
        this.fixedDataMask = new Hex(mask);
        int cmdLength = cmdType >> 4;
        switch (cmdType) {
            case 0: {
                this.cmdIndex = 0;
                cmdLength = 1;
                break;
            }
            case 1: {
                this.cmdIndex = 1;
                cmdLength = 2;
                break;
            }
            case 2: {
                this.cmdIndex = 0;
                cmdLength = 2;
                break;
            }
            default: {
                this.cmdIndex = 0;
            }
        }
        this.defaultCmd = new Hex(new short[cmdLength]);
        this.cmdParms = new CmdParameter[cmdLength];
        this.cmdTranslators = new Translator[cmdLength];
        this.importCmdTranslators = new Translator[cmdLength - 1];
        for (int i3 = 0; i3 < cmdLength; ++i3) {
            if (i3 == this.cmdIndex) {
                System.err.println("Creating OBC parm & translator for index " + i3 + " at bit " + i3 * 8);
                this.cmdParms[i3] = new NumberCmdParm("OBC", null, cmdBits);
                this.cmdTranslators[i3] = new Translator(lsb, comp, this.cmdIndex, cmdBits, this.cmdIndex * 8);
                continue;
            }
            System.err.println("Creating Byte " + (i3 + 1) + " parm & translators for index " + i3 + " at bit " + i3 * 8);
            this.cmdParms[i3] = new NumberCmdParm("Byte " + (i3 + 1), defaultValue, cmdBits);
            this.cmdTranslators[i3] = new Translator(lsb, comp, i3, 8, i3 * 8);
            int j = i3 < this.cmdIndex ? i3 : i3 - 1;
            this.importCmdTranslators[j] = new Translator(false, false, j, 8, i3 * 8);
        }
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.id != null) {
            return ManualProtocol.getDefaultName(this.id);
        }
        return "Manual Settings";
    }

    public void setDeviceParms(List<DeviceParameter> v) {
        this.devParms = new DeviceParameter[v.size()];
        v.toArray(this.devParms);
    }

    public void setDeviceTranslators(List<Translate> v) {
        this.deviceTranslators = new Translator[v.size()];
        v.toArray(this.deviceTranslators);
    }

    public void setCommandParms(List<CmdParameter> v) {
        this.cmdParms = new CmdParameter[v.size()];
        v.toArray(this.cmdParms);
    }

    public void setCommandTranslators(List<Translate> v) {
        this.cmdTranslators = new Translator[v.size()];
        v.toArray(this.cmdTranslators);
    }

    @Override
    public void importCommand(Hex hex, String text, boolean useOBC, int obcIndex, boolean useEFC) {
        if (text.indexOf(32) != -1 || text.indexOf(104) != -1) {
            Hex newHex = new Hex(text);
            if (newHex.length() > hex.length()) {
                this.setDefaultCmd(newHex);
            }
            hex = newHex;
        } else {
            super.importCommand(hex, text, useOBC, obcIndex, useEFC);
        }
    }

    @Override
    public void importCommandParms(Hex hex, String text) {
        if (this.cmdParms.length == 1) {
            return;
        }
        StringTokenizer st = new StringTokenizer(text);
        Value[] values = new Value[st.countTokens()];
        int index = 0;
        while (st.hasMoreTokens()) {
            values[index++] = new Value(Integer.valueOf(st.nextToken(), 16));
        }
        for (index = 0; index < values.length; ++index) {
            for (int i = 0; i < this.importCmdTranslators.length; ++i) {
                this.importCmdTranslators[i].in(values, hex, this.devParms, index);
            }
        }
    }

    public void store(PropertyWriter out) {
        int i;
        StringBuilder buff;
        if (this.devParms.length > 0) {
            buff = new StringBuilder();
            for (i = 0; i < this.devParms.length; ++i) {
                if (i > 0) {
                    buff.append(',');
                }
                DeviceParameter devParm = this.devParms[i];
                buff.append(devParm.toString());
            }
            out.print("DevParms", buff.toString());
        }
        if (this.deviceTranslators != null && this.deviceTranslators.length > 0) {
            buff = new StringBuilder();
            for (i = 0; i < this.deviceTranslators.length; ++i) {
                if (i > 0) {
                    buff.append(' ');
                }
                buff.append(this.deviceTranslators[i].toString());
            }
            out.print("DeviceTranslator", buff.toString());
        }
        if (this.cmdParms.length > 0) {
            buff = new StringBuilder();
            for (i = 0; i < this.cmdParms.length; ++i) {
                if (i > 0) {
                    buff.append(',');
                }
                buff.append(this.cmdParms[i]);
            }
            out.print("CmdParms", buff.toString());
        }
        if (this.cmdTranslators.length > 0) {
            buff = new StringBuilder();
            for (i = 0; i < this.cmdTranslators.length; ++i) {
                if (i > 0) {
                    buff.append(' ');
                }
                buff.append(this.cmdTranslators[i]);
            }
            out.print("CmdTranslator", buff.toString());
        }
        out.print("DefaultCmd", this.defaultCmd.toString());
        out.print("CmdIndex", Integer.toString(this.cmdIndex));
        out.print("FixedData", this.defaultFixedData.toString());
        for (Object key : this.code.keySet()) {
            out.print("Code." + key, ((Hex)this.code.get(key)).toRawString());
        }
        if (this.notes != null) {
            out.print("Protocol.notes", this.notes);
        }
    }

    @Override
    public void store(PropertyWriter out, Value[] vals, Remote remote) throws IOException {
        System.err.println("ManualProtocol.store");
        super.store(out, vals, remote);
        this.store(out);
    }

    public void setDefaultCmd(Hex cmd) {
        this.defaultCmd = cmd;
    }

    public void setRawHex(Hex rawHex) {
        this.defaultFixedData = rawHex;
    }

    public void setCode(Hex pCode, Processor p) {
        if (pCode == null || pCode.length() == 0) {
            this.code.remove(p.getEquivalentName());
        } else {
            this.code.put(p.getEquivalentName(), pCode);
        }
    }

    @Override
    public boolean needsCode(Remote r) {
        return true;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setID(Hex newID) {
        this.id = newID;
    }

    @Override
    public Hex importUpgradeCode(String notes) {
        Hex importedCode = super.importUpgradeCode(notes);
        if (importedCode == null) {
            return null;
        }
        int importedCmdLength = this.getCmdLengthFromCode();
        System.err.println("importedCmdLength=" + importedCmdLength + ", but defaultCmd.length()=" + this.defaultCmd.length());
        if (importedCmdLength != this.defaultCmd.length()) {
            boolean lsb = ((Translator)this.cmdTranslators[this.cmdIndex]).getLSB();
            boolean comp = ((Translator)this.cmdTranslators[this.cmdIndex]).getComp();
            this.defaultCmd = new Hex(new short[importedCmdLength]);
            if (this.cmdIndex != 0) {
                this.cmdIndex = importedCmdLength - 1;
            }
            this.cmdParms = new CmdParameter[importedCmdLength];
            this.cmdTranslators = new Translate[importedCmdLength];
            this.importCmdTranslators = new Translate[importedCmdLength - 1];
            DirectDefaultValue zero = new DirectDefaultValue(0);
            for (int i = 0; i < importedCmdLength; ++i) {
                if (i == this.cmdIndex) {
                    this.cmdParms[i] = new NumberCmdParm("OBC", zero, 8, 10);
                    this.cmdTranslators[i] = new Translator(lsb, comp, i, 8, i * 8);
                } else {
                    this.cmdParms[i] = new NumberCmdParm("Byte " + (i + 1), zero, 8, 16);
                    this.cmdTranslators[i] = new Translator(false, false, i, 8, i * 8);
                }
                if (this.cmdIndex == 0) {
                    if (i <= 0) continue;
                    System.err.printf("Creating importCmdTranslator for index %d to bit %d\n", i - 1, i * 8);
                    this.importCmdTranslators[i - 1] = new Translator(false, false, i - 1, 8, i * 8);
                    continue;
                }
                if (i >= importedCmdLength - 1) continue;
                System.err.printf("Creating importCmdTranslator for index %d to bit %d\n", i, i * 8);
                this.importCmdTranslators[i] = new Translator(false, false, i, 8, i * 8);
            }
        }
        return importedCode;
    }

    public String getIniString(boolean addName, boolean newName) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String name = newName ? ManualProtocol.getDefaultName(this.id) : this.getName();
        try {
            pw.println("[" + name + "]");
            if (addName) {
                pw.println("Name=" + name);
            }
            pw.println("PID=" + this.getID());
            this.store(new PropertyWriter(pw));
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        return sw.toString();
    }

    public PropertyReader getIniReader(boolean addName, boolean newName) {
        StringReader sr = new StringReader(this.getIniString(addName, newName));
        BufferedReader in = new BufferedReader(sr);
        return new PropertyReader(in);
    }

    public IniSection getIniSection() {
        return this.getIniReader(true, false).nextSection();
    }

    public int getNameIndex() {
        if (this.name == null || this.name.equals("Manual Settings") || !this.name.startsWith("Manual Settings")) {
            return 0;
        }
        int begin = this.name.indexOf("(") + 1;
        int end = this.name.indexOf(")");
        if (begin == 0 || end == begin) {
            return 1;
        }
        try {
            int nameIndex = Integer.parseInt(this.name.substring(begin, end));
            return nameIndex;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static String getDefaultName(Hex pid) {
        String name = "Manual Settings: " + pid;
        int index = ProtocolManager.getManualSettingsIndex(pid);
        if (index > 0) {
            name = name + " (" + (index + 1) + ")";
        }
        return name;
    }
}

