/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.ManualCodePanel;
import com.hifiremote.jp1.ManualEditorPanel;
import com.hifiremote.jp1.ManualProtocol;
import com.hifiremote.jp1.ManualSettingsPanel;
import com.hifiremote.jp1.Processor;
import com.hifiremote.jp1.ProcessorManager;
import com.hifiremote.jp1.ProtocolDataPanel;
import com.hifiremote.jp1.RMProtocolBuilder;
import com.hifiremote.jp1.Remote;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ManualSettingsDialog
extends JDialog
implements ActionListener {
    private ManualProtocol protocol = null;
    private int userAction = 2;
    private ManualSettingsPanel manualSettingsPanel = null;
    private ManualEditorPanel editorPanel = null;
    public JButton ok = null;
    public JButton cancel = null;
    private int modeIndex = -1;
    private JButton load = null;
    private JButton save = null;
    private JButton paste = null;

    public ManualSettingsDialog(JDialog owner, ManualProtocol protocol) {
        super(owner, "Protocol Editor", true);
        this.createGui(owner, protocol);
    }

    public ManualSettingsDialog(JFrame owner, ManualProtocol protocol) {
        super(owner, "Protocol Editor", true);
        this.createGui(owner, protocol);
    }

    private void createGui(Component owner, ManualProtocol protocol) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                ManualSettingsDialog.this.resetProcBox();
                ManualSettingsDialog.this.dispose();
            }
        });
        this.setLocationRelativeTo(null);
        Container contentPane = this.getContentPane();
        this.protocol = protocol;
        System.err.println("protocol=" + protocol);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        this.load = new JButton("Load");
        this.load.setToolTipText("Opens dialog to select a previously saved .rmpb file for loading.");
        this.load.addActionListener(this);
        buttonPanel.add(this.load);
        this.save = new JButton("Save");
        this.save.setToolTipText("Opens dialog to save assembler listing as a .rmpb file.");
        this.save.setEnabled(false);
        this.save.addActionListener(this);
        buttonPanel.add(this.save);
        buttonPanel.add(Box.createHorizontalGlue());
        this.paste = new JButton("Paste");
        this.paste.setToolTipText("Opens text box for pasting from clipboard a PB/KM/RM-style protocol entry");
        this.paste.addActionListener(this);
        buttonPanel.add(this.paste);
        buttonPanel.add(Box.createHorizontalStrut(10));
        this.ok = new JButton("OK");
        this.ok.addActionListener(this);
        this.ok.setEnabled(false);
        buttonPanel.add(this.ok);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        buttonPanel.add(this.cancel);
        contentPane.add((Component)buttonPanel, "Last");
        this.editorPanel = new ManualEditorPanel(this);
        this.manualSettingsPanel = this.editorPanel.getManualSettingsPanel();
        this.manualSettingsPanel.reset(false);
        this.manualSettingsPanel.getDeviceText().setEditable(false);
        this.manualSettingsPanel.setProtocol(protocol, false);
        this.manualSettingsPanel.getProcBox().setSelectedIndex(0);
        this.manualSettingsPanel.setMode(ProtocolDataPanel.Mode.ASM);
        this.manualSettingsPanel.getAssemblerPanel().setDialogSaveButton(this.save);
        contentPane.add((Component)this.editorPanel, "Center");
        this.pack();
        Rectangle rect = this.getBounds();
        int x = rect.x - rect.width / 2;
        int y = rect.y - rect.height / 2;
        this.setLocation(x, y);
    }

    public void setRemote(Remote remote) {
        this.editorPanel.setRemote(remote);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block14: {
            Object source;
            block17: {
                boolean validFile;
                File file;
                block19: {
                    String[] fileStrings;
                    block18: {
                        block16: {
                            block15: {
                                block13: {
                                    source = e.getSource();
                                    if (source != this.ok) break block13;
                                    this.userAction = 0;
                                    this.manualSettingsPanel.getDevicePanel().updateFixedData();
                                    this.protocol = this.manualSettingsPanel.getProtocol();
                                    this.resetProcBox();
                                    this.setVisible(false);
                                    this.dispose();
                                    break block14;
                                }
                                if (source != this.cancel) break block15;
                                this.userAction = 2;
                                this.resetProcBox();
                                this.setVisible(false);
                                this.dispose();
                                break block14;
                            }
                            if (source != this.paste) break block16;
                            String clipboardText = this.manualSettingsPanel.readClipboard();
                            if (clipboardText == null) {
                                return;
                            }
                            ManualCodePanel codePanel = this.manualSettingsPanel.getTablePanel();
                            String[] identStrings = codePanel.importProtocolCode(clipboardText, true);
                            boolean validImport = true;
                            if (this.modeIndex > 0) {
                                String pidStr = this.manualSettingsPanel.getPid().getText();
                                if (pidStr == null) {
                                    pidStr = "";
                                }
                                if (!pidStr.equals(identStrings[2])) {
                                    validImport = false;
                                }
                            }
                            if (validImport) {
                                codePanel.importProtocolCode(clipboardText, false);
                                this.manualSettingsPanel.pid.setValue(new Hex(identStrings[2]));
                                Processor p = ProcessorManager.getProcessor(identStrings[3]);
                                this.manualSettingsPanel.getProcBox().setSelectedItem(p);
                                this.manualSettingsPanel.getDeviceText().setText(this.manualSettingsPanel.getProtocolText(true, true));
                            } else {
                                String title = "Invalid import";
                                String message = "You can only import code from a protocol with the same\nPID as that of the protocol being edited.";
                                JOptionPane.showMessageDialog(this, message, title, 0);
                            }
                            break block14;
                        }
                        if (source != this.load) break block17;
                        file = RMProtocolBuilder.getProtocolFile(this, true);
                        if (file == null || !file.exists()) {
                            return;
                        }
                        validFile = true;
                        fileStrings = this.manualSettingsPanel.loadRMPB(file, true, this.modeIndex);
                        if (this.modeIndex != 0) break block18;
                        if (fileStrings[0] != null && fileStrings[0].startsWith("Manual Settings") && (fileStrings[1] == null || fileStrings[1].isEmpty())) break block19;
                        validFile = false;
                        break block19;
                    }
                    String[] idStrings = new String[]{this.manualSettingsPanel.getProtocolName().getText(), this.manualSettingsPanel.getVariantName().getText(), this.manualSettingsPanel.getPid().getText()};
                    for (int i = 0; i < 3; ++i) {
                        if (fileStrings[i] == null) {
                            fileStrings[i] = "";
                        }
                        if (idStrings[i] == null) {
                            idStrings[i] = "";
                        }
                        if (fileStrings[i].equals(idStrings[i])) continue;
                        validFile = false;
                        break;
                    }
                }
                if (validFile) {
                    this.reset();
                    this.manualSettingsPanel.loadRMPB(file, false, this.modeIndex);
                    this.save.setEnabled(true);
                } else {
                    String title = "Invalid file";
                    String message = this.modeIndex == 0 ? "You can only load a .rmpb file for a manual protocol." : "You can only load a .rmpb file for a protocol whose name, variant name if any,\nand PID agree with those of the protocol being edited.";
                    JOptionPane.showMessageDialog(this, message, title, 0);
                }
                break block14;
            }
            if (source == this.save) {
                this.manualSettingsPanel.saveAs();
            }
        }
    }

    public void setMessage(int n) {
        this.modeIndex = n;
        this.editorPanel.getDevicePanel().setVisible(n != 2);
        ManualCodePanel tablePanel = this.manualSettingsPanel.getTablePanel();
        ProtocolDataPanel.DisplayArea noteArea = tablePanel.getNoteArea();
        this.editorPanel.getTranslationButton().setEnabled(n < 0);
        String text = "";
        if (n == 0 || n == 1) {
            text = text + "The processor of the selected remote is ";
        } else if (n == 2) {
            text = text + "A custom protocol is a modified executor for a standard protocol. It uses the same translators as that standard protocol and keeps the same name, variant name and PID.  Only the executor for the selected remote (";
        }
        JTableX codeTable = tablePanel.getCodeTable();
        text = codeTable != null && codeTable.getSelectedRow() >= 0 ? text + ((Processor)codeTable.getValueAt(codeTable.getSelectedRow(), 0)).getName() : text + "??????";
        if (n == 0 || n == 1) {
            text = text + ".  A Manual Protocol is added to the Protocol Manager and, if used in a device upgrade, is stored in a .rmir file of that upgrade. It may have code for more than one processor, to allow the upgrade to be used with remotes with a range of processors.  It only supports simple translators. \n\nUse RMPB to create a .prot file if a custom protocol with complex translators is required.";
        } else if (n == 2) {
            text = text + ") is editable.\n\nUse RMPB to create a .prot file if a more general customization is required.";
        }
        if (n >= 1) {
            text = text + "  Code shown in gray is standard code for information only.  Code in black may be edited directly by double-cicking.";
        }
        noteArea.setText(text);
    }

    public ManualProtocol getProtocol() {
        if (this.userAction != 0) {
            return null;
        }
        return this.protocol;
    }

    public ManualSettingsPanel getManualSettingsPanel() {
        return this.manualSettingsPanel;
    }

    public int getModeIndex() {
        return this.modeIndex;
    }

    private void reset() {
        this.manualSettingsPanel.reset(false);
        this.save.setEnabled(false);
    }

    private void resetProcBox() {
        JComboBox<Processor> procBox = ManualCodePanel.getProcBox();
        ActionListener[] als = procBox.getActionListeners();
        for (ActionListener al : Arrays.copyOf(als, als.length)) {
            procBox.removeActionListener(al);
        }
    }
}

