/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.DeviceUpgradeTableModel;
import com.hifiremote.jp1.ManualProtocol;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.TableSorter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class ManualSettingsEditor
extends DefaultCellEditor
implements TableCellEditor,
ActionListener {
    private JButton button = null;
    private Protocol value = null;
    private int column = 0;
    private Remote remote = null;
    protected static final String EDIT = "edit";

    public ManualSettingsEditor(Remote remote, int column) {
        super(new JTextField());
        this.setClickCountToStart(2);
        this.remote = remote;
        this.column = column;
        this.button = new JButton();
        this.button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.button.setHorizontalAlignment(10);
        this.button.setActionCommand(EDIT);
        this.button.addActionListener(this);
        this.button.setBorderPainted(false);
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.value = (Protocol)value;
        switch (this.column) {
            case 5: {
                TableSorter ts = (TableSorter)table.getModel();
                DeviceUpgradeTableModel model = (DeviceUpgradeTableModel)ts.getTableModel();
                row = ts.modelIndex(row);
                this.button.setText(((DeviceUpgrade)model.getRow(row)).getStarredID());
                break;
            }
            case 6: {
                this.button.setText(this.value.getVariantDisplayName(this.remote.getProcessor()));
                break;
            }
            case 7: {
                this.button.setText(this.value.toString());
            }
        }
        return this.button;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (EDIT.equals(e.getActionCommand())) {
            Protocol result = this.value.editProtocol(this.remote, this.button);
            if (result != null && this.value.getClass() != ManualProtocol.class) {
                this.fireEditingStopped();
            } else if (result != null) {
                this.value = result;
                this.fireEditingStopped();
            } else {
                this.fireEditingCanceled();
            }
        }
    }
}

