/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.AssemblerItem;
import com.hifiremote.jp1.AssemblerPanel;
import com.hifiremote.jp1.AssemblerTableModel;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.EndingFileFilter;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.HexFormat;
import com.hifiremote.jp1.JP1Frame;
import com.hifiremote.jp1.JP2AnalyzerPanel;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.LineTokenizer;
import com.hifiremote.jp1.ManualCodePanel;
import com.hifiremote.jp1.ManualDevicePanel;
import com.hifiremote.jp1.ManualProtocol;
import com.hifiremote.jp1.ManualSettingsDialog;
import com.hifiremote.jp1.Processor;
import com.hifiremote.jp1.ProcessorManager;
import com.hifiremote.jp1.Property;
import com.hifiremote.jp1.PropertyFile;
import com.hifiremote.jp1.PropertyReader;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.ProtocolDataPanel;
import com.hifiremote.jp1.ProtocolManager;
import com.hifiremote.jp1.RMFileChooser;
import com.hifiremote.jp1.RMPBOutputPanel;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.TextPopupMenu;
import com.hifiremote.jp1.Value;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;

public class ManualSettingsPanel
extends JPanel
implements ActionListener,
PropertyChangeListener,
DocumentListener,
ChangeListener,
ListSelectionListener,
ItemListener {
    private ManualProtocol protocol = null;
    private Protocol displayProtocol = null;
    private ManualCodePanel tablePanel = null;
    private ManualDevicePanel devicePanel = null;
    private RMPBOutputPanel outputPanel = null;
    private JP2AnalyzerPanel analyzerPanel = null;
    private JP2AnalyzerPanel pfDescriptionPanel = null;
    private JPanel buttonPanel = null;
    private JTextField name = null;
    private JTextField variantName = null;
    public JFormattedTextField pid = null;
    private JButton importButton = null;
    private Processor processor = null;
    private JPanel availabilityPanel = null;
    private JLabel availabilityLabel = null;
    private File file = null;
    private ProtocolDataPanel protDataPanel = null;
    private JTabbedPane tabbedPane = null;
    private JSplitPane outerPane = null;
    private ProtocolDataPanel.PFMainPanel pfMainPanel = null;
    private JComboBox<Processor> procBox = null;
    private JTextArea deviceText = new JTextArea();
    private boolean changed = false;
    private boolean loadInProgress = true;
    private ProtocolDataPanel.PDMainPanel pdMainPanel = null;
    private ProtocolDataPanel.FunctionMainPanel fnMainPanel = null;
    private JScrollPane protDataScrollPane = null;
    private AssemblerPanel assemblerPanel = null;
    private Processor displayProcessor = null;
    private int dividerLocation = 0;
    private ProtocolDataPanel.Mode mode = ProtocolDataPanel.Mode.ASM;
    private static Processor[] procs = new Processor[0];
    private static List<AssemblerItem>[] itemLists = new List[0];
    public RemoteConfiguration remoteConfig = null;
    private AssemblerTableModel assemblerModel = new AssemblerTableModel();
    public JCheckBox useRegisterConstants = new JCheckBox("Registers");
    public JCheckBox useFunctionConstants = new JCheckBox("Functions");

    public ManualSettingsPanel() {
        this.setLayout(new BorderLayout());
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ManualSettingsPanel.this.interpretPFPD();
                ManualSettingsPanel.this.pfMainPanel.set();
                ManualSettingsPanel.this.pdMainPanel.set();
                ManualSettingsPanel.this.fnMainPanel.set();
            }
        });
        this.name = new JTextField();
        this.name.getDocument().addDocumentListener(this);
        this.variantName = new JTextField();
        this.variantName.getDocument().addDocumentListener(this);
        this.pid = new JFormattedTextField(new HexFormat(2, 2));
        new TextPopupMenu(this.pid);
        this.pid.addPropertyChangeListener("value", this);
        this.availabilityPanel = new JPanel(new FlowLayout(0));
        this.availabilityLabel = new JLabel();
        this.availabilityLabel.setFont(this.availabilityLabel.getFont().deriveFont(1));
        this.availabilityLabel.setForeground(Color.RED);
        this.availabilityPanel.add(this.availabilityLabel);
        this.add((Component)this.availabilityPanel, "First");
        this.tablePanel = new ManualCodePanel(this);
        this.assemblerPanel = new AssemblerPanel(this);
        this.assemblerModel.settingsPanel = this;
        this.outerPane = new JSplitPane(1, leftPanel, this.assemblerPanel);
        this.outerPane.setResizeWeight(0.0);
        this.add((Component)this.outerPane, "Center");
        JPanel midPanel = new JPanel(new BorderLayout());
        this.tablePanel.add((Component)midPanel, "Last");
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 2));
        midPanel.add((Component)this.buttonPanel, "Center");
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.buttonPanel.add(new JLabel("Use predefined constants for: "));
        this.buttonPanel.add(this.useRegisterConstants);
        this.buttonPanel.add(this.useFunctionConstants);
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(this.assemblerPanel.importHexButton);
        this.importButton = new JButton("Import from Clipboard");
        procs = ManualCodePanel.getProcs();
        this.procBox = ManualCodePanel.getProcBox();
        this.procBox.addActionListener(this);
        itemLists = new List[procs.length];
        for (int i = 0; i < procs.length; ++i) {
            ManualSettingsPanel.itemLists[i] = new ArrayList<AssemblerItem>();
            itemLists[i].add(new AssemblerItem());
        }
        this.devicePanel = new ManualDevicePanel();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(this);
        leftPanel.add((Component)this.tabbedPane, "Center");
        this.protDataPanel = new ProtocolDataPanel(this);
        this.protDataScrollPane = new JScrollPane(this.protDataPanel);
        this.protDataScrollPane.setPreferredSize(this.protDataPanel.getPrefSize());
        this.assemblerPanel.setProtDataPanel(this.protDataPanel);
        this.pfMainPanel = this.protDataPanel.pfMainPanel;
        this.pdMainPanel = this.protDataPanel.pdMainPanel;
        this.fnMainPanel = this.protDataPanel.fnMainPanel;
        this.tabbedPane.addTab("Protocol Data", this.protDataScrollPane);
        this.tabbedPane.add("Functions", this.fnMainPanel);
        this.useFunctionConstants.addItemListener(this);
        this.useRegisterConstants.addItemListener(this);
        this.setMode(ProtocolDataPanel.Mode.DISASM);
        this.analyzerPanel = new JP2AnalyzerPanel();
        this.pfDescriptionPanel = new JP2AnalyzerPanel();
        this.pfDescriptionPanel.setDescription();
        this.outputPanel = new RMPBOutputPanel(this);
        Dimension minimumSize = new Dimension(0, 0);
        leftPanel.setMinimumSize(minimumSize);
        this.assemblerPanel.setMinimumSize(minimumSize);
        String s = "Use Extended Lead-Out OFF time, adding 0xFFFF to value in PD0A/PD0B?";
        int baseWidth = new JLabel((String)s).getPreferredSize().width;
        this.dividerLocation = this.outerPane.getInsets().left + baseWidth;
        this.outerPane.setDividerLocation(this.dividerLocation);
        Dimension d = this.assemblerPanel.getPreferredSize();
        d.width = (int)((double)baseWidth * 1.8);
        this.assemblerPanel.setPreferredSize(d);
        this.deviceText.setLineWrap(true);
        this.deviceText.setWrapStyleWord(true);
        this.deviceText.getDocument().addDocumentListener(this);
        Rectangle rect = this.getBounds();
        int x = rect.x - rect.width / 2;
        int y = rect.y - rect.height / 2;
        this.setLocation(x, y);
        this.tabbedPane.setSelectedIndex(0);
        if (this.mode == ProtocolDataPanel.Mode.DISASM) {
            this.protDataPanel.doBoxEnableStates(ProtocolDataPanel.EnableOps.DISABLE);
        }
        this.loadInProgress = false;
    }

    public void setProtocol(ManualProtocol protocol, boolean isClone) {
        this.protocol = protocol;
        this.tablePanel.setProtocol(protocol);
        System.err.println("protocol=" + protocol);
        this.name.setText(protocol.getName());
        this.name.setEditable(isClone);
        this.name.setEnabled(isClone);
        if (protocol.getVariantName() != null) {
            this.variantName.setText(protocol.getVariantName());
        }
        this.variantName.setEditable(isClone);
        this.variantName.setEnabled(isClone);
        this.devicePanel.setProtocol(protocol);
        Hex id = protocol.getID();
        this.pid.setValue(id);
        this.tablePanel.getCodeTable().repaint();
        this.validate();
    }

    public String getProtocolText(boolean deviceOnly, boolean fromData) {
        String protText = null;
        String ls = System.getProperty("line.separator");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (fromData) {
            PropertyReader pr = this.protocol.getIniReader(false, this.pid.isEnabled() && this.pid.getText() != null && !this.pid.getText().trim().isEmpty());
            Property p = null;
            int startAt = deviceOnly ? 2 : 1;
            int line = 0;
            while ((p = pr.nextProperty()) != null) {
                if (++line <= startAt || deviceOnly && p.name.startsWith("Code.")) continue;
                pw.println(p.name + "=" + p.value);
            }
            String protBody = sw.toString();
            protText = !deviceOnly ? "[" + ManualProtocol.getDefaultName(this.protocol.getID()) + "]" + ls : "";
            protText = protText + protBody;
        } else {
            if (!deviceOnly) {
                pw.println("[" + this.protocol.getName() + "]");
                pw.println("PID=" + this.protocol.getID());
                String variantName = this.protocol.getVariantName().trim();
                if (variantName != null && !variantName.isEmpty()) {
                    pw.println("VariantName=" + variantName);
                }
                pw.print(this.displayProtocol.getIniIntro());
                pw.print(this.getIniCode());
            } else {
                pw.print(this.displayProtocol.getIniIntro());
            }
            protText = sw.toString();
        }
        pw.close();
        return protText;
    }

    public ManualProtocol getProtocol() {
        return this.protocol;
    }

    public String getIniCode() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (Processor pr : procs) {
            Hex dispHex;
            String name = pr.getEquivalentName();
            Hex hex = this.protocol.getCode(pr);
            Hex hex2 = dispHex = this.displayProtocol == null ? null : this.displayProtocol.code.get(name);
            if (hex == null) {
                hex = dispHex;
            }
            if (hex == null) continue;
            pw.println("Code." + name + "=" + hex.toRawString());
        }
        return sw.toString();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.importButton) {
            this.importFromClipboard();
        } else if (source == this.procBox) {
            Processor pr = (Processor)this.procBox.getSelectedItem();
            this.selectProcessor(pr);
            this.setVisibility();
        }
    }

    public void setVisibility() {
        boolean showProc;
        Processor pr = (Processor)this.procBox.getSelectedItem();
        boolean bl = showProc = this.mode == ProtocolDataPanel.Mode.DISASM || this.displayProcessor == null || this.displayProcessor.getEquivalentName().equals(pr.getEquivalentName());
        if (this.tabbedPane.isVisible() && !showProc) {
            this.dividerLocation = this.outerPane.getDividerLocation();
        }
        this.tabbedPane.setVisible(showProc);
        this.assemblerPanel.setVisible(showProc);
        if (showProc) {
            this.outerPane.setDividerLocation(this.dividerLocation);
        }
        this.availabilityPanel.setVisible(!showProc);
    }

    public String readClipboard() {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel message = new JLabel("Enter one or more PB-/KM-/IR-formatted protocol upgrades below.");
        message.setBorder(BorderFactory.createEmptyBorder(5, 5, 10, 5));
        panel.add((Component)message, "North");
        JTextArea textArea = new JTextArea(10, 60);
        new TextPopupMenu(textArea);
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Protocol Upgrade Code"), scrollPane.getBorder()));
        panel.add((Component)scrollPane, "Center");
        int rc = JOptionPane.showConfirmDialog(this, panel, "Import Protocol Upgrade", 2, -1, null);
        if (rc == 0) {
            return textArea.getText();
        }
        return null;
    }

    public void importFromClipboard() {
        String clipboardText = this.readClipboard();
        if (clipboardText != null) {
            String[] ident = this.tablePanel.importProtocolCode(clipboardText, false);
            this.name.setText(ident[0]);
            this.variantName.setText(ident[1]);
            this.pid.setValue(new Hex(ident[2]));
            Processor p = ProcessorManager.getProcessor(ident[3]);
            this.procBox.setSelectedItem(p);
            this.deviceText.setText(this.getProtocolText(true, true));
            this.outputPanel.updatePBOutput();
        }
    }

    public String nextSection(BufferedReader br, String line) {
        String section = null;
        try {
            while (line != null) {
                if (!(line = line.trim()).isEmpty() && line.charAt(0) == '[') {
                    section = line.substring(1, line.length() - 1);
                    break;
                }
                line = br.readLine();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        return section;
    }

    public void writeProtFile(String protText) {
        File file;
        File addOnDir = RemoteMaster.getAddonDir();
        if (!addOnDir.isDirectory()) {
            System.err.println("Add-on folder is not a directory");
            return;
        }
        PropertyFile properties = JP1Frame.getProperties();
        String lastName = properties.getProperty("ProtFile");
        ArrayList<String> protNames = new ArrayList<String>();
        for (File f : addOnDir.listFiles()) {
            String fName = f.getName();
            if (!fName.endsWith(".prot")) continue;
            protNames.add(fName.substring(0, fName.length() - 5));
        }
        Collections.sort(protNames);
        if (lastName != null && !protNames.contains(lastName)) {
            lastName = null;
        }
        String title = "Save as Add-on protocol";
        String message = "<html>The protocol will be saved in the AddOns folder in a<br>file with a .prot extension.  The drop-down box lists<br>the names of the existing add-on files.  To replace a<br>file, select its name.  To create a new file, enter a<br> name for it (without the extension).</html>";
        Box box = Box.createVerticalBox();
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(new JLabel(message));
        box.add(panel);
        JComboBox<String> fileBox = new JComboBox<String>(protNames.toArray(new String[0]));
        fileBox.setEditable(true);
        if (lastName != null) {
            fileBox.setSelectedItem(lastName);
        }
        box.add(fileBox);
        int result = JOptionPane.showConfirmDialog(this, box, title, 2, -1);
        if (result != 0) {
            return;
        }
        String name = (String)fileBox.getSelectedItem();
        if (name.toLowerCase().endsWith(".prot")) {
            name = name.substring(0, name.length() - 5);
        }
        if ((file = new File(RemoteMaster.getAddonDir(), name + ".prot")).exists() && (result = JOptionPane.showConfirmDialog(this, message = "File " + file.getAbsolutePath() + " already exists.\nDo you wish to replace it?", "File conflict", 0, 3)) != 0) {
            return;
        }
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            out.print(protText);
            out.close();
        }
        catch (IOException ex) {
            title = "File write error";
            message = "Attempt to write to file " + file.getName() + " failed.";
            JOptionPane.showMessageDialog(this, message, title, 0);
            return;
        }
        properties.setProperty("ProtFile", name);
    }

    public void loadPB(File loadFile) {
        boolean differs = false;
        try {
            String s;
            String procName;
            BufferedReader in = new BufferedReader(new FileReader(loadFile));
            String line = in.readLine();
            String token = line.substring(0, 11);
            if (!token.equals("PB Version:")) {
                JOptionPane.showMessageDialog(RemoteMaster.getFrame(), "The PB protocol you are trying to import is not valid!", "Import Failure", 0);
                in.close();
                return;
            }
            this.loadInProgress = true;
            String delim = line.substring(11, 12);
            List<String> fields = LineTokenizer.tokenize(line, delim);
            String pbVersion = fields.get(1);
            System.err.println("PB version of imported file is '" + pbVersion + '\'');
            String description = fields.get(2);
            this.name.setText(description);
            line = in.readLine();
            fields = LineTokenizer.tokenize(line, delim);
            String procName2 = procName = fields.get(1);
            if (procName.startsWith("S3")) {
                procName = "S3C80";
                procName2 = procName2.indexOf(43) > 0 ? "S3F80" : "S3C80";
            } else if (procName.startsWith("P8/740")) {
                procName2 = procName = "740";
            }
            Processor proc = ProcessorManager.getProcessor(procName);
            int ramAddress = ProcessorManager.getProcessor(procName2).getRAMAddress();
            int ndx = Arrays.asList(procs).indexOf(proc);
            List<AssemblerItem> list = itemLists[ndx];
            list.clear();
            list.add(new AssemblerItem(0, "ORG", String.format("%04XH", ramAddress)));
            int i = 1;
            while (!(i >= fields.size() || (s = fields.get(i++)) != null && s.contains("BYTE"))) {
            }
            String codeText = fields.get(i);
            String f = null;
            while ((line = in.readLine()) != null) {
                AssemblerItem item = new AssemblerItem();
                fields = LineTokenizer.tokenize(line, delim);
                f = fields.get(0);
                if (f != null && f.equals("Protocol ID:")) {
                    ProtocolManager pm = ProtocolManager.getProtocolManager();
                    Hex temp = new Hex(fields.get(1));
                    this.pid.setValue(pm.getCurrentPID(description, temp));
                }
                if (12 < fields.size() && (f = fields.get(12)) != null) {
                    item.setAddress(Integer.parseInt(f, 16));
                }
                if (13 < fields.size() && (f = fields.get(13)) != null && !f.startsWith("=")) {
                    item.setHex(new Hex(f));
                }
                if (14 < fields.size() && (f = fields.get(14)) != null) {
                    f = f + (f.endsWith(":") ? "" : ":");
                    item.setLabel(f);
                }
                if (15 < fields.size() && (f = fields.get(15)) != null) {
                    item.setOperation(f);
                }
                if (16 < fields.size() && (f = fields.get(16)) != null) {
                    item.setArgumentText(f);
                }
                if (17 < fields.size() && (f = fields.get(17)) != null) {
                    f = (f.startsWith(";") ? "" : ";") + f;
                    item.setComments(f);
                }
                if (i < fields.size() && fields.get(i) != null) {
                    codeText = codeText + " " + fields.get(i);
                }
                list.add(item);
            }
            in.close();
            list.add(new AssemblerItem());
            this.assemblerModel.getData().clear();
            this.assemblerModel.getData().addAll(list);
            this.assemblerModel.setItemList(this.assemblerModel.getData());
            differs = this.checkAssembly(list, proc);
            this.assemblerModel.fireTableDataChanged();
            this.assemblerPanel.setAssembled(true);
            Hex hex = new Hex(codeText);
            this.tablePanel.getCodeTable().setValueAt(hex, ndx, 1);
            this.assemblerPanel.setAssembled(false);
            this.procBox.setSelectedItem(proc);
            this.deviceText.setText(this.getProtocolText(true, true));
            this.outputPanel.updatePBOutput();
            this.loadInProgress = false;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        if (differs) {
            this.showDifferenceMessage();
        }
    }

    public String[] loadRMPB(File loadFile, boolean idOnly, int modeIndex) {
        PropertyFile properties = JP1Frame.getProperties();
        JTableX codeTable = this.tablePanel.getCodeTable();
        ManualCodePanel.CodeTableModel codeModel = (ManualCodePanel.CodeTableModel)codeTable.getModel();
        boolean differs = false;
        try {
            this.loadInProgress = true;
            this.file = loadFile;
            properties.setProperty("RMPBPath", this.file.getParentFile());
            DataInputStream in = new DataInputStream(new FileInputStream(this.file));
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String line = "";
            List<AssemblerItem> list = null;
            Processor firstProc = null;
            String section = null;
            int procIndex = 0;
            String[] idStrings = new String[3];
            while ((section = this.nextSection(br, line)) != null) {
                if (section.equals("Identification")) {
                    while ((line = br.readLine()) != null && !line.startsWith("[")) {
                        if (line.startsWith("Name=")) {
                            idStrings[0] = line.substring(5).trim();
                            continue;
                        }
                        if (line.startsWith("VariantName=")) {
                            String vName = line.substring(12).trim();
                            idStrings[1] = modeIndex == 2 ? (vName == null || vName.equals("") ? "Custom" : vName + "-Custom") : vName;
                            continue;
                        }
                        if (!line.startsWith("PID=")) continue;
                        idStrings[2] = line.substring(4).trim();
                    }
                    ProtocolManager pm = ProtocolManager.getProtocolManager();
                    ProtocolManager.QualifiedID qid = pm.getCurrentQID(new Hex(idStrings[2]), idStrings[1]);
                    idStrings[1] = qid.variantName.isEmpty() ? null : qid.variantName;
                    idStrings[2] = qid.pid.toString();
                    if (modeIndex == 2 && idStrings[1] == null) {
                        idStrings[1] = "Custom";
                    }
                    if (idOnly) {
                        return idStrings;
                    }
                    this.name.setText(idStrings[0]);
                    this.variantName.setText(idStrings[1]);
                    this.pid.setValue(new Hex(idStrings[2]));
                    continue;
                }
                if (section.equals("Translators")) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    while ((line = br.readLine()) != null && !line.startsWith("[")) {
                        pw.println(line);
                    }
                    this.deviceText.setText(sw.toString());
                    pw.close();
                    if (modeIndex != 0) continue;
                    StringReader sr = new StringReader(this.deviceText.getText());
                    BufferedReader dbr = new BufferedReader(sr);
                    PropertyReader pr = new PropertyReader(dbr);
                    Properties props = new Properties();
                    Property property = new Property();
                    while ((property = pr.nextProperty()) != null) {
                        props.put(property.name, property.value);
                    }
                    props.put("PID", this.pid.getText());
                    dbr.close();
                    ManualProtocol temp = new ManualProtocol(props);
                    this.protocol.setDeviceParms(Arrays.asList(temp.getDeviceParameters()));
                    this.protocol.setCommandParms(Arrays.asList(temp.getCommandParameters()));
                    this.protocol.setDeviceTranslators(Arrays.asList(temp.getDeviceTranslators()));
                    this.protocol.setCommandTranslators(Arrays.asList(temp.getCmdTranslators()));
                    this.protocol.setDefaultCmd(temp.getDefaultCmd());
                    this.protocol.setRawHex(temp.getFixedData(new Value[this.protocol.getFixedDataLength()]));
                    this.protocol.setCmdIndex(temp.getCmdIndex());
                    continue;
                }
                if (section.equals("Executor")) {
                    block14: while ((line = br.readLine()) != null && !line.startsWith("[")) {
                        if (line.trim().isEmpty()) continue;
                        AssemblerItem item = new AssemblerItem();
                        StringTokenizer st = new StringTokenizer(line, "\t", true);
                        int n = 0;
                        while (st.hasMoreTokens()) {
                            String token = st.nextToken();
                            if (token.equals("\t")) {
                                ++n;
                                continue;
                            }
                            if ((token = token.trim()).isEmpty()) continue;
                            switch (n) {
                                case 0: {
                                    item.setAddress(Integer.parseInt(token, 16));
                                    break;
                                }
                                case 1: {
                                    item.setHex(new Hex(token));
                                    break;
                                }
                                case 2: {
                                    item.setLabel(token);
                                    break;
                                }
                                case 3: {
                                    item.setOperation(token);
                                    break;
                                }
                                case 4: {
                                    item.setArgumentText(token);
                                    break;
                                }
                                case 5: {
                                    item.setComments(token);
                                }
                            }
                        }
                        if (item.getOperation().equals("PROC")) {
                            for (int k = 0; k < procs.length; ++k) {
                                if (!procs[k].getEquivalentName().equals(item.getArgumentText())) continue;
                                if (firstProc == null) {
                                    firstProc = procs[k];
                                }
                                procIndex = k;
                                list = itemLists[k];
                                list.clear();
                                continue block14;
                            }
                            continue;
                        }
                        list.add(item);
                    }
                    list.add(new AssemblerItem());
                    continue;
                }
                if (!section.equals("Code")) continue;
                if (procs[procIndex].getDataStyle() >= 0) {
                    this.assemblerModel.getData().clear();
                    this.assemblerModel.getData().addAll(list);
                    boolean bl = differs = this.checkAssembly(list, procs[procIndex]) || differs;
                    while ((line = br.readLine()) != null && !line.startsWith("[")) {
                        if (line.trim().isEmpty()) continue;
                        this.assemblerPanel.setAssembled(true);
                        codeModel.setValueAt(new Hex(line), procIndex, 1);
                        this.assemblerPanel.setAssembled(false);
                    }
                    continue;
                }
                while ((line = br.readLine()) != null && !line.startsWith("[")) {
                    if (line.trim().isEmpty()) continue;
                    codeModel.setValueAt(new Hex(line), procIndex, 1);
                }
            }
            in.close();
            this.procBox.setSelectedItem(firstProc);
            this.processor = firstProc;
            this.setProcessor(this.processor);
            this.setMode(ProtocolDataPanel.Mode.ASM);
            int row = this.procBox.getSelectedIndex();
            this.assemblerModel.getData().clear();
            this.assemblerModel.getData().addAll(itemLists[row]);
            this.assemblerModel.setItemList(this.assemblerModel.getData());
            this.assemblerModel.fireTableDataChanged();
            this.outputPanel.updatePBOutput();
            this.loadInProgress = false;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        if (differs) {
            this.showDifferenceMessage();
        }
        return null;
    }

    private void showDifferenceMessage() {
        String title = "Assembler difference";
        String message = "The hex code in the file just loaded differs in some places from the code\nthat this assembler would generate from the same source.  The code that\ndiffers is shown in RED.  Some processors have instructions that have more\nthan one valid hex translation, so this is not necessarily an error.\n\nTo replace this code with that from this assembler, press the Assemble\nbutton after exiting this message.\n\nLines entirely in red mark instructions that cause assembler errors.";
        JOptionPane.showMessageDialog(this, message, title, 1);
    }

    private boolean checkAssembly(List<AssemblerItem> list, Processor proc) {
        int n;
        if (proc.getDataStyle() == -1) {
            return false;
        }
        boolean differs = false;
        Hex[] oldHex = new Hex[list.size()];
        for (n = 0; n < list.size(); ++n) {
            oldHex[n] = list.get(n).getHex() == null ? new Hex(0) : list.get(n).getHex();
        }
        this.assemblerModel.assemble(proc);
        for (n = 0; n < list.size(); ++n) {
            Hex hex;
            Hex hex2 = hex = list.get(n).getHex() == null ? new Hex(0) : list.get(n).getHex();
            if (hex.equals(oldHex[n])) continue;
            list.get(n).setChecked(false);
            list.get(n).setHex(oldHex[n]);
            differs = true;
        }
        return differs;
    }

    public File saveAs() {
        int returnVal;
        PropertyFile properties = JP1Frame.getProperties();
        RMFileChooser chooser = new RMFileChooser(properties.getFileProperty("RMPBPath", RemoteMaster.getWorkDir()));
        EndingFileFilter protFilter = new EndingFileFilter("Protocol files (*.rmpb)", RemoteMaster.protocolEndings);
        chooser.setFileFilter(protFilter);
        if (this.file != null) {
            chooser.setSelectedFile(this.file);
        }
        if ((returnVal = chooser.showSaveDialog(this)) == 0) {
            String ending = ((EndingFileFilter)chooser.getFileFilter()).getEndings()[0];
            String fileName = chooser.getSelectedFile().getAbsolutePath();
            if (!fileName.toLowerCase().endsWith(ending)) {
                fileName = fileName + ending;
            }
            File newFile = new File(fileName);
            int rc = 0;
            if (newFile.exists()) {
                rc = JOptionPane.showConfirmDialog(this, newFile.getName() + " already exists.  Do you want to replace it?", "Replace existing file?", 0);
            }
            if (rc == 0) {
                this.file = newFile;
                properties.setProperty("RMPBPath", this.file.getParentFile());
                this.saveRMPB();
            }
        }
        return this.file;
    }

    public void saveRMPB() {
        JTableX codeTable = this.tablePanel.getCodeTable();
        ManualCodePanel.CodeTableModel codeModel = (ManualCodePanel.CodeTableModel)codeTable.getModel();
        if (this.mode == ProtocolDataPanel.Mode.ASM) {
            int row = this.procBox.getSelectedIndex();
            itemLists[row].clear();
            itemLists[row].addAll(this.assemblerModel.getItemList());
        }
        try {
            String ls = System.getProperty("line.separator");
            PrintWriter pw = new PrintWriter(new FileWriter(this.file));
            pw.println("[Identification]");
            pw.println("Name=" + this.name.getText().trim());
            String vName = this.variantName.getText().trim();
            if (!vName.isEmpty()) {
                pw.println("VariantName=" + vName);
            }
            pw.println("PID=" + this.pid.getText());
            pw.println();
            pw.println("[Translators]");
            pw.print(ManualSettingsPanel.removeTrailingSpaces(this.deviceText.getText()));
            pw.println();
            for (int row = 0; row < itemLists.length; ++row) {
                List<AssemblerItem> list = itemLists[row];
                Hex code = (Hex)codeModel.getValueAt(row, 1);
                if (code.length() == 0) {
                    code = null;
                }
                if (list.size() <= 1 && code == null) continue;
                pw.println();
                pw.println("[Executor]");
                String line = "\t\t\tPROC\t" + procs[row].getEquivalentName();
                pw.println(line);
                if (procs[row].getDataStyle() >= 0) {
                    for (int i = 0; i < itemLists[row].size(); ++i) {
                        int j;
                        AssemblerItem item = itemLists[row].get(i);
                        line = "";
                        String addr = (String)item.getElement(0);
                        line = line + (addr.isEmpty() ? "" : addr) + "\t";
                        Hex hex = (Hex)item.getElement(1);
                        line = line + (hex == null ? "" : hex.toString()) + "\t";
                        String str = item.getLabel().trim();
                        line = line + str;
                        if (!(str.isEmpty() || str.equals(";") || str.endsWith(":"))) {
                            line = line + ":";
                        }
                        line = line + "\t" + item.getOperation() + "\t" + item.getArgumentText();
                        str = item.getComments();
                        if (!str.isEmpty()) {
                            line = line + "\t";
                            if (!str.startsWith(";")) {
                                line = line + ";";
                            }
                            line = line + str;
                        }
                        line = line + ls;
                        for (j = 0; j < line.length() && Character.isWhitespace(line.charAt(j)); ++j) {
                        }
                        if (j >= line.length() && i >= this.assemblerModel.getItemList().size() - 1) continue;
                        pw.print(line);
                    }
                }
                pw.println();
                pw.println("[Code]");
                if (code == null) continue;
                pw.println(code.toString());
            }
            pw.close();
            this.changed = false;
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    public static String removeTrailingSpaces(String s) {
        int len;
        if (s == null) {
            return null;
        }
        for (len = s.length(); len > 0 && Character.isWhitespace(s.charAt(len - 1)); --len) {
        }
        return s.substring(0, len);
    }

    public void selectProcessor(Processor proc) {
        Hex hex = this.protocol.getCode(proc);
        if ((hex == null || hex.length() == 0) && this.displayProtocol != null) {
            hex = this.displayProtocol.getCode(proc);
        }
        if (proc.getDataStyle() < 0) {
            this.analyzerPanel.set(proc, hex);
            return;
        }
        this.buttonPanel.setVisible(true);
        Hex oldHex = null;
        if (this.processor != null) {
            if (this.mode == ProtocolDataPanel.Mode.ASM) {
                for (int i = 0; i < procs.length; ++i) {
                    if (!procs[i].getEquivalentName().equals(this.processor.getEquivalentName())) continue;
                    this.assemblerPanel.stopEditing();
                    itemLists[i].clear();
                    itemLists[i].addAll(this.assemblerModel.getItemList());
                    break;
                }
            }
            if ((oldHex = this.protocol.getCode(this.processor)) == null) {
                Hex hex2 = oldHex = this.displayProtocol == null ? null : this.displayProtocol.getCode(this.processor);
            }
        }
        if (hex == null || hex.length() == 0) {
            this.protDataPanel.setInterpretations();
        }
        this.assemblerModel.disassemble(hex, proc);
        if (hex == null || hex.length() == 0) {
            this.protDataPanel.restoreInterpretations();
        }
        this.interpretPFPD();
        this.pfMainPanel.set();
        this.pdMainPanel.set();
        this.fnMainPanel.set();
        if (this.mode == ProtocolDataPanel.Mode.ASM) {
            int row = this.procBox.getSelectedIndex();
            this.assemblerModel.getData().clear();
            this.assemblerModel.getData().addAll(itemLists[row]);
            this.assemblerModel.setItemList(this.assemblerModel.getData());
            this.assemblerModel.fireTableDataChanged();
        }
        this.assemblerPanel.getEditorPanel().setAssemblerButtons(false);
        int tabCount = this.tabbedPane.getTabCount();
        String procName = proc.toString();
        if (!procName.equals("S3C80") && !procName.equals("HCS08")) {
            this.tabbedPane.remove(this.pfMainPanel);
            this.tabbedPane.remove(this.pdMainPanel);
        } else if ((procName.equals("S3C80") || procName.equals("HCS08")) && tabCount <= 3) {
            this.tabbedPane.add("PF Details", this.pfMainPanel);
            this.tabbedPane.add("PD Details", this.pdMainPanel);
        }
    }

    public void setSelectedCode(Processor proc) {
        for (int i = 0; i < procs.length; ++i) {
            if (!procs[i].getEquivalentName().equals(proc.getEquivalentName())) continue;
            JTableX codeTable = this.tablePanel.getCodeTable();
            codeTable.getSelectionModel().setSelectionInterval(i, i);
            this.procBox.setSelectedItem(procs[i]);
            break;
        }
    }

    public void setDisplayProtocol(Protocol displayProtocol) {
        this.displayProtocol = displayProtocol;
        this.tablePanel.setDisplayProtocol(displayProtocol);
    }

    public void setProcessor(Processor processor) {
        this.processor = processor;
        this.protDataPanel.setProcessor(processor);
        this.assemblerPanel.setProcessor(processor);
    }

    public void interpretPFPD() {
        this.protDataPanel.interpretPFPD(false);
    }

    public void reset(boolean forClone) {
        this.setDisplayProtocol(null);
        this.setProtocol(new ManualProtocol(null, null), forClone);
        this.name.setText(null);
        this.variantName.setText(null);
        this.pid.setText(null);
        this.deviceText.setText(null);
        for (int i = procs.length; i > 0; --i) {
            this.processor = procs[i - 1];
            this.setProcessor(this.processor);
            itemLists[i - 1].clear();
            itemLists[i - 1].add(new AssemblerItem());
            this.assemblerModel.disassemble(null, this.processor);
            if (this.processor.getDataStyle() < 0) continue;
            this.procBox.setSelectedItem(this.processor);
        }
        this.protDataPanel.reset();
        if (this.outputPanel != null) {
            this.outputPanel.reset();
        }
        this.changed = false;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        if (!this.loadInProgress) {
            this.changed = changed;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Object source = e.getSource();
        if (source == this.pid) {
            int modeIndex;
            Hex id = (Hex)this.pid.getValue();
            boolean inDeviceUpgrade = false;
            Protocol p = null;
            DeviceUpgrade du = null;
            if (id != null && id.length() != 0 && this.remoteConfig != null) {
                Remote remote = this.remoteConfig.getRemote();
                Iterator<DeviceUpgrade> iterator = this.remoteConfig.getDeviceUpgrades().iterator();
                while (iterator.hasNext()) {
                    DeviceUpgrade temp;
                    du = temp = iterator.next();
                    p = temp.getProtocol();
                    if (!p.getID(remote).equals(id)) continue;
                    inDeviceUpgrade = true;
                    break;
                }
                if (inDeviceUpgrade) {
                    String title = "Manual Settings";
                    boolean exit = false;
                    String starredID = du.getStarredID();
                    boolean usesProtocolUpgrade = starredID.endsWith("*");
                    if (usesProtocolUpgrade) {
                        String message = "There is a Device Upgrade that is using a protocol upgrade with\nPID " + id + " Do you want to abort this PID choice and enter\na different one?  If so, please press OK.\n\nIf you want to edit that protocol code, also press OK, then exit\nthis dialog, change to the Devices page and edit the protocol of\nthe device upgrade from there.\n\nTo continue, press CANCEL but you will be creating a Manual Protocol\nthat cannot be accessed while that Device Upgrade is present.";
                        exit = JOptionPane.showConfirmDialog(null, message, title, 2, 2) == 0;
                    } else {
                        String message = "There is a Device Upgrade with protocol with PID " + id + " that\nis not yet using a protocol upgrade, so you cannot create a new\nmanual protocol with that PID.  If you want to create a manual\nprotocol then please choose a different PID.  If you want to\nprovide code for that device upgrade, please change to the\nDevices page and edit the protocol from there.";
                        JOptionPane.showMessageDialog(null, message, title, 2);
                        exit = true;
                    }
                    if (exit) {
                        this.pid.setValue(null);
                        this.devicePanel.enableButtons();
                        return;
                    }
                }
            }
            this.protocol.setID(id);
            this.name.getDocument().removeDocumentListener(this);
            ManualSettingsDialog dialog = this.devicePanel.getSettingsDialog();
            if (dialog != null && ((modeIndex = dialog.getModeIndex()) == 0 || modeIndex == 1)) {
                this.protocol.setName(null);
                this.protocol.setName(this.protocol.getName());
            }
            this.name.setText(this.protocol.getName());
            this.name.getDocument().addDocumentListener(this);
        }
        this.devicePanel.enableButtons();
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (event.getSource() == this.tabbedPane) {
            if (this.protDataPanel.isActive()) {
                for (Component[] c : this.protDataPanel.getDataComponents()) {
                    ProtocolDataPanel.RMFormattedTextField rmf;
                    if (c == null || c.length <= 0 || !(c[0] instanceof ProtocolDataPanel.RMFormattedTextField) || (rmf = (ProtocolDataPanel.RMFormattedTextField)c[0]).getLastText().equals(rmf.getText()) || !rmf.isEditValid()) continue;
                    rmf.endEdit();
                }
            } else if (this.pdMainPanel.isActive()) {
                for (ProtocolDataPanel.RMFormattedTextField rmf : this.protDataPanel.getPdFields()) {
                    if (rmf.getLastText().equals(rmf.getText()) || !rmf.isEditValid()) continue;
                    rmf.endEdit();
                }
            }
            this.pfMainPanel.setActive(this.tabbedPane.getSelectedComponent() == this.pfMainPanel);
            this.pdMainPanel.setActive(this.tabbedPane.getSelectedComponent() == this.pdMainPanel);
            this.fnMainPanel.setActive(this.tabbedPane.getSelectedComponent() == this.fnMainPanel);
            this.protDataPanel.setActive(this.tabbedPane.getSelectedComponent() == this.protDataScrollPane);
            this.interpretPFPD();
            this.pfMainPanel.set();
            this.pdMainPanel.set();
            this.fnMainPanel.set();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            JTableX codeTable = this.tablePanel.getCodeTable();
            int[] rows = codeTable.getSelectedRows();
            if (this.displayProcessor != null) {
                boolean test = rows.length == 1 && procs[rows[0]].getEquivalentName().equals(this.displayProcessor.getEquivalentName());
                this.assemblerPanel.importHexButton.setEnabled(test);
            }
        }
    }

    public ProtocolDataPanel.Mode getMode() {
        return this.mode;
    }

    public void setMode(ProtocolDataPanel.Mode mode) {
        if (this.mode == mode) {
            return;
        }
        JTableX codeTable = this.tablePanel.getCodeTable();
        this.mode = mode;
        if (mode == ProtocolDataPanel.Mode.DISASM) {
            if (this.protocol != null && codeTable != null) {
                this.protDataPanel.setMode(ProtocolDataPanel.Mode.DISASM);
                this.assemblerPanel.stopEditing();
                int row = this.procBox.getSelectedIndex();
                itemLists[row].clear();
                itemLists[row].addAll(this.assemblerModel.getItemList());
                Processor proc = procs[row];
                Hex hex = this.protocol.getCode(proc);
                if ((hex == null || hex.length() == 0) && this.displayProtocol != null) {
                    hex = this.displayProtocol.getCode(proc);
                }
                this.assemblerModel.disassemble(hex, proc);
                this.assemblerPanel.getEditorPanel().setAssemblerButtons(true);
                this.protDataPanel.doBoxEnableStates(ProtocolDataPanel.EnableOps.DISABLE);
            }
        } else if (mode == ProtocolDataPanel.Mode.ASM) {
            this.protDataPanel.setMode(ProtocolDataPanel.Mode.ASM);
            this.protDataPanel.doBoxEnableStates(ProtocolDataPanel.EnableOps.RESTORE);
            this.protDataPanel.doBoxEnableStates(ProtocolDataPanel.EnableOps.SAVE);
            int row = this.procBox.getSelectedIndex();
            this.assemblerModel.getData().clear();
            this.assemblerModel.getData().addAll(itemLists[row]);
            this.assemblerModel.setItemList(this.assemblerModel.getData());
            this.assemblerModel.fireTableDataChanged();
            this.assemblerPanel.getEditorPanel().setAssemblerButtons(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.useFunctionConstants || source == this.useRegisterConstants) {
            this.assemblerPanel.saveOptionButtons();
        }
    }

    public boolean isLoadInProgress() {
        return this.loadInProgress;
    }

    public void setLoadInProgress(boolean loadInProgress) {
        this.loadInProgress = loadInProgress;
    }

    public void documentChanged(DocumentEvent e) {
        Document doc = e.getDocument();
        if (doc == this.name.getDocument()) {
            this.protocol.setName(this.name.getText());
            this.devicePanel.enableButtons();
        } else if (this.variantName != null && doc == this.variantName.getDocument()) {
            this.protocol.setVariantName(this.variantName.getText());
            this.devicePanel.enableButtons();
        }
        this.setChanged(true);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    public ProtocolDataPanel getProtDataPanel() {
        return this.protDataPanel;
    }

    public AssemblerPanel getAssemblerPanel() {
        return this.assemblerPanel;
    }

    public AssemblerTableModel getAssemblerModel() {
        return this.assemblerModel;
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public ProtocolDataPanel.FunctionMainPanel getFnMainPanel() {
        return this.fnMainPanel;
    }

    public ManualCodePanel getTablePanel() {
        return this.tablePanel;
    }

    public ManualDevicePanel getDevicePanel() {
        return this.devicePanel;
    }

    public JP2AnalyzerPanel getAnalyzerPanel() {
        return this.analyzerPanel;
    }

    public JP2AnalyzerPanel getPfDescriptionPanel() {
        return this.pfDescriptionPanel;
    }

    public RMPBOutputPanel getOutputPanel() {
        return this.outputPanel;
    }

    public JComboBox<Processor> getProcBox() {
        return this.procBox;
    }

    public JTextArea getDeviceText() {
        return this.deviceText;
    }

    public JTextField getProtocolName() {
        return this.name;
    }

    public JTextField getVariantName() {
        return this.variantName;
    }

    public JFormattedTextField getPid() {
        return this.pid;
    }

    public static List<AssemblerItem>[] getItemLists() {
        return itemLists;
    }

    public void setDisplayProcessor(Processor displayProcessor) {
        this.displayProcessor = displayProcessor;
        this.tablePanel.setDisplayProcessor(displayProcessor);
        String s = "Only the executor for the " + displayProcessor.getEquivalentName() + " can be edited for this remote.";
        this.availabilityLabel.setText(s);
    }
}

