/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.RDFParameter;
import com.hifiremote.jp1.RDFReader;
import com.hifiremote.jp1.Remote;
import java.util.StringTokenizer;

public class MultiMacro
extends RDFParameter {
    private int address1 = 0;
    private int address2 = 0;
    private int count = 0;
    private Button button = null;

    @Override
    public void parse(String text, Remote remote) throws Exception {
        StringTokenizer st = new StringTokenizer(text, "=,");
        String buttonName = st.nextToken();
        this.button = remote.getButton(buttonName);
        this.button.setMultiMacro(this);
        this.address1 = RDFReader.parseNumber(st.nextToken());
        if (st.hasMoreTokens()) {
            this.address2 = RDFReader.parseNumber(st.nextToken());
        }
    }

    public void setButton(Button button) {
        this.button = button;
    }

    public Button getButton() {
        return this.button;
    }

    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public void store(short[] data, Remote remote) {
        if (this.address2 == 0) {
            data[this.address1] = (short)((this.count << 4 | 1) & 0xFF);
        } else {
            data[this.address1] = (short)(this.count & 0xFF);
            data[this.address2] = 1;
        }
    }
}

