/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.KeyMove;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.SetupCode;
import com.hifiremote.jp1.SpecialFunctionDialog;
import com.hifiremote.jp1.SpecialProtocolFunction;
import java.util.Properties;

public class MultiplexFunction
extends SpecialProtocolFunction {
    public MultiplexFunction(KeyMove keyMove) {
        super(keyMove);
    }

    public MultiplexFunction(Macro macro) {
        super(macro);
    }

    public MultiplexFunction(int keyCode, int deviceButtonIndex, int deviceType, int setupCode, Hex cmd, String notes) {
        super(keyCode, deviceButtonIndex, deviceType, setupCode, cmd, notes);
    }

    public MultiplexFunction(Properties props, Remote remote) {
        super(props, remote);
    }

    public int getNewDeviceTypeIndex() {
        return this.getCmd().getData()[0] >> 4;
    }

    public int getNewSetupCode() {
        short[] hex = this.getCmd().getData();
        return (hex[0] & 0xF) << 8 | hex[1];
    }

    @Override
    public String get_Type(RemoteConfiguration remoteConfig) {
        return this.getUserFunctions(remoteConfig)[0];
    }

    @Override
    public String getDisplayType(RemoteConfiguration remoteConfig) {
        return this.getUserFunctions(remoteConfig)[0];
    }

    @Override
    public String getValueString(RemoteConfiguration remoteConfig) {
        StringBuilder buff = new StringBuilder();
        buff.append(remoteConfig.getRemote().getDeviceTypeByIndex(this.getNewDeviceTypeIndex()).getName());
        buff.append(':');
        buff.append(SetupCode.toString(this.getNewSetupCode()));
        return buff.toString();
    }

    @Override
    public void update(SpecialFunctionDialog dlg) {
        dlg.setDeviceType(this.getNewDeviceTypeIndex());
        dlg.setSetupCode(this.getNewSetupCode());
    }

    public static Hex createHex(SpecialFunctionDialog dlg) {
        short[] hex = new short[2];
        int setupCode = dlg.getSetupCode();
        hex[0] = (short)(dlg.getDeviceType() << 4 | setupCode >> 8);
        hex[1] = (short)(setupCode & 0xFF);
        return new Hex(hex);
    }
}

