/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.AddressRange;
import com.hifiremote.jp1.BinAnalyzer;
import com.hifiremote.jp1.CheckSum;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JP1Frame;
import com.hifiremote.jp1.Processor;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.Xor16CheckSum;
import com.hifiremote.jp1.XorCheckSum;
import com.hifiremote.jp1.io.CommHID;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;

public class NoSetup
extends BinAnalyzer {
    private int dataEnd = 0;
    private int learnedFormat = -1;
    private LinkedHashMap<Integer, List<Integer>> activityGroups = null;
    private LinkedHashMap<Integer, Integer> devTypeToBtnMap = new LinkedHashMap();

    public NoSetup(File binFile, JP1Frame owner) {
        super(binFile, owner, true);
        String errorStr = this.getGroupButtonAddrs();
        if (errorStr == null && this.getSetupInfo() == null) {
            errorStr = this.setupInfoError;
        }
        if (errorStr == null) {
            for (int addr : this.getExecSetupAddresses()) {
                if (this.setupInfo[6] <= this.btnMapOffset || addr < this.setupInfo[6]) continue;
                this.setupInfo[7] = addr;
                break;
            }
            this.numberTables = this.hex.subHex(this.setupInfo[6], this.setupInfo[7] - this.setupInfo[6]);
        }
    }

    public NoSetup(String signature) {
        super(signature);
        if (this.hex == null) {
            return;
        }
        this.getSetupInfo();
    }

    public Processor getProcessor() {
        return this.p;
    }

    public String getSetupInfoError() {
        return this.setupInfoError;
    }

    public String getRDFInfo() {
        try {
            int i;
            int i2;
            int segStart;
            ZipFile zipIn = new ZipFile(RemoteMaster.getRmpbSys());
            Enumeration<? extends ZipEntry> zipEnum = zipIn.entries();
            String remoteName = "New remote";
            int remNdx = 0;
            while (zipEnum.hasMoreElements()) {
                ZipEntry entryIn = zipEnum.nextElement();
                String nameIn = entryIn.getName();
                String nameOut = CommHID.convertName(nameIn, remNdx, false, true);
                ++remNdx;
                if (!nameOut.startsWith(this.signature)) continue;
                int start = nameOut.indexOf(95);
                int end = nameOut.lastIndexOf(46);
                remoteName = nameOut.substring(start + 1, end);
            }
            String rdfxName = this.signature + " (" + remoteName + ").rdfx";
            String ls = System.lineSeparator();
            List buttonMap = (List)this.btnMaps.get(0);
            StringBuilder sb = new StringBuilder();
            File rdfxFile = new File(RemoteMaster.getWorkDir(), rdfxName);
            FileWriter fw = new FileWriter(rdfxFile);
            PrintWriter pw = new PrintWriter(fw);
            sb.append("[General]");
            sb.append(ls + "Name=" + this.signature + " " + remoteName);
            sb.append(ls + "EepromSize=$" + Integer.toHexString(this.e2Len).toUpperCase());
            if (this.procName == null) {
                pw.close();
                fw.close();
                return null;
            }
            if (this.procName.equals("S3F80")) {
                sb.append(ls + "Processor=" + this.procName);
            } else {
                sb.append(ls + "Processor=S3C80");
                sb.append(ls + "Processor+=" + this.procName);
            }
            sb.append(ls + "BaseAddr=$" + Integer.toHexString(this.e2Address).toUpperCase());
            Hex e2Hex = this.hex.subHex(this.e2Address, this.e2Len);
            short[] e2Data = e2Hex.getData();
            int pos = segStart = this.blockStruct ? 20 : 2;
            int segLength = e2Hex.get(pos);
            ArrayList<Short> realTimeBtns = new ArrayList<Short>();
            short realTimeCode = 0;
            ArrayList<Integer> segmentTypes = new ArrayList<Integer>();
            while (segLength != 65535 && segLength != 0) {
                short segType = e2Data[pos + 2];
                short segFlags = e2Data[pos + 3];
                if (pos + segLength > this.e2Len) {
                    pw.close();
                    fw.close();
                    return null;
                }
                if (segFlags == 255) {
                    if (segType == 3) {
                        short boundBtn = e2Data[pos + 5];
                        if (!realTimeBtns.contains(boundBtn)) {
                            realTimeBtns.add(boundBtn);
                        }
                        for (int i3 = 0; i3 < e2Data[pos + 6] / 2; ++i3) {
                            if (realTimeCode != 0) continue;
                            realTimeCode = e2Data[pos + 7 + 2 * i3];
                            if (realTimeCode == 114 || realTimeCode == 117) {
                                realTimeCode = (short)(realTimeCode - 1);
                            }
                            if (realTimeCode == 113 || realTimeCode == 116) continue;
                            realTimeCode = 0;
                        }
                        if (!segmentTypes.contains(1)) {
                            segmentTypes.add(1);
                        }
                    }
                    if (!segmentTypes.contains(segType)) {
                        segmentTypes.add(Integer.valueOf(segType));
                        if (segType == 0) {
                            sb.append(ls + "SoftDev=SetupCodesOnly");
                            if (!segmentTypes.contains(16)) {
                                segmentTypes.add(16);
                            }
                        }
                        if (segType == 9) {
                            this.learnedFormat = this.procName.equals("MAXQ610") ? 1 : (e2Data[pos + 8] == 0 ? 3 : 4);
                        }
                    }
                }
                segLength = Hex.get(e2Data, pos += segLength);
            }
            this.dataEnd = pos;
            Collections.sort(segmentTypes);
            sb.append(ls + "SegmentTypes=");
            boolean first = true;
            Iterator segFlags = segmentTypes.iterator();
            while (segFlags.hasNext()) {
                int type = (Integer)segFlags.next();
                sb.append((first ? "" : " ") + "$" + String.format("%02X", type));
                first = false;
            }
            sb.append(ls + "BlockFormat=" + (this.blockStruct ? "Y" : "N"));
            if (!realTimeBtns.isEmpty()) {
                sb.append(ls + "RealTimeMacroData=");
                for (int i4 = 0; i4 < realTimeBtns.size(); ++i4) {
                    if (i4 > 0) {
                        sb.append(" ");
                    }
                    sb.append(String.format("$%02X", realTimeBtns.get(i4)));
                }
                sb.append(String.format(", $%02X $%02X", realTimeCode, realTimeCode + 1));
            }
            if (this.learnedFormat == 3) {
                sb.append(ls + "LearnedFormat=3");
            }
            sb.append(ls + "Shift=0");
            int maxDevType = 0;
            Iterator type = this.setupCodeLists.keySet().iterator();
            while (type.hasNext()) {
                int type2 = (Integer)type.next();
                if (type2 <= maxDevType) continue;
                maxDevType = type2;
            }
            sb.append(ls + "PunchThru=" + (maxDevType > 0 ? "V" : "none"));
            sb.append(ls + "#ImageMap=mapname.map  #Update as required");
            sb.append(ls + "RDFSync=5");
            sb.append(ls + ls);
            String actualCheckSum = String.format("  %04X", e2Hex.get(0));
            AddressRange range = new AddressRange(2, this.dataEnd - 1);
            range.setRoundTo(1);
            CheckSum cs = new XorCheckSum(0, range, false);
            String checkXOR = String.format("  %04X", cs.getCheckSum(e2Data));
            range.setRoundTo(2);
            cs = new Xor16CheckSum(0, range, false);
            String check2XOR16 = String.format("  %04X", cs.getCheckSum(e2Data));
            range.setRoundTo(4);
            cs = new Xor16CheckSum(0, range, false);
            String check4XOR16 = String.format("  %04X", cs.getCheckSum(e2Data));
            sb.append("[Checksums]");
            sb.append(ls + "$0000:$0002..$" + String.format("%04X", this.e2Len - 1));
            sb.append(ls + " addr    read    ^    */2   */4");
            sb.append(ls + "E2 area" + actualCheckSum + checkXOR + check2XOR16 + check4XOR16);
            sb.append(ls + ls + "[DeviceTypes]");
            for (i2 = 0; i2 <= maxDevType; ++i2) {
                int btnMapPtr = (Integer)this.btnMapPtrs.get(i2 % this.btnMapPtrs.size());
                ArrayList distinctKeys = new ArrayList(this.btnMapsDistinct.keySet());
                int mapNum = distinctKeys.indexOf(btnMapPtr);
                this.devTypeToBtnMap.put(i2, mapNum);
                sb.append(ls + "DevType" + i2 + " = " + mapNum + ", " + i2);
            }
            sb.append(ls + ls + "[DeviceTypeAliases]");
            sb.append(ls + "#Amend as required");
            sb.append(ls + "DevType0 = TV,DVD,Tape,Laserdisc,DAT,VCR,Video Acc,CD,Tuner");
            sb.append(maxDevType > 0 ? ls + "DevType1 = " : ",");
            sb.append("Cable,SAT");
            sb.append(maxDevType > 1 ? ls + "DevType2 = " : ",");
            sb.append("Misc Audio,Home Auto,Phono,Amp");
            if (this.deviceButtons != null) {
                sb.append(ls + ls + "[DeviceButtons]");
                for (i2 = 0; i2 < this.deviceButtons.size(); ++i2) {
                    sb.append(ls + String.format("Dev%d = $%02X $FF $FF $FF", i2, this.deviceButtons.get(i2)));
                }
            }
            sb.append(ls + ls + "[Buttons]");
            sb.append(ls + "#Fix key names but group assignments are correct" + ls);
            LinkedHashMap<Short, String> keyCodeToName = new LinkedHashMap<Short, String>();
            String[] buttonNames = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "Vol+", "Vol-", "Mute", "Ch+", "Ch-"};
            for (int i5 = 0; i5 < 3; ++i5) {
                int len;
                int addr = this.groupAddrs[i5];
                int n = i5 == 0 ? 10 : (len = i5 == 1 ? 3 : 2);
                int base = i5 == 0 ? 0 : (i5 == 1 ? 10 : 13);
                for (int j = 0; j < len; ++j) {
                    short keyCode = this.hex.getData()[addr + j];
                    keyCodeToName.put(keyCode, buttonNames[base + j]);
                }
            }
            short powerKeyCode = (Short)buttonMap.get(0);
            keyCodeToName.put(powerKeyCode, "Power");
            ArrayList others = new ArrayList(buttonMap);
            int n = others.indexOf(powerKeyCode);
            others.remove(n);
            Collections.sort(others);
            for (int i6 = 0; i6 < others.size(); ++i6) {
                keyCodeToName.put((Short)others.get(i6), "B" + i6);
            }
            ArrayList keyCodeList = new ArrayList(keyCodeToName.keySet());
            Collections.sort(keyCodeList);
            int ndx = 0;
            Iterator<Object> keyCode = keyCodeList.iterator();
            while (keyCode.hasNext()) {
                short code = (Short)keyCode.next();
                ++ndx;
                sb.append(String.format((String)keyCodeToName.get(code) + "=$%02X:group%d", code, this.getGroupIndex(code)));
                if (code == powerKeyCode) {
                    sb.append("+groupActivity");
                }
                if (ndx < keyCodeList.size()) {
                    sb.append(",");
                }
                if (ndx % 5 != 0 || ndx == keyCodeToName.size()) continue;
                sb.append(ls);
            }
            sb.append(ls + ls + "[ButtonMaps]" + ls);
            keyCode = this.btnMaps.keySet().iterator();
            while (keyCode.hasNext()) {
                int btnMapNdx = (Integer)keyCode.next();
                sb.append(btnMapNdx + " = ");
                for (int i7 = 0; i7 < 3; ++i7) {
                    sb.append("(");
                    int addr = this.groupAddrs[i7];
                    if (addr == 0) {
                        sb.append("), ");
                        continue;
                    }
                    int groupLen = i7 == 0 ? 10 : (i7 == 1 ? 3 : 2);
                    for (int j = 0; j < groupLen; ++j) {
                        sb.append(String.format("$%02X", this.hex.getData()[addr + j]));
                        sb.append(j == groupLen - 1 ? (i7 == 2 ? ")" : "), ") : ", ");
                    }
                }
                List btnCodes = (List)this.btnMaps.get(btnMapNdx);
                int len = btnCodes.size();
                if (len == 0) {
                    sb.append(ls);
                    continue;
                }
                sb.append(", " + ls + "    ");
                for (int i8 = 1; i8 <= len; ++i8) {
                    sb.append(String.format("$%02X", btnCodes.get(i8 - 1)));
                    sb.append(i8 == len ? ls : (i8 % 16 == 0 ? "," + ls + "    " : ", "));
                }
            }
            sb.append(ls);
            sb.append("[Number tables]");
            sb.append(ls + "#Use Number Tables file in Master Files to convert to \"[DigitMaps]\"");
            for (int i9 = 0; i9 < this.numberTables.length(); ++i9) {
                if (i9 % 10 == 0) {
                    sb.append(ls + "    ");
                }
                sb.append(String.format("%02X ", this.numberTables.getData()[i9]));
            }
            sb.append(ls + ls);
            StringBuilder execSB = this.makeProtocols(sb);
            if (this.setupCodeLists != null && !this.setupCodeLists.isEmpty()) {
                sb.append(ls + ls + "[SetupCodes]");
                Iterator btnMapNdx = this.setupCodeLists.keySet().iterator();
                while (btnMapNdx.hasNext()) {
                    int key = (Integer)btnMapNdx.next();
                    ArrayList<Integer> codeList = new ArrayList<Integer>();
                    int mask = this.uses16bitSetupCodes ? 65535 : 4095;
                    Iterator j = ((List)this.setupCodeLists.get(key)).iterator();
                    while (j.hasNext()) {
                        int code = (Integer)j.next();
                        codeList.add(code & mask);
                    }
                    Collections.sort(codeList);
                    sb.append(ls + key + " = ");
                    for (i = 0; i < codeList.size(); ++i) {
                        sb.append(String.format("%04d", codeList.get(i)));
                        sb.append(i < codeList.size() - 1 ? "," : "");
                        if ((i + 1) % 16 != 0 || i == codeList.size() - 1) continue;
                        sb.append(ls + "    ");
                    }
                }
            }
            sb.append(ls + ls + "#-------------- Extract Only -----------------");
            sb.append(ls + ls + "[General Extract Data]" + ls);
            sb.append("Signature: " + this.signature + ls);
            sb.append("Processor: " + this.p.getName() + ls);
            sb.append("Flash size: " + this.flashSize + ls);
            sb.append("Has block format: " + (this.blockStruct ? "Y" : "N") + ls);
            sb.append("Uses 16-bit setup codes: " + (this.uses16bitSetupCodes ? "Y" : "N") + ls);
            if (this.omitDigitMapByte) {
                sb.append("OmitDigitMapByte: Y" + ls);
            }
            sb.append(String.format("Code area: %04X", this.codeAddress) + ls);
            sb.append(String.format("Signature area: %04X", this.sigAddress) + ls);
            sb.append(String.format("IR Database address: %04X", this.irdbAddress) + ls);
            sb.append(String.format("E2 area: %04X to %04X", this.e2Address, this.e2Address + this.e2Len - 1) + ls);
            sb.append(String.format("Ptr to number tables: %04X", this.setupInfo[6]) + ls);
            sb.append(String.format("Ptr to digit btn grp: %04X", this.groupAddrs[0]) + ls);
            sb.append(String.format("Ptr to vol btn grp: %04X", this.groupAddrs[1]) + ls);
            sb.append(String.format("Ptr to ch btn grp: %04X", this.groupAddrs[2]) + ls);
            if (this.btnMapPtrPtr > 0) {
                sb.append(String.format("Ptr to btn map ptrs: %04X", this.btnMapPtrPtr) + ls);
            }
            int num = 0;
            Iterator key = this.btnMapsDistinct.keySet().iterator();
            while (key.hasNext()) {
                int btnMapPtr = (Integer)key.next();
                int mapNdx = (Integer)this.btnMapsDistinct.get(btnMapPtr);
                if (mapNdx == 0) {
                    sb.append("Ptr to btn map " + num++ + String.format(": %04X", btnMapPtr) + ls);
                    continue;
                }
                for (i = 0; i <= mapNdx; ++i) {
                    sb.append("Ptr " + i + " to btn map " + num + String.format(": %04X", btnMapPtr) + ls);
                }
                ++num;
            }
            sb.append(ls + "[ProtocolCode]");
            sb.append(ls + "Row number, address, PID, Executor");
            sb.append(ls + execSB.toString());
            sb.append(ls + "[Activity0 permitted serial values]");
            for (int i10 = 0; i10 < this.getMode0Codes().size(); ++i10) {
                if (i10 % 16 == 0) {
                    sb.append(ls + "    ");
                } else {
                    sb.append(" ");
                }
                sb.append(String.format("%3d", this.getMode0Codes().get(i10)));
            }
            sb.append(ls);
            this.makeActivityData(sb);
            if (this.setupInfo[13] != this.setupInfo[11]) {
                this.makeSetupData(sb, null, maxDevType);
            }
            pw.print(sb.toString());
            pw.close();
            fw.close();
            String title = "Replacement Remote Extended RDF";
            String message = "An Extended RDF named \"" + rdfxName + "\" consisting of a draft RDF\nwith other extract data has been written to your RMIR installation folder";
            JOptionPane.showMessageDialog(this.owner, message, title, 1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Hex getHex() {
        return this.hex;
    }

    public int getSerial(int mode, Hex addr) {
        int offset = 0;
        if (mode == 0) {
            addr = this.hex.subHex(this.p.getInt(addr.getData(), 0), 2);
        }
        int vecStart = this.getSetupInfo()[4];
        if (this.getSetupInfo()[12] == 1) {
            int vecEnd = this.getSetupInfo()[0];
            for (int i = vecStart; i < vecEnd; i += 2) {
                if (!this.hex.subHex(i, 2).equals(addr)) continue;
                offset = i - vecStart + 2;
                break;
            }
            return offset / 2;
        }
        return (addr.get(0) - this.getSetupInfo()[4]) / 2 + 1;
    }

    public List<Integer> getMode0Codes() {
        ArrayList<Integer> mode0Codes = new ArrayList<Integer>();
        int serial = 0;
        for (int i = this.getSetupInfo()[2]; i < this.getSetupInfo()[3]; i += 2) {
            if (this.getSetupInfo()[12] == 1) {
                Hex addr = this.hex.subHex(i, 2);
                serial = this.getSerial(0, addr);
            } else {
                short[] data = new short[]{(short)(i >> 8), (short)(i & 0xFF)};
                serial = this.getSerial(0, new Hex(data));
            }
            mode0Codes.add(serial);
        }
        return mode0Codes;
    }

    public List<Integer> getMode1Codes() {
        ArrayList<Integer> mode1Codes = new ArrayList<Integer>();
        for (int i = 1; i < (this.getSetupInfo()[0] - this.getSetupInfo()[3]) / 2 - 2; ++i) {
            mode1Codes.add(i);
        }
        return mode1Codes;
    }

    public Hex createRawUpgrade(int devType, int setupCode) {
        if (this.setupInfo[13] == this.setupInfo[11]) {
            return null;
        }
        int row = 0;
        int mask = this.uses16bitSetupCodes ? 65535 : 4095;
        Iterator iterator = this.setupCodeLists.keySet().iterator();
        while (iterator.hasNext()) {
            int type = (Integer)iterator.next();
            Iterator iterator2 = ((List)this.setupCodeLists.get(type)).iterator();
            while (iterator2.hasNext()) {
                int code = (Integer)iterator2.next();
                ++row;
                if (devType != type || setupCode != (code & mask)) continue;
                BinAnalyzer.SetupAnalysis sa = (BinAnalyzer.SetupAnalysis)this.analyses.get(row);
                int address = this.p.getInt(this.hex.getData(), this.setupInfo[4] + 2 * row) + this.execAddrOffset;
                ArrayList<Short> valList = new ArrayList<Short>();
                for (Short[] val : sa.setupState.values()) {
                    for (int i = 0; i < val.length; ++i) {
                        valList.add(val[i]);
                    }
                }
                Hex mergeHex = new Hex(valList.toArray(new Short[0]));
                String outStr = String.format("%s %02X %s %s%s", sa.pid, sa.numTable, sa.mapBytes, sa.fixedData == null || sa.fixedData.length() == 0 ? "" : sa.fixedData + " ", mergeHex);
                return new Hex(outStr);
            }
        }
        return null;
    }

    public Hex getSetup(int mode, int serial) {
        int setupPtr = this.p.getInt(this.hex.getData(), this.getSetupInfo()[2 * mode + 2] + 2 * serial - 2);
        int execPIDsPtr = this.getSetupInfo()[0];
        int execsStart = this.getSetupInfo()[1];
        if (mode == 0) {
            setupPtr = this.p.getInt(this.hex.getData(), setupPtr);
        }
        Hex getSetupPID = this.hex.subHex(setupPtr, 2);
        int execCount = this.p.getInt(this.hex.getData(), execPIDsPtr);
        int execPtr = 0;
        for (int i = 0; i < execCount; ++i) {
            int pidTest = this.p.getInt(this.hex.getData(), execPIDsPtr + 2 + 2 * i);
            if (pidTest != getSetupPID.get(0)) continue;
            execPtr = execPIDsPtr + 2 + 2 * i + 2 * execCount;
            break;
        }
        int pidAddr = this.p.getInt(this.hex.getData(), execPtr) + (this.procChar == '2' ? execsStart : 0);
        short val = this.hex.getData()[pidAddr + 2];
        int numFixed = val >> 4;
        int numVar = val & 0xF;
        int bitMapAddr = setupPtr + 3;
        int btnCount = 0;
        short bitMapByte = 0;
        int n = 0;
        int mask = 128;
        do {
            bitMapByte = this.hex.getData()[bitMapAddr + n];
            for (int i = 0; i < 7; ++i) {
                if ((bitMapByte << i & mask) != mask) continue;
                btnCount += n > 0 ? 1 : (i == 0 ? 10 : (i == 1 ? 3 : (i == 2 ? 2 : 1)));
            }
            ++n;
        } while ((bitMapByte & 1) == 0);
        int setupLength = 3 + n + numFixed + btnCount * numVar;
        Hex setup = this.hex.subHex(setupPtr, setupLength);
        return setup;
    }

    private void makeActivityData(StringBuilder sb) {
        String ls = System.lineSeparator();
        sb.append(ls + "[ActivityData]");
        sb.append(ls + "serial, address, pid, numberTable, fixed data, map bytes, hex data");
        int endAddr = 0;
        int serial = 1;
        for (int ptr = this.setupInfo[4]; ptr < this.setupInfo[5]; ptr += 2) {
            int startAddr = this.p.getInt(this.hex.getData(), ptr);
            for (int addr : this.getExecSetupAddresses()) {
                if (addr <= startAddr) continue;
                endAddr = addr;
                break;
            }
            Hex data = this.hex.subHex(startAddr, endAddr - startAddr);
            BinAnalyzer.SetupAnalysis sa = new BinAnalyzer.SetupAnalysis(0, serial, data);
            Hex varData = data.subHex(3 + sa.mapBytes.length() + sa.numFix, sa.numDataBytes);
            ++serial;
            sb.append(ls + String.format("%d, %05X, %04X, %02X, %s, %s, %s", sa.setupCode, startAddr, sa.pid.get(0), sa.numTable, sa.fixedData, sa.mapBytes, varData));
        }
    }

    private List<Integer> getActivityGroup(int defnAddress) {
        ArrayList<Integer> keyCodes = new ArrayList<Integer>();
        try {
            int startAddr = this.p.getInt(this.hex.getData(), defnAddress) + 3;
            int pos = 0;
            short mapByte = 0;
            int byteNdx = 0;
            int mask = 128;
            int[] groupSize = new int[]{10, 3, 2};
            do {
                if (((mapByte = this.hex.getData()[startAddr + byteNdx]) & mask) == mask) {
                    if (pos < 3) {
                        for (int i = 0; i < groupSize[pos]; ++i) {
                            keyCodes.add(Integer.valueOf(this.hex.getData()[this.groupAddrs[pos] + i]));
                        }
                    } else {
                        if (pos - 3 >= ((List)this.btnMaps.get(0)).size()) {
                            System.err.println("Requested activity group size exceeds button map size for signature " + this.signature);
                            break;
                        }
                        keyCodes.add((int)((Short)((List)this.btnMaps.get(0)).get(pos - 3)));
                    }
                }
                if ((mask >>= 1) == 1) {
                    ++byteNdx;
                    mask = 128;
                }
                ++pos;
            } while (mask != 128 || (mapByte & 1) == 0);
            return keyCodes;
        }
        catch (Exception e) {
            return null;
        }
    }

    private LinkedHashMap<Integer, List<Integer>> getActivityGroups() {
        if (this.activityGroups != null) {
            return this.activityGroups;
        }
        this.activityGroups = new LinkedHashMap();
        for (int i = 0; i < this.setupInfo[17]; ++i) {
            int defnAddr = this.setupInfo[16] + 2 * i;
            this.activityGroups.put(i, this.getActivityGroup(defnAddr));
        }
        return this.activityGroups;
    }

    private int getGroupIndex(int keyCode) {
        for (int i : this.getActivityGroups().keySet()) {
            if (!this.activityGroups.get(i).contains(keyCode)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int[] getSetupInfo() {
        try {
            int endNdx;
            if (this.setupInfo != null) {
                return this.setupInfo;
            }
            int infoPtrList = this.blockStruct ? this.irdbAddress + 20 : this.irdbAddress;
            int numberTablesStart = this.hex.get(infoPtrList) * this.wordMult;
            int setupStarts = this.hex.get(infoPtrList + 6) * this.wordMult;
            this.numberTables = this.hex.subHex(numberTablesStart, setupStarts - numberTablesStart);
            int setupCodeIndex = this.hex.get(infoPtrList + 2) * this.wordMult;
            int setupCodeVectorsPtr = this.hex.get(infoPtrList + 4) * this.wordMult;
            int execPIDsPtr = this.hex.get(infoPtrList + 8) * this.wordMult;
            int execVectorsPtr = this.hex.get(infoPtrList + 10) * this.wordMult;
            int defaultSetupCodesPtr = this.hex.get(infoPtrList + 12) * this.wordMult;
            int execsStart = this.hex.get(infoPtrList + 14) * this.wordMult;
            int regionalDataStart = this.hex.get(infoPtrList + 16) * this.wordMult;
            int buttonMapVectorsPtr = this.hex.get(infoPtrList + 20) * this.wordMult;
            int ptrToActivityData = 0;
            int ptrToPtrToActivityGroupDefs = 0;
            int activityEndOffset = 6;
            int activitySetupType = 0;
            if (this.procChar == '2') {
                ptrToActivityData = setupCodeVectorsPtr;
                activitySetupType = 1;
                activityEndOffset = 4;
            } else {
                ptrToActivityData = this.hex.get(infoPtrList + 26) * this.wordMult;
            }
            int activityCount = 0;
            ArrayList<Integer> activityGroupBtns = new ArrayList<Integer>();
            ptrToPtrToActivityGroupDefs = this.p.getInt(this.hex.getData(), ptrToActivityData) * this.wordMult;
            int ptrToActivityGroupDefs = this.p.getInt(this.hex.getData(), ptrToPtrToActivityGroupDefs);
            for (int i = 0; i < 10; ++i) {
                int addr = ptrToActivityGroupDefs + 2 * i;
                List<Integer> groupBtns = this.getActivityGroup(addr);
                if (groupBtns == null) {
                    activityCount = i;
                    break;
                }
                for (int keyCode : groupBtns) {
                    if (!activityGroupBtns.contains(keyCode)) continue;
                    activityCount = i;
                }
                if (activityCount != 0) break;
                activityGroupBtns.addAll(groupBtns);
            }
            int activityData = this.p.getInt(this.hex.getData(), ptrToActivityData) * this.wordMult;
            this.setupInfo = new int[18];
            this.setupInfo[0] = execPIDsPtr;
            this.setupInfo[1] = execsStart;
            this.setupInfo[2] = activityData + 2 * activityCount;
            this.setupInfo[3] = this.p.getInt(this.hex.getData(), activityData);
            this.setupInfo[4] = this.p.getInt(this.hex.getData(), ptrToPtrToActivityGroupDefs) + 2 * activityCount;
            this.setupInfo[5] = this.p.getInt(this.hex.getData(), ptrToActivityData + activityEndOffset) * this.wordMult;
            this.setupInfo[6] = numberTablesStart;
            this.setupInfo[8] = setupStarts;
            this.setupInfo[9] = this.setupStart(0);
            this.setupInfo[10] = regionalDataStart;
            this.setupInfo[11] = setupCodeVectorsPtr;
            this.setupInfo[12] = activitySetupType;
            this.setupInfo[13] = ptrToActivityData;
            this.setupInfo[14] = 0;
            this.setupInfo[15] = setupCodeIndex;
            this.setupInfo[16] = ptrToActivityGroupDefs;
            this.setupInfo[17] = activityCount;
            if (this.setupInfo[13] != this.setupInfo[11]) {
                int audioSetupStart;
                int activityGroup2Count = (this.setupInfo[5] - this.setupInfo[4]) / 2;
                this.setupInfo[14] = audioSetupStart = this.setupInfo[11] + activityGroup2Count * 2;
            }
            boolean uses12bitsetupcodes = true;
            for (endNdx = 0; this.setupInfo[8] + 2 * endNdx < this.e2Address && endNdx < 20 && !this.getExecSetupAddresses().contains(this.setupStart(endNdx)); ++endNdx) {
            }
            if (this.setupInfo[8] + 2 * endNdx >= this.e2Address || endNdx == 20) {
                this.setupInfoError = "Failed to find valid device types.";
                return null;
            }
            this.setupCodeLists = new LinkedHashMap();
            int devNdx = 0;
            for (devNdx = 0; devNdx < endNdx; ++devNdx) {
                ArrayList<Integer> codes = new ArrayList<Integer>();
                for (int addr = this.setupStart(devNdx); addr < this.setupStart(devNdx + 1); addr += 2) {
                    int code = this.p.getInt(this.hex.getData(), addr);
                    if (codes.isEmpty() && code == 65535) {
                        codes = null;
                        continue;
                    }
                    if (code >> 12 != devNdx && code >> 12 != 0) {
                        uses12bitsetupcodes = false;
                    }
                    codes.add(code);
                }
                if (codes == null) continue;
                this.setupCodeLists.put(devNdx, codes);
            }
            boolean bl = this.uses16bitSetupCodes = this.setupInfo[9] == this.setupInfo[15] + 2 && !uses12bitsetupcodes;
            if (this.setupInfo[13] != this.setupInfo[11]) {
                this.mergeSetupChains();
                int maxDevType = this.btnMapPtrs.size() - 1;
                Iterator iterator = this.analyses.keySet().iterator();
                while (iterator.hasNext()) {
                    int row = (Integer)iterator.next();
                    BinAnalyzer.SetupAnalysis sa = (BinAnalyzer.SetupAnalysis)this.analyses.get(row);
                    if (sa.devType <= maxDevType || sa.fixedData == null && sa.mapBytes == null && (sa.data == null || sa.data.getData().length <= 0)) continue;
                    maxDevType = sa.devType;
                }
            }
            return this.setupInfo;
        }
        catch (Exception e) {
            return null;
        }
    }
}

