/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.ByteEditor;
import com.hifiremote.jp1.ByteRenderer;
import com.hifiremote.jp1.CmdParameter;
import com.hifiremote.jp1.DefaultValue;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class NumberCmdParm
extends CmdParameter {
    private ByteEditor editor;
    private ByteRenderer renderer;
    private int bits = 8;
    private int base = 10;
    private Object value = null;

    public NumberCmdParm(String name, DefaultValue defaultValue) {
        this(name, defaultValue, 8);
    }

    public NumberCmdParm(String name, DefaultValue defaultValue, int bits) {
        this(name, defaultValue, bits, 10);
    }

    public NumberCmdParm(String name, DefaultValue defaultValue, int bits, int base) {
        super(name, defaultValue);
        this.bits = bits;
        this.base = base;
        this.editor = new ByteEditor(0, (1 << bits) - 1, this);
        this.editor.setBase(base);
        this.renderer = new ByteRenderer();
        this.renderer.setBase(base);
    }

    @Override
    public String getDescription() {
        return "Number";
    }

    @Override
    public TableCellEditor getEditor() {
        return this.editor;
    }

    @Override
    public TableCellRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    public Class<?> getValueClass() {
        return Integer.class;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Object convertValue(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> c = value.getClass();
        System.err.println("NumberCmdParm.convertValue(): class is " + c);
        if (c == Integer.class || c == Short.class) {
            return value;
        }
        return Integer.valueOf((String)value, this.base);
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.name);
        if (this.bits != 8 || this.base != 10) {
            buff.append(':');
            if (this.base != 10) {
                buff.append('$');
            }
            if (this.bits != 8) {
                buff.append(this.bits);
            }
        }
        if (this.defaultValue != null) {
            buff.append('=');
            buff.append(this.defaultValue);
        }
        return buff.toString();
    }

    public void setBits(int bits) {
        this.bits = bits;
        this.editor.setBits(bits);
    }

    public void setBase(int base) {
        this.base = base;
        this.editor.setBase(base);
        this.renderer.setBase(base);
    }

    public int getBase() {
        return this.base;
    }
}

