/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DefaultValue;
import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.FocusSelector;
import com.hifiremote.jp1.IntVerifier;
import com.hifiremote.jp1.TextPopupMenu;
import java.awt.event.ActionListener;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;

public class NumberDeviceParm
extends DeviceParameter {
    private JTextField tf = null;
    private int bits = 8;
    private int min;
    private int max;
    private int base = 10;
    private IntVerifier verifier = null;

    public NumberDeviceParm(String name, DefaultValue defaultValue) {
        this(name, defaultValue, 10);
    }

    public NumberDeviceParm(String name, DefaultValue defaultValue, int base) {
        this(name, defaultValue, base, 8);
    }

    public NumberDeviceParm(String name, DefaultValue defaultValue, int base, int bits) {
        super(name, defaultValue);
        this.bits = bits;
        this.min = 0;
        this.max = (1 << bits) - 1;
        this.base = base;
        this.verifier = new IntVerifier(this.min, this.max, true);
        this.verifier.setBase(base);
        this.tf = new JTextField();
        new TextPopupMenu(this.tf);
        this.tf.setInputVerifier(this.verifier);
        FocusSelector.selectOnFocus(this.tf);
        this.setToolTipText();
    }

    private void setToolTipText() {
        String numType = "";
        if (this.base == 16) {
            numType = "hex ";
        }
        String helpText = "Enter a " + numType + "number in the range " + this.min + ".." + this.max + ".";
        if (this.defaultValue != null && this.defaultValue.value() != null) {
            helpText = helpText + "The default is " + Integer.toString((Integer)this.defaultValue.value(), this.base) + '.';
        }
        this.tf.setToolTipText(helpText);
    }

    public void setBits(int bits) {
        this.bits = bits;
        this.max = (1 << bits) - 1;
        this.verifier.setMax(this.max);
        this.setToolTipText();
    }

    @Override
    public JComponent getComponent() {
        return this.tf;
    }

    @Override
    public void addListener(EventListener l) {
        this.tf.addActionListener((ActionListener)l);
        this.tf.getDocument().addDocumentListener((DocumentListener)l);
    }

    @Override
    public void removeListener(EventListener l) {
        this.tf.removeActionListener((ActionListener)l);
        this.tf.getDocument().removeDocumentListener((DocumentListener)l);
    }

    @Override
    public Object getValue() {
        String text = this.tf.getText();
        if (text == null || text.length() == 0) {
            return null;
        }
        Integer rc = Integer.valueOf(text, this.base);
        return rc;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.tf.setText("");
        } else {
            String temp = null;
            Class<?> aClass = value.getClass();
            temp = aClass == Integer.class && this.base != 10 ? Integer.toHexString((Integer)value) : value.toString();
            this.tf.setText(temp);
        }
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.name);
        if (this.base == 16 || this.bits != 8) {
            buff.append(':');
        }
        if (this.base == 16) {
            buff.append('$');
        }
        if (this.bits != 8) {
            buff.append(this.bits);
        }
        if (this.defaultValue != null) {
            buff.append('=');
            buff.append(this.defaultValue);
        }
        return buff.toString();
    }

    @Override
    public String getDescription() {
        return "Number";
    }
}

