/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.KMPanel;
import com.hifiremote.jp1.KeyMove;
import com.hifiremote.jp1.Processor;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.ProtocolUpgrade;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteMaster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class OutputPanel
extends KMPanel
implements ActionListener {
    private JLabel deviceLabel = null;
    private JLabel protocolLabel = null;
    private JLabel remoteLabel = null;
    private JLabel sigLabel = null;
    private JLabel firmwareSigLabel = null;
    private JLabel procLabel = null;
    private JTextArea upgradeText = null;
    private JTextArea protocolText = null;
    private JTextArea popover = null;
    private JPopupMenu popup = null;
    private JMenuItem copyItem = null;
    private JButton copyDeviceUpgrade = null;
    private JButton copyProtocolUpgrade = null;
    private Clipboard clipboard = null;
    private JCheckBox includeNotes = null;

    public OutputPanel(DeviceUpgrade deviceUpgrade) {
        super("Output", deviceUpgrade);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Box main = Box.createVerticalBox();
        this.add((Component)main, "Center");
        Remote remote = deviceUpgrade.getRemote();
        this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Box infoBox = Box.createVerticalBox();
        infoBox.setAlignmentX(0.0f);
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        p.add((Component)infoBox, "First");
        this.add((Component)p, "First");
        this.remoteLabel = new JLabel("Remote = " + remote.getName());
        this.sigLabel = new JLabel("Signature = " + remote.getSignature());
        this.firmwareSigLabel = new JLabel();
        if (remote.getFirmwareSignature() != null) {
            this.firmwareSigLabel.setText("Firmware signature = " + remote.getFirmwareSignature());
        }
        this.firmwareSigLabel.setVisible(remote.getFirmwareSignature() != null);
        this.procLabel = new JLabel("Processor:  " + remote.getProcessorDescription());
        infoBox.add(this.remoteLabel);
        infoBox.add(this.sigLabel);
        infoBox.add(this.firmwareSigLabel);
        infoBox.add(this.procLabel);
        Box box = Box.createHorizontalBox();
        box.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.deviceLabel = new JLabel("Device Upgrade Code");
        this.deviceLabel.setAlignmentY(1.0f);
        box.add(this.deviceLabel);
        box.add(Box.createHorizontalGlue());
        ImageIcon copyIcon = RMIRSetup.createIcon("Copy24");
        this.copyDeviceUpgrade = new JButton(copyIcon);
        this.copyDeviceUpgrade.setToolTipText("Copy to clipboard");
        this.copyDeviceUpgrade.setAlignmentY(1.0f);
        this.copyDeviceUpgrade.addActionListener(this);
        box.add(this.copyDeviceUpgrade);
        this.upgradeText = new JTextArea(10, 40);
        this.upgradeText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.upgradeText.setEditable(false);
        this.upgradeText.setDragEnabled(true);
        this.upgradeText.setBackground(this.deviceLabel.getBackground());
        JScrollPane scroll = new JScrollPane(this.upgradeText);
        main.add(scroll);
        this.popup = new JPopupMenu();
        this.copyItem = new JMenuItem("Copy");
        this.copyItem.addActionListener(this);
        this.popup.add(this.copyItem);
        MouseAdapter mh = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.showPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showPopup(e);
            }

            private void showPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    OutputPanel.this.popover = (JTextArea)e.getSource();
                    OutputPanel.this.popup.show(OutputPanel.this.popover, e.getX(), e.getY());
                }
            }
        };
        this.upgradeText.addMouseListener(mh);
        main.add(Box.createVerticalStrut(20));
        box = Box.createHorizontalBox();
        main.add(box);
        box.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.protocolLabel = new JLabel("Upgrade Protocol Code");
        this.protocolLabel.setAlignmentY(1.0f);
        box.add(this.protocolLabel);
        box.add(Box.createHorizontalGlue());
        this.copyProtocolUpgrade = new JButton(copyIcon);
        this.copyProtocolUpgrade.setToolTipText("Copy to clipboard");
        this.copyProtocolUpgrade.setAlignmentY(1.0f);
        this.copyProtocolUpgrade.addActionListener(this);
        box.add(this.copyProtocolUpgrade);
        this.protocolText = new JTextArea(10, 40);
        this.protocolText.setEditable(false);
        this.protocolText.setDragEnabled(true);
        this.protocolText.addMouseListener(mh);
        this.protocolText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.protocolText.setBackground(this.protocolLabel.getBackground());
        scroll = new JScrollPane(this.protocolText);
        main.add(scroll);
    }

    @Override
    public void update() {
        ProtocolUpgrade pu;
        Remote r = this.deviceUpgrade.getRemote();
        int keyMoveBytes = 0;
        List<KeyMove> keyMoves = this.deviceUpgrade.getKeyMoves();
        for (KeyMove keyMove : keyMoves) {
            keyMoveBytes += keyMove.getSize(this.deviceUpgrade.getRemote());
        }
        String keyMoveInfo = "";
        if (keyMoves.size() > 0) {
            keyMoveInfo = String.format(" + %1$d bytes from %2$d keymoves", keyMoveBytes, keyMoves.size());
        }
        try {
            this.deviceLabel.setText(String.format("Device Upgrade Code (%1$d bytes%2$s)", this.deviceUpgrade.getUpgradeHex().length(), keyMoveInfo));
        }
        catch (Exception e) {
            this.deviceLabel.setText("Device Upgrade Code");
        }
        this.remoteLabel.setText("Remote = " + r.getName());
        this.sigLabel.setText("Signature = " + r.getSignature());
        if (r.getFirmwareSignature() != null) {
            this.firmwareSigLabel.setText("Firmware signature = " + r.getFirmwareSignature());
        }
        this.firmwareSigLabel.setVisible(r.getFirmwareSignature() != null);
        this.procLabel.setText("Processor:  " + r.getProcessorDescription());
        this.upgradeText.setText(this.deviceUpgrade.getUpgradeText());
        Protocol p = this.deviceUpgrade.getProtocol();
        Hex code = this.deviceUpgrade.getCode();
        Hex altCode = null;
        if (this.deviceUpgrade.getRemoteConfig() != null && this.deviceUpgrade.getProtocol().getCustomCode(this.deviceUpgrade.getRemote().getProcessor()) == null && (pu = p.getCustomUpgrade(this.deviceUpgrade.getRemoteConfig(), true)) != null && p.matched()) {
            altCode = pu.getCode();
            this.deviceUpgrade.translateCode(altCode);
            code = altCode;
        }
        if (this.deviceUpgrade.needsProtocolCode() || altCode != null) {
            if (code != null && code.length() > 0) {
                this.protocolLabel.setForeground(Color.black);
                this.protocolLabel.setText(String.format("Upgrade Protocol Code *** REQUIRED *** (%1$d bytes)", code.length()));
                this.protocolText.setForeground(Color.black);
            } else {
                this.protocolLabel.setForeground(Color.red);
                this.protocolLabel.setText("Upgrade Protocol Code REQUIRED BUT NOT AVAILABLE");
                this.protocolText.setForeground(this.protocolText.getBackground());
            }
        } else {
            this.protocolLabel.setForeground(Color.red);
            this.protocolLabel.setText("Upgrade Protocol Code NOT REQUIRED");
            this.protocolText.setForeground(this.protocolText.getBackground());
        }
        if (code == null) {
            this.protocolText.setText("");
        } else {
            Processor processor = r.getProcessor();
            StringBuilder buff = new StringBuilder(300);
            buff.append("Upgrade protocol 0 = ");
            buff.append(p.getID(r).toString());
            buff.append(" (");
            buff.append(processor.getFullName());
            buff.append(")");
            buff.append(' ');
            buff.append(p.getName());
            String variantName = p.getVariantName();
            Hex customCode = p.getCustomCode(processor);
            if (!variantName.equals("") || customCode != null || altCode != null) {
                buff.append(':');
                if (!variantName.equals("")) {
                    buff.append(variantName);
                    if (customCode != null || altCode != null) {
                        buff.append("-Custom");
                    }
                } else {
                    buff.append("Custom");
                }
            }
            buff.append(" (RMDU ");
            buff.append(RemoteMaster.getDisplayVersion());
            buff.append(')');
            try {
                BufferedReader rdr = new BufferedReader(new StringReader(code.toString(16)));
                String line = null;
                while ((line = rdr.readLine()) != null) {
                    buff.append("\n ");
                    buff.append(line);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace(System.err);
            }
            buff.append("\nEnd");
            this.protocolText.setText(buff.toString());
        }
        this.deviceUpgrade.checkSize();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTextArea area = null;
        Object source = e.getSource();
        if (source == this.includeNotes) {
            this.update();
            return;
        }
        if (source == this.copyDeviceUpgrade) {
            area = this.upgradeText;
        } else if (source == this.copyProtocolUpgrade) {
            area = this.protocolText;
            this.deviceUpgrade.getProtocol().saveAltPID(this.deviceUpgrade.getRemote());
        } else {
            area = this.popover;
        }
        String text = area.getText();
        StringSelection data = new StringSelection(text);
        this.clipboard.setContents(data, data);
    }
}

