/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DefaultValue;
import com.hifiremote.jp1.DirectDefaultValue;

public abstract class Parameter {
    protected String name;
    protected String displayName = null;
    protected DefaultValue defaultValue;

    public Parameter(String name) {
        this(name, null);
    }

    public Parameter(String name, DefaultValue defaultValue) {
        this.setName(name);
        this.defaultValue = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        int semi = aName.indexOf(59);
        if (semi == -1) {
            this.name = aName;
        } else {
            this.name = aName.substring(0, semi);
            this.displayName = aName.substring(semi + 1);
        }
    }

    public String getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.name;
    }

    public abstract String getDescription();

    public DefaultValue getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefault(DefaultValue value) {
        this.defaultValue = value;
    }

    public void setDefault(int value) {
        this.setDefault(new DirectDefaultValue(new Integer(value)));
    }

    public abstract Object getValue();

    public Object getValueOrDefault() {
        Object rc = this.getValue();
        if (rc != null) {
            return rc;
        }
        if (this.defaultValue != null) {
            return this.defaultValue.value();
        }
        return null;
    }

    public abstract void setValue(Object var1);
}

