/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.ManualProtocol;
import com.hifiremote.jp1.ManualSettingsPanel;
import com.hifiremote.jp1.NumberCmdParm;
import com.hifiremote.jp1.NumberDeviceParm;
import com.hifiremote.jp1.Parameter;
import com.hifiremote.jp1.translate.Translate;
import com.hifiremote.jp1.translate.Translator;
import javax.swing.table.AbstractTableModel;

public class ParameterTableModel
extends AbstractTableModel {
    private Parameter[] parms;
    private Translate[] xlators;
    private ManualProtocol protocol = null;
    private Type type = Type.DEVICE;
    private static final int nameCol = 0;
    private static final int bitsCol = 1;
    private static final int orderCol = 2;
    private static final int compCol = 3;
    private static final String[] colNames = new String[]{"Name", "Bits", "LSB", "Comp"};
    private ManualSettingsPanel manualSettingsPanel = null;
    private static final Class<?>[] colClasses = new Class[]{String.class, Integer.class, Boolean.class, Boolean.class};

    public ParameterTableModel(ManualProtocol protocol, Type type) {
        this.protocol = protocol;
        this.type = type;
    }

    private void getProtocolInfo() {
        switch (this.type.ordinal()) {
            case 0: {
                this.parms = this.protocol.getDeviceParameters();
                this.xlators = this.protocol.getDeviceTranslators();
                break;
            }
            case 1: {
                this.parms = this.protocol.getCommandParameters();
                this.xlators = this.protocol.getCmdTranslators();
            }
        }
    }

    @Override
    public int getRowCount() {
        this.getProtocolInfo();
        return this.parms.length;
    }

    @Override
    public int getColumnCount() {
        return colNames.length;
    }

    @Override
    public String getColumnName(int col) {
        if (col < colNames.length) {
            return colNames[col];
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        if (col < colClasses.length) {
            return colClasses[col];
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public Object getValueAt(int row, int col) {
        this.getProtocolInfo();
        Parameter parm = this.parms[row];
        Translator translator = (Translator)this.xlators[row];
        switch (col) {
            case 0: {
                return parm.getName();
            }
            case 1: {
                return new Integer(translator.getBits());
            }
            case 2: {
                return translator.getLSB();
            }
            case 3: {
                return translator.getComp();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.getProtocolInfo();
        Parameter parm = this.parms[row];
        Translator translator = (Translator)this.xlators[row];
        switch (col) {
            case 0: {
                parm.setName((String)value);
                break;
            }
            case 1: {
                int bits = (Integer)value;
                switch (this.type.ordinal()) {
                    case 0: {
                        ((NumberDeviceParm)parm).setBits(bits);
                        break;
                    }
                    case 1: {
                        ((NumberCmdParm)parm).setBits(bits);
                    }
                }
                translator.setBits(bits);
                break;
            }
            case 2: {
                translator.setLSB((Boolean)value);
                break;
            }
            case 3: {
                translator.setComp((Boolean)value);
                break;
            }
        }
        this.setProtocolText(0);
    }

    public void setProtocolText(int modeIndex) {
        if (modeIndex >= 0 && modeIndex <= 1 && this.manualSettingsPanel != null) {
            this.manualSettingsPanel.getDeviceText().setText(this.manualSettingsPanel.getProtocolText(true, true));
        }
    }

    public void setManualSettingsPanel(ManualSettingsPanel manualSettingsPanel) {
        this.manualSettingsPanel = manualSettingsPanel;
    }

    public static enum Type {
        DEVICE,
        COMMAND;

    }
}

