/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.EFC;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.KeyMove;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.PauseParameters;
import com.hifiremote.jp1.PauseSpecialProtocol;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.SpecialFunctionDialog;
import com.hifiremote.jp1.SpecialProtocolFunction;
import java.text.DecimalFormat;
import java.util.Properties;

public class PauseFunction
extends SpecialProtocolFunction {
    public static final DecimalFormat pauseFormat = new DecimalFormat("0.0##");

    public PauseFunction(KeyMove keyMove) {
        super(keyMove);
    }

    public PauseFunction(Macro macro) {
        super(macro);
    }

    public PauseFunction(int keyCode, int deviceButtonIndex, int deviceType, int setupCode, Hex cmd, String notes) {
        super(keyCode, deviceButtonIndex, deviceType, setupCode, cmd, notes);
    }

    public PauseFunction(Properties props, Remote remote) {
        super(props, remote);
    }

    @Override
    public String get_Type(RemoteConfiguration remoteConfig) {
        return this.getUserFunctions(remoteConfig)[0];
    }

    @Override
    public String getDisplayType(RemoteConfiguration remoteConfig) {
        return this.getUserFunctions(remoteConfig)[0];
    }

    @Override
    public String getValueString(RemoteConfiguration remoteConfig) {
        return pauseFormat.format(this.getPauseDuration(remoteConfig)) + "secs";
    }

    @Override
    public void update(SpecialFunctionDialog dlg) {
        dlg.setPauseDuration(Float.valueOf(this.getPauseDuration(dlg.getRemoteConfiguration())));
    }

    public static Hex createHex(SpecialFunctionDialog dlg, PauseParameters params) {
        short[] hex = new short[params.getDataLength()];
        Float pauseDuration = dlg.getPauseDuration();
        if (pauseDuration == null) {
            return null;
        }
        int duration = Math.round(pauseDuration.floatValue() * params.getMultiplier());
        if (params.getBytesUsed() == 2) {
            if (duration > 65535) {
                duration = 65535;
            }
            int lsb = params.isLsb() ? 0 : 1;
            hex[lsb] = (short)(duration & 0xFF);
            hex[1 - lsb] = (short)(duration >> 8);
        } else {
            if (duration > 255) {
                duration = 255;
            }
            hex[params.getOffset()] = (short)duration;
            if (params.getDataLength() == 2) {
                if (params.getOffset() == 0) {
                    hex[1] = (short)(EFC.parseHex(hex[0]) & 0xFF);
                } else {
                    hex[0] = EFC.toHex(hex[1]).getData()[0];
                }
            }
        }
        return new Hex(hex);
    }

    public float getPauseDuration(RemoteConfiguration remoteConfig) {
        PauseParameters params = PauseSpecialProtocol.getPauseParameters(this.getUserFunctions(remoteConfig)[0], remoteConfig.getRemote());
        short[] data = this.getCmd().getData();
        int duration = 0;
        if (params.getBytesUsed() == 2) {
            int lsb = params.isLsb() ? 0 : 1;
            duration = data[1 - lsb] << 8 | data[lsb];
        } else {
            duration = data[params.getOffset()];
        }
        return (float)duration / params.getMultiplier();
    }
}

