/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.ParameterTokenizer;
import com.hifiremote.jp1.RDFParameter;
import com.hifiremote.jp1.Remote;
import java.util.List;

public class PauseParameters
extends RDFParameter {
    private String userName = "";
    private int dataLength = 2;
    private int offset = 0;
    private int bytesUsed = 1;
    private boolean lsb = false;
    private float multiplier = 1.0f;

    public PauseParameters(String userName, Remote remote) {
        this.userName = userName;
        this.multiplier = remote.getProcessor().getName().equals("S3C80") && remote.getRAMAddress() != 65280 ? 10.66f : 16.0f;
    }

    public PauseParameters() {
    }

    @Override
    public void parse(String text, Remote remote) throws Exception {
        List<String> parms = ParameterTokenizer.getTokens(text);
        this.userName = parms.get(0);
        String value = parms.get(1);
        if (value.equals("1")) {
            this.dataLength = 1;
            this.offset = 0;
            this.bytesUsed = 1;
            this.lsb = false;
        } else if (value.equals("2/1")) {
            this.dataLength = 2;
            this.offset = 0;
            this.bytesUsed = 1;
            this.lsb = false;
        } else if (value.equals("2/2")) {
            this.dataLength = 2;
            this.offset = 1;
            this.bytesUsed = 1;
            this.lsb = false;
        } else if (value.equals("2/B")) {
            this.dataLength = 2;
            this.offset = 0;
            this.bytesUsed = 2;
            this.lsb = false;
        } else if (value.equals("2/L")) {
            this.dataLength = 2;
            this.offset = 0;
            this.bytesUsed = 2;
            this.lsb = true;
        }
        this.multiplier = Float.parseFloat(parms.get(2));
    }

    public String getUserName() {
        return this.userName;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getBytesUsed() {
        return this.bytesUsed;
    }

    public boolean isLsb() {
        return this.lsb;
    }

    public float getMultiplier() {
        return this.multiplier;
    }
}

