/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableCellEditor;

public class PopupEditor
extends DefaultCellEditor
implements TableCellEditor,
ActionListener,
PopupMenuListener,
Runnable {
    private JButton button = new JButton();
    private JTable table = null;
    private Object value = null;
    private JPopupMenu popup = new JPopupMenu();

    public PopupEditor() {
        super(new JTextField());
        this.setClickCountToStart(2);
        this.button = new JButton();
        this.button.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.button.setHorizontalAlignment(10);
        this.button.setBorderPainted(false);
        this.popup.setLayout(new GridLayout(0, 3));
        this.popup.addPopupMenuListener(this);
    }

    public void addObject(Object value) {
        ObjectItem item = new ObjectItem(value);
        this.popup.add(item);
        item.addActionListener(this);
    }

    public void removeAll() {
        MenuElement[] elements = this.popup.getSubElements();
        for (int i = 0; i < elements.length; ++i) {
            ObjectItem item = (ObjectItem)elements[i];
            item.removeActionListener(this);
        }
        this.popup.removeAll();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.value = ((ObjectItem)e.getSource()).getValue();
        this.fireEditingStopped();
        this.giveFocusToTable();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        this.fireEditingCanceled();
        this.giveFocusToTable();
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.value = value;
        if (value == null) {
            this.button.setText("");
        } else {
            this.button.setText(value.toString());
        }
        MenuElement[] elements = this.popup.getSubElements();
        for (int i = 0; i < elements.length; ++i) {
            ObjectItem item = (ObjectItem)elements[i];
            if (!item.getValue().equals(value)) continue;
            this.popup.setSelected(item);
            break;
        }
        SwingUtilities.invokeLater(this);
        return this.button;
    }

    private void giveFocusToTable() {
        this.table.requestFocusInWindow();
    }

    @Override
    public void run() {
        this.popup.show(this.button, 0, this.button.getHeight());
    }

    private class ObjectItem
    extends JMenuItem {
        private Object value;

        public ObjectItem(Object value) {
            super(value.toString());
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

