/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class PortDialog
extends JDialog
implements ActionListener {
    private String port = null;
    private JTextField other = new JTextField(15);
    private JButton ok = null;
    private JButton cancel = null;
    private JRadioButton autodetect = null;
    private int userAction = 2;
    public static final String AUTODETECT = "Auto-detect";
    public static final String OTHER = "Other:";

    public PortDialog(JFrame owner, String[] portNames, String port) {
        super(owner, "Port Selection", true);
        this.createGui(owner, portNames, port);
    }

    public PortDialog(JDialog owner, String[] portNames, String port) {
        super(owner, "Port Selection", true);
        this.createGui(owner, portNames, port);
    }

    private void createGui(Component owner, String[] portNames, String port) {
        this.setLocationRelativeTo(owner);
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (port == null || port.equals("")) {
            port = AUTODETECT;
        }
        ButtonGroup group = new ButtonGroup();
        JRadioButton[] buttons = new JRadioButton[portNames.length + 2];
        int i = 0;
        buttons[i++] = new JRadioButton(AUTODETECT);
        buttons[0].setAlignmentX(0.0f);
        this.autodetect = buttons[0];
        for (String name : portNames) {
            buttons[i++] = new JRadioButton(name);
        }
        buttons[i++] = new JRadioButton(OTHER);
        Box box = Box.createVerticalBox();
        box.add(new JLabel("Select the desired port:"));
        box.add(Box.createVerticalStrut(5));
        int numColumns = 3;
        if (portNames.length < 3) {
            numColumns = portNames.length;
        }
        if (numColumns == 0) {
            numColumns = 1;
        }
        JPanel panel = new JPanel(new GridLayout(0, numColumns, 5, 5));
        panel.setAlignmentX(0.0f);
        boolean foundMatch = false;
        for (int j = 0; j < buttons.length; ++j) {
            JRadioButton button = buttons[j];
            group.add(button);
            button.addActionListener(this);
            String text = button.getText();
            if (port.equals(text)) {
                button.setSelected(true);
                foundMatch = true;
            }
            if (j == 0) {
                box.add(button);
                box.add(Box.createVerticalStrut(5));
                box.add(panel);
                box.add(Box.createVerticalStrut(5));
                continue;
            }
            if (j == buttons.length - 1) {
                JPanel otherPanel = new JPanel(new FlowLayout(3, 0, 0));
                otherPanel.setAlignmentX(0.0f);
                box.add(otherPanel);
                otherPanel.add(button);
                otherPanel.add(Box.createHorizontalStrut(5));
                otherPanel.add(this.other);
                continue;
            }
            panel.add(button);
        }
        if (!foundMatch) {
            this.other.setText(port);
            this.port = OTHER;
            buttons[buttons.length - 1].setSelected(true);
        } else {
            this.port = port;
        }
        this.other.setEnabled(OTHER.equals(this.port));
        this.add((Component)box, "North");
        panel = new JPanel(new FlowLayout(4));
        this.ok = new JButton("OK");
        this.ok.addActionListener(this);
        panel.add(this.ok);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        panel.add(this.cancel);
        this.add((Component)panel, "South");
        this.pack();
        Rectangle rect = this.getBounds();
        int x = rect.x - rect.width / 2;
        int y = rect.y - rect.height / 2;
        this.setLocation(x, y);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.cancel) {
            this.userAction = 2;
            this.setVisible(false);
            this.dispose();
        } else if (source == this.ok) {
            this.userAction = 0;
            this.setVisible(false);
            this.dispose();
        } else {
            JRadioButton button = (JRadioButton)source;
            this.port = button.getText();
            this.other.setEnabled(OTHER.equals(this.port));
        }
    }

    public void setOtherPort(String port) {
        this.other.setText(port);
    }

    public String getPort() {
        if (OTHER.equals(this.port)) {
            this.port = this.other.getText();
        }
        return this.port;
    }

    public int getUserAction() {
        return this.userAction;
    }

    public JRadioButton getAutodetect() {
        return this.autodetect;
    }
}

