/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.PropertyFile;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteManager;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class Preferences {
    private PropertyFile file;
    private static final String upgradeDirectory = "Upgrades";
    private static final String protocolDirectory = "Protocols";
    private static final String rfDirectory = "RFFiles";

    public Preferences(PropertyFile file) {
        this.file = file;
    }

    public void load(JMenu recentFileMenu, String recentName, ActionListener l) {
        this.file.populateFileMenu(recentFileMenu, recentName + ".", l);
    }

    public String[] getCustomNames() {
        String[] customNames = null;
        String temp = this.file.getProperty("CustomNames");
        if (temp != null) {
            StringTokenizer st = new StringTokenizer(temp, "|");
            int count = st.countTokens();
            customNames = new String[count];
            for (int i = 0; i < count; ++i) {
                customNames[i] = st.nextToken();
            }
        }
        return customNames;
    }

    public void setCustomNames(String[] customNames) {
        if (customNames == null || customNames.length == 0) {
            this.file.remove("CustomNames");
        } else {
            StringBuilder value = new StringBuilder();
            for (int i = 0; i < customNames.length; ++i) {
                if (i != 0) {
                    value.append('|');
                }
                value.append(customNames[i]);
            }
            this.file.setProperty("CustomNames", value.toString());
        }
    }

    public String getShowRemotes() {
        return this.file.getProperty("ShowRemotes", "All");
    }

    public void setShowRemotes(String str) {
        this.file.setProperty("ShowRemotes", str);
    }

    public Collection<Remote> getPreferredRemotes() {
        String name;
        RemoteManager rm = RemoteManager.getRemoteManager();
        ArrayList<Remote> preferredRemotes = new ArrayList<Remote>();
        int i = 0;
        while ((name = this.file.getProperty("PreferredRemotes." + i)) != null) {
            Remote r = rm.findRemoteByName(name);
            if (r != null) {
                preferredRemotes.add(r);
            }
            ++i;
        }
        return preferredRemotes;
    }

    public void setPreferredRemotes(Collection<Remote> remotes) {
        String name;
        int i = 0;
        while ((name = this.file.getProperty("PreferredRemotes." + i)) != null) {
            this.file.remove(name);
            ++i;
        }
        i = 0;
        for (Remote remote : remotes) {
            this.file.setProperty("PreferredRemotes." + i, remote.getName());
            ++i;
        }
    }

    public void save(JMenu recentFileMenu, String recentName) throws Exception {
        for (int i = 0; i < recentFileMenu.getItemCount(); ++i) {
            JMenuItem item = recentFileMenu.getItem(i);
            this.file.setProperty(recentName + "." + i, item.getText());
        }
        this.file.save();
    }

    public File getRDFPath() {
        return this.file.getFileProperty("RDFPath");
    }

    public File getUpgradePath() {
        File path = this.file.getFileProperty("UpgradePath");
        if (path != null) {
            return path;
        }
        path = this.file.getFileProperty("KMPath");
        if (path != null) {
            this.file.remove("KMPath");
            this.setUpgradePath(path);
            return path;
        }
        path = new File(this.file.getFile().getParentFile(), upgradeDirectory);
        this.setUpgradePath(path);
        return path;
    }

    public File getProtocolPath() {
        File path = this.file.getFileProperty("RMPBPath");
        if (path != null) {
            return path;
        }
        path = new File(this.file.getFile().getParentFile(), protocolDirectory);
        this.setProtocolPath(path);
        return path;
    }

    public File getRFPath() {
        File path = this.file.getFileProperty("RFPath");
        if (path != null) {
            return path;
        }
        path = this.file.getFile().getParentFile();
        this.setRFPath(path);
        return path;
    }

    public File getUpgradeSavePath() {
        if (this.getSeparateSaveFolder()) {
            File path = this.file.getFileProperty("UpgradeSavePath");
            if (path != null) {
                return path;
            }
            path = this.getUpgradePath();
            this.setUpgradeSavePath(path);
            return path;
        }
        return this.getUpgradePath();
    }

    public void setUpgradePath(File path) {
        this.file.setProperty("UpgradePath", path);
    }

    public void setProtocolPath(File path) {
        this.file.setProperty("RMPBPath", path);
    }

    public void setRFPath(File path) {
        this.file.setProperty("RFPath", path);
    }

    public boolean getSeparateSaveFolder() {
        return Boolean.parseBoolean(this.file.getProperty("UpgradeSaveFolder", "false"));
    }

    public void setUpgradeSavePath(File path) {
        if (this.getSeparateSaveFolder()) {
            this.file.setProperty("UpgradeSavePath", path);
        } else {
            this.setUpgradePath(path);
        }
    }

    public void setProtocolSavePath(File path) {
        if (this.getSeparateSaveFolder()) {
            this.file.setProperty("RMPBSavePath", path);
        } else {
            this.setProtocolPath(path);
        }
    }

    public File getBinaryUpgradePath() {
        File path = this.file.getFileProperty("BinaryUpgradePath", this.getUpgradePath());
        if (path != null) {
            return path;
        }
        return this.getUpgradePath();
    }

    public File getExternalFilePath() {
        File path = this.file.getFileProperty("ExternalFilePath", this.getUpgradePath());
        if (path != null) {
            return path;
        }
        return this.getUpgradePath();
    }

    public void setBinaryUpgradePath(File path) {
        this.file.setProperty("BinaryUpgradePath", path);
    }

    public void setExternalFilePath(File path) {
        this.file.setProperty("ExternalFilePath", path);
    }

    public Rectangle getBounds() {
        String temp = this.file.getProperty("KMBounds");
        if (temp == null) {
            return null;
        }
        Rectangle bounds = new Rectangle();
        StringTokenizer st = new StringTokenizer(temp, ",");
        bounds.x = Integer.parseInt(st.nextToken());
        bounds.y = Integer.parseInt(st.nextToken());
        bounds.width = Integer.parseInt(st.nextToken());
        bounds.height = Integer.parseInt(st.nextToken());
        return bounds;
    }

    public Rectangle getPBBounds() {
        String temp = this.file.getProperty("PBBounds");
        if (temp == null) {
            return null;
        }
        Rectangle bounds = new Rectangle();
        StringTokenizer st = new StringTokenizer(temp, ",");
        bounds.x = Integer.parseInt(st.nextToken());
        bounds.y = Integer.parseInt(st.nextToken());
        bounds.width = Integer.parseInt(st.nextToken());
        bounds.height = Integer.parseInt(st.nextToken());
        return bounds;
    }

    public Rectangle getRFBounds() {
        String temp = this.file.getProperty("RFBounds");
        if (temp == null) {
            return null;
        }
        Rectangle bounds = new Rectangle();
        StringTokenizer st = new StringTokenizer(temp, ",");
        bounds.x = Integer.parseInt(st.nextToken());
        bounds.y = Integer.parseInt(st.nextToken());
        bounds.width = Integer.parseInt(st.nextToken());
        bounds.height = Integer.parseInt(st.nextToken());
        return bounds;
    }

    public void setBounds(Rectangle bounds) {
        this.file.setProperty("KMBounds", "" + bounds.x + ',' + bounds.y + ',' + bounds.width + ',' + bounds.height);
    }

    public void setPBBounds(Rectangle bounds) {
        this.file.setProperty("PBBounds", "" + bounds.x + ',' + bounds.y + ',' + bounds.width + ',' + bounds.height);
    }

    public void setRFBounds(Rectangle bounds) {
        this.file.setProperty("RFBounds", "" + bounds.x + ',' + bounds.y + ',' + bounds.width + ',' + bounds.height);
    }

    public String getLastRemoteName() {
        return this.file.getProperty("Remote.name");
    }

    public void setLastRemoteName(String name) {
        this.file.setProperty("Remote.name", name);
    }

    public String getLastRemoteSignature() {
        return this.file.getProperty("Remote.signature");
    }

    public void setLastRemoteSignature(String sig) {
        this.file.setProperty("Remote.signature", sig);
    }

    public void setLookAndFeel(String lf) {
        this.file.setProperty("LookAndFeel", lf);
    }

    public String getLookAndFeel() {
        return this.file.getProperty("LookAndFeel");
    }

    public void setFontSizeAdjustment(Float adjustment) {
        if (adjustment.floatValue() == 0.0f) {
            this.file.remove("FontSizeAdjustment");
        } else {
            this.file.setProperty("FontSizeAdjustment", Float.toString(adjustment.floatValue()));
        }
    }

    public float getFontSizeAdjustment() {
        float rc = 0.0f;
        String temp = this.file.getProperty("FontSizeAdjustment");
        if (temp != null) {
            rc = Float.parseFloat(temp);
        }
        return rc;
    }

    public String getPromptToSave() {
        return this.file.getProperty("PromptToSave", "Always");
    }

    public void setPromptToSave(String prompt) {
        this.file.setProperty("PromptToSave", prompt);
    }

    public String getUseCustomNames() {
        String temp = this.file.getProperty("UseCustomNames");
        return temp == null ? "Empty" : temp;
    }

    public void setUseCustomNames(String use) {
        if (use.equals("Custom")) {
            this.file.setProperty("UseCustomNames", "Custom");
        } else if (use.equals("Default")) {
            this.file.setProperty("UseCustomNames", "Default");
        } else {
            this.file.remove("UseCustomNames");
        }
    }

    public boolean getShowRemoteSignature() {
        return this.file.getProperty("ShowRemoteSignature") != null;
    }

    public void setShowRemoteSignature(boolean flag) {
        if (flag) {
            this.file.setProperty("ShowRemoteSignature", "yes");
        } else {
            this.file.remove("ShowRemoteSignature");
        }
    }

    public File getFileProperty(String name) {
        return this.file.getFileProperty(name);
    }

    public void setProperty(String name, File value) {
        this.file.setProperty(name, value);
    }
}

