/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PreferredRemoteDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private DefaultListModel unusedListModel = null;
    private DefaultListModel preferredListModel = null;
    private JList unusedList = null;
    private JList preferredList = null;
    private JButton add = null;
    private JButton remove = null;
    private JButton ok = null;
    private JButton cancel = null;
    private int userAction = 2;

    public PreferredRemoteDialog(JFrame owner, Collection<Remote> preferredRemotes) {
        super(owner, "Preferred Remotes", true);
        this.createGui(owner, preferredRemotes);
    }

    public PreferredRemoteDialog(JDialog owner, Collection<Remote> preferredRemotes) {
        super(owner, "Preferred Remotes", true);
        this.createGui(owner, preferredRemotes);
    }

    private void createGui(Component owner, Collection<Remote> preferredRemotes) {
        if (owner != null) {
            this.setLocationRelativeTo(owner);
        }
        Collection<Remote> remotes = RemoteManager.getRemoteManager().getRemotes();
        this.unusedListModel = new DefaultListModel();
        Iterator<Remote> iPref = preferredRemotes.iterator();
        Iterator<Remote> iAll = remotes.iterator();
        while (iPref.hasNext()) {
            Remote r;
            Remote preferred = iPref.next();
            while (iAll.hasNext() && (r = iAll.next()) != preferred) {
                this.unusedListModel.addElement(r);
            }
        }
        while (iAll.hasNext()) {
            this.unusedListModel.addElement(iAll.next());
        }
        this.preferredListModel = new DefaultListModel();
        for (Remote r : preferredRemotes) {
            this.preferredListModel.addElement(r);
        }
        this.unusedList = new JList(this.unusedListModel);
        this.unusedList.setVisibleRowCount(20);
        this.unusedList.addListSelectionListener(this);
        this.preferredList = new JList(this.preferredListModel);
        this.preferredList.addListSelectionListener(this);
        Container contentPane = this.getContentPane();
        JLabel instructions = new JLabel("Move remotes from the \"Available Remotes\" list to the \"Preferred Remotes\" list.");
        instructions.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        contentPane.add((Component)instructions, "North");
        Box outerBox = Box.createHorizontalBox();
        contentPane.add((Component)outerBox, "Center");
        outerBox.add(Box.createHorizontalStrut(10));
        Box box = Box.createVerticalBox();
        box.add(new JLabel("Available Remotes"));
        box.add(new JScrollPane(this.unusedList));
        outerBox.add(box);
        outerBox.add(Box.createHorizontalStrut(10));
        box = Box.createVerticalBox();
        this.add = new JButton(" -->> ");
        this.add.setEnabled(false);
        this.add.addActionListener(this);
        box.add(this.add);
        box.add(Box.createVerticalStrut(10));
        this.remove = new JButton(" <<-- ");
        this.remove.setEnabled(false);
        this.remove.addActionListener(this);
        box.add(this.remove);
        outerBox.add(box);
        outerBox.add(Box.createHorizontalStrut(10));
        box = Box.createVerticalBox();
        box.add(new JLabel("Preferred Remotes"));
        box.add(new JScrollPane(this.preferredList));
        outerBox.add(box);
        outerBox.add(Box.createHorizontalStrut(10));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        FlowLayout fl = (FlowLayout)buttonPanel.getLayout();
        fl.setAlignment(2);
        this.ok = new JButton("OK");
        this.ok.addActionListener(this);
        buttonPanel.add(this.ok);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        buttonPanel.add(this.cancel);
        contentPane.add((Component)buttonPanel, "South");
        this.pack();
        Rectangle rect = this.getBounds();
        int x = rect.x - rect.width / 2;
        int y = rect.y - rect.height / 2;
        this.setLocation(x, y);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.cancel) {
            this.userAction = 2;
            this.setVisible(false);
            this.dispose();
        } else if (source == this.ok) {
            this.userAction = 0;
            this.setVisible(false);
            this.dispose();
        } else if (source == this.add) {
            this.transfer(this.unusedList, this.preferredList);
        } else if (source == this.remove) {
            this.transfer(this.preferredList, this.unusedList);
        }
    }

    public Collection<Remote> getPreferredRemotes() {
        ArrayList<Remote> remotes = new ArrayList<Remote>(this.preferredListModel.size());
        Enumeration e = this.preferredListModel.elements();
        while (e.hasMoreElements()) {
            remotes.add((Remote)e.nextElement());
        }
        return remotes;
    }

    public int getUserAction() {
        return this.userAction;
    }

    private void transfer(JList fromList, JList toList) {
        DefaultListModel fromModel = (DefaultListModel)fromList.getModel();
        int first = fromList.getMinSelectionIndex();
        DefaultListModel toModel = (DefaultListModel)toList.getModel();
        int toIndex = toModel.getSize();
        for (int fromIndex = fromList.getMaxSelectionIndex(); fromIndex >= first; --fromIndex) {
            Remote r2;
            int rc;
            if (!fromList.isSelectedIndex(fromIndex)) continue;
            Remote r = (Remote)fromModel.getElementAt(fromIndex);
            fromModel.removeElementAt(fromIndex);
            while (toIndex > 0 && (rc = (r2 = (Remote)toModel.elementAt(toIndex - 1)).getName().compareTo(r.getName())) >= 0) {
                --toIndex;
            }
            toModel.add(toIndex, r);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object source = e.getSource();
        if (source == this.unusedList) {
            this.add.setEnabled(!this.unusedList.isSelectionEmpty());
        } else {
            this.remove.setEnabled(!this.preferredList.isSelectionEmpty());
        }
    }
}

